/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.filesystem.FileStoreCreationRule;
import org.eclipse.core.tests.filesystem.FileSystemTestUtil;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SymlinkTest {
    private static final boolean SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES = "win32".equals(Platform.getOS());
    private static String specialCharName = "\u00e4\u00f6\u00fc\u00df \u00c4\u00d6\u00dc \u00e0\u00c0\u00e2\u00c2 \u00b5\u00b2\u00b3\u00fa\u00e1";
    protected IFileStore aDir;
    protected IFileStore aFile;
    protected IFileInfo iDir;
    protected IFileInfo iFile;
    protected IFileInfo ilDir;
    protected IFileInfo ilFile;
    protected IFileInfo illDir;
    protected IFileInfo illFile;
    protected IFileStore lDir;
    protected IFileStore lFile;
    protected IFileStore llDir;
    protected IFileStore llFile;
    @Rule
    public final FileStoreCreationRule fileStoreRule = new FileStoreCreationRule(FileStoreCreationRule.FileSystemType.LOCAL);

    @Before
    public void assumeSymbolicLinksAvailable() throws Exception {
        Assume.assumeTrue((String)"only relevant for platforms supporting symbolic links", (boolean)FileSystemHelper.canCreateSymLinks());
    }

    protected void fetchFileInfos() {
        this.iDir = this.aDir.fetchInfo();
        this.iFile = this.aFile.fetchInfo();
        this.ilDir = this.lDir.fetchInfo();
        this.ilFile = this.lFile.fetchInfo();
        this.illDir = this.llDir.fetchInfo();
        this.illFile = this.llFile.fetchInfo();
    }

    public boolean haveSymlinks() {
        return SymlinkTest.isAttributeSupported(32);
    }

    protected void makeLinkStructure() throws CoreException, IOException {
        IFileStore baseStore = this.fileStoreRule.getFileStore();
        this.aDir = baseStore.getChild("aDir");
        this.aFile = baseStore.getChild("aFile");
        this.lDir = baseStore.getChild("lDir");
        this.lFile = baseStore.getChild("lFile");
        this.llDir = baseStore.getChild("llDir");
        this.llFile = baseStore.getChild("llFile");
        FileSystemTestUtil.ensureExists(this.aDir, true);
        FileSystemTestUtil.ensureExists(this.aFile, false);
        this.mkLink(baseStore, "lDir", "aDir", true);
        this.mkLink(baseStore, "llDir", "lDir", true);
        this.mkLink(baseStore, "lFile", "aFile", false);
        this.mkLink(baseStore, "llFile", "lFile", false);
        this.fetchFileInfos();
    }

    protected void mkLink(IFileStore dir, String src, String tgt, boolean isDir) throws IOException, CoreException {
        FileSystemHelper.createSymLink((File)dir.toLocalFile(0, FileSystemTestUtil.getMonitor()), (String)src, (String)tgt, (boolean)isDir);
    }

    @Test
    public void testBrokenSymlinkAttributes() throws Exception {
        long testStartTime = System.currentTimeMillis();
        this.makeLinkStructure();
        FileSystemTestUtil.ensureDoesNotExist(this.aDir);
        FileSystemTestUtil.ensureDoesNotExist(this.aFile);
        this.fetchFileInfos();
        Assert.assertEquals((Object)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (Object)this.ilFile.exists());
        Assert.assertFalse((boolean)this.ilFile.isDirectory());
        Assert.assertEquals((Object)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (Object)this.illFile.exists());
        Assert.assertFalse((boolean)this.illFile.isDirectory());
        Assert.assertEquals((Object)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (Object)this.ilDir.exists());
        Assert.assertEquals((Object)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (Object)this.ilDir.isDirectory());
        Assert.assertEquals((Object)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (Object)this.illDir.exists());
        Assert.assertEquals((Object)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (Object)this.illDir.isDirectory());
        if (SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES) {
            Assert.assertTrue((this.ilFile.getLastModified() >= testStartTime ? 1 : 0) != 0);
            Assert.assertTrue((this.ilDir.getLastModified() >= testStartTime ? 1 : 0) != 0);
            Assert.assertTrue((this.illFile.getLastModified() >= testStartTime ? 1 : 0) != 0);
            Assert.assertTrue((this.illDir.getLastModified() >= testStartTime ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)this.ilFile.getLastModified());
            Assert.assertEquals((long)0L, (long)this.ilDir.getLastModified());
            Assert.assertEquals((long)0L, (long)this.illFile.getLastModified());
            Assert.assertEquals((long)0L, (long)this.illDir.getLastModified());
        }
        Assert.assertEquals((long)0L, (long)this.ilFile.getLength());
        Assert.assertEquals((long)0L, (long)this.ilDir.getLength());
        Assert.assertEquals((long)0L, (long)this.illFile.getLength());
        Assert.assertEquals((long)0L, (long)this.illDir.getLength());
        Assert.assertTrue((boolean)this.ilFile.getAttribute(32));
        Assert.assertEquals((Object)this.ilFile.getStringAttribute(64), (Object)"aFile");
        Assert.assertTrue((boolean)this.ilDir.getAttribute(32));
        Assert.assertEquals((Object)this.ilDir.getStringAttribute(64), (Object)"aDir");
        Assert.assertTrue((boolean)this.illFile.getAttribute(32));
        Assert.assertEquals((Object)this.illFile.getStringAttribute(64), (Object)"lFile");
        Assert.assertTrue((boolean)this.illDir.getAttribute(32));
        Assert.assertEquals((Object)this.illDir.getStringAttribute(64), (Object)"lDir");
    }

    @Test
    public void testBrokenSymlinkMove() throws Exception {
        IFileStore baseStore = this.fileStoreRule.getFileStore();
        this.makeLinkStructure();
        FileSystemTestUtil.ensureDoesNotExist(this.aFile);
        FileSystemTestUtil.ensureDoesNotExist(this.aDir);
        Object[] infos = baseStore.childInfos(0, FileSystemTestUtil.getMonitor());
        Assertions.assertThat((Object[])infos).hasSize(4);
        Function<String, Consumer> isSymLinkCheckProvider = link -> info -> {
            Assertions.assertThat((String)link).isEqualTo(info.getName());
            Assertions.assertThat((boolean)info.getAttribute(32)).isTrue();
        };
        IFileStore _llFile = baseStore.getChild("_llFile");
        IFileStore _llDir = baseStore.getChild("_llDir");
        this.llFile.move(_llFile, 0, FileSystemTestUtil.getMonitor());
        this.llDir.move(_llDir, 0, FileSystemTestUtil.getMonitor());
        infos = baseStore.childInfos(0, FileSystemTestUtil.getMonitor());
        ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])infos).hasSize(4)).noneSatisfy(isSymLinkCheckProvider.apply(this.llFile.getName()))).noneSatisfy(isSymLinkCheckProvider.apply(this.llDir.getName()))).anySatisfy(isSymLinkCheckProvider.apply(_llFile.getName()));
        IFileStore _lFile = baseStore.getChild("_lFile");
        IFileStore _lDir = baseStore.getChild("_lDir");
        this.lFile.move(_lFile, 0, FileSystemTestUtil.getMonitor());
        this.lDir.move(_lDir, 0, FileSystemTestUtil.getMonitor());
        infos = baseStore.childInfos(0, FileSystemTestUtil.getMonitor());
        ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])infos).hasSize(4)).noneSatisfy(isSymLinkCheckProvider.apply(this.lFile.getName()))).noneSatisfy(isSymLinkCheckProvider.apply(this.lDir.getName()))).anySatisfy(isSymLinkCheckProvider.apply(_lFile.getName()));
    }

    @Test
    public void testBrokenSymlinkRemove() throws Exception {
        IFileStore baseStore = this.fileStoreRule.getFileStore();
        this.makeLinkStructure();
        FileSystemTestUtil.ensureDoesNotExist(this.aFile);
        FileSystemTestUtil.ensureDoesNotExist(this.aDir);
        Object[] infos = baseStore.childInfos(0, FileSystemTestUtil.getMonitor());
        Assertions.assertThat((Object[])infos).hasSize(4);
        this.llFile.delete(0, FileSystemTestUtil.getMonitor());
        this.llDir.delete(0, FileSystemTestUtil.getMonitor());
        infos = baseStore.childInfos(0, FileSystemTestUtil.getMonitor());
        Assertions.assertThat((Object[])infos).hasSize(2);
        this.lFile.delete(0, FileSystemTestUtil.getMonitor());
        this.lDir.delete(0, FileSystemTestUtil.getMonitor());
        infos = baseStore.childInfos(0, FileSystemTestUtil.getMonitor());
        Assertions.assertThat((Object[])infos).isEmpty();
    }

    @Test
    public void testRecursiveSymlink() throws Exception {
        IFileStore baseStore = this.fileStoreRule.getFileStore();
        this.mkLink(baseStore, "l1", "l2", false);
        this.mkLink(baseStore, "l2", "l1", false);
        IFileStore l1 = baseStore.getChild("l1");
        IFileInfo i1 = l1.fetchInfo();
        Assert.assertEquals((Object)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (Object)i1.exists());
        Assert.assertFalse((boolean)i1.isDirectory());
        Assert.assertTrue((boolean)i1.getAttribute(32));
        Assert.assertEquals((Object)"l2", (Object)i1.getStringAttribute(64));
        Object[] infos = baseStore.childInfos(0, FileSystemTestUtil.getMonitor());
        Assertions.assertThat((Object[])infos).hasSize(2);
        i1.setAttribute(2, true);
        boolean exceptionThrown = false;
        try {
            l1.putInfo(i1, 1024, FileSystemTestUtil.getMonitor());
        }
        catch (CoreException ce) {
            exceptionThrown = true;
        }
        i1 = l1.fetchInfo();
        boolean fixMeFixed = false;
        if (fixMeFixed) {
            Assert.assertTrue((boolean)exceptionThrown);
            Assert.assertTrue((boolean)i1.getAttribute(2));
        }
        Assert.assertEquals((Object)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (Object)i1.exists());
        i1.setLastModified(12345L);
        exceptionThrown = false;
        try {
            l1.putInfo(i1, 2048, FileSystemTestUtil.getMonitor());
        }
        catch (CoreException ce) {
            exceptionThrown = true;
        }
        i1 = l1.fetchInfo();
        Assert.assertEquals((Object)SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES, (Object)i1.exists());
        l1.delete(0, FileSystemTestUtil.getMonitor());
        infos = baseStore.childInfos(0, FileSystemTestUtil.getMonitor());
        Assertions.assertThat((Object[])infos).hasSize(1);
    }

    @Test
    public void testSymlinkAttributes() throws Exception {
        this.makeLinkStructure();
        Assert.assertFalse((boolean)this.iFile.getAttribute(32));
        Assert.assertFalse((boolean)this.iDir.getAttribute(32));
        Assert.assertTrue((boolean)this.ilFile.exists());
        Assert.assertFalse((boolean)this.ilFile.isDirectory());
        Assert.assertTrue((boolean)this.illFile.exists());
        Assert.assertFalse((boolean)this.illFile.isDirectory());
        Assert.assertTrue((boolean)this.ilDir.exists());
        Assert.assertTrue((boolean)this.ilDir.isDirectory());
        Assert.assertTrue((boolean)this.illDir.exists());
        Assert.assertTrue((boolean)this.illDir.isDirectory());
        if (SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES) {
            Assert.assertTrue((this.illFile.getLastModified() >= this.iFile.getLastModified() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)this.illFile.getLength());
            Assert.assertTrue((this.illDir.getLastModified() >= this.iDir.getLastModified() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)this.illDir.getLength());
        } else {
            Assert.assertEquals((long)this.iFile.getLastModified(), (long)this.illFile.getLastModified());
            Assert.assertEquals((long)this.iFile.getLength(), (long)this.illFile.getLength());
            Assert.assertEquals((long)this.iDir.getLastModified(), (long)this.illDir.getLastModified());
            Assert.assertEquals((long)this.iDir.getLength(), (long)this.illDir.getLength());
        }
        Assert.assertTrue((boolean)this.ilFile.getAttribute(32));
        Assert.assertEquals((Object)this.ilFile.getStringAttribute(64), (Object)"aFile");
        Assert.assertTrue((boolean)this.ilDir.getAttribute(32));
        Assert.assertEquals((Object)this.ilDir.getStringAttribute(64), (Object)"aDir");
        Assert.assertTrue((boolean)this.illFile.getAttribute(32));
        Assert.assertEquals((Object)this.illFile.getStringAttribute(64), (Object)"lFile");
        Assert.assertTrue((boolean)this.illDir.getAttribute(32));
        Assert.assertEquals((Object)this.illDir.getStringAttribute(64), (Object)"lDir");
    }

    @Test
    public void testSymlinkDirRead() throws Exception {
        this.makeLinkStructure();
        IFileStore childDir = this.aDir.getChild("subDir");
        FileSystemTestUtil.ensureExists(childDir, true);
        Object[] infos = this.llDir.childInfos(0, FileSystemTestUtil.getMonitor());
        Assertions.assertThat((Object[])infos).hasSize(1);
        Assert.assertTrue((boolean)infos[0].isDirectory());
        Assert.assertFalse((boolean)infos[0].getAttribute(32));
        Assert.assertNull((Object)infos[0].getStringAttribute(64));
        Assert.assertEquals((Object)infos[0].getName(), (Object)"subDir");
        FileSystemTestUtil.ensureDoesNotExist(childDir);
    }

    @Test
    public void testSymlinkDirWrite() throws Exception {
        this.makeLinkStructure();
        IFileStore childFile = this.llDir.getChild("subFile");
        FileSystemTestUtil.ensureExists(childFile, false);
        Object[] infos = this.aDir.childInfos(0, FileSystemTestUtil.getMonitor());
        Assertions.assertThat((Object[])infos).hasSize(1);
        Assert.assertFalse((boolean)infos[0].isDirectory());
        Assert.assertFalse((boolean)infos[0].getAttribute(32));
        Assert.assertNull((Object)infos[0].getStringAttribute(64));
        Assert.assertEquals((Object)infos[0].getName(), (Object)"subFile");
        FileSystemTestUtil.ensureDoesNotExist(this.aDir);
        childFile = this.llDir.getChild("subFile");
        OutputStream out = null;
        boolean exceptionThrown = false;
        try {
            out = childFile.openOutputStream(0, FileSystemTestUtil.getMonitor());
        }
        catch (CoreException ce) {
            exceptionThrown = true;
        }
        if (out != null) {
            out.close();
        }
        Assert.assertNull((Object)out);
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testSymlinkEnabled() {
        Assert.assertTrue((boolean)this.haveSymlinks());
    }

    public void _testSymlinkExtendedChars() throws Exception {
        IFileStore baseStore = this.fileStoreRule.getFileStore();
        IFileStore childDir = baseStore.getChild(specialCharName);
        FileSystemTestUtil.ensureExists(childDir, true);
        IFileStore childFile = baseStore.getChild("ff" + specialCharName);
        FileSystemTestUtil.ensureExists(childFile, false);
        this.mkLink(baseStore, "l" + specialCharName, specialCharName, true);
        this.mkLink(baseStore, "lf" + specialCharName, "ff" + specialCharName, false);
        Object[] infos = baseStore.childInfos(0, FileSystemTestUtil.getMonitor());
        Assertions.assertThat((Object[])infos).hasSize(4);
        Assertions.assertThat((Object[])infos).allSatisfy(info -> {
            Assertions.assertThat((String)info.getName()).endsWith((CharSequence)specialCharName);
            Assertions.assertThat((Comparable)info).matches(IFileInfo::exists, "exists");
            if (info.getName().charAt(1) == 'f') {
                Assertions.assertThat((Comparable)info).matches(Predicate.not(IFileInfo::isDirectory), "is not a directory");
            } else {
                Assertions.assertThat((Comparable)info).matches(IFileInfo::isDirectory, "is a directory");
            }
            if (info.getName().charAt(0) == 'l') {
                Assertions.assertThat((Comparable)info).matches(it -> it.getAttribute(32), "is symlink");
                Assertions.assertThat((boolean)info.getStringAttribute(64).endsWith(specialCharName));
            }
        });
    }

    @Test
    public void testSymlinkPutLastModified() throws Exception {
        Assume.assumeFalse((String)"setting EFS.SET_LAST_MODIFIED fails on Mac", (boolean)Platform.OS.isMac());
        this.makeLinkStructure();
        long oldTime = this.iFile.getLastModified();
        long timeToSet = oldTime - 100000L;
        this.illFile.setLastModified(timeToSet);
        this.llFile.putInfo(this.illFile, 3072, FileSystemTestUtil.getMonitor());
        this.iFile = this.aFile.fetchInfo();
        Assert.assertEquals((long)this.iFile.getLastModified(), (long)timeToSet);
        oldTime = this.iDir.getLastModified();
        timeToSet = oldTime - 100000L;
        this.illDir.setLastModified(timeToSet);
        this.llDir.putInfo(this.illDir, 3072, FileSystemTestUtil.getMonitor());
        this.iDir = this.aDir.fetchInfo();
        Assert.assertTrue((this.iDir.getLastModified() != oldTime ? 1 : 0) != 0);
        Assert.assertEquals((long)this.iDir.getLastModified(), (long)timeToSet);
        this.illFile = this.llFile.fetchInfo();
        this.illDir = this.llDir.fetchInfo();
        Assert.assertTrue((boolean)this.illFile.getAttribute(32));
        Assert.assertTrue((boolean)this.illDir.getAttribute(32));
        Assert.assertEquals((Object)this.illFile.getStringAttribute(64), (Object)"lFile");
        Assert.assertEquals((Object)this.illDir.getStringAttribute(64), (Object)"lDir");
    }

    @Test
    public void testSymlinkPutReadOnly() throws Exception {
        this.makeLinkStructure();
        this.illFile.setAttribute(2, true);
        this.llFile.putInfo(this.illFile, 1024, FileSystemTestUtil.getMonitor());
        this.iFile = this.aFile.fetchInfo();
        Assert.assertEquals((Object)(!SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES ? 1 : 0), (Object)this.iFile.getAttribute(2));
        this.illFile.setAttribute(2, false);
        this.llFile.putInfo(this.illFile, 1024, FileSystemTestUtil.getMonitor());
        this.iFile = this.aFile.fetchInfo();
        Assert.assertFalse((boolean)this.iFile.getAttribute(2));
        this.illDir.setAttribute(2, true);
        this.llDir.putInfo(this.illDir, 1024, FileSystemTestUtil.getMonitor());
        this.iDir = this.aDir.fetchInfo();
        Assert.assertEquals((Object)(!SYMLINKS_ARE_FIRST_CLASS_FILES_OR_DIRECTORIES ? 1 : 0), (Object)this.iDir.getAttribute(2));
        this.illDir.setAttribute(2, false);
        this.llDir.putInfo(this.illDir, 1024, FileSystemTestUtil.getMonitor());
        this.iDir = this.aDir.fetchInfo();
        Assert.assertFalse((boolean)this.iDir.getAttribute(2));
        this.illFile = this.llFile.fetchInfo();
        this.illDir = this.llDir.fetchInfo();
        Assert.assertTrue((boolean)this.illFile.getAttribute(32));
        Assert.assertTrue((boolean)this.illDir.getAttribute(32));
        Assert.assertEquals((Object)this.illFile.getStringAttribute(64), (Object)"lFile");
        Assert.assertEquals((Object)this.illDir.getStringAttribute(64), (Object)"lDir");
    }

    @Test
    public void testSymlinkPutExecutable() throws Exception {
        Assume.assumeTrue((String)"only relevant for platforms supporting hidden attribute", (boolean)SymlinkTest.isAttributeSupported(4));
        this.makeLinkStructure();
        this.illFile.setAttribute(4, true);
        this.llFile.putInfo(this.illFile, 1024, FileSystemTestUtil.getMonitor());
        this.iFile = this.aFile.fetchInfo();
        Assert.assertTrue((boolean)this.iFile.getAttribute(4));
        this.illDir.setAttribute(4, false);
        this.llDir.putInfo(this.illDir, 1024, FileSystemTestUtil.getMonitor());
        this.iDir = this.aDir.fetchInfo();
        Assert.assertFalse((boolean)this.iDir.getAttribute(4));
        this.illFile = this.llFile.fetchInfo();
        this.illDir = this.llDir.fetchInfo();
        Assert.assertTrue((boolean)this.illFile.getAttribute(32));
        Assert.assertTrue((boolean)this.illDir.getAttribute(32));
        Assert.assertEquals((Object)this.illFile.getStringAttribute(64), (Object)"lFile");
        Assert.assertEquals((Object)this.illDir.getStringAttribute(64), (Object)"lDir");
    }

    @Test
    public void testSymlinkPutHidden() throws Exception {
        Assume.assumeTrue((String)"only relevant for platforms supporting hidden attribute", (boolean)SymlinkTest.isAttributeSupported(16));
        this.makeLinkStructure();
        this.illFile.setAttribute(16, true);
        this.llFile.putInfo(this.illFile, 1024, FileSystemTestUtil.getMonitor());
        this.illFile = this.llFile.fetchInfo();
        Assert.assertTrue((boolean)this.illFile.getAttribute(16));
        this.iFile = this.aFile.fetchInfo();
        Assert.assertFalse((boolean)this.iFile.getAttribute(16));
        this.illDir.setAttribute(16, true);
        this.llDir.putInfo(this.illDir, 1024, FileSystemTestUtil.getMonitor());
        this.illDir = this.llDir.fetchInfo();
        Assert.assertTrue((boolean)this.illDir.getAttribute(16));
        this.iDir = this.aDir.fetchInfo();
        Assert.assertFalse((boolean)this.iDir.getAttribute(16));
        this.illFile = this.llFile.fetchInfo();
        this.illDir = this.llDir.fetchInfo();
        Assert.assertTrue((boolean)this.illFile.getAttribute(32));
        Assert.assertTrue((boolean)this.illDir.getAttribute(32));
        Assert.assertEquals((Object)this.illFile.getStringAttribute(64), (Object)"lFile");
        Assert.assertEquals((Object)this.illDir.getStringAttribute(64), (Object)"lDir");
    }

    @Test
    public void testSymlinkRemove() throws Exception {
        this.makeLinkStructure();
        this.lFile.delete(0, FileSystemTestUtil.getMonitor());
        this.illFile = this.lFile.fetchInfo();
        Assert.assertFalse((boolean)this.illFile.exists());
        this.iFile = this.aFile.fetchInfo();
        Assert.assertTrue((boolean)this.iFile.exists());
        IFileStore childFile = this.aDir.getChild("subFile");
        FileSystemTestUtil.ensureExists(childFile, false);
        this.lDir.delete(0, FileSystemTestUtil.getMonitor());
        this.illDir = this.lDir.fetchInfo();
        Assert.assertFalse((boolean)this.illFile.exists());
        this.iDir = this.aDir.fetchInfo();
        Assert.assertTrue((boolean)this.iDir.exists());
        IFileInfo iFileInsideDir = childFile.fetchInfo();
        Assert.assertTrue((boolean)iFileInsideDir.exists());
    }

    private static boolean isAttributeSupported(int attribute) {
        return (EFS.getLocalFileSystem().attributes() & attribute) != 0;
    }
}

