/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class URIUtilTest {
    @Test
    public void testEquals() {
        if (EFS.getLocalFileSystem().isCaseSensitive()) {
            URI two;
            URI one = new File("c:\\temp\\test").toURI();
            Assert.assertTrue((String)"1.0", (!URIUtil.equals((URI)one, (URI)(two = new File("c:\\TEMP\\test").toURI())) ? 1 : 0) != 0);
        } else {
            URI one = new File("c:\\temp\\test").toURI();
            URI two = new File("c:\\TEMP\\test").toURI();
            Assert.assertTrue((String)"1.0", (boolean)URIUtil.equals((URI)one, (URI)two));
        }
    }

    @Test
    public void testPathToURI() {
        if (Platform.getOS().equals("win32")) {
            Assert.assertEquals((String)"1.0", (Object)"/c:/temp/with spaces", (Object)URIUtil.toURI((String)"c:\\temp\\with spaces").getSchemeSpecificPart());
        } else {
            Assert.assertEquals((String)"2.0", (Object)"/tmp/with spaces", (Object)URIUtil.toURI((String)"/tmp/with spaces").getSchemeSpecificPart());
        }
    }

    @Test
    public void testStringToURI() {
        if (Platform.getOS().equals("win32")) {
            Assert.assertEquals((String)"1.0", (Object)"/c:/temp/with spaces", (Object)URIUtil.toURI((IPath)IPath.fromOSString((String)"c:\\temp\\with spaces")).getSchemeSpecificPart());
        } else {
            Assert.assertEquals((String)"1.0", (Object)"/tmp/with spaces", (Object)URIUtil.toURI((IPath)IPath.fromOSString((String)"/tmp/with spaces")).getSchemeSpecificPart());
        }
    }

    @Test
    public void testToPath() throws Exception {
        String pathString = "test/path with/spaces to_file.txt";
        Assert.assertEquals((String)"1.0", (Object)IPath.fromOSString((String)pathString), (Object)URIUtil.toPath((URI)URIUtil.toURI((String)pathString, (boolean)false)));
        pathString = Platform.getOS().equals("win32") ? "c:/test/path with/spaces to_file.txt" : "/test/path with/spaces to_file.txt";
        Assert.assertEquals((String)"2.0", (Object)IPath.fromOSString((String)pathString), (Object)URIUtil.toPath((URI)URIUtil.toURI((String)pathString)));
        Assert.assertEquals((String)"3.0", (Object)IPath.fromOSString((String)pathString), (Object)URIUtil.toPath((URI)WrapperFileSystem.getWrappedURI(URIUtil.toURI((String)pathString))));
    }

    @Test
    public void testToURIAbsolute() {
        String pathString = null;
        pathString = Platform.getOS().equals("win32") ? "c:/test/path with/spaces to_file.txt" : "/test/path with/spaces to_file.txt";
        IPath path = IPath.fromOSString((String)pathString);
        URI uri01 = URIUtil.toURI((IPath)path);
        URI uri02 = URIUtil.toURI((String)pathString);
        Assert.assertEquals((String)"1.0", (Object)uri01, (Object)uri02);
    }

    @Test
    public void testToURIRelative() {
        String pathString = "test/path with/spaces to_file.txt";
        IPath path = IPath.fromOSString((String)pathString);
        URI uri01 = URIUtil.toURI((IPath)path);
        URI uri02 = URIUtil.toURI((String)pathString, (boolean)false);
        Assert.assertEquals((String)"1.0", (Object)uri01, (Object)uri02);
        Assert.assertTrue((String)"1.1", (!uri01.isAbsolute() ? 1 : 0) != 0);
        Assert.assertTrue((String)"1.2", (!uri02.isAbsolute() ? 1 : 0) != 0);
    }

    @Test
    public void testFromPathToURI() {
        IPath aPath = null;
        aPath = Platform.getOS().equals("win32") ? IPath.fromOSString((String)"c:/test/path with spaces/to_file.txt") : IPath.fromOSString((String)"/test/path with spaces/to_file.txt");
        IPath rPath = IPath.fromOSString((String)"relative/with spaces/path/to_file.txt");
        URI aUri = URIUtil.toURI((IPath)aPath);
        URI rUri = URIUtil.toURI((IPath)rPath);
        Assert.assertEquals((String)"1.0", (Object)aPath.toString(), (Object)URIUtil.toPath((URI)aUri).toString());
        Assert.assertEquals((String)"2.0", (Object)rPath.toString(), (Object)URIUtil.toPath((URI)rUri).toString());
    }

    @Test
    public void testBug291323_doubleDotLocationPath() {
        URI aUri = URIUtil.toURI((String)"..");
        URI bUri = URIUtil.toURI((String)"");
        Assert.assertEquals((String)"1.0", (Object)URIUtil.toPath((URI)bUri).toString(), (Object)URIUtil.toPath((URI)aUri).toString());
    }
}

