/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.alias;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.internal.filesystem.NullFileStore;
import org.eclipse.core.internal.filesystem.NullFileSystem;
import org.eclipse.core.internal.resources.AliasManager;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileSystem;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class BasicAliasTest {
    private IProject pNoOverlap;
    private IProject pOverlap;
    private IProject pLinked;
    private IFolder fOverlap;
    private IFile lChildOverlap;
    private IFile lOverlap;
    private IFolder fLinked;
    private IFolder fLinkOverlap1;
    private IFolder fLinkOverlap2;
    private IFile lLinked;
    private IFile lChildLinked;
    private IPath linkOverlapLocation;

    public void assertOverlap(IResource resource1, IResource resource2) throws CoreException {
        Assertions.assertThat((Object)resource1.getLocation()).isEqualTo((Object)resource2.getLocation());
        Assertions.assertThat((Object)resource1).matches(it -> it.isSynchronized(0), "is synchronized");
        Assertions.assertThat((Object)resource2).matches(it -> it.isSynchronized(0), "is synchronized");
        Object[] children1 = null;
        IResource[] children2 = null;
        children1 = this.getSortedChildren(resource1);
        children2 = this.getSortedChildren(resource2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])children1).as("number of children", new Object[0])).hasSameSizeAs((Object)children2);
        int i = 0;
        while (i < children2.length) {
            this.assertOverlap((IResource)children1[i], children2[i]);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private IResource[] getSortedChildren(IResource resource) throws CoreException {
        void container;
        if (!(resource instanceof IContainer)) {
            return new IResource[0];
        }
        IContainer iContainer = (IContainer)resource;
        IResource[] children = container.members();
        Arrays.sort(children, (arg0, arg1) -> arg0.getFullPath().toString().compareTo(arg1.getFullPath().toString()));
        return children;
    }

    @BeforeEach
    public void setUp(@TempDir Path tempDirectory) throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.pNoOverlap = root.getProject("NoOverlap");
        ResourceTestUtil.createInWorkspace((IResource)this.pNoOverlap);
        ResourceTestUtil.createInWorkspace(ResourceTestUtil.buildResources((IContainer)this.pNoOverlap, new String[]{"/1/", "/1/1", "/1/2", "/2/", "/2/1"}));
        this.pOverlap = root.getProject("Overlap");
        ResourceTestUtil.createInWorkspace((IResource)this.pOverlap);
        this.fOverlap = this.pOverlap.getFolder("fOverlap");
        IFolder f2 = this.pOverlap.getFolder("F2");
        this.lOverlap = f2.getFile("lOverlap");
        this.lChildOverlap = this.fOverlap.getFile("lChildOverlap");
        ResourceTestUtil.createInWorkspace(new IResource[]{this.fOverlap, f2, this.lOverlap, this.lChildOverlap});
        ResourceTestUtil.createInWorkspace(ResourceTestUtil.buildResources((IContainer)this.pOverlap, new String[]{"/1/", "/1/1", "/1/2"}));
        ResourceTestUtil.createInWorkspace(ResourceTestUtil.buildResources((IContainer)f2, new String[]{"/1/", "/1/1", "/1/2"}));
        ResourceTestUtil.createInWorkspace(ResourceTestUtil.buildResources((IContainer)this.fOverlap, new String[]{"/1/", "/1/1", "/1/2"}));
        this.pLinked = root.getProject("LinkProject");
        ResourceTestUtil.createInWorkspace((IResource)this.pLinked);
        this.fLinked = this.pLinked.getFolder("LinkedFolder");
        this.fLinkOverlap1 = this.pLinked.getFolder("LinkOverlap1");
        this.fLinkOverlap2 = this.pLinked.getFolder("LinkOverlap2");
        this.lLinked = this.pLinked.getFile("LinkedFile");
        this.lChildLinked = this.fLinked.getFile(this.lChildOverlap.getName());
        this.fLinked.createLink(this.fOverlap.getLocation(), 0, null);
        this.lLinked.createLink(this.lOverlap.getLocation(), 0, null);
        ResourceTestUtil.createInWorkspace((IResource)this.lChildLinked);
        ResourceTestUtil.createInWorkspace(ResourceTestUtil.buildResources((IContainer)this.pLinked, new String[]{"/a/", "/a/a", "/a/b"}));
        ResourceTestUtil.createInWorkspace(ResourceTestUtil.buildResources((IContainer)this.fLinked, new String[]{"/a/", "/a/a", "/a/b"}));
        this.linkOverlapLocation = ResourceTestUtil.wrapInCanonicalIPath(tempDirectory);
        this.linkOverlapLocation.toFile().mkdirs();
        this.fLinkOverlap1.createLink(this.linkOverlapLocation, 0, null);
        this.fLinkOverlap2.createLink(this.linkOverlapLocation, 0, null);
    }

    @Test
    public void testBug32785(@TempDir Path tempDirectory) throws CoreException, IOException {
        IProject project = this.pNoOverlap;
        IFolder link = project.getFolder("Source");
        IFile child = link.getFile("Child.txt");
        IPath location = ResourceTestUtil.wrapInCanonicalIPath(tempDirectory);
        link.createLink(location, 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.createInWorkspace(child, ResourceTestUtil.createRandomString());
        IFolder movedLink = project.getFolder("MovedLink");
        link.move(movedLink.getFullPath(), 32, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)link.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)movedLink.exists());
        org.junit.jupiter.api.Assertions.assertEquals((Object)location, (Object)movedLink.getLocation());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)movedLink.isSynchronized(2));
        IFolder copiedLink = project.getFolder("CopiedLink");
        movedLink.copy(copiedLink.getFullPath(), 32, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)link.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)movedLink.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)copiedLink.exists());
        org.junit.jupiter.api.Assertions.assertEquals((Object)location, (Object)movedLink.getLocation());
        org.junit.jupiter.api.Assertions.assertEquals((Object)location, (Object)copiedLink.getLocation());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)movedLink.isSynchronized(2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)copiedLink.isSynchronized(2));
    }

    @Test
    public void testBug156082() throws CoreException {
        IProject top = ResourcesPlugin.getWorkspace().getRoot().getProject("Bug156082_Top");
        IProject sub1 = ResourcesPlugin.getWorkspace().getRoot().getProject("Bug156082_Sub1");
        IProject sub2 = ResourcesPlugin.getWorkspace().getRoot().getProject("Bug156082_Sub2");
        ResourceTestUtil.createInWorkspace((IResource)top);
        IProjectDescription desc1 = ResourcesPlugin.getWorkspace().newProjectDescription(sub1.getName());
        desc1.setLocation(top.getLocation().append(sub1.getName()));
        IProjectDescription desc2 = ResourcesPlugin.getWorkspace().newProjectDescription(sub2.getName());
        desc2.setLocation(top.getLocation().append(sub2.getName()));
        sub1.create(desc1, ResourceTestUtil.createTestMonitor());
        sub1.open(ResourceTestUtil.createTestMonitor());
        sub2.create(desc2, ResourceTestUtil.createTestMonitor());
        sub2.open(ResourceTestUtil.createTestMonitor());
        IFile sub2File = sub2.getFile("file.txt");
        IFile topFile = top.getFolder(sub2.getName()).getFile(sub2File.getName());
        ResourceTestUtil.createInWorkspace(sub2File, ResourceTestUtil.createRandomString());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)topFile.exists());
    }

    @Test
    public void testBug198571() throws Exception {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        String[] devices = ResourceTestUtil.findAvailableDevices();
        Assume.assumeFalse((String)"only executable if at least two volumes are present", (devices[0] == null || devices[1] == null ? 1 : 0) != 0);
        String location = ResourceTestUtil.createUniqueString();
        IProject testProject1 = ResourcesPlugin.getWorkspace().getRoot().getProject(location + "1");
        IProject testProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(location + "2");
        IProjectDescription desc1 = ResourcesPlugin.getWorkspace().newProjectDescription(testProject1.getName());
        IPath location1 = IPath.fromOSString((String)(devices[0] + location));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)location1.toFile().exists());
        desc1.setLocation(location1);
        IProjectDescription desc2 = ResourcesPlugin.getWorkspace().newProjectDescription(testProject2.getName());
        IPath location2 = IPath.fromOSString((String)(devices[1] + location));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)location2.toFile().exists());
        desc2.setLocation(location2);
        testProject1.create(desc1, ResourceTestUtil.createTestMonitor());
        testProject1.open(ResourceTestUtil.createTestMonitor());
        testProject2.create(desc2, ResourceTestUtil.createTestMonitor());
        testProject2.open(ResourceTestUtil.createTestMonitor());
        AliasManager aliasManager = ((Workspace)ResourcesPlugin.getWorkspace()).getAliasManager();
        aliasManager.startup(null);
        IFolder folder = testProject2.getFolder("NewFolder");
        ResourceTestUtil.createInFileSystem((IResource)folder);
        testProject2.refreshLocal(2, null);
        IResource[] resources = aliasManager.computeAliases((IResource)folder, ((Folder)folder).getStore());
        org.junit.jupiter.api.Assertions.assertNull((Object)resources);
    }

    private void replaceProject(IProject project, URI newLocation) throws CoreException, IOException {
        IProjectDescription projectDesc = project.getDescription();
        projectDesc.setLocationURI(newLocation);
        project.move(projectDesc, 256, null);
    }

    @Test
    public void testCompareUriAuthorityDistinct() throws URISyntaxException {
        this.assertComparedDistinct(List.of("batfs://authority1/path?query#fragment", "batfs://authority2/path?query#fragment"));
    }

    private void assertComparedDistinct(List<String> urisStrings) {
        List<BatFSURI> batfsList = urisStrings.stream().map(BatFSURI::new).toList();
        for (BatFSURI bu1 : batfsList) {
            for (BatFSURI bu2 : batfsList) {
                if (bu1.equals((Object)bu2)) continue;
                org.junit.jupiter.api.Assertions.assertNotEquals((int)0, (int)bu1.compareTo((IFileStore)bu2));
            }
        }
    }

    @Test
    public void testCompareUriPathHierarchy() throws URISyntaxException {
        this.assertPreOrdered(List.of("batfs://Server/Volume:segment1a", "batfs://Server/Volume:segment1a/a", "batfs://Server/Volume:segment1a/a%00", "batfs://Server/Volume:segment1a/segment2a", "batfs://Server/Volume:segment1a/segment2a%00", "batfs://Server/Volume:segment1a/segment2b", "batfs://Server/Volume:segment1a/segment2b%00", "batfs://Server/Volume:segment1a%00", "batfs://Server/Volume:segment2a", "batfs://Server/Volume:segment2a/b", "batfs://Server/Volume:segment2a/segment2a", "batfs://Server/Volume:segment2a/segment2b", "batfs://Server/Volume:segment2a%00"));
    }

    @Test
    public void testCompareUriOctets() throws URISyntaxException {
        this.assertPreOrdered(List.of("http://Server/Volume:A", "http://Server/Volume:%41", "http://Server/Volume:A", "http://Server/Volume:%41"));
    }

    @Test
    public void testCompareUriCase() throws URISyntaxException {
        this.assertComparedDistinct(List.of("http://Server/Volume:a", "http://Server/Volume:A"));
    }

    @Test
    public void testCompareUriFragment() throws URISyntaxException {
        this.assertPreOrdered(List.of("bats://authority/path?query#fragment1", "bats://authority/path?query#fragment2", "bats://authority/path?query#fragment1", "bats://authority/path?query#fragment2"));
    }

    private void assertPreOrdered(List<String> urisStrings) {
        List<BatFSURI> batfsList = urisStrings.stream().map(BatFSURI::new).toList();
        List sorted = batfsList.stream().sorted(IFileStore::compareTo).toList();
        org.junit.jupiter.api.Assertions.assertEquals(batfsList, sorted);
    }

    @Test
    public void testBug256837(@TempDir Path tempDirectory) throws Throwable {
        AliasManager aliasManager = ((Workspace)ResourcesPlugin.getWorkspace()).getAliasManager();
        aliasManager.startup(null);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject p1 = root.getProject(ResourceTestUtil.createUniqueString());
        IProject p2 = root.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace(new IResource[]{p1, p2});
        IFileStore tempStore = ResourceTestUtil.getFileStore(tempDirectory);
        tempStore.mkdir(0, ResourceTestUtil.createTestMonitor());
        IFolder link2TempFolder = p1.getFolder("link2TempFolder");
        FileSystemHelper.deleteAfterExecution((Path)p2.getLocation().toPath(), () -> {
            this.replaceProject(p2, WrapperFileSystem.getWrappedURI(p2.getLocationURI()));
            link2TempFolder.createLink(tempStore.toURI(), 0, ResourceTestUtil.createTestMonitor());
            this.replaceProject(p2, tempStore.toURI());
        });
        Object[] resources = aliasManager.computeAliases((IResource)link2TempFolder, ((Folder)link2TempFolder).getStore());
        Assertions.assertThat((Object[])resources).containsExactly((Object[])new IResource[]{p2});
        resources = aliasManager.computeAliases((IResource)p2, ((Project)p2).getStore());
        Assertions.assertThat((Object[])resources).containsExactly((Object[])new IResource[]{link2TempFolder});
    }

    @Test
    public void testBug258987(@TempDir Path tempDirectory) throws Exception {
        IFileStore dirStore = ResourceTestUtil.getFileStore(tempDirectory);
        dirStore.mkdir(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dirStore.fetchInfo().exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dirStore.fetchInfo().isDirectory());
        IFileStore childStore = dirStore.getChild("child");
        ResourceTestUtil.createInFileSystem(childStore);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)childStore.fetchInfo().exists());
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("project1");
        IFolder folder1 = null;
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        folder1 = project1.getFolder("subdir");
        folder1.createLink(dirStore.toURI(), 256, ResourceTestUtil.createTestMonitor());
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("project2");
        IFolder folder2 = null;
        project2.create(ResourceTestUtil.createTestMonitor());
        project2.open(ResourceTestUtil.createTestMonitor());
        folder2 = project2.getFolder("subdir");
        folder2.createLink(dirStore.toURI(), 256, ResourceTestUtil.createTestMonitor());
        project2.close(ResourceTestUtil.createTestMonitor());
        IResource[] resources = ((Workspace)ResourcesPlugin.getWorkspace()).getAliasManager().computeAliases((IResource)folder1, ((Folder)folder1).getStore());
        org.junit.jupiter.api.Assertions.assertNull((Object)resources);
    }

    @Test
    public void testCloseOpenProject() throws CoreException {
        this.pOverlap.close(ResourceTestUtil.createTestMonitor());
        IFile linkFile = this.fLinked.getFile("ChildFile.txt");
        linkFile.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        IFile closedFile = this.fOverlap.getFile(linkFile.getName());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)closedFile.exists());
        this.pOverlap.open(0, ResourceTestUtil.createTestMonitor());
        this.pOverlap.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)closedFile.exists());
    }

    @Test
    public void testCopyFile() throws CoreException {
        IFile sourceFile = this.pNoOverlap.getFile("CopySource");
        ResourceTestUtil.createInWorkspace((IResource)sourceFile);
        IFile linkDest = this.fLinked.getFile("CopyDestination");
        IFile overlapDest = this.fOverlap.getFile(linkDest.getName());
        sourceFile.copy(linkDest.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linkDest.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)overlapDest.exists());
        this.assertOverlap((IResource)linkDest, (IResource)overlapDest);
        linkDest.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)linkDest.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)overlapDest.exists());
        this.assertOverlap((IResource)linkDest, (IResource)overlapDest);
        linkDest = this.lLinked;
        overlapDest = this.lOverlap;
        overlapDest.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linkDest.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)overlapDest.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)linkDest.getLocation().toFile().exists());
        org.junit.jupiter.api.Assertions.assertEquals((Object)linkDest.getLocation(), (Object)overlapDest.getLocation());
        sourceFile.copy(overlapDest.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linkDest.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)overlapDest.exists());
        this.assertOverlap((IResource)linkDest, (IResource)overlapDest);
        linkDest = this.fLinked.getFile("CopyDestination");
        overlapDest = this.fOverlap.getFile(linkDest.getName());
        sourceFile.copy(overlapDest.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linkDest.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)overlapDest.exists());
        this.assertOverlap((IResource)linkDest, (IResource)overlapDest);
        overlapDest.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)linkDest.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)overlapDest.exists());
        this.assertOverlap((IResource)linkDest, (IResource)overlapDest);
    }

    @Test
    public void testCopyFolder() throws CoreException {
        IFolder source = this.pNoOverlap.getFolder("CopyFolder");
        ResourceTestUtil.createInWorkspace((IResource)source);
        IFolder destFolder1 = this.fLinkOverlap1.getFolder(source.getName());
        IFolder destFolder2 = this.fLinkOverlap2.getFolder(source.getName());
        IResource[] allDest = new IResource[]{destFolder1, destFolder2};
        ResourceTestUtil.assertDoesNotExistInWorkspace(allDest);
        source.copy(destFolder1.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(allDest);
        destFolder2.delete(0, ResourceTestUtil.createTestMonitor());
        source.copy(destFolder2.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(allDest);
        destFolder1.delete(0, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testCopyToChild() throws CoreException {
        IFolder copyDest = this.fLinkOverlap1.getFolder("CopyDest");
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> this.fLinkOverlap2.copy(copyDest.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> this.fLinkOverlap2.move(copyDest.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        IFolder copyDest2 = this.fLinkOverlap2.getFolder(copyDest.getName());
        copyDest.create(0, true, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> copyDest.copy(copyDest2.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> copyDest.move(copyDest2.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
    }

    @Test
    public void testCreateDeleteFile() throws CoreException {
        this.lChildLinked.delete(0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        this.lChildLinked.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        this.lOverlap.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.lLinked.getLocation(), (Object)this.lOverlap.getLocation());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.lOverlap.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.lOverlap.getLocation().toFile().exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.lOverlap.isSynchronized(2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.lLinked.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.lLinked.getLocation().toFile().exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.lLinked.isSynchronized(2));
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> this.lLinked.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor()));
        this.lOverlap.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lLinked, (IResource)this.lOverlap);
        this.lChildOverlap.delete(0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        this.lChildOverlap.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
    }

    @Test
    public void testCreateDeleteFolder() throws CoreException {
        this.fOverlap.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fLinked.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fLinked.getLocation().toFile().exists());
        this.fOverlap.create(0, true, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.fOverlap, (IResource)this.fLinked);
        this.fLinked.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fOverlap.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fOverlap.getLocation().toFile().exists());
        this.fLinked.createLink(this.fOverlap.getLocation(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.fOverlap, (IResource)this.fLinked);
        IFolder child1 = this.fLinkOverlap1.getFolder("LinkChild");
        IFolder child2 = this.fLinkOverlap2.getFolder(child1.getName());
        child1.create(0, true, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)child1, (IResource)child2);
        child1.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)child1.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)child2.exists());
        child2.create(0, true, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)child1, (IResource)child2);
        child2.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)child1.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)child2.exists());
    }

    @Test
    public void testCreateDeleteLink() throws CoreException {
        IFolder folder = this.pNoOverlap.getFolder("folder");
        IFile folderChild = folder.getFile("Child.txt");
        IFolder link = this.pLinked.getFolder("FolderLink");
        IFile linkChild = link.getFile(folderChild.getName());
        ResourceTestUtil.createInWorkspace((IResource)folder);
        ResourceTestUtil.createInWorkspace((IResource)folderChild);
        link.createLink(folder.getLocationURI(), 0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linkChild.exists());
        folderChild.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)linkChild.exists());
        ResourceTestUtil.createInWorkspace((IResource)folderChild);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linkChild.exists());
        link.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)linkChild.exists());
    }

    @Test
    public void testDeepLink() throws Exception {
        IFolder folder = this.pNoOverlap.getFolder("folder");
        IFile folderChild = folder.getFile("Child.txt");
        IFolder linkParent = this.pLinked.getFolder("LinkParent");
        IFolder link = linkParent.getFolder("FolderLink");
        IFile linkChild = link.getFile(folderChild.getName());
        ResourceTestUtil.createInWorkspace(new IResource[]{folder, folderChild, linkParent});
        link.createLink(folder.getLocationURI(), 0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linkChild.exists());
        folderChild.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)linkChild.exists());
        ResourceTestUtil.createInWorkspace((IResource)folderChild);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linkChild.exists());
        link.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)linkChild.exists());
        link.createLink(folder.getLocationURI(), 0, ResourceTestUtil.createTestMonitor());
        link.getProject().close(ResourceTestUtil.createTestMonitor());
        link.getProject().open(ResourceTestUtil.createTestMonitor());
        folderChild.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)linkChild.exists());
        ResourceTestUtil.createInWorkspace((IResource)folderChild);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linkChild.exists());
        AliasManager aliasManager = ((Workspace)ResourcesPlugin.getWorkspace()).getAliasManager();
        aliasManager.startup(null);
        folderChild.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)linkChild.exists());
        ResourceTestUtil.createInWorkspace((IResource)folderChild);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linkChild.exists());
        IFile fileInLinkedProject = this.pLinked.getFile("fileInLinkedProject.txt");
        ResourceTestUtil.createInFileSystem(((Resource)fileInLinkedProject).getStore());
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> ResourcesPlugin.getWorkspace().getRoot().delete(0, ResourceTestUtil.createTestMonitor()));
        ResourceTestUtil.waitForRefresh();
        Object[] aliases = aliasManager.computeAliases((IResource)folder, ((Folder)folder).getStore());
        org.junit.jupiter.api.Assertions.assertNull((Object)aliases, (String)("Unexpected aliases: " + Arrays.toString(aliases)));
    }

    @Test
    public void testCreateOpenProject() throws CoreException {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject("createOpenProject");
        IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(newProject.getName());
        desc.setLocationURI(this.fLinkOverlap1.getLocationURI());
        newProject.create(desc, ResourceTestUtil.createTestMonitor());
        newProject.open(ResourceTestUtil.createTestMonitor());
        IFile linkChild = this.fLinkOverlap1.getFile(".project");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)linkChild.exists());
    }

    @Test
    public void testDeleteLink() throws CoreException {
        IFolder linkOnProject = this.pLinked.getFolder("LinkOnProject");
        linkOnProject.createLink(this.pOverlap.getLocation(), 0, ResourceTestUtil.createTestMonitor());
        linkOnProject.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)linkOnProject.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pOverlap.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fOverlap.exists());
    }

    @Test
    public void testDeleteProjectUnderProject() throws CoreException {
        IProject parent = ResourcesPlugin.getWorkspace().getRoot().getProject("parent");
        IProject child = ResourcesPlugin.getWorkspace().getRoot().getProject("child");
        ResourceTestUtil.createInWorkspace((IResource)parent);
        IProjectDescription childDesc = ResourcesPlugin.getWorkspace().newProjectDescription(child.getName());
        childDesc.setLocation(parent.getLocation().append(child.getName()));
        child.create(childDesc, ResourceTestUtil.createTestMonitor());
        child.open(ResourceTestUtil.createTestMonitor());
        IFolder childDirInParent = parent.getFolder(child.getName());
        IFile childProjectFileInParent = childDirInParent.getFile(".project");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)childDirInParent.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)childProjectFileInParent.exists());
        child.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)childDirInParent.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)childProjectFileInParent.exists());
        child.create(childDesc, ResourceTestUtil.createTestMonitor());
        child.open(ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)childDirInParent.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)childProjectFileInParent.exists());
        parent.delete(0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)parent.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)child.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)childDirInParent.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)childProjectFileInParent.exists());
    }

    @Test
    public void testDeleteProjectContents() throws CoreException {
        this.pOverlap.delete(4, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{this.pOverlap, this.fOverlap, this.lOverlap, this.lChildOverlap, this.lChildLinked});
        ResourceTestUtil.assertDoesNotExistInFileSystem(new IResource[]{this.pOverlap, this.fOverlap, this.lOverlap, this.lChildOverlap, this.lChildLinked, this.lLinked, this.fLinked});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{this.pLinked, this.fLinked, this.lLinked});
    }

    @Test
    public void testFileAppendContents() throws CoreException {
        this.lLinked.appendContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lLinked, (IResource)this.lOverlap);
        this.lChildLinked.appendContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        this.lOverlap.appendContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lLinked, (IResource)this.lOverlap);
        this.lChildOverlap.appendContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
    }

    @Test
    public void testFileSetContents() throws CoreException {
        this.lLinked.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lLinked, (IResource)this.lOverlap);
        this.lChildLinked.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        this.lOverlap.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lLinked, (IResource)this.lOverlap);
        this.lChildOverlap.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
    }

    @Test
    public void testMoveFile() throws CoreException {
        IFile destination = this.pNoOverlap.getFile("MoveDestination");
        this.lChildLinked.move(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)this.lChildLinked);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)this.lChildOverlap);
        ResourceTestUtil.assertExistsInWorkspace((IResource)destination);
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.lChildLinked.isSynchronized(2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)destination.isSynchronized(2));
        destination.move(this.lChildLinked.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)this.lChildLinked);
        ResourceTestUtil.assertExistsInWorkspace((IResource)this.lChildOverlap);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        this.lOverlap.move(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)this.lOverlap);
        ResourceTestUtil.assertExistsInWorkspace((IResource)this.lLinked);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)this.lLinked);
        ResourceTestUtil.assertExistsInWorkspace((IResource)destination);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.lLinked.getLocation(), (Object)this.lOverlap.getLocation());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.lLinked.isSynchronized(2));
        destination.move(this.lOverlap.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)this.lLinked);
        ResourceTestUtil.assertExistsInWorkspace((IResource)this.lOverlap);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        this.assertOverlap((IResource)this.lLinked, (IResource)this.lOverlap);
        this.lChildOverlap.move(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)this.lChildLinked);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)this.lChildOverlap);
        ResourceTestUtil.assertExistsInWorkspace((IResource)destination);
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        destination.move(this.lChildOverlap.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)this.lChildLinked);
        ResourceTestUtil.assertExistsInWorkspace((IResource)this.lChildOverlap);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destination);
        this.assertOverlap((IResource)this.lChildLinked, (IResource)this.lChildOverlap);
    }

    static class BatFS
    extends NullFileSystem {
        static final BatFS instance = new BatFS();

        private BatFS() {
            this.initialize("batfs");
        }
    }

    static class BatFSURI
    extends NullFileStore {
        private final URI uri;

        public BatFSURI(String uri) {
            this(BatFSURI.from(uri));
        }

        private static URI from(String uri) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public BatFSURI(URI uri) {
            super(IPath.fromOSString((String)"/not/used"));
            this.uri = uri;
        }

        public IFileSystem getFileSystem() {
            return BatFS.instance;
        }

        public URI toURI() {
            return this.uri;
        }
    }
}

