/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.tests.internal.builders.EmptyDeltaBuilder;
import org.eclipse.core.tests.internal.builders.TestBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class AutoBuildJobTest {
    private IProject project;
    private AtomicLong running;
    private AtomicLong scheduled;
    IJobChangeListener jobChangeListener = new JobChangeAdapter(){

        public void scheduled(IJobChangeEvent event) {
            if (event.getJob().belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD)) {
                AutoBuildJobTest.this.scheduled.incrementAndGet();
            }
        }

        public void running(IJobChangeEvent event) {
            if (event.getJob().belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD)) {
                AutoBuildJobTest.this.running.incrementAndGet();
            }
        }
    };

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.scheduled = new AtomicLong(0L);
        this.running = new AtomicLong(0L);
        this.setupProjectWithOurBuilder(((Method)testInfo.getTestMethod().get()).getName());
        ResourceTestUtil.setAutoBuilding(true);
        Job.getJobManager().addJobChangeListener(this.jobChangeListener);
    }

    @AfterEach
    public void tearDown() throws Exception {
        Job.getJobManager().removeJobChangeListener(this.jobChangeListener);
    }

    private void setupProjectWithOurBuilder(String testMethodName) throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(testMethodName);
        this.project.create(ResourceTestUtil.createTestMonitor());
        this.project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(this.project).addingCommand("org.eclipse.core.tests.resources.emptydeltabuilder").withTestBuilderId(testMethodName).apply();
    }

    private void requestAutoBuildJobExecution() {
        this.getBuildManager().endTopLevel(true);
    }

    private BuildManager getBuildManager() {
        return ((Workspace)this.project.getWorkspace()).getBuildManager();
    }

    @Test
    public void testNoBuildIfBuildRequestedFromSameThread() throws Exception {
        this.triggerAutobuildAndCheckNoExtraBuild(false);
    }

    @Test
    public void testNoBuildIfBuildRequestedFromSameThreadAfterCancel() throws Exception {
        this.triggerAutobuildAndCheckNoExtraBuild(true);
    }

    private void triggerAutobuildAndCheckNoExtraBuild(final boolean cancel) throws Exception {
        final AtomicBoolean cancelled = new AtomicBoolean();
        EmptyDeltaBuilder.getInstance().setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                if (cancel) {
                    monitor.setCanceled(true);
                    cancelled.set(true);
                }
                AutoBuildJobTest.this.requestAutoBuildJobExecution();
                return new IProject[0];
            }
        });
        this.triggerAutoBuildAndWait();
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        Assertions.assertEquals((long)1L, (long)this.scheduled.get(), (String)"Should see one scheduled() call");
        Assertions.assertEquals((long)1L, (long)this.running.get(), (String)"Should see one running() call");
        if (cancel) {
            Assertions.assertEquals((Object)true, (Object)cancelled.get());
        }
    }

    @Test
    public void testExtraBuildIfBuildRequestedFromOtherThreadDuringRun() throws Exception {
        EmptyDeltaBuilder.getInstance().setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                Job job = Job.createSystem((String)"", m -> AutoBuildJobTest.this.requestAutoBuildJobExecution());
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return new IProject[0];
            }
        });
        this.triggerAutoBuildAndWait();
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        Assertions.assertEquals((long)2L, (long)this.scheduled.get(), (String)"Should see two scheduled() calls");
        Assertions.assertEquals((long)2L, (long)this.running.get(), (String)"Should see two running() calls");
    }

    @Test
    public void testWaitForAutoBuild_JobManagerIsSuspended_ExceptionIsThrown() throws Exception {
        try {
            Job.getJobManager().suspend();
            Assertions.assertEquals((long)0L, (long)this.scheduled.get(), (String)"Scheduled calls");
            Assertions.assertEquals((long)0L, (long)this.running.get(), (String)"Running calls");
            this.triggerAutoBuildAndWait();
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            Assertions.assertEquals((long)1L, (long)this.scheduled.get(), (String)"Scheduled calls");
            Assertions.assertEquals((long)0L, (long)this.running.get(), (String)"Running calls");
            Assertions.assertThrows(BuildManager.JobManagerSuspendedException.class, () -> this.waitForAutoBuild(2000L));
        }
        finally {
            Job.getJobManager().resume();
        }
    }

    @Test
    public void testWaitForAutoBuild_JobManagerIsRunning_NoExceptionIsThrown() throws Throwable {
        Assertions.assertEquals((long)0L, (long)this.scheduled.get(), (String)"Scheduled calls");
        Assertions.assertEquals((long)0L, (long)this.running.get(), (String)"Running calls");
        this.triggerAutoBuildAndWait();
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        Assertions.assertEquals((long)1L, (long)this.scheduled.get(), (String)"Scheduled calls");
        Assertions.assertEquals((long)1L, (long)this.running.get(), (String)"Running calls");
        this.waitForAutoBuild(2000L);
    }

    private void triggerAutoBuildAndWait() throws CoreException, InterruptedException {
        this.project.touch(ResourceTestUtil.createTestMonitor());
        Thread.sleep(1000L);
    }

    private void waitForAutoBuild(long timeoutMillis) throws Throwable {
        try {
            ((ForkJoinTask)ForkJoinPool.commonPool().submit(() -> this.getBuildManager().waitForAutoBuild())).get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("This test timed out which means there is no safeguard to avoid waiting indefinitely for an auto-build job while the JobManager is suspended", e);
        }
    }
}

