/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.Map;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.internal.builders.ConfigurationBuilder;
import org.eclipse.core.tests.internal.builders.TestBuilder;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class BuildConfigurationsTest {
    private static final String variant0 = "Variant0";
    private static final String variant1 = "Variant1";
    private static final String variant2 = "Variant2";
    private IProject project0;
    private IProject project1;
    private IFile file0;
    private IFile file1;

    @BeforeEach
    public void setUp() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project0 = root.getProject("BuildVariantTest_p0");
        this.project1 = root.getProject("BuildVariantTest_p1");
        this.file0 = this.project0.getFile("File0");
        this.file1 = this.project1.getFile("File1");
        IResource[] resources = new IResource[]{this.project0, this.project1, this.file0, this.file1};
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.setAutoBuilding(false);
        this.setupProject(this.project0);
        this.setupProject(this.project1);
    }

    private void setupProject(IProject project) throws CoreException {
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.configbuilder").withTestBuilderId("Build0").withBuildingSetting(9, true).withBuildingSetting(6, true).withBuildingSetting(10, true).withBuildingSetting(15, true).apply();
        IProjectDescription desc = project.getDescription();
        desc.setBuildConfigs(new String[]{variant0, variant1, variant2});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testDeltas() throws CoreException {
        ConfigurationBuilder.clearStats();
        this.file0.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        this.incrementalBuild(1, this.project0, variant1, true, 1, 6);
        this.incrementalBuild(2, this.project0, variant1, false, 1, 0);
        this.incrementalBuild(3, this.project0, variant2, true, 1, 6);
        this.incrementalBuild(4, this.project0, variant1, false, 1, 0);
        this.file0.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        this.incrementalBuild(5, this.project0, variant1, true, 2, 10);
        this.incrementalBuild(6, this.project0, variant2, true, 2, 10);
        this.incrementalBuild(7, this.project0, variant0, true, 1, 6);
    }

    @Test
    public void testCloseAndOpenProject() throws CoreException {
        ConfigurationBuilder.clearStats();
        this.file0.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        this.incrementalBuild(1, this.project0, variant0, true, 1, 6);
        this.incrementalBuild(2, this.project0, variant1, true, 1, 6);
        this.incrementalBuild(3, this.project0, variant2, true, 1, 6);
        this.project0.close(ResourceTestUtil.createTestMonitor());
        ConfigurationBuilder.clearStats();
        this.project0.open(ResourceTestUtil.createTestMonitor());
        this.incrementalBuild(4, this.project0, variant0, false, 0, 0);
        this.incrementalBuild(5, this.project0, variant1, false, 0, 0);
        this.incrementalBuild(6, this.project0, variant2, false, 0, 0);
    }

    @Test
    public void testCloseAndOpenProject_Bug361675() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject tempProject = root.getProject("BuildVariantTest_pTemp");
        IFile tempFile0 = tempProject.getFile("File0");
        IFile tempFile1 = tempProject.getFile("File1");
        IResource[] resources = new IResource[]{tempProject, tempFile0, tempFile1};
        ResourceTestUtil.createInWorkspace(resources);
        this.setupProject(tempProject);
        ConfigurationBuilder.clearStats();
        tempFile0.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        tempFile1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        this.incrementalBuild(1, tempProject, variant0, true, 1, 6);
        this.incrementalBuild(2, tempProject, variant1, true, 1, 6);
        this.incrementalBuild(3, tempProject, variant2, true, 1, 6);
        tempFile0.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        this.incrementalBuild(4, tempProject, variant1, true, 2, 10);
        tempFile1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        this.incrementalBuild(5, tempProject, variant2, true, 2, 10);
        tempProject.close(ResourceTestUtil.createTestMonitor());
        ConfigurationBuilder.clearStats();
        tempProject.open(ResourceTestUtil.createTestMonitor());
        this.incrementalBuild(6, tempProject, variant0, true, 1, 10);
        ConfigurationBuilder builder0 = ConfigurationBuilder.getBuilder(tempProject.getBuildConfig(variant0));
        Assertions.assertNotNull((Object)((Object)builder0));
        ResourceDeltaVerifier verifier0 = new ResourceDeltaVerifier();
        verifier0.addExpectedChange((IResource)tempFile0, (IResource)tempProject, 4, 256);
        verifier0.addExpectedChange((IResource)tempFile1, (IResource)tempProject, 4, 256);
        verifier0.verifyDelta(builder0.deltaForLastBuild);
        Assertions.assertTrue((boolean)verifier0.isDeltaValid(), (String)verifier0.getMessage());
        this.incrementalBuild(7, tempProject, variant1, true, 1, 10);
        ConfigurationBuilder builder1 = ConfigurationBuilder.getBuilder(tempProject.getBuildConfig(variant1));
        Assertions.assertNotNull((Object)((Object)builder1));
        ResourceDeltaVerifier verifier1 = new ResourceDeltaVerifier();
        verifier1.addExpectedChange((IResource)tempFile1, (IResource)tempProject, 4, 256);
        verifier1.verifyDelta(builder1.deltaForLastBuild);
        Assertions.assertTrue((boolean)verifier1.isDeltaValid(), (String)verifier1.getMessage());
        this.incrementalBuild(8, tempProject, variant2, false, 0, 0);
    }

    @Test
    public void testBuildReferences() throws CoreException {
        ConfigurationBuilder.clearStats();
        ConfigurationBuilder.clearBuildOrder();
        IProjectDescription desc = this.project0.getDescription();
        desc.setActiveBuildConfig(variant0);
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = this.project1.getDescription();
        desc.setActiveBuildConfig(variant0);
        this.project1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        this.setReferences(this.project0, variant0, new IBuildConfiguration[]{this.project0.getBuildConfig(variant1), this.project1.getBuildConfig(variant2), this.project1.getBuildConfig(variant0)});
        ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)4, (int)ConfigurationBuilder.buildOrder.size());
        Assertions.assertEquals((Object)this.project0.getBuildConfig(variant1), (Object)ConfigurationBuilder.buildOrder.get(0));
        Assertions.assertEquals((Object)this.project1.getBuildConfig(variant0), (Object)ConfigurationBuilder.buildOrder.get(1));
        Assertions.assertEquals((Object)this.project1.getBuildConfig(variant2), (Object)ConfigurationBuilder.buildOrder.get(2));
        Assertions.assertEquals((Object)this.project0.getBuildConfig(variant0), (Object)ConfigurationBuilder.buildOrder.get(3));
        this.checkBuild(2, this.project0, variant0, true, 1, 6);
        this.checkBuild(3, this.project0, variant1, true, 1, 6);
        this.checkBuild(4, this.project0, variant2, false, 0, 0);
        this.checkBuild(5, this.project1, variant0, true, 1, 6);
        this.checkBuild(6, this.project1, variant1, false, 0, 0);
        this.checkBuild(7, this.project1, variant2, true, 1, 6);
        this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        ConfigurationBuilder.clearBuildOrder();
        ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)2, (int)ConfigurationBuilder.buildOrder.size());
        Assertions.assertEquals((Object)this.project1.getBuildConfig(variant0), (Object)ConfigurationBuilder.buildOrder.get(0));
        Assertions.assertEquals((Object)this.project1.getBuildConfig(variant2), (Object)ConfigurationBuilder.buildOrder.get(1));
        this.checkBuild(9, this.project0, variant0, false, 1, 0);
        this.checkBuild(10, this.project0, variant1, false, 1, 0);
        this.checkBuild(11, this.project0, variant2, false, 0, 0);
        this.checkBuild(12, this.project1, variant0, true, 2, 10);
        this.checkBuild(13, this.project1, variant1, false, 0, 0);
        this.checkBuild(14, this.project1, variant2, true, 2, 10);
    }

    @Test
    public void testBuildReferencesOfClosedProject() throws CoreException {
        ConfigurationBuilder.clearStats();
        ConfigurationBuilder.clearBuildOrder();
        IProjectDescription desc = this.project0.getDescription();
        desc.setActiveBuildConfig(variant0);
        desc.setBuildConfigReferences(variant0, new IBuildConfiguration[]{this.project1.getBuildConfig(variant0)});
        this.project0.setDescription(desc, ResourceTestUtil.createTestMonitor());
        this.project1.close(ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().build(new IBuildConfiguration[]{this.project0.getBuildConfig(variant0)}, 6, true, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)1, (int)ConfigurationBuilder.buildOrder.size());
        Assertions.assertEquals((Object)this.project0.getBuildConfig(variant0), (Object)ConfigurationBuilder.buildOrder.get(0));
        this.checkBuild(2, this.project0, variant0, true, 1, 6);
        ConfigurationBuilder.clearStats();
        ConfigurationBuilder.clearBuildOrder();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)1, (int)ConfigurationBuilder.buildOrder.size());
        Assertions.assertEquals((Object)this.project0.getBuildConfig(variant0), (Object)ConfigurationBuilder.buildOrder.get(0));
        this.checkBuild(2, this.project0, variant0, true, 1, 6);
        this.project1.open(ResourceTestUtil.createTestMonitor());
        ConfigurationBuilder.clearStats();
        ConfigurationBuilder.clearBuildOrder();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)2, (int)ConfigurationBuilder.buildOrder.size());
        Assertions.assertEquals((Object)this.project1.getBuildConfig(variant0), (Object)ConfigurationBuilder.buildOrder.get(0));
        Assertions.assertEquals((Object)this.project0.getBuildConfig(variant0), (Object)ConfigurationBuilder.buildOrder.get(1));
    }

    @Test
    public void testClean() throws CoreException {
        ConfigurationBuilder.clearStats();
        this.incrementalBuild(1, this.project0, variant0, true, 1, 6);
        this.incrementalBuild(2, this.project0, variant1, true, 1, 6);
        this.clean(3, this.project0, variant0, 2);
        this.incrementalBuild(4, this.project0, variant1, false, 1, 0);
    }

    private void setReferences(IProject project, String configId, IBuildConfiguration[] configs) throws CoreException {
        IProjectDescription desc = project.getDescription();
        desc.setBuildConfigReferences(configId, configs);
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
    }

    private void incrementalBuild(int testId, IProject project, String variant, boolean shouldBuild, int expectedCount, int expectedTrigger) throws CoreException {
        project.build(project.getBuildConfig(variant), 10, ResourceTestUtil.createTestMonitor());
        this.checkBuild(testId, project, variant, shouldBuild, expectedCount, expectedTrigger);
    }

    private void clean(int testId, IProject project, String variant, int expectedCount) throws CoreException {
        project.build(project.getBuildConfig(variant), 15, ResourceTestUtil.createTestMonitor());
        ConfigurationBuilder builder = ConfigurationBuilder.getBuilder(project.getBuildConfig(variant));
        Assertions.assertNotNull((Object)((Object)builder), (String)("" + testId));
        Assertions.assertEquals((float)expectedCount, (float)builder.buildCount, (float)testId);
        Assertions.assertEquals((float)15.0f, (float)builder.triggerForLastBuild, (float)testId);
    }

    private void checkBuild(int testId, IProject project, String variant, boolean shouldBuild, int expectedCount, int expectedTrigger) throws CoreException {
        project.getBuildConfig(variant);
        ConfigurationBuilder builder = ConfigurationBuilder.getBuilder(project.getBuildConfig(variant));
        if (builder == null) {
            Assertions.assertFalse((boolean)shouldBuild, (String)("" + testId));
            Assertions.assertEquals((float)0.0f, (float)expectedCount, (float)testId);
        } else {
            Assertions.assertEquals((float)expectedCount, (float)builder.buildCount, (float)testId);
            if (shouldBuild) {
                Assertions.assertEquals((float)expectedTrigger, (float)builder.triggerForLastBuild, (float)testId);
            }
        }
    }

    @Test
    public void testBuildProjectWithNotExistingReference() throws Exception {
        IBuildConfiguration buildConfig = this.project0.getBuildConfig(variant0);
        this.project0.build(buildConfig, 10, ResourceTestUtil.createTestMonitor());
        ConfigurationBuilder builder = ConfigurationBuilder.getBuilder(buildConfig);
        final IProject notExistingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("not_existing_one");
        builder.setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                return new IProject[]{notExistingProject};
            }
        });
        this.project0.build(buildConfig, 6, ResourceTestUtil.createTestMonitor());
        this.project1.touch(ResourceTestUtil.createTestMonitor());
        this.project0.build(buildConfig, 10, ResourceTestUtil.createTestMonitor());
    }
}

