/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.events.BuildContext;
import org.eclipse.core.internal.resources.BuildConfiguration;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IBuildContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.ContextBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class BuildContextTest {
    private IProject project0;
    private IProject project1;
    private IProject project2;
    private static final String variant0 = "Variant0";
    private static final String variant1 = "Variant1";

    @BeforeEach
    public void setUp() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project0 = root.getProject("BuildContextTests_p0");
        this.project1 = root.getProject("BuildContextTests_p1");
        this.project2 = root.getProject("BuildContextTests_p2");
        IResource[] resources = new IResource[]{this.project0, this.project1, this.project2};
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.setAutoBuilding(false);
        this.setupProject(this.project0);
        this.setupProject(this.project1);
        this.setupProject(this.project2);
    }

    private void setupProject(IProject project) throws CoreException {
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.contextbuilder").withTestBuilderId("Build0").withBuildingSetting(9, true).withBuildingSetting(6, true).withBuildingSetting(10, true).withBuildingSetting(15, true).apply();
        IProjectDescription desc = project.getDescription();
        desc.setBuildConfigs(new String[]{variant0, variant1});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
    }

    private IBuildConfiguration changeActiveBuildConfig(IProject project) throws CoreException {
        IBuildConfiguration[] configs = project.getBuildConfigs();
        IBuildConfiguration active = project.getActiveBuildConfig();
        IProjectDescription desc = project.getDescription();
        IBuildConfiguration[] iBuildConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfiguration config = iBuildConfigurationArray[n2];
            if (!config.equals(active)) {
                desc.setActiveBuildConfig(config.getName());
                project.setDescription(desc, ResourceTestUtil.createTestMonitor());
                return config;
            }
            ++n2;
        }
        throw new IllegalStateException("No build config other than the active one could be found for project: " + String.valueOf(project));
    }

    private void setupSimpleReferences() throws CoreException {
        this.setReferences(this.project0.getActiveBuildConfig(), new IBuildConfiguration[]{this.project1.getActiveBuildConfig()});
        this.setReferences(this.project1.getActiveBuildConfig(), new IBuildConfiguration[]{this.project2.getActiveBuildConfig()});
        this.setReferences(this.project2.getActiveBuildConfig(), new IBuildConfiguration[0]);
    }

    private void setReferences(IBuildConfiguration variant, IBuildConfiguration[] refs) throws CoreException {
        IProjectDescription desc = variant.getProject().getDescription();
        desc.setBuildConfigReferences(variant.getName(), refs);
        variant.getProject().setDescription(desc, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testBuildContext() {
        IBuildConfiguration p0v0 = ResourcesPlugin.getWorkspace().newBuildConfig(this.project0.getName(), variant0);
        IBuildConfiguration p0v1 = ResourcesPlugin.getWorkspace().newBuildConfig(this.project0.getName(), variant1);
        IBuildConfiguration p1v0 = ResourcesPlugin.getWorkspace().newBuildConfig(this.project1.getName(), variant0);
        IBuildConfiguration[] buildOrder = new IBuildConfiguration[]{p0v0, p0v1, p1v0};
        BuildContext context = new BuildContext(p0v0, new IBuildConfiguration[]{p0v0, p1v0}, buildOrder);
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).isEmpty();
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{p0v1, p1v0});
        Assertions.assertThat((Object[])context.getRequestedConfigs()).containsExactly((Object[])new IBuildConfiguration[]{p0v0, p1v0});
        context = new BuildContext(p0v1, buildOrder, buildOrder);
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{p0v0});
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{p1v0});
        context = new BuildContext(p1v0, buildOrder, buildOrder);
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{p0v0, p0v1});
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).isEmpty();
        context = new BuildContext(p1v0);
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).isEmpty();
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).isEmpty();
    }

    @Test
    public void testSingleProjectBuild() throws CoreException {
        ResourceTestUtil.setAutoBuilding(true);
        this.setupSimpleReferences();
        ContextBuilder.clearStats();
        this.project0.build(6, ResourceTestUtil.createTestMonitor());
        ContextBuilder.assertValid();
        IBuildContext context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).isEmpty();
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).isEmpty();
        ContextBuilder.clearStats();
        IBuildConfiguration newActive = this.changeActiveBuildConfig(this.project0);
        ResourceTestUtil.waitForBuild();
        ContextBuilder.assertValid();
        context = ContextBuilder.getContext(newActive);
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).isEmpty();
    }

    @Test
    public void testWorkspaceBuildProject() throws CoreException {
        this.setupSimpleReferences();
        ContextBuilder.clearStats();
        ResourcesPlugin.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, 6, true, ResourceTestUtil.createTestMonitor());
        ContextBuilder.assertValid();
        IBuildContext context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project2.getActiveBuildConfig(), this.project1.getActiveBuildConfig()});
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).isEmpty();
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project1.getActiveBuildConfig()).contextForLastBuild;
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project2.getActiveBuildConfig()});
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project0.getActiveBuildConfig()});
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project2.getActiveBuildConfig()).contextForLastBuild;
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).isEmpty();
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project0.getActiveBuildConfig()});
        ContextBuilder.clearStats();
        ResourcesPlugin.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, 6, false, ResourceTestUtil.createTestMonitor());
        ContextBuilder.assertValid();
        context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).isEmpty();
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).isEmpty();
    }

    @Test
    public void testWorkspaceBuildProjects() throws CoreException {
        this.setupSimpleReferences();
        ContextBuilder.clearStats();
        ResourcesPlugin.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig(), this.project2.getActiveBuildConfig()}, 6, true, ResourceTestUtil.createTestMonitor());
        ContextBuilder.assertValid();
        IBuildContext context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project2.getActiveBuildConfig(), this.project1.getActiveBuildConfig()});
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).isEmpty();
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project1.getActiveBuildConfig()).contextForLastBuild;
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project2.getActiveBuildConfig()});
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project0.getActiveBuildConfig()});
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project2.getActiveBuildConfig()).contextForLastBuild;
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).isEmpty();
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project0.getActiveBuildConfig()});
    }

    @Test
    public void testReferenceActiveVariant() throws CoreException {
        this.setReferences(this.project0.getActiveBuildConfig(), new IBuildConfiguration[]{ResourcesPlugin.getWorkspace().newBuildConfig(this.project1.getName(), null)});
        this.setReferences(this.project1.getActiveBuildConfig(), new IBuildConfiguration[]{ResourcesPlugin.getWorkspace().newBuildConfig(this.project2.getName(), null)});
        this.setReferences(this.project2.getActiveBuildConfig(), new IBuildConfiguration[0]);
        ContextBuilder.clearStats();
        ResourcesPlugin.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, 6, true, ResourceTestUtil.createTestMonitor());
        ContextBuilder.assertValid();
        IBuildContext context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project2.getActiveBuildConfig(), this.project1.getActiveBuildConfig()});
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).isEmpty();
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project1.getActiveBuildConfig()).contextForLastBuild;
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project2.getActiveBuildConfig()});
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project0.getActiveBuildConfig()});
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project2.getActiveBuildConfig()).contextForLastBuild;
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).isEmpty();
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project0.getActiveBuildConfig()});
    }

    @Test
    public void testReferenceVariantTwice() throws CoreException {
        BuildConfiguration ref1 = new BuildConfiguration(this.project1, null);
        BuildConfiguration ref2 = new BuildConfiguration(this.project1, this.project1.getActiveBuildConfig().getName());
        this.setReferences(this.project0.getActiveBuildConfig(), new IBuildConfiguration[]{ref1, ref2});
        this.setReferences(this.project1.getActiveBuildConfig(), new IBuildConfiguration[0]);
        ContextBuilder.clearStats();
        ResourcesPlugin.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, 6, true, ResourceTestUtil.createTestMonitor());
        ContextBuilder.assertValid();
        IBuildContext context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project1.getActiveBuildConfig()});
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).isEmpty();
        Assertions.assertThat((Object[])context.getRequestedConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project0.getActiveBuildConfig()});
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project1.getActiveBuildConfig()).contextForLastBuild;
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).isEmpty();
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project0.getActiveBuildConfig()});
        ContextBuilder.clearStats();
        IBuildConfiguration project1PreviousActive = this.project1.getActiveBuildConfig();
        IBuildConfiguration project1NewActive = this.changeActiveBuildConfig(this.project1);
        ResourcesPlugin.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, 6, true, ResourceTestUtil.createTestMonitor());
        ContextBuilder.assertValid();
        context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        Assertions.assertThat((Object[])context.getAllReferencedBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{project1PreviousActive, project1NewActive});
        Assertions.assertThat((Object[])context.getAllReferencingBuildConfigs()).isEmpty();
        Assertions.assertThat((Object[])context.getRequestedConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.project0.getActiveBuildConfig()});
    }
}

