/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.internal.builders.EmptyDeltaBuilder;
import org.eclipse.core.tests.internal.builders.EmptyDeltaBuilder2;
import org.eclipse.core.tests.internal.builders.TestBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class BuildDeltaVerificationTest {
    protected static final String PROJECT1 = "Project1";
    protected static final String PROJECT2 = "Project2";
    protected static final String FOLDER1 = "Folder1";
    protected static final String FOLDER2 = "Folder2";
    protected static final String FILE1 = "File1";
    protected static final String FILE2 = "File2";
    protected static final String FILE3 = "File3";
    IProject project1;
    IProject project2;
    IFolder folder1;
    IFolder folder2;
    IFolder folder3;
    IFile file1;
    IFile file2;
    IFile file3;
    DeltaVerifierBuilder verifier;

    public void assertDelta() {
        this.verifier.isDeltaValid();
        Assertions.assertTrue((boolean)this.verifier.wasIncrementalBuild(), (String)"Should be an incremental build");
        Assertions.assertTrue((boolean)this.verifier.isDeltaValid(), (String)this.verifier.getMessage());
    }

    protected void rebuild() throws CoreException {
        this.project1.build(10, ResourceTestUtil.createTestMonitor());
        this.project2.build(10, ResourceTestUtil.createTestMonitor());
    }

    @BeforeEach
    public void setUp() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ResourceTestUtil.setAutoBuilding(false);
        this.project1 = workspace.getRoot().getProject(PROJECT1);
        this.project2 = workspace.getRoot().getProject(PROJECT2);
        this.folder1 = this.project1.getFolder(FOLDER1);
        this.folder2 = this.folder1.getFolder(FOLDER2);
        this.folder3 = this.folder1.getFolder(FILE1);
        this.file1 = this.folder1.getFile(FILE1);
        this.file2 = this.folder1.getFile(FILE2);
        this.file3 = this.folder2.getFile(FILE1);
        this.project1.create(ResourceTestUtil.createTestMonitor());
        this.project1.open(ResourceTestUtil.createTestMonitor());
        this.folder1.create(true, true, ResourceTestUtil.createTestMonitor());
        this.file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(this.project1).addingCommand("org.eclipse.core.tests.resources.deltaverifierbuilder").apply();
        this.project1.build(6, ResourceTestUtil.createTestMonitor());
        this.verifier = DeltaVerifierBuilder.getInstance();
        Assertions.assertNotNull((Object)((Object)this.verifier), (String)"Builder was not instantiated");
        Assertions.assertTrue((boolean)this.verifier.wasFullBuild(), (String)"First build should be a batch build");
    }

    @Test
    public void testAddAndRemoveFile() throws CoreException {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
        this.file2.create((InputStream)in, true, ResourceTestUtil.createTestMonitor());
        this.file2.delete(true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        if (this.verifier.wasFullBuild()) {
            this.verifier.emptyBuild();
        }
        Assertions.assertTrue((boolean)this.verifier.isDeltaValid(), (String)this.verifier.getMessage());
    }

    @Test
    public void testAddAndRemoveFolder() throws CoreException {
        this.folder2.create(true, true, ResourceTestUtil.createTestMonitor());
        this.folder2.delete(true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        if (this.verifier.wasFullBuild()) {
            this.verifier.emptyBuild();
        }
        Assertions.assertTrue((boolean)this.verifier.isDeltaValid(), (String)this.verifier.getMessage());
    }

    @Test
    public void testAddFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file2, (IResource)this.project1, 1, 0);
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
        this.file2.create((InputStream)in, true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.assertDelta();
    }

    @Test
    public void testAddFileAndFolder() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder2, (IResource)this.project1, 1, 0);
        this.verifier.addExpectedChange((IResource)this.file3, (IResource)this.project1, 1, 0);
        this.folder2.create(true, true, ResourceTestUtil.createTestMonitor());
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
        this.file3.create((InputStream)in, true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.assertDelta();
    }

    @Test
    public void testAddFolder() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder2, (IResource)this.project1, 1, 0);
        this.folder2.create(true, true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.assertDelta();
    }

    @Test
    public void testAddProject() throws CoreException {
        this.project2.create(ResourceTestUtil.createTestMonitor());
        this.rebuild();
        Assertions.assertTrue((boolean)this.verifier.isDeltaValid(), (String)this.verifier.getMessage());
    }

    @Test
    public void testChangeFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 256);
        this.file1.setContents(new byte[]{4, 5, 6}, true, false, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.assertDelta();
    }

    @Test
    public void testChangeFileToFolder() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 295168);
        this.file1.delete(true, ResourceTestUtil.createTestMonitor());
        this.folder3.create(true, true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.assertDelta();
    }

    @Test
    public void testChangeFolderToFile() throws CoreException {
        this.file1.delete(true, ResourceTestUtil.createTestMonitor());
        this.folder3.create(true, true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 295168);
        this.folder3.delete(true, ResourceTestUtil.createTestMonitor());
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2});
        this.file1.create((InputStream)in, true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.assertDelta();
    }

    @Test
    public void testCloseOpenReplaceFile() throws CoreException {
        this.rebuild();
        this.project1.close(null);
        this.project1.open(null);
        this.verifier = DeltaVerifierBuilder.getInstance();
        this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 262400);
        this.file1.delete(true, null);
        this.file1.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        this.rebuild();
        this.verifier = DeltaVerifierBuilder.getInstance();
        this.assertDelta();
    }

    @Test
    public void testMoveFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder2, (IResource)this.project1, 1, 0);
        this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 2, 8192, null, this.file3.getFullPath());
        this.verifier.addExpectedChange((IResource)this.file3, (IResource)this.project1, 1, 4096, this.file1.getFullPath(), null);
        this.folder2.create(true, true, ResourceTestUtil.createTestMonitor());
        this.file1.move(this.file3.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.assertDelta();
    }

    @Test
    public void testRemoveFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 2, 0);
        this.file1.delete(true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.assertDelta();
    }

    @Test
    public void testRemoveFileAndFolder() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.folder1, (IResource)this.project1, 2, 0);
        this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 2, 0);
        this.folder1.delete(true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.assertDelta();
    }

    @Test
    public void testReplaceFile() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 262400);
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
        this.file1.delete(true, ResourceTestUtil.createTestMonitor());
        this.file1.create((InputStream)in, true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.assertDelta();
    }

    @Test
    public void testTwoFileChanges() throws CoreException {
        this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 256);
        this.verifier.addExpectedChange((IResource)this.file2, (IResource)this.project1, 1, 0);
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
        this.file1.setContents((InputStream)in, true, false, ResourceTestUtil.createTestMonitor());
        ByteArrayInputStream in2 = new ByteArrayInputStream(new byte[]{4, 5, 6});
        this.file2.create((InputStream)in2, true, ResourceTestUtil.createTestMonitor());
        this.rebuild();
        this.assertDelta();
    }

    @Test
    public void testReuseCachedDelta() throws CoreException {
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("delta-cache");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.emptydeltabuilder").andCommand("org.eclipse.core.tests.resources.emptydeltabuilder2").apply();
        project.build(6, ResourceTestUtil.createTestMonitor());
        final ArrayList deltas = new ArrayList();
        TestBuilder.BuilderRuleCallback captureDelta = new TestBuilder.BuilderRuleCallback(){

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                deltas.add(this.getDelta(project));
                return super.build(kind, args, monitor);
            }
        };
        EmptyDeltaBuilder.getInstance().setRuleCallback(captureDelta);
        EmptyDeltaBuilder2.getInstance().setRuleCallback(captureDelta);
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
        project.getFile("test").create((InputStream)in, true, ResourceTestUtil.createTestMonitor());
        project.build(10, ResourceTestUtil.createTestMonitor());
        Assert.assertSame((String)"both builders should receive the same cached delta ", deltas.get(0), deltas.get(1));
    }
}

