/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.CycleBuilder;
import org.eclipse.core.tests.internal.builders.SortBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class BuilderCycleTest {
    @Test
    public void testIsBeforeThisProject() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        IProject before1 = root.getProject("Before1");
        IProject before2 = root.getProject("Before2");
        IProject after1 = root.getProject("After1");
        IProject after2 = root.getProject("After2");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, before1, before2, after1, after2});
        ResourceTestUtil.setBuildOrder(before1, before2, project, after1, after2);
        ResourceTestUtil.setAutoBuilding(false);
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.cyclebuilder").withTestBuilderId("Build0").apply();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        CycleBuilder builder = CycleBuilder.getInstance();
        builder.resetBuildCount();
        builder.setBeforeProjects(new IProject[]{before1, before2});
        builder.setAfterProjects(new IProject[]{after1, after2});
        project.getFile("Foo.txt").create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor());
        builder.resetBuildCount();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
    }

    @Test
    @Disabled(value="test has been skipped for unknown reasons")
    public void testNeedRebuild() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        IFolder unsorted = project.getFolder(SortBuilder.DEFAULT_UNSORTED_FOLDER);
        IFile unsortedFile = unsorted.getFile("File.txt");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.createInWorkspace((IResource)unsorted);
        ResourceTestUtil.createInWorkspace((IResource)unsortedFile);
        ResourceTestUtil.setAutoBuilding(true);
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.cyclebuilder").withTestBuilderId("Build0").andCommand("org.eclipse.core.tests.resources.sortbuilder").withTestBuilderId("Build1").apply();
        CycleBuilder builder = CycleBuilder.getInstance();
        builder.resetBuildCount();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        builder.setRebuildsToRequest(0);
        builder.resetBuildCount();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)1, (int)builder.getBuildCount());
        IFile file = project.getFile("foo.txt");
        builder.resetBuildCount();
        file.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)1, (int)builder.getBuildCount());
        builder.setRebuildsToRequest(1);
        builder.resetBuildCount();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)2, (int)builder.getBuildCount());
        builder.resetBuildCount();
        file.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)2, (int)builder.getBuildCount());
        builder.setRebuildsToRequest(5);
        builder.resetBuildCount();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)6, (int)builder.getBuildCount());
        builder.resetBuildCount();
        file.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)6, (int)builder.getBuildCount());
        int maxBuilds = ResourcesPlugin.getWorkspace().getDescription().getMaxBuildIterations();
        builder.setRebuildsToRequest(maxBuilds * 2);
        builder.resetBuildCount();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)maxBuilds, (int)builder.getBuildCount());
        builder.resetBuildCount();
        file.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)maxBuilds, (int)builder.getBuildCount());
        maxBuilds = 7;
        IWorkspaceDescription desc = ResourcesPlugin.getWorkspace().getDescription();
        desc.setMaxBuildIterations(maxBuilds);
        ResourcesPlugin.getWorkspace().setDescription(desc);
        builder.setRebuildsToRequest(maxBuilds * 2);
        builder.resetBuildCount();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)maxBuilds, (int)builder.getBuildCount());
        builder.resetBuildCount();
        file.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((int)maxBuilds, (int)builder.getBuildCount());
    }
}

