/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.BuildEventListener;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class BuilderEventTest {
    private BuildEventListener listener;

    @BeforeEach
    public void setUp() throws Exception {
        this.listener = new BuildEventListener();
        int mask = 25;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener, mask);
    }

    @AfterEach
    public void tearDown() throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.listener);
    }

    @Test
    public void testEventsOnClean() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("PROJECT");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.deltaverifierbuilder").withTestBuilderId("Project2Build2").apply();
        this.listener.reset();
        ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((Object)ResourcesPlugin.getWorkspace(), (Object)this.listener.getSource());
        Assertions.assertEquals((int)10, (int)this.listener.getBuildKind());
        Assertions.assertTrue((boolean)this.listener.hadPreBuild());
        Assertions.assertTrue((boolean)this.listener.hadPostBuild());
        Assertions.assertTrue((boolean)this.listener.hadPostChange());
        this.listener.reset();
        ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((Object)ResourcesPlugin.getWorkspace(), (Object)this.listener.getSource());
        Assertions.assertEquals((int)10, (int)this.listener.getBuildKind());
        Assertions.assertTrue((boolean)this.listener.hadPreBuild());
        Assertions.assertTrue((boolean)this.listener.hadPostBuild());
        Assertions.assertTrue((boolean)this.listener.hadPostChange());
        this.listener.reset();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((Object)ResourcesPlugin.getWorkspace(), (Object)this.listener.getSource());
        Assertions.assertEquals((int)6, (int)this.listener.getBuildKind());
        Assertions.assertTrue((boolean)this.listener.hadPreBuild());
        Assertions.assertTrue((boolean)this.listener.hadPostBuild());
        Assertions.assertTrue((boolean)this.listener.hadPostChange());
        this.listener.reset();
        ResourcesPlugin.getWorkspace().build(15, ResourceTestUtil.createTestMonitor());
        Assertions.assertEquals((Object)ResourcesPlugin.getWorkspace(), (Object)this.listener.getSource());
        Assertions.assertEquals((int)15, (int)this.listener.getBuildKind());
        Assertions.assertTrue((boolean)this.listener.hadPreBuild());
        Assertions.assertTrue((boolean)this.listener.hadPostBuild());
        Assertions.assertTrue((boolean)this.listener.hadPostChange());
    }
}

