/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.SnowBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class BuilderNatureTest {
    protected InputStream projectFileWithoutSnow() {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>P1</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.core.tests.resources.snowbuilder</name>\n\t\t\t<arguments>\n\t\t\t\t<dictionary>\n\t\t\t\t\t<key>BuildID</key>\n\t\t\t\t\t<value>SnowBuild</value>\n\t\t\t\t</dictionary>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t\t<nature>org.eclipse.core.tests.resources.waterNature</nature>\n\t</natures>\n</projectDescription>";
        return new ByteArrayInputStream(contents.getBytes());
    }

    protected InputStream projectFileWithoutWater() {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>P1</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.core.tests.resources.snowbuilder</name>\n\t\t\t<arguments>\n\t\t\t\t<dictionary>\n\t\t\t\t\t<key>BuildID</key>\n\t\t\t\t\t<value>SnowBuild</value>\n\t\t\t\t</dictionary>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t\t<nature>org.eclipse.core.tests.resources.snowNature</nature>\n\t</natures>\n</projectDescription>";
        return new ByteArrayInputStream(contents.getBytes());
    }

    @Test
    public void testBasic() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        ResourceTestUtil.createInWorkspace((IResource)project);
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.reset();
        ResourceTestUtil.setAutoBuilding(true);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
        project.setDescription(desc, 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.addExpectedLifecycleEvent("SnowBuild");
        builder.assertLifecycleEvents();
    }

    @Test
    public void testDisabledNature() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.setAutoBuilding(true);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
        project.setDescription(desc, 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.reset();
        IFile descFile = project.getFile(".project");
        descFile.setContents(this.projectFileWithoutWater(), 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        builder.assertLifecycleEvents();
        builder.reset();
        builder.addExpectedLifecycleEvent("SnowBuild");
        desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
        project.setDescription(desc, 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        builder.assertLifecycleEvents();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasDeltaNull());
    }

    @Test
    public void testMissingNature() throws CoreException {
        ICommand[] commands;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.setAutoBuilding(true);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
        project.setDescription(desc, 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.reset();
        desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature"});
        project.setDescription(desc, 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        builder.assertLifecycleEvents();
        ICommand[] iCommandArray = commands = project.getDescription().getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            Assertions.assertThat((String)command.getBuilderName()).isNotEqualTo((Object)"org.eclipse.core.tests.resources.snowbuilder");
            ++n2;
        }
        builder.reset();
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.addExpectedLifecycleEvent("SnowBuild");
        desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
        project.setDescription(desc, 2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        builder.assertLifecycleEvents();
        builder.reset();
        IFile descFile = project.getFile(".project");
        descFile.setContents(this.projectFileWithoutSnow(), 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        builder.assertLifecycleEvents();
        ICommand[] iCommandArray2 = commands = project.getDescription().getBuildSpec();
        int n3 = commands.length;
        n = 0;
        while (n < n3) {
            ICommand command = iCommandArray2[n];
            Assertions.assertThat((String)command.getBuilderName()).isNotEqualTo((Object)"org.eclipse.core.tests.resources.snowbuilder");
            ++n;
        }
        builder.reset();
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.addExpectedLifecycleEvent("SnowBuild");
        desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
        project.setDescription(desc, 1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        builder.assertLifecycleEvents();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasDeltaNull());
    }
}

