/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.harness.TestJob;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.internal.builders.SortBuilder;
import org.eclipse.core.tests.internal.builders.TestBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.function.ThrowingRunnable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class BuilderTest {
    @BeforeEach
    @AfterEach
    public void resetBuilder() throws Exception {
        TestBuilder builder = SortBuilder.getInstance();
        if (builder != null) {
            builder.reset();
        }
        if ((builder = DeltaVerifierBuilder.getInstance()) != null) {
            builder.reset();
        }
    }

    private void dirty(IFile file) throws CoreException {
        file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
    }

    private ICommand createCommand(IProjectDescription description, String builderName, String buildID) {
        ICommand command = description.newCommand();
        Map args = command.getArguments();
        args.put("BuildID", buildID);
        command.setBuilderName(builderName);
        command.setArguments(args);
        return command;
    }

    @Test
    public void testAardvarkBuildOrder() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        org.junit.jupiter.api.Assertions.assertNull((Object)workspace.getDescription().getBuildOrder());
    }

    @Test
    public void testAutoBuildPR() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("PROJECT1");
        IFolder folder = project1.getFolder("FOLDER");
        IFolder sub = folder.getFolder("sub");
        IFile fileA = folder.getFile("A");
        IFile fileB = sub.getFile("B");
        ResourceTestUtil.setAutoBuilding(true);
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project1.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        command.getArguments().put("BuildID", "Project1Build1");
        desc.setBuildSpec(new ICommand[]{command});
        project1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        fileA.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        sub.create(true, true, ResourceTestUtil.createTestMonitor());
        fileB.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testBrokenBuilder() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("PROJECT");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project.getDescription();
        ICommand command1 = desc.newCommand();
        command1.setBuilderName("org.eclipse.core.tests.resources.brokenbuilder");
        ICommand command2 = desc.newCommand();
        command2.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        desc.setBuildSpec(new ICommand[]{command1, command2});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor()));
        SortBuilder verifier = SortBuilder.getInstance();
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testBuildClean() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("PROJECT");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.deltaverifierbuilder", "Project2Build2")});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        ResourcesPlugin.getWorkspace().build(15, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        DeltaVerifierBuilder verifier = DeltaVerifierBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.wasCleanBuild());
        monitor = new FussyProgressMonitor();
        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.wasFullBuild());
        project.touch(ResourceTestUtil.createTestMonitor());
        monitor = new FussyProgressMonitor();
        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.wasIncrementalBuild());
        monitor = new FussyProgressMonitor();
        ResourcesPlugin.getWorkspace().build(15, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.wasCleanBuild());
        monitor = new FussyProgressMonitor();
        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.wasFullBuild());
    }

    @Test
    public void testBuildCommands() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("PROJECT1");
        IProject project2 = workspace.getRoot().getProject("PROJECT2");
        IFile file1 = project1.getFile("FILE1");
        IFile file2 = project2.getFile("FILE2");
        ResourceTestUtil.setBuildOrder(project1, project2);
        SortBuilder verifier = null;
        ResourceTestUtil.setAutoBuilding(false);
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        project2.create(ResourceTestUtil.createTestMonitor());
        project2.open(ResourceTestUtil.createTestMonitor());
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file2.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project1.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Project1Build1")});
        project1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        project1.build(6, ResourceTestUtil.createTestMonitor());
        verifier = SortBuilder.getInstance();
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Project1Build1");
        verifier.assertLifecycleEvents();
        desc = project1.getDescription();
        desc.setBuildSpec(new ICommand[0]);
        project1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        verifier.reset();
        this.dirty(file1);
        project1.build(6, ResourceTestUtil.createTestMonitor());
        verifier.assertLifecycleEvents();
        desc = project1.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        project1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        this.dirty(file1);
        project1.build(6, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
        desc = project1.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Project1Build1")});
        project1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = project2.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Project2Build1"), this.createCommand(desc, "org.eclipse.core.tests.resources.deltaverifierbuilder", "Project2Build2")});
        project2.setDescription(desc, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Project1Build1");
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Project2Build1");
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Project2Build2");
        this.dirty(file1);
        this.dirty(file2);
        workspace.build(6, ResourceTestUtil.createTestMonitor());
        verifier.assertLifecycleEvents();
        verifier.addExpectedLifecycleEvent("Project1Build1");
        this.dirty(file1);
        project1.build(10, ResourceTestUtil.createTestMonitor());
        verifier.assertLifecycleEvents();
        this.dirty(file2);
        project2.build(10, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("Project2Build1");
        verifier.addExpectedLifecycleEvent("Project2Build2");
        verifier.assertLifecycleEvents();
        desc = project2.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.deltaverifierbuilder", "Project2Build2"), this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Project2Build1")});
        project2.setDescription(desc, ResourceTestUtil.createTestMonitor());
        workspace.build(6, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("Project1Build1");
        verifier.addExpectedLifecycleEvent("Project2Build2");
        verifier.addExpectedLifecycleEvent("Project2Build1");
        verifier.assertLifecycleEvents();
        this.dirty(file1);
        this.dirty(file2);
        project1.build(10, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("Project1Build1");
        verifier.assertLifecycleEvents();
        this.dirty(file1);
        this.dirty(file2);
        project2.build(10, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("Project2Build2");
        verifier.addExpectedLifecycleEvent("Project2Build1");
        verifier.assertLifecycleEvents();
    }

    @Test
    public void testPreBuildEvent() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        boolean[] notified = new boolean[1];
        IProject proj1 = workspace.getRoot().getProject("PROJECT1");
        IResourceChangeListener listener = event -> {
            boolean bl = blArray[0] = true;
        };
        try {
            workspace.addResourceChangeListener(listener, 8);
            ResourceTestUtil.setAutoBuilding(false);
            proj1.create(ResourceTestUtil.createTestMonitor());
            proj1.open(ResourceTestUtil.createTestMonitor());
            IProjectDescription desc = proj1.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build0")});
            proj1.setDescription(desc, ResourceTestUtil.createTestMonitor());
            proj1.build(6, "org.eclipse.core.tests.resources.sortbuilder", new HashMap(), null);
            notified[0] = false;
            ResourceTestUtil.setAutoBuilding(true);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)notified[0]);
        }
        finally {
            workspace.removeResourceChangeListener(listener);
        }
    }

    @Test
    public void testBuildOrder() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("PROJECT1");
        IProject proj2 = workspace.getRoot().getProject("PROJECT2");
        ResourceTestUtil.setAutoBuilding(false);
        proj1.create(ResourceTestUtil.createTestMonitor());
        proj1.open(ResourceTestUtil.createTestMonitor());
        proj2.create(ResourceTestUtil.createTestMonitor());
        proj2.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.setBuildOrder(proj1, proj2);
        IProjectDescription desc = proj1.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build0")});
        proj1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = proj2.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build1"), this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build2")});
        proj2.setDescription(desc, ResourceTestUtil.createTestMonitor());
        workspace.build(6, ResourceTestUtil.createTestMonitor());
        SortBuilder verifier = SortBuilder.getInstance();
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build1");
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build2");
        verifier.assertLifecycleEvents();
        ResourceTestUtil.setBuildOrder(proj2, proj1);
        workspace.build(6, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("Build1");
        verifier.addExpectedLifecycleEvent("Build2");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
        ResourceTestUtil.setBuildOrder(proj1);
        workspace.build(6, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.addExpectedLifecycleEvent("Build1");
        verifier.addExpectedLifecycleEvent("Build2");
        verifier.assertLifecycleEvents();
        ResourceTestUtil.setBuildOrder(proj2, proj1);
        workspace.build(6, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("Build1");
        verifier.addExpectedLifecycleEvent("Build2");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
    }

    @Test
    public void testChangeDynamicBuildOrder() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("PROJECT1");
        IProject proj2 = workspace.getRoot().getProject("PROJECT2");
        ResourceTestUtil.setAutoBuilding(true);
        ResourceTestUtil.setBuildOrder(null);
        ResourcesPlugin.getWorkspace().run(monitor -> {
            proj2.create(ResourceTestUtil.createTestMonitor());
            proj2.open(ResourceTestUtil.createTestMonitor());
            IProjectDescription desc = proj2.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build1")});
            proj2.setDescription(desc, ResourceTestUtil.createTestMonitor());
        }, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        SortBuilder verifier = SortBuilder.getInstance();
        verifier.reset();
        ResourcesPlugin.getWorkspace().run(monitor -> this.extracted(proj1, proj2), ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.addExpectedLifecycleEvent("Build1");
        verifier.assertLifecycleEvents();
    }

    private void extracted(IProject proj1, IProject proj2) throws CoreException {
        proj1.create(ResourceTestUtil.createTestMonitor());
        proj1.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = proj1.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build0")});
        proj1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        IProjectDescription description = proj2.getDescription();
        description.setDynamicReferences(new IProject[]{proj1});
        proj2.setDescription(description, 0, null);
    }

    @Test
    public void testChangeDynamicBuildOrderDuringPreBuild() throws Throwable {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("bug_330194_referencer");
        IProject proj2 = workspace.getRoot().getProject("bug_330194_referencee");
        ResourceTestUtil.setAutoBuilding(false);
        proj1.create(ResourceTestUtil.createTestMonitor());
        proj1.open(ResourceTestUtil.createTestMonitor());
        proj2.create(ResourceTestUtil.createTestMonitor());
        proj2.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = proj1.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build0")});
        proj1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = proj2.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build1")});
        proj2.setDescription(desc, ResourceTestUtil.createTestMonitor());
        workspace.build(6, ResourceTestUtil.createTestMonitor());
        AtomicReference<ThrowingRunnable> exceptionInMainThreadCallback = new AtomicReference<ThrowingRunnable>(Function::identity);
        IResourceChangeListener buildListener = event -> {
            try {
                IProjectDescription desc1 = proj1.getDescription();
                IProjectDescription desc2 = proj2.getDescription();
                if (desc1.getDynamicReferences().length == 0) {
                    desc1.setDynamicReferences(new IProject[]{proj2});
                    desc2.setDynamicReferences(new IProject[0]);
                } else {
                    desc1.setDynamicReferences(new IProject[0]);
                    desc2.setDynamicReferences(new IProject[]{proj1});
                }
                proj1.setDescription(desc1, ResourceTestUtil.createTestMonitor());
                proj2.setDescription(desc2, ResourceTestUtil.createTestMonitor());
            }
            catch (CoreException e) {
                exceptionInMainThreadCallback.set(() -> {
                    throw e;
                });
            }
        };
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(buildListener, 8);
            SortBuilder verifier = SortBuilder.getInstance();
            verifier.reset();
            workspace.build(6, ResourceTestUtil.createTestMonitor());
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents();
            verifier.reset();
            workspace.build(6, ResourceTestUtil.createTestMonitor());
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.assertLifecycleEvents();
            verifier.reset();
            ResourceTestUtil.setAutoBuilding(true);
            proj1.touch(ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.waitForBuild();
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents();
            verifier.reset();
            proj1.touch(ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.waitForBuild();
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.assertLifecycleEvents();
            verifier.reset();
            exceptionInMainThreadCallback.get().run();
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(buildListener);
        }
    }

    @Test
    public void testCloseOpenProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build1"), this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build2")});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        project.close(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        desc = project.getDescription();
        Object[] commands = desc.getBuildSpec();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])commands).hasSize(2)).allSatisfy(command -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)command.getBuilderName()).isEqualTo("org.eclipse.core.tests.resources.sortbuilder");
        });
        Map args = commands[0].getArguments();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Build1", args.get("BuildID"));
        args = commands[1].getArguments();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Build2", args.get("BuildID"));
    }

    @Test
    public void testCopyProject(TestInfo testInfo) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("testCopyProject1");
        IProject proj2 = workspace.getRoot().getProject("testCopyProject2");
        ResourceTestUtil.setAutoBuilding(true);
        proj1.create(ResourceTestUtil.createTestMonitor());
        proj1.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.removeFromWorkspace((IResource)proj2);
        IProjectDescription desc = proj1.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build0")});
        proj1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        SortBuilder.getInstance().reset();
        desc = proj1.getDescription();
        desc.setName(proj2.getName());
        proj1.copy(desc, 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForEncodingRelatedJobs(((Method)testInfo.getTestMethod().get()).getName());
        ResourceTestUtil.waitForBuild();
        SortBuilder builder = SortBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertEquals((Object)proj2, (Object)builder.getProject());
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.addExpectedLifecycleEvent("Build0");
        builder.assertLifecycleEvents();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasFullBuild());
    }

    @Test
    public void testDynamicBuildOrder() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("PROJECT1");
        IProject proj2 = workspace.getRoot().getProject("PROJECT2");
        ResourceTestUtil.setAutoBuilding(false);
        proj1.create(ResourceTestUtil.createTestMonitor());
        proj1.open(ResourceTestUtil.createTestMonitor());
        proj2.create(ResourceTestUtil.createTestMonitor());
        proj2.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription description = proj2.getDescription();
        description.setDynamicReferences(new IProject[]{proj1});
        proj2.setDescription(description, 0, null);
        ResourceTestUtil.setBuildOrder(null);
        IProjectDescription desc = proj1.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build0")});
        proj1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc = proj2.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build1"), this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Build2")});
        proj2.setDescription(desc, ResourceTestUtil.createTestMonitor());
        workspace.build(6, ResourceTestUtil.createTestMonitor());
        SortBuilder verifier = SortBuilder.getInstance();
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build1");
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build2");
        verifier.assertLifecycleEvents();
        description = proj2.getDescription();
        description.setDynamicReferences(new IProject[0]);
        proj2.setDescription(description, 0, null);
        description = proj1.getDescription();
        description.setDynamicReferences(new IProject[]{proj2});
        proj1.setDescription(description, 0, null);
        workspace.build(6, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("Build1");
        verifier.addExpectedLifecycleEvent("Build2");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
    }

    @Test
    public void testEnableAutobuild() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("PROJECT");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.setAutoBuilding(true);
        SortBuilder verifier = SortBuilder.getInstance();
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
    }

    @Test
    public void testExceptionBuilder() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("PROJECT");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project.getDescription();
        ICommand command1 = desc.newCommand();
        command1.setBuilderName("org.eclipse.core.tests.resources.exceptionbuilder");
        desc.setBuildSpec(new ICommand[]{command1});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        AtomicReference listenerCalled = new AtomicReference();
        IResourceChangeListener listener = event -> listenerCalled.set(true);
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 16);
            CoreException exception = (CoreException)org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor()));
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)exception.getStatus().getSeverity());
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)listenerCalled.get()));
    }

    @Test
    public void testForgetLastBuiltState() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("PROJECT");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        SortBuilder verifier = null;
        project.build(10, "org.eclipse.core.tests.resources.sortbuilder", null, ResourceTestUtil.createTestMonitor());
        verifier = SortBuilder.getInstance();
        verifier.forgetLastBuiltState();
        project.build(10, "org.eclipse.core.tests.resources.sortbuilder", null, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.wasDeltaNull());
        verifier.requestForgetLastBuildState();
        project.touch(ResourceTestUtil.createTestMonitor());
        project.build(10, "org.eclipse.core.tests.resources.sortbuilder", null, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)verifier.wasDeltaNull());
        ResourcesPlugin.getWorkspace().save(false, ResourceTestUtil.createTestMonitor());
        project.build(10, "org.eclipse.core.tests.resources.sortbuilder", null, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.wasDeltaNull());
    }

    @Test
    public void testIncrementalBuildBeforeAutobuild() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("PROJECT");
        IFile input = project.getFolder(SortBuilder.DEFAULT_UNSORTED_FOLDER).getFile("File.txt");
        IFile output = project.getFolder(SortBuilder.DEFAULT_SORTED_FOLDER).getFile("File.txt");
        ResourceTestUtil.setAutoBuilding(true);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.createInWorkspace(input, ResourceTestUtil.createRandomString());
        ResourceTestUtil.waitForBuild();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)output.exists());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AtomicReference exception = new AtomicReference();
        ResourcesPlugin.getWorkspace().run(monitor -> {
            input.setContents(new byte[]{5, 4, 3, 2, 1}, 0, ResourceTestUtil.createTestMonitor());
            project.build(10, ResourceTestUtil.createTestMonitor());
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream inputStream = output.getContents();){
                    inputStream.transferTo(out);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                exception.set(e);
            }
        }, ResourceTestUtil.createTestMonitor());
        if (exception.get() != null) {
            throw (IOException)exception.get();
        }
        byte[] result = out.toByteArray();
        Assertions.assertThat((byte[])result).containsExactly(new int[]{1, 2, 3, 4, 5});
    }

    @Test
    public void testInterruptAutobuild() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("PROJECT");
        IFile file = project.getFile("File.txt");
        ResourceTestUtil.setAutoBuilding(true);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        SortBuilder verifier = SortBuilder.getInstance();
        verifier.reset();
        TestJob blockedJob = new TestJob("Interrupt build", 3, 1000L);
        blockedJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        TestBarrier2 barrier = new TestBarrier2();
        barrier.setStatus(0);
        IResourceChangeListener listener = event -> {
            blockedJob.schedule();
            while (!Job.getJobManager().currentJob().isBlocking()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            barrier.setStatus(3);
        };
        try {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 8);
            file.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
            barrier.waitForStatus(3);
            blockedJob.join();
            ResourceTestUtil.waitForBuild();
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents();
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    @Test
    public void testLifecycleEvents() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("PROJECT");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)monitor);
        SortBuilder verifier = SortBuilder.getInstance();
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
        monitor.assertUsedUp();
        monitor = new FussyProgressMonitor();
        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)monitor);
        verifier.assertLifecycleEvents();
        monitor.assertUsedUp();
        monitor = new FussyProgressMonitor();
        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)monitor);
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
        monitor.assertUsedUp();
        project.close(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        monitor = new FussyProgressMonitor();
        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        project.delete(false, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
    }

    @Test
    public void testMoveProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("PROJECT1");
        IProject proj2 = workspace.getRoot().getProject("Destination");
        ResourceTestUtil.setAutoBuilding(false);
        proj1.create(ResourceTestUtil.createTestMonitor());
        proj1.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = proj1.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        command.getArguments().put("BuildID", "Build0");
        desc.setBuildSpec(new ICommand[]{command});
        proj1.setDescription(desc, ResourceTestUtil.createTestMonitor());
        proj1.build(6, ResourceTestUtil.createTestMonitor());
        proj1.move(proj2.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        proj2.build(10, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testTurnOnAutobuild() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("PROJECT");
        IFile file = project.getFile("File.txt");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        IProjectDescription desc = project.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor());
        SortBuilder verifier = SortBuilder.getInstance();
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
        IWorkspaceRunnable r = monitor -> {
            file.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
            IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
            description.setAutoBuilding(true);
            ResourcesPlugin.getWorkspace().setDescription(description);
        };
        ResourceTestUtil.waitForBuild();
        ResourcesPlugin.getWorkspace().run(r, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
    }
}

