/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.internal.resources.ComputeProjectOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComputeProjectOrderTest {
    @Test
    public void testComputeVertexOrderDuration() {
        ComputeProjectOrder.Digraph digraph = new ComputeProjectOrder.Digraph(Object.class);
        int i = 0;
        while (i < 320) {
            HashSet existingVertexes = new HashSet(digraph.vertexMap.keySet());
            Object newVertex = new Object();
            digraph.addVertex(newVertex);
            existingVertexes.forEach(existingVertex -> digraph.addEdge(existingVertex, newVertex));
            ++i;
        }
        long timestamp = System.currentTimeMillis();
        digraph.freeze();
        ComputeProjectOrder.computeVertexOrder((ComputeProjectOrder.Digraph)digraph, Object.class);
        long duration = System.currentTimeMillis() - timestamp;
        System.err.println(duration);
        Assertions.assertTrue((duration < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testFilterDigraphDuration() {
        ComputeProjectOrder.Digraph digraph = new ComputeProjectOrder.Digraph(Object.class);
        Object initialVertex = new Object();
        digraph.addVertex(initialVertex);
        int i = 0;
        while (i < 320) {
            HashSet existingVertexes = new HashSet(digraph.vertexMap.keySet());
            Object newVertex = new Object();
            digraph.addVertex(newVertex);
            existingVertexes.forEach(existingVertex -> digraph.addEdge(existingVertex, newVertex));
            ++i;
        }
        long timestamp = System.currentTimeMillis();
        ComputeProjectOrder.Digraph filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, o -> false, Object.class);
        Assertions.assertEquals(digraph.vertexMap.keySet(), filtered.vertexMap.keySet());
        long duration = System.currentTimeMillis() - timestamp;
        System.err.println(duration);
        Assertions.assertTrue((duration < 1000L ? 1 : 0) != 0);
        timestamp = System.currentTimeMillis();
        filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, o -> o != initialVertex, Object.class);
        Assertions.assertEquals(Collections.singleton(initialVertex), filtered.vertexMap.keySet());
        duration = System.currentTimeMillis() - timestamp;
        System.err.println(duration);
        Assertions.assertTrue((duration < 1000L ? 1 : 0) != 0);
        timestamp = System.currentTimeMillis();
        Predicate<Object> removeOneOutOfTwo = new Predicate<Object>(){
            private int i = 0;

            @Override
            public boolean test(Object t) {
                return this.i++ % 2 == 0;
            }
        };
        filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, (Predicate)removeOneOutOfTwo, Object.class);
        duration = System.currentTimeMillis() - timestamp;
        System.err.println(duration);
        Assertions.assertTrue((duration < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testFilterDigraphBasic() {
        ComputeProjectOrder.Digraph digraph = new ComputeProjectOrder.Digraph(Object.class);
        Object a = new Object();
        Object b = new Object();
        Object c = new Object();
        Object d = new Object();
        Object e = new Object();
        Object f = new Object();
        digraph.addVertex(a);
        digraph.addVertex(b);
        digraph.addEdge(a, b);
        digraph.addVertex(c);
        digraph.addEdge(b, c);
        digraph.addVertex(d);
        digraph.addEdge(c, d);
        digraph.addVertex(e);
        digraph.addEdge(d, e);
        digraph.addVertex(f);
        digraph.addEdge(e, f);
        ComputeProjectOrder.Digraph filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, v -> v == b || v == e, Object.class);
        HashSet<Object> expectedVertexes = new HashSet<Object>(2, 1.0f);
        expectedVertexes.add(a);
        expectedVertexes.add(c);
        expectedVertexes.add(d);
        expectedVertexes.add(f);
        Assertions.assertEquals(expectedVertexes, filtered.vertexMap.keySet());
        HashSet<ComputeProjectOrder.Digraph.Edge> expectedEdges = new HashSet<ComputeProjectOrder.Digraph.Edge>(3, 1.0f);
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge(a, c));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge(c, d));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge(d, f));
        Assertions.assertEquals(expectedEdges, (Object)filtered.getEdges());
    }

    @Test
    public void testFilterSelfReference() {
        ComputeProjectOrder.Digraph digraph = new ComputeProjectOrder.Digraph(String.class);
        String a = "a";
        String b = "b";
        String c = "c";
        digraph.addVertex((Object)a);
        digraph.addVertex((Object)b);
        digraph.addVertex((Object)c);
        digraph.addEdge((Object)a, (Object)b);
        digraph.addEdge((Object)b, (Object)b);
        digraph.addEdge((Object)b, (Object)c);
        ComputeProjectOrder.Digraph filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, b::equals, String.class);
        HashSet<String> expectedVertexes = new HashSet<String>(2, 1.0f);
        expectedVertexes.add(a);
        expectedVertexes.add(c);
        Assertions.assertEquals(expectedVertexes, filtered.vertexMap.keySet());
        Set<ComputeProjectOrder.Digraph.Edge> expectedEdges = Collections.singleton(new ComputeProjectOrder.Digraph.Edge((Object)a, (Object)c));
        Assertions.assertEquals(expectedEdges, (Object)filtered.getEdges());
    }

    @Test
    public void testCycle3Nodes() {
        ComputeProjectOrder.Digraph digraph = new ComputeProjectOrder.Digraph(String.class);
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        digraph.addVertex((Object)a);
        digraph.addVertex((Object)b);
        digraph.addVertex((Object)c);
        digraph.addVertex((Object)d);
        digraph.addVertex((Object)e);
        digraph.addEdge((Object)a, (Object)b);
        digraph.addEdge((Object)b, (Object)c);
        digraph.addEdge((Object)c, (Object)d);
        digraph.addEdge((Object)d, (Object)b);
        digraph.addEdge((Object)d, (Object)e);
        ComputeProjectOrder.Digraph filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, b::equals, String.class);
        HashSet<String> expectedVertexes = new HashSet<String>(4, 1.0f);
        expectedVertexes.add(a);
        expectedVertexes.add(c);
        expectedVertexes.add(d);
        expectedVertexes.add(e);
        Assertions.assertEquals(expectedVertexes, filtered.vertexMap.keySet());
        HashSet<ComputeProjectOrder.Digraph.Edge> expectedEdges = new HashSet<ComputeProjectOrder.Digraph.Edge>();
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge((Object)a, (Object)c));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge((Object)d, (Object)e));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge((Object)d, (Object)c));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge((Object)c, (Object)d));
        Assertions.assertEquals(expectedEdges, (Object)filtered.getEdges());
        filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, c::equals, String.class);
        expectedVertexes = new HashSet(4, 1.0f);
        expectedVertexes.add(a);
        expectedVertexes.add(b);
        expectedVertexes.add(d);
        expectedVertexes.add(e);
        Assertions.assertEquals(expectedVertexes, filtered.vertexMap.keySet());
        expectedEdges = new HashSet();
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge((Object)a, (Object)b));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge((Object)b, (Object)d));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge((Object)d, (Object)b));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge((Object)d, (Object)e));
        Assertions.assertEquals(expectedEdges, (Object)filtered.getEdges());
        filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, node -> node.equals(b) || node.equals(c) || node.equals(d), String.class);
        HashSet<String> expectedVertexes2 = new HashSet<String>(4, 1.0f);
        expectedVertexes2.add(a);
        expectedVertexes2.add(e);
        Assertions.assertEquals(expectedVertexes2, filtered.vertexMap.keySet());
        Assertions.assertEquals(Collections.singleton(new ComputeProjectOrder.Digraph.Edge((Object)a, (Object)e)), (Object)filtered.getEdges());
    }

    @Test
    public void testCycle2Nodes() {
        ComputeProjectOrder.Digraph digraph = new ComputeProjectOrder.Digraph(String.class);
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        digraph.addVertex((Object)a);
        digraph.addVertex((Object)b);
        digraph.addVertex((Object)c);
        digraph.addVertex((Object)d);
        digraph.addEdge((Object)a, (Object)b);
        digraph.addEdge((Object)b, (Object)c);
        digraph.addEdge((Object)c, (Object)b);
        digraph.addEdge((Object)c, (Object)d);
        ComputeProjectOrder.Digraph filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, v -> v.equals(b) || v.equals(c), String.class);
        HashSet<String> expectedVertexes = new HashSet<String>(4, 1.0f);
        expectedVertexes.add(a);
        expectedVertexes.add(d);
        Assertions.assertEquals(expectedVertexes, filtered.vertexMap.keySet());
        Assertions.assertEquals(Collections.singleton(new ComputeProjectOrder.Digraph.Edge((Object)a, (Object)d)), (Object)filtered.getEdges());
        filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, d::equals, String.class);
        HashSet<String> expectedVertexes2 = new HashSet<String>(3, 1.0f);
        expectedVertexes2.add(a);
        expectedVertexes2.add(b);
        expectedVertexes2.add(c);
        Assertions.assertEquals(expectedVertexes2, filtered.vertexMap.keySet());
        HashSet<ComputeProjectOrder.Digraph.Edge> expectedEdges = new HashSet<ComputeProjectOrder.Digraph.Edge>(3, 1.0f);
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge((Object)a, (Object)b));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge((Object)b, (Object)c));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge((Object)c, (Object)b));
        Assertions.assertEquals(expectedEdges, (Object)filtered.getEdges());
    }
}

