/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IBuildContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.tests.internal.builders.TestBuilder;

public class ContextBuilder
extends TestBuilder {
    public static final String BUILDER_NAME = "org.eclipse.core.tests.resources.contextbuilder";
    private static HashMap<IBuildConfiguration, ContextBuilder> builders = new HashMap();
    IBuildContext contextForLastBuild = null;
    int triggerForLastBuild = 0;
    private boolean getRuleCalledForLastBuild = false;
    private IBuildContext contextForLastBuildInGetRule = null;
    private IBuildConfiguration buildConfigurationForLastBuild = null;
    private IBuildConfiguration buildConfigurationForLastBuildInGetRule = null;

    public static ContextBuilder getBuilder(IBuildConfiguration variant) {
        return builders.get(variant);
    }

    public static IBuildContext getContext(IBuildConfiguration variant) {
        if (!builders.containsKey(variant)) {
            return null;
        }
        return ContextBuilder.getBuilder((IBuildConfiguration)variant).contextForLastBuild;
    }

    public static void assertValid() {
        for (ContextBuilder builder : builders.values()) {
            if (!builder.getRuleCalledForLastBuild) continue;
            Assertions.assertThat((Object)builder.contextForLastBuild).isEqualTo((Object)builder.contextForLastBuildInGetRule);
            Assertions.assertThat((Object)builder.buildConfigurationForLastBuild).isEqualTo((Object)builder.buildConfigurationForLastBuildInGetRule);
        }
    }

    public static void clearStats() {
        for (ContextBuilder builder : builders.values()) {
            builder.contextForLastBuild = null;
            builder.contextForLastBuildInGetRule = null;
            builder.buildConfigurationForLastBuild = null;
            builder.buildConfigurationForLastBuildInGetRule = null;
            builder.getRuleCalledForLastBuild = false;
            builder.triggerForLastBuild = 0;
        }
    }

    @Override
    protected void startupOnInitialize() {
        builders.put(this.getBuildConfig(), this);
    }

    @Override
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        this.contextForLastBuild = this.getContext();
        this.triggerForLastBuild = kind;
        this.buildConfigurationForLastBuild = this.getBuildConfig();
        return super.build(kind, args, monitor);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        this.contextForLastBuild = this.getContext();
        this.triggerForLastBuild = 15;
        this.buildConfigurationForLastBuild = this.getBuildConfig();
    }

    @Override
    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        this.getRuleCalledForLastBuild = true;
        this.contextForLastBuildInGetRule = this.getContext();
        this.buildConfigurationForLastBuildInGetRule = this.getBuildConfig();
        return super.getRule(kind, args);
    }
}

