/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.CustomTriggerBuilder;
import org.eclipse.core.tests.internal.builders.SortBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class CustomBuildTriggerTest {
    @BeforeEach
    public void setUp() throws Exception {
        SortBuilder.resetSingleton();
        CustomTriggerBuilder.resetSingleton();
    }

    @Test
    public void testBuildAfterClean_builderRespondingToFull() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.flexbuilder").withTestBuilderId("Build0").withBuildingSetting(9, false).withBuildingSetting(6, true).withBuildingSetting(10, false).withBuildingSetting(15, false).apply();
        ResourceTestUtil.setAutoBuilding(true);
        workspace.build(15, ResourceTestUtil.createTestMonitor());
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)builder));
        org.junit.jupiter.api.Assertions.assertTrue((builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
        ResourceTestUtil.waitForBuild();
        builder.reset();
        workspace.build(15, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)builder.triggerForLastBuild);
        ResourceTestUtil.waitForBuild();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)builder.triggerForLastBuild);
        builder.reset();
        workspace.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasFullBuild());
        builder.reset();
        builder.clearBuildTrigger();
        workspace.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBuildAfterClean_builderRespondingToIncremental() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.flexbuilder").withTestBuilderId("Build0").withBuildingSetting(9, false).withBuildingSetting(6, false).withBuildingSetting(10, true).withBuildingSetting(15, false).apply();
        ResourceTestUtil.setAutoBuilding(true);
        workspace.build(15, ResourceTestUtil.createTestMonitor());
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)builder));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)builder.triggerForLastBuild);
        ResourceTestUtil.waitForBuild();
        builder.reset();
        workspace.build(15, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)builder.triggerForLastBuild);
        ResourceTestUtil.waitForBuild();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)builder.triggerForLastBuild);
        builder.reset();
        workspace.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasFullBuild());
        IFile file = project.getFile("a.txt");
        file.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        builder.reset();
        builder.clearBuildTrigger();
        workspace.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)builder.triggerForLastBuild);
    }

    @Test
    public void testBuildAfterClean_builderRespondingToAuto() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.flexbuilder").withTestBuilderId("Build0").withBuildingSetting(9, true).withBuildingSetting(6, false).withBuildingSetting(10, false).withBuildingSetting(15, false).apply();
        IWorkspaceDescription description = workspace.getDescription();
        description.setAutoBuilding(true);
        workspace.setDescription(description);
        workspace.build(15, ResourceTestUtil.createTestMonitor());
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)builder));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)builder.triggerForLastBuild);
        ResourceTestUtil.waitForBuild();
        builder.reset();
        workspace.build(15, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasFullBuild());
        builder.clearBuildTrigger();
        builder.reset();
        IFile file = project.getFile("b.txt");
        file.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasCleanBuild());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasAutobuild());
    }

    @Test
    public void testConfigurable() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.flexbuilder").withTestBuilderId("Build0").apply();
        Assertions.assertThat((Object[])project.getDescription().getBuildSpec()).hasSize(1);
        ICommand command = project.getDescription().getBuildSpec()[0];
        org.junit.jupiter.api.Assertions.assertTrue((boolean)command.isConfigurable());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)command.isBuilding(9));
        command.setBuilding(9, false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)command.isBuilding(9));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)command.isBuilding(15));
        command.setBuilding(15, false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)command.isBuilding(15));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)command.isBuilding(6));
        command.setBuilding(6, false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)command.isBuilding(6));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)command.isBuilding(10));
        command.setBuilding(10, false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)command.isBuilding(10));
        ResourceTestUtil.updateProjectDescription(project).removingExistingCommands().addingCommand(command).apply();
        project.build(6, ResourceTestUtil.createTestMonitor());
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertTrue((builder == null || builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
        project.build(15, ResourceTestUtil.createTestMonitor());
        builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertTrue((builder == null || builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
        project.touch(ResourceTestUtil.createTestMonitor());
        project.build(10, ResourceTestUtil.createTestMonitor());
        builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertTrue((builder == null || builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
        ResourceTestUtil.setAutoBuilding(true);
        project.touch(ResourceTestUtil.createTestMonitor());
        builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertTrue((builder == null || builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
        ResourceTestUtil.setAutoBuilding(false);
        ResourceTestUtil.updateProjectDescription(project).removingExistingCommands().addingCommand(command).withBuildingSetting(9, true).withBuildingSetting(15, true).withBuildingSetting(6, true).withBuildingSetting(10, true).apply();
        project.build(6, ResourceTestUtil.createTestMonitor());
        builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasFullBuild());
        project.build(6, ResourceTestUtil.createTestMonitor());
        builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasFullBuild());
        project.build(15, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasCleanBuild());
    }

    @Test
    public void testNonConfigurable() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.sortbuilder").withTestBuilderId("Build0").apply();
        Assertions.assertThat((Object[])project.getDescription().getBuildSpec()).hasSize(1);
        ICommand command = project.getDescription().getBuildSpec()[0];
        org.junit.jupiter.api.Assertions.assertFalse((boolean)command.isConfigurable());
        command.setBuilding(9, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)command.isBuilding(9));
        command.setBuilding(15, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)command.isBuilding(15));
        command.setBuilding(6, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)command.isBuilding(6));
        command.setBuilding(10, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)command.isBuilding(10));
        ResourceTestUtil.updateProjectDescription(project).removingExistingCommands().addingCommand(command);
        project.build(6, ResourceTestUtil.createTestMonitor());
        SortBuilder builder = SortBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasBuilt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasFullBuild());
        org.junit.jupiter.api.Assertions.assertEquals((Object)command, (Object)builder.getCommand());
        project.touch(ResourceTestUtil.createTestMonitor());
        project.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasBuilt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasIncrementalBuild());
    }

    @Test
    public void testSkipAutobuildDelta() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        CustomTriggerBuilder.resetSingleton();
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.flexbuilder").withTestBuilderId("Build0").withBuildingSetting(9, false).apply();
        Assertions.assertThat((Object[])project.getDescription().getBuildSpec()).hasSize(1);
        ICommand command = project.getDescription().getBuildSpec()[0];
        ResourceTestUtil.setAutoBuilding(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)command.isConfigurable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)command.isBuilding(9));
        project.build(10, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)builder));
        builder.clearBuildTrigger();
        IFile file = project.getFile("a.txt");
        file.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasIncrementalBuild());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasAutobuild());
        project.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasAutobuild());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasIncrementalBuild());
    }

    @Test
    public void testCleanBuild_AfterCleanBuilder() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.flexbuilder").withTestBuilderId("Build0").withBuildingSetting(9, false).withBuildingSetting(6, true).withBuildingSetting(10, false).withBuildingSetting(15, false).apply();
        ResourceTestUtil.setAutoBuilding(false);
        project.build(10, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)builder));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasFullBuild());
        builder.clearBuildTrigger();
        builder.reset();
        workspace.build(15, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasCleanBuild());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasFullBuild());
        builder.clearBuildTrigger();
        builder.reset();
        workspace.build(10, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasCleanBuild());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasFullBuild());
        IFile file = project.getFile("a.txt");
        file.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        builder.clearBuildTrigger();
        builder.reset();
        workspace.build(10, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasCleanBuild());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasFullBuild());
    }

    @Test
    public void testCleanAutoBuild_AfterCleanBuilder() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.flexbuilder").withTestBuilderId("Build0").withBuildingSetting(9, false).withBuildingSetting(6, true).withBuildingSetting(10, false).withBuildingSetting(15, false).apply();
        ResourceTestUtil.setAutoBuilding(true);
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((Object)builder));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)builder.triggerForLastBuild);
        builder.clearBuildTrigger();
        builder.reset();
        workspace.build(15, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasCleanBuild());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasFullBuild());
        builder.clearBuildTrigger();
        builder.reset();
        IFile file = project.getFile("a.txt");
        file.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)builder.triggerForLastBuild);
        project.build(10, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.wasFullBuild());
        builder.clearBuildTrigger();
        builder.reset();
        file = project.getFile("b.txt");
        file.create(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.waitForBuild();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasCleanBuild());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.wasFullBuild());
    }
}

