/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.EmptyDeltaBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class EmptyDeltaTest {
    @Test
    public void testBuildEvents() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("TestBuildEvents");
        ResourceTestUtil.setAutoBuilding(false);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.emptydeltabuilder").apply();
        new EmptyDeltaBuilder().reset();
        ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor());
        EmptyDeltaBuilder verifier = EmptyDeltaBuilder.getInstance();
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
        verifier.reset();
        ResourcesPlugin.getWorkspace().build(10, ResourceTestUtil.createTestMonitor());
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents();
    }
}

