/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.TestPerformer;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class MultiProjectBuildTest {
    private IProject project1;
    private IProject project2;
    private IProject project3;
    private IProject project4;
    private IFile file1;
    private IFile file2;
    private IFile file3;
    private IFile file4;

    private IProject[][] interestingProjects() {
        return new IProject[][]{new IProject[0], {this.project3}, {this.project1}, {this.project1, this.project2, this.project3}, {this.project2}, {this.project3}, {this.project4}, {this.project1, this.project2}, {this.project1, this.project3}, {this.project3}, {this.project2, this.project3}, {this.project1, this.project2, this.project3}, {this.project1, this.project2, this.project4}, {this.project1}, {this.project1, this.project3, this.project4}, {this.project1, this.project2}, {this.project2, this.project3, this.project4}, {this.project3, this.project4}, {this.project1, this.project2, this.project3, this.project4}};
    }

    private void dirty(IProject[] projects) throws CoreException {
        ResourcesPlugin.getWorkspace().run(monitor -> {
            IProject[] iProjectArray2 = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray2[n2];
                IResource[] iResourceArray = project.members();
                int n3 = iResourceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource member = iResourceArray[n4];
                    if (member.getType() == 1 && !member.getName().equals(".project")) {
                        ((IFile)member).setContents(ResourceTestUtil.createRandomContentsStream(), true, true, null);
                    }
                    ++n4;
                }
                ++n2;
            }
            ResourcesPlugin.getWorkspace().build(10, null);
        }, ResourceTestUtil.createTestMonitor());
    }

    private IProject[][] reverse(IProject[][] input) {
        if (input == null) {
            return null;
        }
        int len = input.length;
        IProject[][] output = (IProject[][])Array.newInstance(IProject[].class, len);
        int i = 0;
        while (i < len) {
            output[len - i - 1] = input[i];
            ++i;
        }
        return output;
    }

    @BeforeEach
    public void setUp() throws Exception {
        ResourceTestUtil.setAutoBuilding(true);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project1 = root.getProject("Project1");
        this.project2 = root.getProject("Project2");
        this.project3 = root.getProject("Project3");
        this.project4 = root.getProject("Project4");
        this.file1 = this.project1.getFile("File1");
        this.file2 = this.project2.getFile("File2");
        this.file3 = this.project3.getFile("File3");
        this.file4 = this.project4.getFile("File4");
        IResource[] resources = new IResource[]{this.project1, this.project2, this.project3, this.project4, this.file1, this.file2, this.file3, this.file4};
        ResourceTestUtil.createInWorkspace(resources);
    }

    @Test
    public void testDeltas() throws Exception {
        ResourceTestUtil.setAutoBuilding(false);
        ResourceTestUtil.updateProjectDescription(this.project1).addingCommand("org.eclipse.core.tests.resources.deltaverifierbuilder").withTestBuilderId("testbuild").apply();
        this.project1.build(6, ResourceTestUtil.createTestMonitor());
        final DeltaVerifierBuilder builder = DeltaVerifierBuilder.getInstance();
        Assertions.assertNotNull((Object)((Object)builder));
        final IProject[] allProjects = new IProject[]{this.project1, this.project2, this.project3, this.project4};
        builder.checkDeltas(allProjects);
        final IProject[][] previousRequest = new IProject[][]{{this.project1}};
        final HashSet previouslyModified = new HashSet();
        new TestPerformer("testDeltas"){

            @Override
            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IProject[] requested = (IProject[])args[0];
                IProject[] toModify = (IProject[])args[1];
                builder.reset();
                builder.requestDeltas(requested);
                MultiProjectBuildTest.this.dirty(toModify);
                IProject[] result = previousRequest[0];
                if (builder.wasBuilt()) {
                    previousRequest[0] = requested;
                    previouslyModified.clear();
                } else {
                    previouslyModified.addAll(Arrays.asList(toModify));
                }
                return result;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                HashSet<IProject> requested = new HashSet<IProject>(Arrays.asList((IProject[])result));
                HashSet<IProject> modified = new HashSet<IProject>(Arrays.asList((IProject[])args[1]));
                modified.addAll(previouslyModified);
                HashSet<IProject> obtained = new HashSet<IProject>();
                if (!builder.getReceivedDeltas().isEmpty()) {
                    obtained.addAll(builder.getReceivedDeltas());
                }
                ArrayList<IProject> emptyDeltas = builder.getEmptyDeltas();
                requested.add(builder.getProject());
                IProject[] iProjectArray = allProjects;
                int n = allProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    boolean wasObtained = obtained.contains(project);
                    boolean wasRequested = requested.contains(project);
                    boolean wasModified = modified.contains(project);
                    boolean wasEmpty = emptyDeltas.contains(project);
                    if (wasObtained ? !wasRequested || !wasModified && !wasEmpty : wasRequested && wasModified) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }.performTest(new Object[][]{this.interestingProjects(), this.reverse(this.interestingProjects())});
    }

    @Test
    public void testRequestMissingProject() throws CoreException {
        ResourceTestUtil.updateProjectDescription(this.project1).addingCommand("org.eclipse.core.tests.resources.deltaverifierbuilder").withTestBuilderId("testbuild").apply();
        this.project1.build(6, ResourceTestUtil.createTestMonitor());
        DeltaVerifierBuilder builder = DeltaVerifierBuilder.getInstance();
        Assertions.assertNotNull((Object)((Object)builder));
        IProject[] allProjects = new IProject[]{this.project1, this.project2, this.project3, this.project4};
        this.project2.close(ResourceTestUtil.createTestMonitor());
        this.project3.delete(4, ResourceTestUtil.createTestMonitor());
        builder.checkDeltas(allProjects);
        this.file1.setContents(ResourceTestUtil.createRandomContentsStream(), 0, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testPR() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        project.create(null);
        project.open(null);
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.refreshbuilder").andCommand("org.eclipse.core.tests.resources.sortbuilder").apply();
        project.build(6, null);
        IFile file = project.getFile("Foo");
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
    }
}

