/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.lang.reflect.Method;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.RebuildingBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class RebuildTest {
    final String builderName = "org.eclipse.core.tests.resources.rebuildingbuilder";
    private int maxBuildIterations;
    private String testName;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws CoreException {
        this.maxBuildIterations = ResourcesPlugin.getWorkspace().getDescription().getMaxBuildIterations();
        this.testName = ((Method)testInfo.getTestMethod().get()).getName();
        ResourceTestUtil.setAutoBuilding(false);
        boolean earlyExitAllowed = ((Workspace)ResourcesPlugin.getWorkspace()).getBuildManager().isEarlyExitFromBuildLoopAllowed();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)earlyExitAllowed, (String)"early exit shouldn't be set");
    }

    @AfterEach
    public void tearDown() throws CoreException {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setMaxBuildIterations(this.maxBuildIterations);
        ResourcesPlugin.getWorkspace().setDescription(description);
        RebuildingBuilder.getInstances().clear();
        this.allowEarlyBuildLoopExit(false);
    }

    @Test
    public void testSingleProjectPropagationAndNoOtherBuilders() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        RebuildingBuilder b2 = builders.get(1);
        RebuildingBuilder b3 = builders.get(2);
        builders.forEach(RebuildingBuilder::reset);
        project.build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b2.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b3.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b2.setRequestProjectRebuild(project, 1);
        b3.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        int max = 5;
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setMaxBuildIterations(5);
        ResourcesPlugin.getWorkspace().setDescription(description);
        int rebuilds = 42;
        int expectedRebuildsFirstBuilders = 25;
        int expectedRebuildslastBuilder = 5;
        b2.setRequestProjectRebuild(project, rebuilds);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildslastBuilder, (int)b3.buildsCount());
    }

    @Test
    public void testSingleProjectPropagationAndOtherBuilders() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        RebuildingBuilder b2 = builders.get(1);
        RebuildingBuilder b3 = builders.get(2);
        builders.forEach(RebuildingBuilder::reset);
        project.build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b2.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b3.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b2.setRequestProjectRebuild(project, 1);
        b3.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        int max = 5;
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setMaxBuildIterations(5);
        ResourcesPlugin.getWorkspace().setDescription(description);
        int rebuilds = 42;
        int expectedRebuildsFirstBuilders = 25;
        int expectedRebuildslastBuilder = 25;
        b2.setRequestProjectRebuild(project, rebuilds);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildslastBuilder, (int)b3.buildsCount());
    }

    @Test
    public void testSingleProjectNoPropagationAndProcessOtherBuilder() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        RebuildingBuilder b2 = builders.get(1);
        RebuildingBuilder b3 = builders.get(2);
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        project.build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b2.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b3.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b2.setRequestProjectRebuild(project, 1);
        b3.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        int max = 5;
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setMaxBuildIterations(5);
        ResourcesPlugin.getWorkspace().setDescription(description);
        int rebuilds = 42;
        int expectedRebuildsFirstBuilders = 5;
        int expectedRebuildslastBuilder = 5;
        b2.setRequestProjectRebuild(project, rebuilds);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildslastBuilder, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        expectedRebuildslastBuilder = 5;
        b3.setRequestProjectRebuild(project, rebuilds);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildslastBuilder, (int)b3.buildsCount());
    }

    @Test
    public void testSingleProjectNoPropagationNoOtherBuilders() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        RebuildingBuilder b2 = builders.get(1);
        RebuildingBuilder b3 = builders.get(2);
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        project.build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b2.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        expectedKinds = List.of(Integer.valueOf(6));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b3.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b2.setRequestProjectRebuild(project, 1);
        b3.setRequestProjectRebuild(project, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        int max = 5;
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setMaxBuildIterations(5);
        ResourcesPlugin.getWorkspace().setDescription(description);
        int rebuilds = 42;
        int expectedRebuildsFirstBuilders = 5;
        int expectedRebuildslastBuilder = 1;
        b2.setRequestProjectRebuild(project, rebuilds);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildslastBuilder, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        expectedRebuildslastBuilder = 5;
        b3.setRequestProjectRebuild(project, rebuilds);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstBuilders, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildslastBuilder, (int)b3.buildsCount());
    }

    @Test
    public void testMultipleProjectsPropagationAndNoOtherBuilders() throws Exception {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "1");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "2");
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        project2.create(ResourceTestUtil.createTestMonitor());
        project2.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project1).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project1.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project1.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        RebuildingBuilder b2 = builders.get(1);
        RebuildingBuilder b3 = builders.get(2);
        builders.forEach(RebuildingBuilder::reset);
        ResourceTestUtil.updateProjectDescription(project2).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project2.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)builders.size());
        RebuildingBuilder b4 = builders.get(3);
        RebuildingBuilder b5 = builders.get(4);
        RebuildingBuilder b6 = builders.get(5);
        builders.forEach(RebuildingBuilder::reset);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b6.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b4.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b5.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b6.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        b4.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        b4.setRequestProjectRebuild(project2, 1);
        b5.setRequestProjectRebuild(project2, 1);
        b6.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b6.buildsCount());
    }

    @Test
    public void testMultipleProjectsPropagationAndProcessOtherBuilders() throws Exception {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "1");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "2");
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        project2.create(ResourceTestUtil.createTestMonitor());
        project2.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project1).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project1.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project1.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        RebuildingBuilder b2 = builders.get(1);
        RebuildingBuilder b3 = builders.get(2);
        builders.forEach(RebuildingBuilder::reset);
        ResourceTestUtil.updateProjectDescription(project2).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project2.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)builders.size());
        RebuildingBuilder b4 = builders.get(3);
        RebuildingBuilder b5 = builders.get(4);
        RebuildingBuilder b6 = builders.get(5);
        builders.forEach(RebuildingBuilder::reset);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b6.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b4.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b5.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b6.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setRequestProjectRebuild(project1, 1);
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setRequestProjectRebuild(project1, 1);
        b4.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setRequestProjectRebuild(project1, 1);
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        b4.setRequestProjectRebuild(project2, 1);
        b5.setRequestProjectRebuild(project2, 1);
        b6.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b6.buildsCount());
    }

    @Test
    public void testMultipleProjectsPropagationAndNoOtherBuildersWithEarlyExit() throws Exception {
        this.allowEarlyBuildLoopExit(true);
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "1");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "2");
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        project2.create(ResourceTestUtil.createTestMonitor());
        project2.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project1).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project1.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project1.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        RebuildingBuilder b2 = builders.get(1);
        RebuildingBuilder b3 = builders.get(2);
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        ResourceTestUtil.updateProjectDescription(project2).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project2.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)builders.size());
        RebuildingBuilder b4 = builders.get(3);
        RebuildingBuilder b5 = builders.get(4);
        RebuildingBuilder b6 = builders.get(5);
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        expectedKinds = List.of(Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b4.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b5.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b6.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        b4.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        b4.setRequestProjectRebuild(project2, 1);
        b5.setRequestProjectRebuild(project2, 1);
        b6.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        int max = 5;
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setMaxBuildIterations(5);
        ResourcesPlugin.getWorkspace().setDescription(description);
        int rebuilds = 42;
        int expectedRebuildsFirstProject = 25;
        int expectedBuildCycles = 5;
        b2.setRequestProjectRebuild(project1, rebuilds);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstProject, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedRebuildsFirstProject, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedBuildCycles, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
    }

    @Test
    public void testMultipleProjectsNoPropagationNoOtherBuilders() throws Exception {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "1");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "2");
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        project2.create(ResourceTestUtil.createTestMonitor());
        project2.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project1).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project1.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project1.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        RebuildingBuilder b2 = builders.get(1);
        RebuildingBuilder b3 = builders.get(2);
        builders.forEach(RebuildingBuilder::reset);
        ResourceTestUtil.updateProjectDescription(project2).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        project2.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)builders.size());
        RebuildingBuilder b4 = builders.get(3);
        RebuildingBuilder b5 = builders.get(4);
        RebuildingBuilder b6 = builders.get(5);
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b2.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        expectedKinds = List.of(Integer.valueOf(6));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b4.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b5.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b6.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b2.setRequestProjectRebuild(project1, 1);
        b5.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        b4.setRequestProjectRebuild(project2, 1);
        b5.setRequestProjectRebuild(project2, 1);
        b6.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b6.buildsCount());
    }

    @Test
    public void testMultipleProjectsNoPropagationAndOtherBuilders() throws Exception {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "1");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "2");
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        project2.create(ResourceTestUtil.createTestMonitor());
        project2.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project1).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project1.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project1.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        RebuildingBuilder b2 = builders.get(1);
        RebuildingBuilder b3 = builders.get(2);
        builders.forEach(RebuildingBuilder::reset);
        ResourceTestUtil.updateProjectDescription(project2).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        project2.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)builders.size());
        RebuildingBuilder b4 = builders.get(3);
        RebuildingBuilder b5 = builders.get(4);
        RebuildingBuilder b6 = builders.get(5);
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        expectedKinds = List.of(Integer.valueOf(6));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b4.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b5.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b6.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b2.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setRequestProjectRebuild(project1, 1);
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b2.setRequestProjectRebuild(project1, 1);
        b5.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setRequestProjectRebuild(project1, 1);
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        b4.setRequestProjectRebuild(project2, 1);
        b5.setRequestProjectRebuild(project2, 1);
        b6.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b6.buildsCount());
    }

    @Test
    public void testMultipleProjectsNoPropagationNoOtherBuildersEarlyExit() throws Exception {
        this.allowEarlyBuildLoopExit(true);
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "1");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "2");
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        project2.create(ResourceTestUtil.createTestMonitor());
        project2.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project1).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        project1.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project1.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        RebuildingBuilder b2 = builders.get(1);
        RebuildingBuilder b3 = builders.get(2);
        ResourceTestUtil.updateProjectDescription(project2).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder2").andCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder3").apply();
        builders.forEach(b -> b.setPropagateRebuild(false));
        project2.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)builders.size());
        RebuildingBuilder b4 = builders.get(3);
        RebuildingBuilder b5 = builders.get(4);
        RebuildingBuilder b6 = builders.get(5);
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b2.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        expectedKinds = List.of(Integer.valueOf(6));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b4.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b5.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b6.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b2.setRequestProjectRebuild(project1, 1);
        b5.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b6.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(false));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setRequestProjectRebuild(project1, 1);
        b2.setRequestProjectRebuild(project1, 1);
        b3.setRequestProjectRebuild(project1, 1);
        b4.setRequestProjectRebuild(project2, 1);
        b5.setRequestProjectRebuild(project2, 1);
        b6.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b4.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b5.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b6.buildsCount());
    }

    @Test
    public void testMultipleProjectsPropagationAndNoOtherBuildersExplicitRebuild() throws Exception {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "1");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "2");
        IProject project3 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "3");
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        project2.create(ResourceTestUtil.createTestMonitor());
        project2.open(ResourceTestUtil.createTestMonitor());
        project3.create(ResourceTestUtil.createTestMonitor());
        project3.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project1).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").apply();
        project1.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project1.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        ResourceTestUtil.updateProjectDescription(project2).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").apply();
        project2.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)builders.size());
        RebuildingBuilder b2 = builders.get(1);
        ResourceTestUtil.updateProjectDescription(project3).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").apply();
        project3.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)builders.size());
        RebuildingBuilder b3 = builders.get(2);
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project2, 1);
        b2.setPropagateRebuild(false);
        b2.setRequestProjectRebuild(project3, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project1, 1);
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project2, 1);
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project3, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        expectedKinds = List.of(Integer.valueOf(6));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b2.setPropagateRebuild(false);
        b2.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project2, 1);
        b2.setPropagateRebuild(false);
        b2.setRequestProjectRebuild(project3, 1);
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project1, 1);
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project2, 1);
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project3, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project1, project2, project3);
        b2.setPropagateRebuild(false);
        b2.setRequestProjectRebuild(project1, project2, project3);
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project1, project2, project3);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        b1.setPropagateRebuild(true);
        b1.setRequestProjectRebuild(project1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(false));
        int max = 5;
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setMaxBuildIterations(5);
        ResourcesPlugin.getWorkspace().setDescription(description);
        int rebuilds = 42;
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project3, rebuilds);
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project1, rebuilds);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
    }

    @Test
    public void testMultipleProjectsPropagationAndProcessOtherBuildersExplicitRebuild() throws Exception {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "1");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "2");
        IProject project3 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testName + "3");
        project1.create(ResourceTestUtil.createTestMonitor());
        project1.open(ResourceTestUtil.createTestMonitor());
        project2.create(ResourceTestUtil.createTestMonitor());
        project2.open(ResourceTestUtil.createTestMonitor());
        project3.create(ResourceTestUtil.createTestMonitor());
        project3.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(project1).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").apply();
        project1.build(10, ResourceTestUtil.createTestMonitor());
        List<RebuildingBuilder> builders = RebuildingBuilder.getInstances();
        Assertions.assertThat((Object[])project1.getDescription().getBuildSpec()).hasSameSizeAs(builders);
        RebuildingBuilder b1 = builders.get(0);
        ResourceTestUtil.updateProjectDescription(project2).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").apply();
        project2.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)builders.size());
        RebuildingBuilder b2 = builders.get(1);
        ResourceTestUtil.updateProjectDescription(project3).addingCommand("org.eclipse.core.tests.resources.rebuildingbuilder").withTestBuilderId("builder1").apply();
        project3.build(10, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)builders.size());
        RebuildingBuilder b3 = builders.get(2);
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project2, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project2, 1);
        b2.setPropagateRebuild(false);
        b2.setRequestProjectRebuild(project3, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project1, 1);
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project2, 1);
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project3, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        List<Integer> expectedKinds = List.of(Integer.valueOf(6), Integer.valueOf(10));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b1.buildKinds());
        expectedKinds = List.of(Integer.valueOf(6));
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b2.buildKinds());
        org.junit.jupiter.api.Assertions.assertEquals(expectedKinds, b3.buildKinds());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b2.setPropagateRebuild(false);
        b2.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project2, 1);
        b2.setPropagateRebuild(false);
        b2.setRequestProjectRebuild(project3, 1);
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project1, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project1, 1);
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project2, 1);
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project3, 1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project1, project2, project3);
        b2.setPropagateRebuild(false);
        b2.setRequestProjectRebuild(project1, project2, project3);
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project1, project2, project3);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        b1.setPropagateRebuild(true);
        b1.setRequestProjectRebuild(project1);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)b3.buildsCount());
        builders.forEach(RebuildingBuilder::reset);
        builders.forEach(b -> b.setPropagateRebuild(true));
        builders.forEach(b -> b.setProcessOtherBuilders(true));
        int max = 5;
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setMaxBuildIterations(5);
        ResourcesPlugin.getWorkspace().setDescription(description);
        int rebuilds = 42;
        b1.setPropagateRebuild(false);
        b1.setRequestProjectRebuild(project3, rebuilds);
        b3.setPropagateRebuild(false);
        b3.setRequestProjectRebuild(project1, rebuilds);
        ResourcesPlugin.getWorkspace().build(6, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)b1.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)b2.buildsCount());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b3.buildsCount());
    }

    private void allowEarlyBuildLoopExit(boolean earlyExitFromInnerBuildLoopAllowed) {
        ((Workspace)ResourcesPlugin.getWorkspace()).getBuildManager().setEarlyExitFromBuildLoopAllowed(earlyExitFromInnerBuildLoopAllowed);
    }
}

