/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.internal.builders.TestBuilder;

public class RebuildingBuilder
extends TestBuilder {
    public static final String BUILDER_NAME = "org.eclipse.core.tests.resources.rebuildingbuilder";
    static List<RebuildingBuilder> instances = new ArrayList<RebuildingBuilder>();
    private boolean propagateRebuild;
    private boolean processOtherBuilders;
    Map<IProject, Integer> projectToRebuild = new HashMap<IProject, Integer>();
    List<IProject> projectsBuilt = new ArrayList<IProject>();
    List<Integer> buildKinds = new ArrayList<Integer>();
    TestBuilder.BuilderRuleCallback callback = new TestBuilder.BuilderRuleCallback(){

        @Override
        public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
            RebuildingBuilder.this.projectsBuilt.add(RebuildingBuilder.this.getProject());
            RebuildingBuilder.this.buildKinds.add(kind);
            if (RebuildingBuilder.this.projectToRebuild.size() > 1 || RebuildingBuilder.this.projectToRebuild.get(RebuildingBuilder.this.getProject()) == null) {
                HashSet<IProject> toRebuild = new HashSet<IProject>();
                HashSet<IProject> toRemove = new HashSet<IProject>();
                Set<Map.Entry<IProject, Integer>> entries = RebuildingBuilder.this.projectToRebuild.entrySet();
                for (Map.Entry<IProject, Integer> entry : entries) {
                    IProject project = entry.getKey();
                    Integer rebuild = entry.getValue();
                    if (rebuild <= 0) continue;
                    toRebuild.add(project);
                    int count = rebuild - 1;
                    if (count > 0) {
                        RebuildingBuilder.this.setRequestProjectRebuild(project, count);
                        continue;
                    }
                    toRemove.add(project);
                }
                toRemove.forEach(p -> {
                    Integer n = RebuildingBuilder.this.projectToRebuild.remove(p);
                });
                RebuildingBuilder.this.requestProjectsRebuild(toRebuild);
            } else {
                IProject project = RebuildingBuilder.this.getProject();
                Integer rebuild = RebuildingBuilder.this.projectToRebuild.get(project);
                if (rebuild != null && rebuild > 0) {
                    int count;
                    RebuildingBuilder.this.requestProjectRebuild(RebuildingBuilder.this.isProcessOtherBuilders());
                    if (RebuildingBuilder.this.isPropagateRebuild()) {
                        RebuildingBuilder.this.needRebuild();
                    }
                    if ((count = rebuild - 1) > 0) {
                        RebuildingBuilder.this.setRequestProjectRebuild(project, count);
                    } else {
                        RebuildingBuilder.this.projectToRebuild.remove(project);
                    }
                }
            }
            return super.build(kind, args, monitor);
        }
    };

    public static List<RebuildingBuilder> getInstances() {
        return instances;
    }

    public RebuildingBuilder() {
        instances.add(this);
        this.setRuleCallback(this.callback);
        this.setPropagateRebuild(true);
        this.setProcessOtherBuilders(true);
    }

    public void setRequestProjectRebuild(IProject p, Integer count) {
        this.projectToRebuild.put(p, count);
    }

    public void setRequestProjectRebuild(IProject ... projects) {
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.projectToRebuild.put(project, 1);
            ++n2;
        }
    }

    public int buildsCount() {
        return this.projectsBuilt.size();
    }

    public List<Integer> buildKinds() {
        return this.buildKinds;
    }

    @Override
    public void reset() {
        super.reset();
        this.projectsBuilt.clear();
        this.projectToRebuild.clear();
        this.buildKinds.clear();
        this.setRuleCallback(this.callback);
        this.setPropagateRebuild(true);
        this.setProcessOtherBuilders(true);
    }

    public boolean isPropagateRebuild() {
        return this.propagateRebuild;
    }

    public void setPropagateRebuild(boolean propagateRebuild) {
        this.propagateRebuild = propagateRebuild;
    }

    public boolean isProcessOtherBuilders() {
        return this.processOtherBuilders;
    }

    public void setProcessOtherBuilders(boolean processOtherBuilders) {
        this.processOtherBuilders = processOtherBuilders;
    }
}

