/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.tests.harness.TestBarrier2;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.internal.builders.EmptyDeltaBuilder;
import org.eclipse.core.tests.internal.builders.EmptyDeltaBuilder2;
import org.eclipse.core.tests.internal.builders.TestBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.TestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.function.ThrowingRunnable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class RelaxedSchedRuleBuilderTest {
    private ErrorLogging errorLogging = new ErrorLogging();

    @BeforeEach
    public void setUp() throws Exception {
        this.errorLogging.enable();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.errorLogging.disable();
        TestBuilder builder = DeltaVerifierBuilder.getInstance();
        if (builder != null) {
            builder.reset();
        }
        if ((builder = EmptyDeltaBuilder.getInstance()) != null) {
            builder.reset();
        }
        if ((builder = EmptyDeltaBuilder2.getInstance()) != null) {
            builder.reset();
        }
    }

    @Test
    public void testBasicRelaxedSchedulingRules() throws Throwable {
        String projectName = "TestRelaxed";
        ResourceTestUtil.setAutoBuilding(false);
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.emptydeltabuilder").withTestBuilderId("testbuild").apply();
        project.build(15, ResourceTestUtil.createTestMonitor());
        final TestBarrier2 tb = new TestBarrier2(0);
        EmptyDeltaBuilder builder = EmptyDeltaBuilder.getInstance();
        builder.setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            @Override
            public ISchedulingRule getRule(String name, IncrementalProjectBuilder projectBuilder, int trigger, Map<String, String> args) {
                return null;
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                org.junit.jupiter.api.Assertions.assertTrue((Job.getJobManager().currentRule() == null ? 1 : 0) != 0);
                tb.setStatus(1);
                while (!monitor.isCanceled()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                tb.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        final AtomicReference<ThrowingRunnable> exceptionInMainThreadCallback = new AtomicReference<ThrowingRunnable>(Function::identity);
        Job j = new Job("build job"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    project.build(6, monitor);
                }
                catch (CoreException e) {
                    exceptionInMainThreadCallback.set(() -> {
                        throw e;
                    });
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        tb.waitForStatus(1);
        project.getFile("foo.c").create(null, true, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)project.getFile("foo.c").exists());
        j.cancel();
        tb.waitForStatus(5);
        exceptionInMainThreadCallback.get().run();
    }

    @Test
    public void testTwoBuildersRunInOneBuild() throws Throwable {
        String projectName = "testTwoBuildersRunInOneBuild";
        ResourceTestUtil.setAutoBuilding(false);
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.emptydeltabuilder").withTestBuilderId("Project1Build1").andCommand("org.eclipse.core.tests.resources.emptydeltabuilder2").withTestBuilderId("Project1Build2").apply();
        project.build(15, ResourceTestUtil.createTestMonitor());
        final TestBarrier2 tb1 = new TestBarrier2(0);
        final TestBarrier2 tb2 = new TestBarrier2(0);
        EmptyDeltaBuilder builder = EmptyDeltaBuilder.getInstance();
        EmptyDeltaBuilder2 builder2 = EmptyDeltaBuilder2.getInstance();
        builder.setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            @Override
            public ISchedulingRule getRule(String name, IncrementalProjectBuilder projectBuilder, int trigger, Map<String, String> args) {
                tb1.setStatus(1);
                return project;
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)Job.getJobManager().currentRule().contains((ISchedulingRule)project));
                tb1.setStatus(3);
                tb1.waitForStatus(4);
                tb1.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        builder2.setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            @Override
            public ISchedulingRule getRule(String name, IncrementalProjectBuilder projectBuilder, int trigger, Map<String, String> args) {
                tb2.setStatus(1);
                return null;
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                org.junit.jupiter.api.Assertions.assertTrue((Job.getJobManager().currentRule() == null || Job.getJobManager().currentRule().contains((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()) ? 1 : 0) != 0);
                tb2.setStatus(3);
                tb2.waitForStatus(4);
                tb2.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        final AtomicReference<ThrowingRunnable> exceptionInMainThreadCallback = new AtomicReference<ThrowingRunnable>(Function::identity);
        Job j = new Job("build job1"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    project.build(6, monitor);
                }
                catch (CoreException e) {
                    exceptionInMainThreadCallback.set(() -> {
                        throw e;
                    });
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        tb1.waitForStatus(3);
        tb1.setStatus(4);
        tb1.waitForStatus(5);
        tb2.waitForStatus(3);
        tb2.setStatus(4);
        tb2.waitForStatus(5);
        exceptionInMainThreadCallback.get().run();
    }

    HashSet<ISchedulingRule> getRulesAsSet(ISchedulingRule rule) {
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        if (rule == null) {
            return rules;
        }
        if (rule instanceof MultiRule) {
            MultiRule mRule = (MultiRule)rule;
            rules.addAll(Arrays.asList(mRule.getChildren()));
        } else {
            rules.add(rule);
        }
        return rules;
    }

    @Test
    public void testBuilderDeltaUsingRelaxedRuleBug343256(TestInfo testInfo) throws Throwable {
        int timeout = 10000;
        String projectName = "testBuildDeltaUsingRelaxedRuleBug343256";
        ResourceTestUtil.setAutoBuilding(false);
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        final IFile foo = project.getFile("foo");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String testMethodName = ((Method)testInfo.getTestMethod().get()).getName();
        ResourceTestUtil.waitForEncodingRelatedJobs(testMethodName);
        this.waitForContentDescriptionUpdate(testMethodName);
        ((Workspace)ResourcesPlugin.getWorkspace()).getBuildManager().waitForAutoBuildOff();
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.emptydeltabuilder").withTestBuilderId("Project1Build1").apply();
        project.build(6, ResourceTestUtil.createTestMonitor());
        final TestBarrier2 tb = new TestBarrier2(0);
        final AtomicReference errorInBuildTriggeringJob = new AtomicReference();
        final AtomicReference errorInWorkspaceChangingJob = new AtomicReference();
        final Job workspaceChangingJob = new Job("Workspace Changing Job"){

            protected IStatus run(IProgressMonitor monitor) {
                tb.setStatus(2);
                try {
                    ResourceTestUtil.createInWorkspace((IResource)foo);
                }
                catch (CoreException e) {
                    errorInWorkspaceChangingJob.set(e);
                }
                return Status.OK_STATUS;
            }
        };
        Job buildTriggeringJob = new Job("Build Triggering Job"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ResourcesPlugin.getWorkspace().build(new IBuildConfiguration[]{project.getActiveBuildConfig()}, 10, true, monitor);
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    IStatus[] children = status.getChildren();
                    if (children.length > 0) {
                        errorInBuildTriggeringJob.set(children[0].getException());
                    }
                    errorInBuildTriggeringJob.set(e);
                }
                return Status.OK_STATUS;
            }
        };
        EmptyDeltaBuilder builder = EmptyDeltaBuilder.getInstance();
        builder.setRuleCallback(new TestBuilder.BuilderRuleCallback(){
            boolean called = false;

            @Override
            public ISchedulingRule getRule(String name, IncrementalProjectBuilder projectBuilder, int trigger, Map<String, String> args) {
                if (!this.called) {
                    this.called = true;
                    return project;
                }
                tb.setStatus(1);
                tb.waitForStatus(2);
                boolean workspaceChangingJobAcquiringLock = this.waitForThreadStateWaiting(workspaceChangingJob.getThread());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)workspaceChangingJobAcquiringLock, (String)"timed out waiting for workspace changing job to wait for workspace lock");
                return project;
            }

            private boolean waitForThreadStateWaiting(Thread threadToWaitFor) {
                long startWaitingTime = System.currentTimeMillis();
                while (threadToWaitFor.getState() != Thread.State.TIMED_WAITING && threadToWaitFor.getState() != Thread.State.WAITING) {
                    long elapsedWaitingTime = System.currentTimeMillis() - startWaitingTime;
                    if (elapsedWaitingTime <= 10000L) continue;
                    return false;
                }
                return true;
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)Job.getJobManager().currentRule().equals(project));
                IResourceDelta delta = this.getDelta(project);
                org.junit.jupiter.api.Assertions.assertNotNull((Object)delta, (String)"no workspace change occurred between getRule and build");
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)delta.getAffectedChildren().length, (String)("unexpected number of changes occurred: " + ((ResourceDelta)delta).toDeepDebugString()));
                org.junit.jupiter.api.Assertions.assertEquals((Object)foo, (Object)delta.getAffectedChildren()[0].getResource(), (String)"unexpected resource was changed");
                tb.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        buildTriggeringJob.schedule();
        tb.waitForStatus(1);
        workspaceChangingJob.schedule();
        workspaceChangingJob.join(10000L, null);
        buildTriggeringJob.join(10000L, null);
        if (errorInBuildTriggeringJob.get() != null) {
            throw (Throwable)errorInBuildTriggeringJob.get();
        }
        if (errorInWorkspaceChangingJob.get() != null) {
            throw (Throwable)errorInWorkspaceChangingJob.get();
        }
        tb.waitForStatus(5);
        this.errorLogging.assertNoErrorsLogged();
    }

    private void waitForContentDescriptionUpdate(String testMethodName) {
        TestUtil.waitForJobs(testMethodName, 10L, 5000L, "org.eclipse.core.resources.contentDescriptionCacheFamily");
    }

    @Test
    public void testBug343256() throws Throwable {
        String projectName = "testBug343256";
        ResourceTestUtil.setAutoBuilding(false);
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourceTestUtil.updateProjectDescription(project).addingCommand("org.eclipse.core.tests.resources.emptydeltabuilder").withTestBuilderId("Project1Build1").andCommand("org.eclipse.core.tests.resources.emptydeltabuilder2").withTestBuilderId("Project1Build2").apply();
        project.build(15, ResourceTestUtil.createTestMonitor());
        final TestBarrier2 tb1 = new TestBarrier2(0);
        final TestBarrier2 tb2 = new TestBarrier2(0);
        final ISchedulingRule[] getRules = new ISchedulingRule[2];
        final ISchedulingRule[] buildRules = new ISchedulingRule[2];
        EmptyDeltaBuilder builder = EmptyDeltaBuilder.getInstance();
        EmptyDeltaBuilder2 builder2 = EmptyDeltaBuilder2.getInstance();
        builder.setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            @Override
            public ISchedulingRule getRule(String name, IncrementalProjectBuilder projectBuilder, int trigger, Map<String, String> args) {
                tb1.waitForStatus(1);
                return getRules[0];
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                HashSet<ISchedulingRule> h1 = RelaxedSchedRuleBuilderTest.this.getRulesAsSet(Job.getJobManager().currentRule());
                HashSet<ISchedulingRule> h2 = RelaxedSchedRuleBuilderTest.this.getRulesAsSet(buildRules[0]);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)h1.equals(h2));
                tb1.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        builder2.setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            @Override
            public ISchedulingRule getRule(String name, IncrementalProjectBuilder projectBuilder, int trigger, Map<String, String> args) {
                tb2.waitForStatus(1);
                return getRules[1];
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                HashSet<ISchedulingRule> h1 = RelaxedSchedRuleBuilderTest.this.getRulesAsSet(Job.getJobManager().currentRule());
                HashSet<ISchedulingRule> h2 = RelaxedSchedRuleBuilderTest.this.getRulesAsSet(buildRules[1]);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)h1.equals(h2));
                tb2.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        final AtomicReference<ThrowingRunnable> exceptionInMainThreadCallback = new AtomicReference<ThrowingRunnable>(Function::identity);
        Job j = new Job("IWorkspace.build(IBuildConfiguration[],...)"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ResourcesPlugin.getWorkspace().build(new IBuildConfiguration[]{project.getActiveBuildConfig()}, 6, true, monitor);
                }
                catch (CoreException e) {
                    exceptionInMainThreadCallback.set(() -> {
                        throw e;
                    });
                }
                return Status.OK_STATUS;
            }
        };
        this.invokeTestBug343256(project, getRules, buildRules, tb1, tb2, j);
        exceptionInMainThreadCallback.get().run();
    }

    private void invokeTestBug343256(IProject project, ISchedulingRule[] getRules, ISchedulingRule[] buildRules, TestBarrier2 tb1, TestBarrier2 tb2, Job j) {
        getRules[0] = getRules[1] = project;
        buildRules[0] = buildRules[1] = new MultiRule(new ISchedulingRule[]{getRules[0]});
        tb1.setStatus(1);
        tb2.setStatus(1);
        j.schedule();
        tb1.waitForStatus(5);
        tb2.waitForStatus(5);
        getRules[1] = null;
        getRules[0] = null;
        buildRules[1] = null;
        buildRules[0] = null;
        tb1.setStatus(1);
        tb2.setStatus(1);
        j.schedule();
        tb1.waitForStatus(5);
        tb2.waitForStatus(5);
        getRules[0] = buildRules[0] = project;
        getRules[1] = buildRules[1] = ResourcesPlugin.getWorkspace().getRoot().getProject("other");
        tb1.setStatus(1);
        tb2.setStatus(1);
        j.schedule();
        tb1.waitForStatus(5);
        tb2.waitForStatus(5);
        getRules[0] = buildRules[0] = project;
        buildRules[1] = null;
        getRules[1] = null;
        buildRules[0] = buildRules[1] = ResourcesPlugin.getWorkspace().getRoot();
        tb1.setStatus(1);
        tb2.setStatus(1);
        j.schedule();
        tb1.waitForStatus(5);
        tb2.waitForStatus(5);
    }

    private static class ErrorLogging {
        private final Queue<IStatus> loggedErrors = new ConcurrentLinkedQueue<IStatus>();
        private final ILogListener errorLogListener = (status, plugin) -> {
            if (status.matches(4)) {
                this.loggedErrors.add(status);
            }
        };

        private ErrorLogging() {
        }

        public void enable() {
            Platform.addLogListener((ILogListener)this.errorLogListener);
        }

        public void disable() {
            Platform.removeLogListener((ILogListener)this.errorLogListener);
        }

        public void assertNoErrorsLogged() {
            ArrayList errors = new ArrayList();
            this.loggedErrors.removeIf(errors::add);
            List thrownExceptions = errors.stream().map(IStatus::getException).filter(Objects::nonNull).collect(Collectors.toList());
            ((ListAssert)Assertions.assertThat(thrownExceptions).as("logged exceptions", new Object[0])).isEmpty();
            ((ListAssert)Assertions.assertThat(errors).as("logged errors", new Object[0])).isEmpty();
        }
    }
}

