/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.junit.jupiter.api.Assertions;

public abstract class TestBuilder
extends IncrementalProjectBuilder {
    volatile BuilderRuleCallback ruleCallBack;
    public static final String BUILD_ID = "BuildID";
    public static final String INTERESTING_PROJECT = "InterestingProject";
    public static final String STARTUP_ON_INITIALIZE = "StartupOnInitialize";
    public static final String SET_INITIALIZATION_DATA = "SetInitializationData";
    public static final String DEFAULT_BUILD_ID = "Build0";
    protected Map<String, String> arguments;
    private IConfigurationElement config = null;
    private String name = null;
    private Object data = null;
    private static final ArrayList<String> expectedEvents = new ArrayList();
    private static final ArrayList<String> actualEvents = new ArrayList();

    public void addExpectedLifecycleEvent(String event) {
        expectedEvents.add(event);
    }

    public void assertLifecycleEvents() {
        Assertions.assertEquals(expectedEvents, actualEvents);
        this.reset();
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        this.arguments = args == null ? new HashMap<String, String>(1) : args;
        this.logPluginLifecycleEvent(this.getBuildId());
        if (this.ruleCallBack == null) {
            return new IProject[0];
        }
        this.ruleCallBack.builder = this;
        return this.ruleCallBack.build(kind, args, monitor);
    }

    public ISchedulingRule getRule(int trigger, Map<String, String> args) {
        if (this.ruleCallBack == null) {
            return super.getRule(trigger, args);
        }
        this.ruleCallBack.builder = this;
        return this.ruleCallBack.getRule(this.name, this, trigger, args);
    }

    public void setRuleCallback(BuilderRuleCallback callback) {
        this.ruleCallBack = callback;
    }

    private String getBuildId() {
        String buildId = this.arguments.get(BUILD_ID);
        if (buildId == null) {
            buildId = DEFAULT_BUILD_ID;
        }
        return buildId;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.config;
    }

    public Object getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    private void logPluginLifecycleEvent(String event) {
        actualEvents.add(event);
    }

    public void reset() {
        expectedEvents.clear();
        actualEvents.clear();
        this.ruleCallBack = null;
    }

    public void setInitializationData(IConfigurationElement config, String name, Object data) {
        this.logPluginLifecycleEvent(SET_INITIALIZATION_DATA);
        this.config = config;
        this.name = name;
        this.data = data;
    }

    protected void startupOnInitialize() {
        this.logPluginLifecycleEvent(STARTUP_ON_INITIALIZE);
    }

    public static class BuilderRuleCallback {
        IncrementalProjectBuilder builder;

        public ISchedulingRule getRule(String name, IncrementalProjectBuilder projectBuilder, int trigger, Map<String, String> args) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }

        public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
            return new IProject[0];
        }

        public IResourceDelta getDelta(IProject project) {
            return this.builder.getDelta(project);
        }
    }
}

