/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.tests.resources.TestUtil;
import org.junit.Assert;

public class TimerBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_NAME = "org.eclipse.core.tests.resources.timerbuilder";
    public static final String DURATION_ARG = "duration";
    public static final String RULE_TYPE_ARG = "ruleType";
    private static final int SHUTDOWN_TIMEOUT_IN_MILLIS = 60000;
    private static BuildExecutionState executionState = new BuildExecutionState(-1);
    final ISchedulingRule noConflictRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }
    };
    final ISchedulingRule relaxedProjetRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule || ResourcesPlugin.getWorkspace().getRoot().contains(rule);
        }
    };

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        Assert.assertNotEquals((String)"no expected number of builds has been set", (long)-1L, (long)TimerBuilder.executionState.expectedNumberOfBuilds);
        executionState.startedExecutingProject(this.getProject());
        try {
            int durationInMillis = Integer.parseInt(args.get(DURATION_ARG));
            TestUtil.waitForCondition(() -> TimerBuilder.executionState.shallAbort, durationInMillis);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        executionState.endedExcecutingProject(this.getProject());
        return new IProject[]{this.getProject()};
    }

    public ISchedulingRule getRule(int trigger, Map<String, String> args) {
        if (args != null) {
            RuleType ruleType = RuleType.valueOf(args.get(RULE_TYPE_ARG));
            switch (ruleType) {
                case NO_CONFLICT: {
                    return this.noConflictRule;
                }
                case CURRENT_PROJECT: {
                    return this.getProject();
                }
                case WORKSPACE_ROOT: {
                    return this.getProject().getWorkspace().getRoot();
                }
                case CURRENT_PROJECT_RELAXED: {
                    return this.relaxedProjetRule;
                }
            }
        }
        return this.noConflictRule;
    }

    public static List<IProject> getStartedProjectBuilds() {
        return executionState.getProjectBuilds(BuildEventType.START);
    }

    public static List<IProject> getFinishedProjectBuilds() {
        return executionState.getProjectBuilds(BuildEventType.FINISH);
    }

    public static int getMaximumNumberOfSimultaneousBuilds() {
        return TimerBuilder.executionState.maxSimultaneousBuilds;
    }

    public static Iterable<BuildEvent> getBuildEvents() {
        return new ArrayList<BuildEvent>(TimerBuilder.executionState.events);
    }

    public static void setExpectedNumberOfBuilds(int expectedNumberOfBuilds) {
        Assert.assertFalse((String)"builds are still running while resetting TimerBuilder", (boolean)executionState.isExecuting());
        executionState = new BuildExecutionState(expectedNumberOfBuilds);
    }

    public static void abortCurrentBuilds() {
        executionState.abortAndWaitForAllBuilds();
    }

    public static BuildEvent createStartEvent(IProject project) {
        return new BuildEvent(project, BuildEventType.START);
    }

    public static BuildEvent createCompleteEvent(IProject project) {
        return new BuildEvent(project, BuildEventType.FINISH);
    }

    private static class BuildEvent {
        private final IProject project;
        private final BuildEventType eventType;

        public BuildEvent(IProject project, BuildEventType event) {
            this.project = project;
            this.eventType = event;
        }

        public boolean equals(Object other) {
            if (other instanceof BuildEvent) {
                BuildEvent otherEvent = (BuildEvent)other;
                return this.project == otherEvent.project && this.eventType == otherEvent.eventType;
            }
            return false;
        }

        static /* synthetic */ IProject access$0(BuildEvent buildEvent) {
            return buildEvent.project;
        }
    }

    private static enum BuildEventType {
        START,
        FINISH;

    }

    private static class BuildExecutionState {
        private final int expectedNumberOfBuilds;
        private final List<BuildEvent> events = Collections.synchronizedList(new ArrayList());
        private volatile boolean shallAbort = false;
        private volatile int maxSimultaneousBuilds = 0;
        private volatile int currentlyRunningBuilds = 0;

        private BuildExecutionState(int expectedNumberOfBuilds) {
            this.expectedNumberOfBuilds = expectedNumberOfBuilds;
        }

        private synchronized boolean isExecuting() {
            return this.getProjectBuilds(BuildEventType.FINISH).size() < TimerBuilder.executionState.expectedNumberOfBuilds;
        }

        private synchronized List<IProject> getProjectBuilds(BuildEventType eventType) {
            return this.events.stream().filter(event -> event.eventType == eventType).map(event -> event.project).toList();
        }

        private synchronized void startedExecutingProject(IProject project) {
            ++this.currentlyRunningBuilds;
            this.maxSimultaneousBuilds = Math.max(this.currentlyRunningBuilds, this.maxSimultaneousBuilds);
            this.events.add(new BuildEvent(project, BuildEventType.START));
        }

        private synchronized void endedExcecutingProject(IProject project) {
            --this.currentlyRunningBuilds;
            this.events.add(new BuildEvent(project, BuildEventType.FINISH));
            this.notifyAll();
        }

        private synchronized void abortAndWaitForAllBuilds() {
            this.shallAbort = true;
            long durationInMillis = 0L;
            long waitingStartTimeInMillis = System.currentTimeMillis();
            while (this.isExecuting() && durationInMillis < 60000L) {
                try {
                    this.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                durationInMillis = System.currentTimeMillis() - waitingStartTimeInMillis;
            }
        }
    }

    public static enum RuleType {
        NO_CONFLICT,
        CURRENT_PROJECT,
        WORKSPACE_ROOT,
        CURRENT_PROJECT_RELAXED;

    }
}

