/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.dtree;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.core.internal.dtree.AbstractDataTree;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.IComparator;
import org.eclipse.core.internal.dtree.NodeComparison;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.dtree.TestHelper;
import org.eclipse.core.internal.watson.DefaultElementComparator;
import org.eclipse.core.runtime.IPath;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DeltaDataTreeTest {
    IPath rootKey;
    IPath leftKey;
    IPath rightKey;
    DeltaDataTree tree;
    DeltaDataTree emptyTree;
    DeltaDataTree changedTree;
    DeltaDataTree deltaTree;

    public void assertDelta(DeltaDataTree originalTree) {
        Assertions.assertThat((Object)this.rootKey).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.rootKey.append("newTopLevel")).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("new")).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("two")).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("three")).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey.append("rightOfRight")).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0)));
    }

    public void assertTree(DeltaDataTree originalTree) {
        Assertions.assertThat((Object)this.rootKey).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("two")).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("three")).matches(arg_0 -> ((DeltaDataTree)originalTree).includes(arg_0));
    }

    @BeforeEach
    public void setUp() {
        this.emptyTree = new DeltaDataTree();
        this.tree = new DeltaDataTree();
        this.rootKey = IPath.ROOT;
        this.tree.createChild(this.rootKey, "leftOfRoot");
        this.tree.createChild(this.rootKey, "rightOfRoot");
        this.leftKey = this.rootKey.append("leftOfRoot");
        this.rightKey = this.rootKey.append("rightOfRoot");
        this.tree.createChild(this.leftKey, "one");
        this.tree.createChild(this.leftKey, "two");
        this.tree.createChild(this.leftKey, "three");
        this.tree.createChild(this.rightKey, "rightOfRight");
        this.changedTree = new DeltaDataTree();
        this.changedTree.createSubtree(this.rootKey, this.tree.copyCompleteSubtree(this.rootKey));
    }

    @Test
    public void testAddAndRemoveOnSameLayer() {
        IPath elementA = IPath.ROOT.append("A");
        DeltaDataTree tree1 = new DeltaDataTree();
        tree1.createChild(IPath.ROOT, "A", (Object)"Data for A");
        tree1.immutable();
        DeltaDataTree tree2 = tree1.newEmptyDeltaTree();
        tree2.createChild(elementA, "B", (Object)"New B Data");
        tree2.deleteChild(elementA, "B");
        tree2.immutable();
        tree1.compareWith(tree2, (IComparator)DefaultElementComparator.getComparator());
        tree2.compareWith(tree1, (IComparator)DefaultElementComparator.getComparator());
        tree1.forwardDeltaWith(tree2, (IComparator)DefaultElementComparator.getComparator());
        tree2.forwardDeltaWith(tree1, (IComparator)DefaultElementComparator.getComparator());
        tree1.copyCompleteSubtree(IPath.ROOT);
        tree2.copyCompleteSubtree(IPath.ROOT);
        tree1.reroot();
        tree2.reroot();
        tree1.makeComplete();
        tree2.makeComplete();
    }

    @Test
    public void testCompareWithPath() {
        String X = "x";
        IPath elementX = IPath.ROOT.append(X);
        DeltaDataTree treeA = new DeltaDataTree();
        String oldData = "A Data for x";
        treeA.createChild(IPath.ROOT, X, (Object)oldData);
        treeA.immutable();
        DeltaDataTree treeB = treeA.newEmptyDeltaTree();
        String newData = "B Data for x";
        treeB.createChild(IPath.ROOT, X, (Object)newData);
        treeB.immutable();
        DeltaDataTree treeC = treeB.newEmptyDeltaTree();
        treeC.immutable();
        DeltaDataTree treeD = treeC.newEmptyDeltaTree();
        treeD.immutable();
        DeltaDataTree delta = treeA.compareWith(treeC, (IComparator)DefaultElementComparator.getComparator(), elementX);
        org.junit.jupiter.api.Assertions.assertNull((Object)delta.getParent());
        Object rootData = delta.getRootData();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)delta.isImmutable());
        Assertions.assertThat((Object)rootData).isInstanceOf(NodeComparison.class);
        NodeComparison nodeComparison = (NodeComparison)rootData;
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)nodeComparison.getComparison());
        org.junit.jupiter.api.Assertions.assertEquals((Object)oldData, (Object)nodeComparison.getOldData());
        org.junit.jupiter.api.Assertions.assertEquals((Object)newData, (Object)nodeComparison.getNewData());
    }

    @Test
    public void testCompareWithPath2() {
        String X = "x";
        IPath elementX = IPath.ROOT.append(X);
        DeltaDataTree treeD = new DeltaDataTree();
        String oldData = "D Data for x";
        treeD.createChild(IPath.ROOT, X, (Object)oldData);
        treeD.immutable();
        DeltaDataTree treeC = treeD.newEmptyDeltaTree();
        treeC.immutable();
        DeltaDataTree treeB = treeC.newEmptyDeltaTree();
        String newData = "B Data for x";
        treeB.createChild(IPath.ROOT, X, (Object)newData);
        treeB.immutable();
        DeltaDataTree treeA = treeB.newEmptyDeltaTree();
        treeA.immutable();
        DeltaDataTree delta = treeA.compareWith(treeC, (IComparator)DefaultElementComparator.getComparator(), elementX);
        delta = delta.asReverseComparisonTree((IComparator)DefaultElementComparator.getComparator());
        org.junit.jupiter.api.Assertions.assertNull((Object)delta.getParent());
        Object rootData = delta.getRootData();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)delta.isImmutable());
        Assertions.assertThat((Object)rootData).isInstanceOf(NodeComparison.class);
        NodeComparison nodeComparison = (NodeComparison)rootData;
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)nodeComparison.getComparison());
        org.junit.jupiter.api.Assertions.assertEquals((Object)oldData, (Object)nodeComparison.getOldData());
        org.junit.jupiter.api.Assertions.assertEquals((Object)newData, (Object)nodeComparison.getNewData());
    }

    @Test
    public void testCompareWithPathUnchanged() {
        String X = "x";
        IPath elementX = IPath.ROOT.append(X);
        DeltaDataTree treeA = new DeltaDataTree();
        String oldData = "Old Data for x";
        treeA.createChild(IPath.ROOT, X, (Object)oldData);
        treeA.immutable();
        DeltaDataTree treeB = treeA.newEmptyDeltaTree();
        treeB.immutable();
        DeltaDataTree deltaAA = treeA.compareWith(treeA, (IComparator)DefaultElementComparator.getComparator(), elementX);
        this.assertUnchanged(deltaAA);
        DeltaDataTree deltaAB = treeA.compareWith(treeB, (IComparator)DefaultElementComparator.getComparator(), elementX);
        this.assertUnchanged(deltaAB);
        DeltaDataTree deltaBA = treeB.compareWith(treeA, (IComparator)DefaultElementComparator.getComparator(), elementX);
        this.assertUnchanged(deltaBA);
    }

    private void assertUnchanged(DeltaDataTree delta) {
        org.junit.jupiter.api.Assertions.assertNull((Object)delta.getParent());
        Object rootData = delta.getRootData();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)delta.isImmutable());
        Assertions.assertThat((Object)rootData).isInstanceOf(NodeComparison.class);
        NodeComparison nodeComparison = (NodeComparison)rootData;
        org.junit.jupiter.api.Assertions.assertEquals((Object)nodeComparison.getNewData(), (Object)nodeComparison.getOldData());
        Assertions.assertThat((Object[])delta.getChildren(AbstractDataTree.rootKey())).isEmpty();
    }

    @Test
    public void testAddTwiceAndDelete() {
        DeltaDataTree tree1 = new DeltaDataTree();
        tree1.createChild(IPath.ROOT, "A", (Object)"Data for A");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        tree1.createChild(IPath.ROOT, "A", (Object)"New A Data");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        tree1.deleteChild(IPath.ROOT, "A");
        tree1.immutable();
        Assertions.assertThat((int)tree1.getChildCount(IPath.ROOT)).isZero();
    }

    @Test
    public void testAssembleWithIn() {
        this.changedTree.deleteChild(this.leftKey, "two");
        this.deltaTree = this.tree.forwardDeltaWith(this.changedTree, (IComparator)DefaultElementComparator.getComparator());
        DeltaDataTree assembledTree = this.tree.assembleWithForwardDelta(this.deltaTree);
        Assertions.assertThat((Object)this.rootKey).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("two")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0)));
        Assertions.assertThat((Object)this.leftKey.append("three")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
    }

    @Test
    public void testCreateChild() {
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.tree.createChild(this.rootKey.append("bogus"), "foobar"));
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.emptyTree.createChild(this.rootKey.append("bogus"), "foobar"));
        this.emptyTree.createChild(this.rootKey, "first");
        Assertions.assertThat((Object)this.rootKey.append("first")).matches(arg_0 -> ((DeltaDataTree)this.emptyTree).includes(arg_0));
        this.tree.createChild(this.rootKey, "NewTopLevel");
        Assertions.assertThat((Object)this.rootKey.append("NewTopLevel")).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        this.tree.createChild(this.leftKey.append("one"), "NewBottom");
        Assertions.assertThat((Object)this.leftKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("one").append("NewBottom")).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        this.tree.createChild(this.rightKey, "NewRight");
        Assertions.assertThat((Object)this.leftKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey.append("rightOfRight")).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey.append("NewRight")).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        int size = this.tree.getNamesOfChildren(this.leftKey).length;
        this.tree.createChild(this.leftKey, "double");
        this.tree.createChild(this.leftKey, "double");
        Assertions.assertThat((Object[])this.tree.getNamesOfChildren(this.leftKey)).hasSize(size + 1);
    }

    @Test
    public void testDeleteChild() {
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.emptyTree.deleteChild(this.rootKey, "non-existant"));
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.tree.deleteChild(this.rootKey, "rightOfRight"));
        Assertions.assertThat((Object)this.rightKey.append("rightOfRight")).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.tree.deleteChild(this.rootKey.append("bogus"), "rightOfRight"));
        Assertions.assertThat((Object)this.rightKey.append("rightOfRight")).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.tree.deleteChild(this.leftKey, "four"));
        Assertions.assertThat((Object)this.leftKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        this.tree.deleteChild(this.rootKey, "leftOfRoot");
        Assertions.assertThat((Object)this.leftKey).matches(Predicate.not(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0)));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0)));
        Assertions.assertThat((Object)this.rootKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        this.tree.deleteChild(this.rightKey, "rightOfRight");
        Assertions.assertThat((Object)this.rightKey.append("rightOfRight")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0)));
        Assertions.assertThat((Object)this.rightKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
    }

    @Test
    public void testDeltaOnCompletelyDifferentTrees() {
        DeltaDataTree newTree = new DeltaDataTree();
        newTree.createChild(this.rootKey, "newLeft");
        newTree.createChild(this.rootKey, "newRight");
        newTree.createChild(this.rootKey.append("newLeft"), "newOne");
        newTree.createChild(this.rootKey.append("newLeft"), "newTwo");
        newTree.createChild(this.rootKey.append("newLeft"), "newThree");
        newTree.createChild(this.rootKey.append("newRight"), "newRightOfRight");
        newTree.createChild(this.rootKey.append("newRight").append("newRightOfRight"), "bottom");
        this.deltaTree = newTree.forwardDeltaWith(this.tree, (IComparator)DefaultElementComparator.getComparator());
        this.assertTree(this.deltaTree);
        Assertions.assertThat((Object)this.rootKey.append("newLeft")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0)));
        Assertions.assertThat((Object)this.rootKey.append("newRight")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0)));
    }

    @Test
    public void testEmpty() {
        Assertions.assertThat((Object)this.rootKey).matches(arg_0 -> ((DeltaDataTree)this.emptyTree).includes(arg_0));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)TestHelper.getRootNode((DeltaDataTree)this.emptyTree));
        Assertions.assertThat((Object[])TestHelper.getRootNode((DeltaDataTree)this.emptyTree).getChildren()).isEmpty();
    }

    @Test
    public void testForwardDeltaOnDataDeltaNode() {
        this.tree.immutable();
        DeltaDataTree tree1 = this.tree.newEmptyDeltaTree();
        tree1.setData(this.leftKey, (Object)"replaced");
        DeltaDataTree delta = tree1.forwardDeltaWith(this.changedTree, (IComparator)DefaultElementComparator.getComparator());
        org.junit.jupiter.api.Assertions.assertNull((Object)delta.getData(this.leftKey));
    }

    @Test
    public void testForwardDeltaWith() {
        this.changedTree.deleteChild(this.leftKey, "two");
        this.changedTree.createChild(this.leftKey, "four");
        this.changedTree.createChild(this.leftKey, "five");
        this.changedTree.createChild(this.leftKey, "six");
        this.changedTree.createChild(this.rootKey, "NewTopLevel");
        this.deltaTree = this.tree.forwardDeltaWith(this.changedTree, (IComparator)DefaultElementComparator.getComparator());
        DeltaDataTree assembledTree = this.tree.assembleWithForwardDelta(this.deltaTree);
        Assertions.assertThat((Object)this.rootKey).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.rootKey.append("NewTopLevel")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("two")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0)));
        Assertions.assertThat((Object)this.leftKey.append("three")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("four")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("five")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("six")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey.append("rightOfRight")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
    }

    @Test
    public void testForwardDeltaWithEquality() {
        this.changedTree.deleteChild(this.leftKey, "two");
        this.changedTree.createChild(this.leftKey, "four");
        IPath oneKey = this.leftKey.append("one");
        this.changedTree.setData(oneKey, (Object)"New");
        this.deltaTree = this.tree.forwardDeltaWith(this.changedTree, (IComparator)DefaultElementComparator.getComparator());
        DeltaDataTree assembledTree = this.tree.assembleWithForwardDelta(this.deltaTree);
        Assertions.assertThat((Object)this.rootKey).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("two")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0)));
        Assertions.assertThat((Object)this.leftKey.append("three")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("four")).matches(arg_0 -> ((DeltaDataTree)assembledTree).includes(arg_0));
        Object data = assembledTree.getData(oneKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)data);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"New", (Object)data);
    }

    @Test
    public void testGetChild() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.leftKey, (Object)this.tree.getChild(this.rootKey, 0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.leftKey.append("two"), (Object)this.tree.getChild(this.leftKey, 2));
        org.junit.jupiter.api.Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> {
            IPath iPath = this.tree.getChild(this.rootKey, 99);
        });
        org.junit.jupiter.api.Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> {
            IPath iPath = this.tree.getChild(this.leftKey, 99);
        });
        org.junit.jupiter.api.Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> {
            IPath iPath = this.tree.getChild(this.leftKey.append("one"), 99);
        });
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> {
            IPath iPath = this.tree.getChild(this.rootKey.append("bogus"), 0);
        });
    }

    @Test
    public void testGetChildCount() {
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.emptyTree.getChildCount(this.rootKey));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.tree.getChildCount(this.rootKey));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.tree.getChildCount(this.leftKey));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.tree.getChildCount(this.rightKey));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.tree.getChildCount(this.leftKey.append("one")));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.tree.getChildCount(this.leftKey.append("three")));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.tree.getChildCount(this.rightKey.append("rightOfRight")));
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> {
            int n = this.tree.getChildCount(this.rootKey.append("bogus"));
        });
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> {
            int n = this.emptyTree.getChildCount(this.rootKey.append("bogus"));
        });
    }

    @Test
    public void testGetChildren() {
        IPath[] rootChildren = new IPath[]{this.leftKey, this.rightKey};
        IPath[] leftChildren = new IPath[]{this.leftKey.append("one"), this.leftKey.append("two"), this.leftKey.append("three")};
        IPath[] rightChildren = new IPath[]{this.rightKey.append("rightOfRight")};
        Object[] testChildren = this.emptyTree.getChildren(this.rootKey);
        Assertions.assertThat((Object[])testChildren).isEmpty();
        testChildren = this.tree.getChildren(this.rootKey);
        Assertions.assertThat((Object[])testChildren).containsExactly((Object[])new IPath[]{rootChildren[0], rootChildren[1]});
        testChildren = this.tree.getChildren(this.leftKey);
        Assertions.assertThat((Object[])testChildren).containsExactly((Object[])new IPath[]{leftChildren[0], leftChildren[2], leftChildren[1]});
        testChildren = this.tree.getChildren(leftChildren[0]);
        Assertions.assertThat((Object[])testChildren).isEmpty();
        testChildren = this.tree.getChildren(rightChildren[0]);
        Assertions.assertThat((Object[])testChildren).isEmpty();
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> {
            IPath[] iPathArray = this.tree.getChildren(this.rootKey.append("bogus"));
        });
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> {
            IPath[] iPathArray = this.emptyTree.getChildren(this.rootKey.append("bogus"));
        });
    }

    @Test
    public void testGetNamesOfChildren() {
        String[] rootChildren = new String[]{"leftOfRoot", "rightOfRoot"};
        String[] leftChildren = new String[]{"one", "two", "three"};
        String[] rightChildren = new String[]{"rightOfRight"};
        Object[] testChildren = this.emptyTree.getNamesOfChildren(this.rootKey);
        Assertions.assertThat((Object[])testChildren).isEmpty();
        testChildren = this.tree.getNamesOfChildren(this.rootKey);
        Assertions.assertThat((Object[])testChildren).containsExactly((Object[])new String[]{rootChildren[0], rootChildren[1]});
        testChildren = this.tree.getNamesOfChildren(this.leftKey);
        Assertions.assertThat((Object[])testChildren).containsExactly((Object[])new String[]{leftChildren[0], leftChildren[2], leftChildren[1]});
        testChildren = this.tree.getNamesOfChildren(this.rightKey);
        Assertions.assertThat((Object[])testChildren).containsExactly((Object[])new String[]{rightChildren[0]});
        testChildren = this.tree.getNamesOfChildren(this.leftKey.append("one"));
        Assertions.assertThat((Object[])testChildren).isEmpty();
        testChildren = this.tree.getNamesOfChildren(this.rightKey.append("rightOfRight"));
        Assertions.assertThat((Object[])testChildren).isEmpty();
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> {
            String[] stringArray = this.tree.getNamesOfChildren(this.rootKey.append("bogus"));
        });
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> {
            String[] stringArray = this.emptyTree.getNamesOfChildren(this.rootKey.append("bogus"));
        });
    }

    @Test
    public void testIncludes() {
        Assertions.assertThat((Object)this.rootKey).matches(arg_0 -> ((DeltaDataTree)this.emptyTree).includes(arg_0));
        Assertions.assertThat((Object)this.rootKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.rightKey.append("rightOfRight")).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        Assertions.assertThat((Object)this.rootKey.append("bogus")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)this.emptyTree).includes(arg_0)));
        Assertions.assertThat((Object)this.rootKey.append("bogus")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0)));
        Assertions.assertThat((Object)this.leftKey.append("bogus")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0)));
        Assertions.assertThat((Object)this.leftKey.append("one").append("bogus")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0)));
        Assertions.assertThat((Object)this.rightKey.append("bogus")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0)));
    }

    @Test
    public void testLongDeltaChain() {
        int NUM_DELTAS = 10;
        DeltaDataTree[] deltas = new DeltaDataTree[10];
        this.tree.immutable();
        deltas[0] = this.tree.newEmptyDeltaTree();
        deltas[0].createChild(this.leftKey, "new");
        this.assertTree(deltas[0]);
        Assertions.assertThat((Object)this.leftKey.append("new")).matches(arg_0 -> ((DeltaDataTree)deltas[0]).includes(arg_0));
        deltas[0].immutable();
        deltas[1] = deltas[0].newEmptyDeltaTree();
        deltas[1].deleteChild(this.leftKey, "one");
        org.junit.jupiter.api.Assertions.assertEquals((Object)deltas[1].getParent(), (Object)deltas[0]);
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)deltas[1]).includes(arg_0)));
        deltas[1].immutable();
        deltas[2] = deltas[1].newEmptyDeltaTree();
        deltas[2].createChild(this.rootKey, "newTopLevel");
        org.junit.jupiter.api.Assertions.assertEquals((Object)deltas[2].getParent(), (Object)deltas[1]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)deltas[2].getParent().getParent(), (Object)deltas[0]);
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)deltas[2]).includes(arg_0)));
        Assertions.assertThat((Object)this.rootKey.append("newTopLevel")).matches(arg_0 -> ((DeltaDataTree)deltas[2]).includes(arg_0));
    }

    @Test
    public void testNewEmptyDeltaTree() {
        this.tree.immutable();
        DeltaDataTree delta = this.tree.newEmptyDeltaTree();
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.tree, (Object)delta.getParent());
        this.assertTree(delta);
    }

    @Test
    public void testRegression1FVVP6L() {
        IPath elementA = IPath.ROOT.append("A");
        DeltaDataTree tree1 = new DeltaDataTree();
        tree1.createChild(IPath.ROOT, "A", (Object)"Data for A");
        tree1.createChild(elementA, "B", (Object)"Data for B");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        tree1.deleteChild(elementA, "B");
        tree1.createChild(elementA, "B", (Object)"New B Data");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        tree1.deleteChild(elementA, "B");
        tree1.copyCompleteSubtree(IPath.ROOT);
    }

    @Test
    public void testRegression1FVVP6LWithChildren() {
        IPath elementA = IPath.ROOT.append("A");
        IPath elementB = elementA.append("B");
        IPath elementC = elementB.append("C");
        DeltaDataTree tree1 = new DeltaDataTree();
        tree1.createChild(IPath.ROOT, "A", (Object)"Data for A");
        tree1.createChild(elementA, "B", (Object)"Data for B");
        tree1.createChild(elementB, "C", (Object)"Data for C");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        tree1.deleteChild(elementA, "B");
        tree1.createChild(elementA, "B", (Object)"New B Data");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        ((ObjectAssert)Assertions.assertThat((Object)elementC).as("child should not exist after deletion", new Object[0])).matches(Predicate.not(arg_0 -> ((DeltaDataTree)tree1).includes(arg_0)));
        tree1.copyCompleteSubtree(IPath.ROOT);
    }

    @Test
    public void testReroot() {
        int NUM_DELTAS = 10;
        DeltaDataTree[] deltas = new DeltaDataTree[10];
        this.tree.immutable();
        deltas[0] = this.tree.newEmptyDeltaTree();
        deltas[0].createChild(this.leftKey, "new");
        this.assertTree(deltas[0]);
        Assertions.assertThat((Object)this.leftKey.append("new")).matches(arg_0 -> ((DeltaDataTree)deltas[0]).includes(arg_0));
        deltas[0].immutable();
        deltas[1] = deltas[0].newEmptyDeltaTree();
        deltas[1].deleteChild(this.leftKey, "one");
        org.junit.jupiter.api.Assertions.assertEquals((Object)deltas[1].getParent(), (Object)deltas[0]);
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)deltas[1]).includes(arg_0)));
        deltas[1].immutable();
        deltas[2] = deltas[1].newEmptyDeltaTree();
        deltas[2].createChild(this.rootKey, "newTopLevel");
        org.junit.jupiter.api.Assertions.assertEquals((Object)deltas[2].getParent(), (Object)deltas[1]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)deltas[2].getParent().getParent(), (Object)deltas[0]);
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)deltas[2]).includes(arg_0)));
        Assertions.assertThat((Object)this.rootKey.append("newTopLevel")).matches(arg_0 -> ((DeltaDataTree)deltas[2]).includes(arg_0));
        deltas[2].immutable();
        deltas[3] = deltas[2].newEmptyDeltaTree();
        deltas[3].immutable();
        deltas[3].reroot();
        org.junit.jupiter.api.Assertions.assertNull((Object)deltas[3].getParent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)deltas[2].getParent(), (Object)deltas[3]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)deltas[1].getParent(), (Object)deltas[2]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)deltas[0].getParent(), (Object)deltas[1]);
        this.assertTree(this.tree);
        Assertions.assertThat((Object)this.leftKey.append("new")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0)));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(arg_0 -> ((DeltaDataTree)this.tree).includes(arg_0));
        this.assertTree(deltas[0]);
        Assertions.assertThat((Object)this.leftKey.append("new")).matches(arg_0 -> ((DeltaDataTree)deltas[0]).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(arg_0 -> ((DeltaDataTree)deltas[0]).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("new")).matches(arg_0 -> ((DeltaDataTree)deltas[1]).includes(arg_0));
        Assertions.assertThat((Object)this.leftKey.append("one")).matches(Predicate.not(arg_0 -> ((DeltaDataTree)deltas[1]).includes(arg_0)));
        this.assertDelta(deltas[2]);
        this.assertDelta(deltas[3]);
    }

    @Test
    public void testSetup() {
        this.assertTree(this.tree);
        this.assertTree(this.changedTree);
    }
}

