/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.events;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class BuildProjectFromMultipleJobsTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final String TEST_PROJECT_NAME = "ProjectForBuildCommandTest";
    private final ErrorLogListener logListener = new ErrorLogListener();

    @Before
    public void setUp() throws Exception {
        ResourceTestUtil.setAutoBuilding(false);
        Platform.addLogListener((ILogListener)this.logListener);
    }

    @After
    public void tearDown() throws Exception {
        Job.getJobManager().cancel(BuildTestProject.class);
        Platform.removeLogListener((ILogListener)this.logListener);
        this.logListener.clear();
    }

    @Test
    public void test10IterationsWithBuildsFrom8Jobs() throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        int iterations = 10;
        int jobs = 8;
        int i = 0;
        while (i < iterations) {
            IProject project = this.createTestProject("org.eclipse.core.tests.resources.simplebuilder", (IProgressMonitor)monitor);
            ArrayList<BuildTestProject> buildJobs = new ArrayList<BuildTestProject>();
            int j = 0;
            while (j < jobs) {
                BuildTestProject buildTestProject = new BuildTestProject(project, j);
                buildJobs.add(buildTestProject);
                ++j;
            }
            for (BuildTestProject buildJob : buildJobs) {
                buildJob.schedule();
            }
            for (BuildTestProject buildJob : buildJobs) {
                buildJob.join();
            }
            project.delete(true, (IProgressMonitor)monitor);
            String errorMessage = "Building in parallel encountered an exception in iteration " + i;
            this.logListener.assertNoExceptionsWereLogged(errorMessage);
            ++i;
        }
    }

    @Test
    public void testBuildersAreNotModifiable() throws Exception {
        Project project = (Project)this.createTestProject("org.eclipse.core.tests.resources.configbuilder", null);
        project.build(6, null);
        BuildCommand buildCommand = (BuildCommand)project.internalGetDescription().getBuildSpec(false)[0];
        Assertions.assertThat((Object)buildCommand.getBuilders()).isInstanceOf(Map.class);
        Object object = buildCommand.getBuilders();
        if (object instanceof Map) {
            Map buildersMap = (Map)object;
            Assertions.assertThat(buildersMap.entrySet()).hasSize(1);
            buildersMap.clear();
            Assertions.assertThat(buildersMap.entrySet()).isEmpty();
        }
        Assertions.assertThat((Object)buildCommand.getBuilders()).isInstanceOf(Map.class);
        Object object2 = buildCommand.getBuilders();
        if (object2 instanceof Map) {
            Map buildersMap = (Map)object2;
            ((AbstractCollectionAssert)Assertions.assertThat(buildersMap.entrySet()).as("check BuildCommand state did not changed", new Object[0])).hasSize(1);
        }
    }

    private IProject createTestProject(String builderId, IProgressMonitor monitor) throws CoreException {
        IProject project = BuildProjectFromMultipleJobsTest.getTestProject();
        Assert.assertFalse((String)"Expected test project to not exist at beginning of test", (boolean)project.exists());
        ResourceTestUtil.createInWorkspace((IResource)project);
        Assert.assertTrue((String)"Expected test project to be open after creation", (boolean)project.isOpen());
        ResourceTestUtil.updateProjectDescription(project).addingCommand(builderId).apply();
        return project;
    }

    private static IProject getTestProject() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(TEST_PROJECT_NAME);
        return project;
    }

    private static class BuildTestProject
    extends Job {
        private final IProject project;

        public BuildTestProject(IProject project, int number) {
            super("build test project " + number);
            this.project = project;
        }

        protected IStatus run(IProgressMonitor jobMonitor) {
            try {
                if (!jobMonitor.isCanceled()) {
                    this.project.build(6, jobMonitor);
                }
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return new Status(0, "org.eclipse.core.tests.resources", this.getName() + " finished");
        }

        public boolean belongsTo(Object family) {
            return BuildTestProject.class == family;
        }
    }

    private static class ErrorLogListener
    implements ILogListener {
        private final List<Throwable> loggedExceptions = new ArrayList<Throwable>();

        public void logging(IStatus status, String plugin) {
            Throwable statusException = status.getException();
            this.loggedExceptions.add(statusException);
        }

        void assertNoExceptionsWereLogged(String errorMessage) {
            Iterator<Throwable> iterator = this.loggedExceptions.iterator();
            if (iterator.hasNext()) {
                Throwable loggedException = iterator.next();
                throw new AssertionError(errorMessage, loggedException);
            }
        }

        void clear() {
            this.loggedExceptions.clear();
        }
    }
}

