/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.filesystem.remote;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryFileStore;

public class RemoteFileStore
extends MemoryFileStore {
    private final String userInfo;
    private final String host;
    private final int port;
    private final IPath remotePath;

    private static String createAuthoritySegment(String userInfo, String host, int port) {
        Object authority = host;
        if (userInfo != null) {
            authority = userInfo + "___" + (String)authority;
        }
        if (port != -1) {
            authority = (String)authority + "___" + port;
        }
        return authority;
    }

    public RemoteFileStore(String userInfo, String host, int port, IPath path) {
        super(IPath.ROOT.append(RemoteFileStore.createAuthoritySegment(userInfo, host, port)).append(path));
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.remotePath = path;
    }

    @Override
    public IFileStore getChild(String name) {
        return new RemoteFileStore(this.userInfo, this.host, this.port, this.remotePath.append(name));
    }

    @Override
    public IFileStore getParent() {
        if (this.remotePath.segmentCount() == 0) {
            return null;
        }
        return new RemoteFileStore(this.userInfo, this.host, this.port, this.remotePath.removeLastSegments(1));
    }

    @Override
    public URI toURI() {
        try {
            return new URI("remote", this.userInfo, this.host, this.port, this.remotePath.toString(), null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

