/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.filesystem.wrapper;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileStore;
import org.osgi.framework.Bundle;

public class WrapperFileSystem
extends FileSystem {
    protected static final IFileStore NULL_ROOT = EFS.getNullFileSystem().getStore(IPath.ROOT);
    private static final String SCHEME_WRAPPED = "wrapped";
    private static volatile WrapperFileSystem instance;
    private static volatile Class<? extends WrapperFileStore> customFS;

    static {
        customFS = WrapperFileStore.class;
    }

    public static URI getBasicURI(URI wrappedURI) {
        Assert.isLegal((boolean)SCHEME_WRAPPED.equals(wrappedURI.getScheme()));
        return URI.create(wrappedURI.getQuery());
    }

    public static synchronized WrapperFileSystem getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new WrapperFileSystem();
        return instance;
    }

    public static void setCustomFileStore(Class<? extends WrapperFileStore> fs) {
        customFS = fs == null ? WrapperFileStore.class : fs;
    }

    public static URI getWrappedURI(URI baseURI) {
        try {
            return new URI(SCHEME_WRAPPED, null, baseURI.getPath(), baseURI.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public WrapperFileSystem() {
        instance = this;
    }

    public IFileStore getStore(URI uri) {
        IFileStore baseStore;
        Assert.isLegal((boolean)SCHEME_WRAPPED.equals(uri.getScheme()));
        try {
            baseStore = EFS.getStore((URI)WrapperFileSystem.getBasicURI(uri));
        }
        catch (CoreException e) {
            ILog.of((Bundle)Platform.getBundle((String)"org.eclipse.core.tests.resources")).log((IStatus)new Status(4, "org.eclipse.core.tests.resources", 4, "Error", (Throwable)e));
            return NULL_ROOT;
        }
        return WrapperFileStore.newInstance(customFS, baseStore);
    }
}

