/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.BlobStore;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class BlobStoreTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Test
    public void testConstructor() throws CoreException {
        IFileStore root = this.createStore();
        Assert.assertThrows(RuntimeException.class, () -> {
            BlobStore blobStore = new BlobStore(null, 0);
        });
        Assert.assertThrows(RuntimeException.class, () -> {
            BlobStore blobStore = new BlobStore(EFS.getLocalFileSystem().getStore(IPath.fromOSString((String)"../this/path/should/not/be/a/folder")), 128);
        });
        Assert.assertThrows(RuntimeException.class, () -> {
            BlobStore blobStore = new BlobStore(root, 0);
        });
        Assert.assertThrows(RuntimeException.class, () -> {
            BlobStore blobStore = new BlobStore(root, -1);
        });
        Assert.assertThrows(RuntimeException.class, () -> {
            BlobStore blobStore = new BlobStore(root, 35);
        });
        Assert.assertThrows(RuntimeException.class, () -> {
            BlobStore blobStore = new BlobStore(root, 512);
        });
    }

    private IFileStore createStore() throws CoreException {
        IFileStore root = this.workspaceRule.getTempStore();
        root.mkdir(0, null);
        IFileInfo info = root.fetchInfo();
        Assert.assertTrue((String)"createStore.1", (boolean)info.exists());
        Assert.assertTrue((String)"createStore.2", (boolean)info.isDirectory());
        return root;
    }

    @Test
    public void testDeleteBlob() throws CoreException, IOException {
        UniversalUniqueIdentifier uuid;
        IFileStore root = this.createStore();
        BlobStore store = new BlobStore(root, 64);
        Assert.assertTrue((!store.fileFor(uuid = new UniversalUniqueIdentifier()).fetchInfo().exists() ? 1 : 0) != 0);
        store.deleteBlob(uuid);
        Assert.assertTrue((!store.fileFor(uuid).fetchInfo().exists() ? 1 : 0) != 0);
        IFileStore target = root.getChild("target");
        ResourceTestUtil.createInFileSystem(target);
        uuid = store.addBlob(target, true);
        Assert.assertTrue((boolean)store.fileFor(uuid).fetchInfo().exists());
        store.deleteBlob(uuid);
        Assert.assertFalse((boolean)store.fileFor(uuid).fetchInfo().exists());
    }

    @Test
    public void testGetBlob() throws CoreException, IOException {
        IFileStore root = this.createStore();
        BlobStore store = new BlobStore(root, 64);
        Assert.assertThrows(RuntimeException.class, () -> {
            InputStream inputStream = store.getBlob(null);
        });
        IFileStore target = root.getChild("target");
        UniversalUniqueIdentifier uuid = null;
        String content = "nothing important........tnatropmi gnihton";
        Throwable throwable = null;
        Object var7_9 = null;
        try (OutputStream output = target.openOutputStream(0, null);){
            ResourceTestUtil.createInputStream(content).transferTo(output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        uuid = store.addBlob(target, true);
        throwable = null;
        var7_9 = null;
        try (InputStream input = store.getBlob(uuid);){
            Assertions.assertThat((InputStream)input).hasContent(content);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void testSetBlob() throws CoreException, IOException {
        IFileStore root = this.createStore();
        BlobStore store = new BlobStore(root, 64);
        IFileStore target = root.getChild("target");
        UniversalUniqueIdentifier uuid = null;
        String content = "nothing important........tnatropmi gnihton";
        Throwable throwable = null;
        Object var7_9 = null;
        try (OutputStream output = target.openOutputStream(0, null);){
            ResourceTestUtil.createInputStream(content).transferTo(output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        uuid = store.addBlob(target, true);
        throwable = null;
        var7_9 = null;
        try (InputStream input = store.getBlob(uuid);){
            Assertions.assertThat((InputStream)input).hasContent(content);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

