/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class BucketTreeTests {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Test
    public void testVisitor() throws CoreException {
        IPath[] paths;
        IPath baseLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(baseLocation);
        SimpleBucket bucket = new SimpleBucket();
        BucketTree tree = new BucketTree((Workspace)ResourcesPlugin.getWorkspace(), (Bucket)bucket);
        IProject proj1 = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        IProject proj2 = ResourcesPlugin.getWorkspace().getRoot().getProject("proj2");
        IFile file1 = proj1.getFile("file1.txt");
        IFolder folder1 = proj1.getFolder("folder1");
        IFile file2 = folder1.getFile("file2.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2, proj2});
        IPath[] iPathArray = paths = new IPath[]{IPath.ROOT, proj1.getFullPath(), file1.getFullPath(), folder1.getFullPath(), file2.getFullPath(), proj2.getFullPath()};
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            tree.loadBucketFor(path);
            bucket.set(path, "path", path.toString());
            bucket.set(path, "segments", Integer.toString(path.segmentCount()));
            ++n2;
        }
        bucket.save();
        this.verify(tree, "1.1", IPath.ROOT, 0, Set.of(IPath.ROOT));
        this.verify(tree, "1.2", IPath.ROOT, 1, Set.of(IPath.ROOT, proj1.getFullPath(), proj2.getFullPath()));
        this.verify(tree, "1.3", IPath.ROOT, Integer.MAX_VALUE, Set.of(IPath.ROOT, proj1.getFullPath(), file1.getFullPath(), folder1.getFullPath(), file2.getFullPath(), proj2.getFullPath()));
        this.verify(tree, "2.1", proj1.getFullPath(), 0, Arrays.asList(proj1.getFullPath()));
        this.verify(tree, "2.2", proj1.getFullPath(), 1, Arrays.asList(proj1.getFullPath(), file1.getFullPath(), folder1.getFullPath()));
        this.verify(tree, "2.3", proj1.getFullPath(), Integer.MAX_VALUE, Arrays.asList(proj1.getFullPath(), file1.getFullPath(), folder1.getFullPath(), file2.getFullPath()));
        this.verify(tree, "3.1", file1.getFullPath(), 0, Arrays.asList(file1.getFullPath()));
        this.verify(tree, "3.2", file1.getFullPath(), 1, Arrays.asList(file1.getFullPath()));
        this.verify(tree, "3.3", file1.getFullPath(), Integer.MAX_VALUE, Arrays.asList(file1.getFullPath()));
        this.verify(tree, "4.1", folder1.getFullPath(), 0, Arrays.asList(folder1.getFullPath()));
        this.verify(tree, "4.2", folder1.getFullPath(), 1, Arrays.asList(folder1.getFullPath(), file2.getFullPath()));
        this.verify(tree, "4.3", folder1.getFullPath(), Integer.MAX_VALUE, Arrays.asList(folder1.getFullPath(), file2.getFullPath()));
        this.verify(tree, "5.1", file2.getFullPath(), 0, Arrays.asList(file2.getFullPath()));
        this.verify(tree, "5.2", file2.getFullPath(), 1, Arrays.asList(file2.getFullPath()));
        this.verify(tree, "5.3", file2.getFullPath(), Integer.MAX_VALUE, Arrays.asList(file2.getFullPath()));
        this.verify(tree, "6.1", proj2.getFullPath(), 0, Arrays.asList(proj2.getFullPath()));
        this.verify(tree, "6.2", proj2.getFullPath(), 1, Arrays.asList(proj2.getFullPath()));
        this.verify(tree, "6.3", proj2.getFullPath(), Integer.MAX_VALUE, Arrays.asList(proj2.getFullPath()));
    }

    public void verify(BucketTree tree, final String tag, IPath root, int depth, final Collection<IPath> expected) throws CoreException {
        final HashSet visited = new HashSet();
        Bucket.Visitor verifier = new Bucket.Visitor(){

            public int visit(Bucket.Entry entry) {
                SimpleBucket.SimpleEntry simple = (SimpleBucket.SimpleEntry)entry;
                IPath path = simple.getPath();
                Assert.assertTrue((String)(tag + ".0 " + String.valueOf(path)), (boolean)expected.contains(path));
                visited.add(path);
                Assert.assertEquals((String)(tag + ".1 " + String.valueOf(path)), (Object)path.toString(), (Object)simple.getProperty("path"));
                Assert.assertEquals((String)(tag + ".2 " + String.valueOf(path)), (Object)Integer.toString(path.segmentCount()), (Object)simple.getProperty("segments"));
                return 0;
            }
        };
        tree.accept(verifier, root, depth);
        Assert.assertEquals((String)(tag + ".4"), (long)expected.size(), (long)visited.size());
        for (IPath path : expected) {
            Assert.assertTrue((String)(tag + ".5 " + String.valueOf(path)), (boolean)visited.contains(path));
        }
    }

    static class SimpleBucket
    extends Bucket {
        public SimpleBucket() {
            super(true);
        }

        protected String getIndexFileName() {
            return "simple_bucket.index";
        }

        protected String getVersionFileName() {
            return "simple_bucket.version";
        }

        protected Bucket.Entry createEntry(IPath path, Object value) {
            return new SimpleEntry(path, (Map)value);
        }

        protected byte getVersion() {
            return 0;
        }

        protected Object readEntryValue(DataInputStream source) throws IOException {
            int length = source.readUnsignedShort();
            HashMap<String, String> value = new HashMap<String, String>(length);
            int j = 0;
            while (j < length) {
                value.put(source.readUTF(), source.readUTF());
                ++j;
            }
            return value;
        }

        public void set(IPath path, String key, String value) {
            String pathAsString = path.toString();
            HashMap<String, String> existing = (HashMap<String, String>)this.getEntryValue(pathAsString);
            if (existing == null) {
                if (value != null) {
                    existing = new HashMap<String, String>();
                    existing.put(key, value);
                    this.setEntryValue(pathAsString, existing);
                }
                return;
            }
            if (value == null) {
                existing.remove(key);
                if (existing.isEmpty()) {
                    existing = null;
                }
            } else {
                existing.put(key, value);
            }
            this.setEntryValue(pathAsString, existing);
        }

        protected void writeEntryValue(DataOutputStream destination, Object entryValue) throws IOException {
            Map value = (Map)entryValue;
            int length = value.size();
            destination.writeShort(length);
            for (Map.Entry entry : value.entrySet()) {
                destination.writeUTF((String)entry.getKey());
                destination.writeUTF((String)entry.getValue());
            }
        }

        static class SimpleEntry
        extends Bucket.Entry {
            private final Map<String, String> value;

            public SimpleEntry(IPath path, Map<String, String> value) {
                super(path);
                this.value = value;
            }

            public int getOccurrences() {
                return this.value.size();
            }

            public String getProperty(String key) {
                return this.value.get(key);
            }

            public Object getValue() {
                return this.value;
            }
        }
    }
}

