/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class CaseSensitivityTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private final boolean isCaseSensitive = Workspace.caseSensitive;

    @Test
    public void testCreateProjects() throws Throwable {
        String projectName = "testProject31415";
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        project1.create(null);
        project1.open(null);
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName.toUpperCase());
        ThrowingRunnable projectCreation = () -> {
            project2.create(null);
            project2.open(null);
        };
        if (this.isCaseSensitive) {
            projectCreation.run();
        } else {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)projectCreation);
        }
    }

    @Test
    public void testCreateFolders() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String folderName = "testFolder31415";
        IFolder folder1 = project.getFolder(folderName);
        folder1.create(true, true, null);
        IFolder folder2 = project.getFolder(folderName.toUpperCase());
        ThrowingRunnable folderCreation = () -> folder2.create(true, true, null);
        if (this.isCaseSensitive) {
            folderCreation.run();
        } else {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)folderCreation);
        }
        IFile file = project.getFile(folderName.toUpperCase());
        Assert.assertThrows(CoreException.class, () -> file.create(ResourceTestUtil.createRandomContentsStream(), true, null));
    }

    @Test
    public void testCreateFiles() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String fileName = "testFile31415";
        IFile file1 = project.getFile(fileName);
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        IFile file2 = project.getFile(fileName.toUpperCase());
        ThrowingRunnable fileCreation = () -> file2.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        if (this.isCaseSensitive) {
            fileCreation.run();
        } else {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)fileCreation);
        }
        IFolder folder = project.getFolder(fileName.toUpperCase());
        Assert.assertThrows(CoreException.class, () -> folder.create(true, true, null));
    }

    @Test
    public void testRenameProject() throws Throwable {
        String project1name = "project1test31415";
        String project2name = "project2test31415";
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(project1name);
        project1.create(null);
        project1.open(null);
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(project2name);
        project2.create(null);
        project2.open(null);
        ThrowingRunnable projectMovement = () -> project1.move(IPath.ROOT.append(project2.getName().toUpperCase()), true, null);
        if (this.isCaseSensitive) {
            projectMovement.run();
        } else {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)projectMovement);
        }
    }

    @Test
    public void testRenameFolder() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String folder1name = "folder1test31415";
        String folder2name = "folder2test31415";
        IFolder folder1 = project.getFolder(folder1name);
        folder1.create(true, true, null);
        IFolder folder2 = project.getFolder(folder2name);
        folder2.create(true, true, null);
        IFolder folder3 = project.getFolder(folder2name.toUpperCase());
        ThrowingRunnable folderMovement = () -> folder1.move(folder3.getFullPath(), true, null);
        if (this.isCaseSensitive) {
            folderMovement.run();
        } else {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)folderMovement);
        }
    }

    @Test
    public void testRenameFile() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String file1name = "file1test31415";
        String file2name = "file2test31415";
        IFile file1 = project.getFile(file1name);
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        IFile file2 = project.getFile(file2name);
        file2.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        IFile file3 = project.getFile(file2name.toUpperCase());
        ThrowingRunnable fileMovement = () -> file1.move(file3.getFullPath(), true, null);
        if (this.isCaseSensitive) {
            fileMovement.run();
        } else {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)fileMovement);
        }
    }

    @Test
    public void testCopyAndMoveFolder() throws Throwable {
        IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Source");
        ResourceTestUtil.createInWorkspace((IResource)sourceProject);
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Target");
        ResourceTestUtil.createInWorkspace((IResource)destinationProject);
        String folderName = "folderTest31415";
        IFolder folder1 = sourceProject.getFolder(folderName);
        folder1.create(true, true, null);
        IFolder folder2 = destinationProject.getFolder(folderName.toUpperCase());
        folder2.create(true, true, null);
        ThrowingRunnable folderCopy = () -> folder1.copy(destinationProject.getFullPath().append(folder1.getName()), true, null);
        if (this.isCaseSensitive) {
            folderCopy.run();
        } else {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)folderCopy);
        }
        Assert.assertThrows(CoreException.class, () -> folder1.move(destinationProject.getFullPath().append(folder1.getName()), true, null));
    }

    @Test
    public void testCopyAndMoveFile() throws Throwable {
        IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Source");
        ResourceTestUtil.createInWorkspace((IResource)sourceProject);
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Target");
        ResourceTestUtil.createInWorkspace((IResource)destinationProject);
        String fileName = "fileTest31415";
        IFile file1 = sourceProject.getFile(fileName);
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        IFile file2 = destinationProject.getFile(fileName.toUpperCase());
        file2.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        ThrowingRunnable fileCopy = () -> file1.copy(destinationProject.getFullPath().append(file1.getName()), true, null);
        if (this.isCaseSensitive) {
            fileCopy.run();
        } else {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)fileCopy);
        }
        Assert.assertThrows(CoreException.class, () -> file1.move(destinationProject.getFullPath().append(file1.getName()), true, null));
    }

    @Test
    public void testCopyAndMoveFolderOverFile() throws Throwable {
        IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Source");
        ResourceTestUtil.createInWorkspace((IResource)sourceProject);
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Target");
        ResourceTestUtil.createInWorkspace((IResource)destinationProject);
        String name = "test31415";
        IFolder folder = sourceProject.getFolder(name);
        folder.create(true, true, null);
        IFile file = destinationProject.getFile(name.toUpperCase());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        ThrowingRunnable folderCopy = () -> folder.copy(destinationProject.getFullPath().append(folder.getName()), true, null);
        if (this.isCaseSensitive) {
            folderCopy.run();
        } else {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)folderCopy);
        }
        Assert.assertThrows(CoreException.class, () -> folder.move(destinationProject.getFullPath().append(folder.getName()), true, null));
    }

    @Test
    public void testCopyAndMoveFileOverFolder() throws Throwable {
        IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Source");
        ResourceTestUtil.createInWorkspace((IResource)sourceProject);
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Target");
        ResourceTestUtil.createInWorkspace((IResource)destinationProject);
        String name = "test31415";
        IFile file = sourceProject.getFile(name);
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        IFolder folder = destinationProject.getFolder(name.toUpperCase());
        folder.create(true, true, null);
        ThrowingRunnable fileCopy = () -> file.copy(destinationProject.getFullPath().append(file.getName()), true, null);
        if (this.isCaseSensitive) {
            fileCopy.run();
        } else {
            Assert.assertThrows(CoreException.class, (ThrowingRunnable)fileCopy);
        }
        Assert.assertThrows(CoreException.class, () -> file.move(destinationProject.getFullPath().append(file.getName()), true, null));
    }

    @Test
    public void testCopyAndMoveFolderBecomeProject() throws CoreException {
        IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Source");
        ResourceTestUtil.createInWorkspace((IResource)sourceProject);
        IProject blockingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Blocking");
        ResourceTestUtil.createInWorkspace((IResource)blockingProject);
        IFolder folder = sourceProject.getFolder(blockingProject.getName().toUpperCase());
        folder.create(true, true, null);
        Assert.assertThrows(CoreException.class, () -> folder.move(IPath.ROOT.append(folder.getName()), true, null));
        Assert.assertThrows(CoreException.class, () -> folder.copy(IPath.ROOT.append(folder.getName()), true, null));
    }

    @Test
    public void testCopyAndMoveProjectBecomeFolder() throws CoreException {
        IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Source");
        ResourceTestUtil.createInWorkspace((IResource)sourceProject);
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Target");
        ResourceTestUtil.createInWorkspace((IResource)destinationProject);
        IFile file = destinationProject.getFile(sourceProject.getName().toUpperCase());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        Assert.assertThrows(CoreException.class, () -> sourceProject.move(destinationProject.getFullPath().append(sourceProject.getName()), true, null));
        Assert.assertThrows(CoreException.class, () -> sourceProject.copy(destinationProject.getFullPath().append(sourceProject.getName()), true, null));
    }

    @Test
    public void testRefreshLocalFolder1() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String name = "test31415";
        IFolder folder = project.getFolder(name.toUpperCase());
        folder.create(true, true, null);
        IFolder herringRouge = project.getFolder(name);
        folder.getLocation().toFile().delete();
        File dir = herringRouge.getLocation().toFile();
        dir.mkdir();
        project.refreshLocal(2, null);
        Assert.assertFalse((boolean)folder.exists());
        Assert.assertTrue((boolean)herringRouge.exists());
    }

    @Test
    public void testRefreshLocalFile1() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String name = "test31415";
        IFile file = project.getFile(name.toUpperCase());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        IFile herringRouge = project.getFile(name);
        ResourceTestUtil.removeFromFileSystem((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)herringRouge);
        project.refreshLocal(2, null);
        Assert.assertFalse((boolean)file.exists());
        Assert.assertTrue((boolean)herringRouge.exists());
    }

    @Test
    public void testRefreshLocalFolder2() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String name = "test31415";
        IFolder folder = project.getFolder(name.toUpperCase());
        folder.create(true, true, null);
        IFile herringRouge = project.getFile(name);
        ResourceTestUtil.removeFromFileSystem((IResource)folder);
        ResourceTestUtil.createInFileSystem((IResource)herringRouge);
        project.refreshLocal(2, null);
        Assert.assertFalse((boolean)folder.exists());
        Assert.assertTrue((boolean)herringRouge.exists());
    }

    @Test
    public void testRefreshLocalFile2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String name = "test31415";
        IFile file = project.getFile(name.toUpperCase());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        IFolder herringRouge = project.getFolder(name);
        File localFile = file.getLocation().toFile();
        localFile.delete();
        Assert.assertFalse((boolean)localFile.exists());
        File dir = herringRouge.getLocation().toFile();
        dir.mkdir();
        Assert.assertTrue((boolean)dir.exists());
        project.refreshLocal(2, null);
        Assert.assertFalse((boolean)file.exists());
        Assert.assertTrue((boolean)herringRouge.exists());
    }

    @Test
    public void testDeleteResources() throws CoreException, IOException {
        String name = "test31415";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        project.create(null);
        project.open(null);
        IFolder folder = project.getFolder(name);
        folder.create(true, true, null);
        IFile file = folder.getFile(name);
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        File localFile = file.getLocation().toFile();
        localFile.delete();
        Assert.assertTrue((!localFile.exists() ? 1 : 0) != 0);
        localFile = new File(file.getLocation().removeLastSegments(1).toString(), name.toUpperCase());
        localFile.createNewFile();
        Assert.assertTrue((boolean)localFile.exists());
        file.delete(true, null);
        localFile.delete();
        Assert.assertFalse((boolean)localFile.exists());
        File localFolder = folder.getLocation().toFile();
        localFolder.delete();
        Assert.assertFalse((boolean)localFolder.exists());
        localFolder = new File(folder.getLocation().removeLastSegments(1).toString(), name.toUpperCase());
        localFolder.mkdir();
        Assert.assertTrue((boolean)localFolder.exists());
        folder.delete(true, null);
    }
}

