/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CopyTest {
    private static final int NUMBER_OF_PROPERTIES = 5;
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Test
    public void testCopyResource() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("file.txt");
        ResourceTestUtil.createInWorkspace((IResource)folder);
        ResourceTestUtil.createInFileSystem((IResource)folder);
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)file);
        QualifiedName[] propNames = new QualifiedName[5];
        String[] propValues = new String[5];
        int i = 0;
        while (i < 5) {
            propNames[i] = new QualifiedName("test", "prop" + i);
            propValues[i] = "value" + i;
            file.setPersistentProperty(propNames[i], propValues[i]);
            file.setSessionProperty(propNames[i], (Object)propValues[i]);
            ++i;
        }
        IFile destination = project.getFile("copy of file.txt");
        ResourceTestUtil.removeFromFileSystem((IResource)destination);
        file.copy(destination.getFullPath(), true, null);
        Assert.assertTrue((boolean)destination.exists());
        int i2 = 0;
        while (i2 < 5) {
            String persistentValue = destination.getPersistentProperty(propNames[i2]);
            Object sessionValue = destination.getSessionProperty(propNames[i2]);
            Assertions.assertThat((String)propValues[i2]).isEqualTo(persistentValue).isNotEqualTo(sessionValue);
            ++i2;
        }
        ResourceTestUtil.removeFromWorkspace((IResource)destination);
        ResourceTestUtil.removeFromFileSystem((IResource)destination);
        IPath path = IPath.fromOSString((String)"copy of file.txt");
        IFile destinationInFolder = folder.getFile(path);
        ResourceTestUtil.removeFromFileSystem((IResource)destinationInFolder);
        file.copy(path, true, null);
        Assert.assertTrue((boolean)destinationInFolder.exists());
        int i3 = 0;
        while (i3 < 5) {
            String persistentValue = destinationInFolder.getPersistentProperty(propNames[i3]);
            Object sessionValue = destinationInFolder.getSessionProperty(propNames[i3]);
            Assertions.assertThat((String)propValues[i3]).isEqualTo(persistentValue).isNotEqualTo(sessionValue);
            ++i3;
        }
        ResourceTestUtil.removeFromWorkspace((IResource)destinationInFolder);
        ResourceTestUtil.removeFromFileSystem((IResource)destinationInFolder);
        IFolder destinationInSubfolder = folder.getFolder("subfolder");
        Assert.assertThrows(RuntimeException.class, () -> folder.copy(destinationInSubfolder.getFullPath(), true, null));
        project.refreshLocal(2, null);
        IFolder subfolder = folder.getFolder("subfolder");
        ResourceTestUtil.createInFileSystem((IResource)subfolder);
        IFile anotherFile = folder.getFile("new file");
        ResourceTestUtil.createInFileSystem((IResource)anotherFile);
        IFolder destinationFolder = project.getFolder("destination");
        CoreException exception = (CoreException)Assert.assertThrows(CoreException.class, () -> folder.copy(destinationFolder.getFullPath(), false, null));
        Assertions.assertThat((Object[])exception.getStatus().getChildren()).hasSize(2);
        Assert.assertTrue((boolean)destinationFolder.exists());
        Assert.assertTrue((boolean)destinationFolder.getFile(IPath.fromOSString((String)file.getName())).exists());
        Assert.assertFalse((boolean)destinationFolder.getFolder(IPath.fromOSString((String)subfolder.getName())).exists());
        Assert.assertFalse((boolean)destinationFolder.getFile(IPath.fromOSString((String)anotherFile.getName())).exists());
        IFile target = destinationFolder.getFile(IPath.fromOSString((String)file.getName()));
        int i4 = 0;
        while (i4 < 5) {
            String persistentValue = target.getPersistentProperty(propNames[i4]);
            Object sessionValue = target.getSessionProperty(propNames[i4]);
            Assertions.assertThat((String)propValues[i4]).isEqualTo(persistentValue).isNotEqualTo(sessionValue);
            ++i4;
        }
        ResourceTestUtil.removeFromWorkspace((IResource)destinationFolder);
        ResourceTestUtil.removeFromFileSystem((IResource)destinationFolder);
        IFile ghostFile = project.getFile("ghost");
        ghostFile.create(null, true, null);
        ResourceTestUtil.removeFromFileSystem((IResource)file);
        IFile destinationFile = project.getFile("destination");
        Assert.assertThrows(CoreException.class, () -> ghostFile.copy(destinationFile.getFullPath(), true, null));
    }
}

