/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DeleteTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private IProject project;

    @Before
    public void createTestProject() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)this.project);
    }

    @Test
    public void testDeleteOpenProject() throws Exception {
        IFolder folder = this.project.getFolder("folder");
        IFile file = folder.getFile("file");
        ResourceTestUtil.createInWorkspace(new IResource[]{this.project, folder, file});
        IPath folderPath = folder.getLocation();
        IPath filePath = file.getLocation();
        IPath projectLocation = this.project.getLocation();
        this.project.delete(false, true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((boolean)this.project.exists());
        Assert.assertFalse((boolean)((Workspace)ResourcesPlugin.getWorkspace()).getMetaArea().locationFor((IResource)this.project).toFile().exists());
        Assert.assertNull((Object)this.project.getLocation());
        Assert.assertTrue((boolean)folderPath.toFile().isDirectory());
        Assert.assertTrue((boolean)filePath.toFile().isFile());
        Workspace.clear((File)projectLocation.toFile());
        ResourceTestUtil.createInWorkspace(new IResource[]{this.project, folder, file});
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        projectLocation = this.project.getLocation();
        this.project.delete(true, true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((boolean)this.project.exists());
        Assert.assertFalse((boolean)((Workspace)ResourcesPlugin.getWorkspace()).getMetaArea().locationFor((IResource)this.project).toFile().exists());
        Assert.assertNull((Object)this.project.getLocation());
        Assert.assertFalse((boolean)projectLocation.toFile().exists());
        Assert.assertFalse((boolean)folderPath.toFile().exists());
        Assert.assertFalse((boolean)filePath.toFile().exists());
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        folder.create(true, false, ResourceTestUtil.createTestMonitor());
        file.create(null, true, ResourceTestUtil.createTestMonitor());
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        projectLocation = this.project.getLocation();
        this.project.delete(true, true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((boolean)this.project.exists());
        Assert.assertFalse((boolean)((Workspace)ResourcesPlugin.getWorkspace()).getMetaArea().locationFor((IResource)this.project).toFile().exists());
        Assert.assertNull((Object)this.project.getLocation());
        Assert.assertFalse((boolean)folderPath.toFile().isDirectory());
        Assert.assertFalse((boolean)filePath.toFile().isFile());
        ResourceTestUtil.createInWorkspace(new IResource[]{this.project, folder, file});
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        this.project.delete(true, true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((boolean)this.project.exists());
        Assert.assertFalse((boolean)((Workspace)ResourcesPlugin.getWorkspace()).getMetaArea().locationFor((IResource)this.project).toFile().exists());
        Assert.assertNull((Object)this.project.getLocation());
        Assert.assertFalse((boolean)folderPath.toFile().exists());
        Assert.assertFalse((boolean)filePath.toFile().exists());
        Workspace.clear((File)folderPath.toFile());
        ResourceTestUtil.createInWorkspace((IResource)this.project);
        ResourceTestUtil.createInFileSystem((IResource)folder);
        ResourceTestUtil.createInFileSystem((IResource)file);
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        projectLocation = this.project.getLocation();
        this.project.delete(true, true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((boolean)this.project.exists());
        Assert.assertFalse((boolean)((Workspace)ResourcesPlugin.getWorkspace()).getMetaArea().locationFor((IResource)this.project).toFile().exists());
        Assert.assertNull((Object)this.project.getLocation());
        Assert.assertFalse((boolean)folderPath.toFile().isDirectory());
        Assert.assertFalse((boolean)filePath.toFile().isFile());
    }

    @Test
    public void testDeleteClosedProject() throws Throwable {
        IFolder folder = this.project.getFolder("folder");
        IFile file = folder.getFile("file");
        ResourceTestUtil.createInWorkspace(new IResource[]{this.project, folder});
        ResourcesPlugin.getWorkspace().run(monitor -> file.create(null, true, monitor), ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.createInWorkspace((IResource)file);
        IPath folderPath = folder.getLocation();
        IPath filePath = file.getLocation();
        IPath projectLocation = this.project.getLocation();
        this.project.close(ResourceTestUtil.createTestMonitor());
        this.project.delete(false, true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((boolean)this.project.exists());
        Assert.assertFalse((boolean)((Workspace)ResourcesPlugin.getWorkspace()).getMetaArea().locationFor((IResource)this.project).toFile().exists());
        Assert.assertNull((Object)this.project.getLocation());
        Assert.assertTrue((boolean)folderPath.toFile().exists());
        Assert.assertFalse((boolean)filePath.toFile().exists());
        Workspace.clear((File)projectLocation.toFile());
        ResourceTestUtil.createInWorkspace(new IResource[]{this.project, folder, file});
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        this.project.close(ResourceTestUtil.createTestMonitor());
        this.project.delete(true, true, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((boolean)this.project.exists());
        Assert.assertFalse((boolean)((Workspace)ResourcesPlugin.getWorkspace()).getMetaArea().locationFor((IResource)this.project).toFile().exists());
        Assert.assertNull((Object)this.project.getLocation());
        Assert.assertFalse((boolean)folderPath.toFile().isDirectory());
        Assert.assertFalse((boolean)filePath.toFile().isFile());
        ResourceTestUtil.createInWorkspace(new IResource[]{this.project, folder});
        ResourceTestUtil.createInWorkspace((IResource)file);
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        projectLocation = this.project.getLocation();
        this.project.close(ResourceTestUtil.createTestMonitor());
        this.project.delete(true, false, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((boolean)this.project.exists());
        IPath metaAreaLocation = ((Workspace)ResourcesPlugin.getWorkspace()).getMetaArea().locationFor((IResource)this.project);
        Assert.assertFalse((boolean)metaAreaLocation.toFile().exists());
        Assert.assertFalse((boolean)metaAreaLocation.append(".properties").toFile().exists());
        Assert.assertFalse((boolean)projectLocation.append(".project").toFile().exists());
        Assert.assertNull((Object)this.project.getLocation());
        Assert.assertFalse((boolean)folderPath.toFile().exists());
        Assert.assertFalse((boolean)filePath.toFile().exists());
    }

    @Test
    public void testDeleteResource() throws Throwable {
        IFolder folder = this.project.getFolder("folder");
        ResourceTestUtil.createInWorkspace((IResource)folder);
        IFile fileSync = folder.getFile("fileSync");
        ResourceTestUtil.createInWorkspace((IResource)fileSync);
        IFile fileUnsync = folder.getFile("fileUnsync");
        ResourceTestUtil.createInWorkspace((IResource)fileUnsync);
        IFile fileCreated = folder.getFile("fileCreated");
        ResourceTestUtil.createInFileSystem((IResource)fileCreated);
        IFolder subfolderSync = folder.getFolder("subfolderSync");
        ResourceTestUtil.createInWorkspace((IResource)subfolderSync);
        IFolder deletedfolderSync = subfolderSync.getFolder("deletedfolderSync");
        ResourceTestUtil.createInWorkspace((IResource)deletedfolderSync);
        IFolder subfolderUnsync = folder.getFolder("subfolderUnsync");
        ResourceTestUtil.createInWorkspace((IResource)subfolderUnsync);
        IFolder subsubfolderUnsync = subfolderUnsync.getFolder("subsubfolderUnsync");
        ResourceTestUtil.createInWorkspace((IResource)subsubfolderUnsync);
        IFile subsubfileSync = subsubfolderUnsync.getFile("subsubfileSync");
        ResourceTestUtil.createInWorkspace((IResource)subsubfileSync);
        IFile subsubfileUnsync = subsubfolderUnsync.getFile("subsubfileUnsync");
        ResourceTestUtil.createInWorkspace((IResource)subsubfileUnsync);
        ResourceTestUtil.ensureOutOfSync(fileUnsync);
        ResourceTestUtil.removeFromFileSystem((IResource)deletedfolderSync);
        ResourceTestUtil.ensureOutOfSync(subsubfileUnsync);
        folder.delete(true, null);
        Assert.assertFalse((boolean)folder.getLocation().toFile().exists());
        IFolder recreatedFolder = this.project.getFolder("folder");
        ResourceTestUtil.createInWorkspace((IResource)recreatedFolder);
        fileSync = recreatedFolder.getFile("fileSync");
        ResourceTestUtil.createInWorkspace((IResource)fileSync);
        fileUnsync = recreatedFolder.getFile("fileUnsync");
        ResourceTestUtil.createInWorkspace((IResource)fileUnsync);
        fileCreated = recreatedFolder.getFile("fileCreated");
        ResourceTestUtil.createInFileSystem((IResource)fileCreated);
        subfolderSync = recreatedFolder.getFolder("subfolderSync");
        ResourceTestUtil.createInWorkspace((IResource)subfolderSync);
        deletedfolderSync = subfolderSync.getFolder("deletedfolderSync");
        ResourceTestUtil.createInWorkspace((IResource)deletedfolderSync);
        subfolderUnsync = recreatedFolder.getFolder("subfolderUnsync");
        ResourceTestUtil.createInWorkspace((IResource)subfolderUnsync);
        subsubfolderUnsync = subfolderUnsync.getFolder("subsubfolderUnsync");
        ResourceTestUtil.createInWorkspace((IResource)subsubfolderUnsync);
        subsubfileSync = subsubfolderUnsync.getFile("subsubfileSync");
        ResourceTestUtil.createInWorkspace((IResource)subsubfileSync);
        subsubfileUnsync = subsubfolderUnsync.getFile("subsubfileUnsync");
        ResourceTestUtil.createInWorkspace((IResource)subsubfileUnsync);
        ResourceTestUtil.ensureOutOfSync(fileUnsync);
        ResourceTestUtil.removeFromFileSystem((IResource)deletedfolderSync);
        ResourceTestUtil.ensureOutOfSync(subsubfileUnsync);
        Assert.assertThrows(CoreException.class, () -> recreatedFolder.delete(false, null));
        Assert.assertTrue((boolean)recreatedFolder.getLocation().toFile().exists());
        Assert.assertFalse((boolean)fileSync.getLocation().toFile().exists());
        Assert.assertTrue((boolean)fileUnsync.getLocation().toFile().exists());
        Assert.assertFalse((boolean)subfolderSync.getLocation().toFile().exists());
        Assert.assertTrue((boolean)subfolderUnsync.getLocation().toFile().exists());
        Assert.assertFalse((boolean)deletedfolderSync.getLocation().toFile().exists());
        Assert.assertTrue((boolean)subsubfolderUnsync.getLocation().toFile().exists());
        Assert.assertTrue((boolean)subsubfileUnsync.getLocation().toFile().exists());
        Assert.assertFalse((boolean)subsubfileSync.getLocation().toFile().exists());
        Assert.assertTrue((boolean)fileCreated.getLocation().toFile().exists());
    }
}

