/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.InputStream;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.internal.filesystem.bug440110.Bug440110FileSystem;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FileSystemResourceManagerTest
implements ICoreConstants {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private IProject project;

    @Before
    public void createTestProject() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)this.project);
    }

    @Test
    public void testBug440110() throws Exception {
        String projectName = ResourceTestUtil.createUniqueString();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.project = workspace.getRoot().getProject(projectName);
        IProjectDescription projectDescription = workspace.newProjectDescription(projectName);
        projectDescription.setLocationURI(new URI("bug440110://" + projectName));
        this.project.create(projectDescription, null);
        this.project.open(null);
        Assert.assertEquals((Object)"bug440110", (Object)this.project.getLocationURI().getScheme());
        IFolder folder = this.project.getFolder("folder");
        folder.create(true, true, null);
        Assert.assertEquals((Object)"bug440110", (Object)folder.getLocationURI().getScheme());
        Bug440110FileSystem.clearFetchedFileTree();
        folder.refreshLocal(0, null);
        Assert.assertFalse((boolean)Bug440110FileSystem.hasFetchedFileTree());
        Bug440110FileSystem.clearFetchedFileTree();
        folder.refreshLocal(1, null);
        Assert.assertTrue((boolean)Bug440110FileSystem.hasFetchedFileTree());
        Bug440110FileSystem.clearFetchedFileTree();
        folder.refreshLocal(2, null);
        Assert.assertTrue((boolean)Bug440110FileSystem.hasFetchedFileTree());
    }

    @Test
    public void testContainerFor() {
        Assert.assertThrows(RuntimeException.class, () -> {
            IContainer iContainer = this.getLocalManager().containerForLocation(null);
        });
        IPath path = IPath.fromOSString((String)"target");
        IFolder folder = this.project.getFolder(path);
        IPath location = this.project.getLocation().append(path);
        IFolder testFolder = (IFolder)this.getLocalManager().containerForLocation(location);
        Assert.assertEquals((Object)folder, (Object)testFolder);
        path = IPath.fromOSString((String)"folder/target");
        folder = this.project.getFolder(path);
        location = this.project.getLocation().append(path);
        testFolder = (IFolder)this.getLocalManager().containerForLocation(location);
        Assert.assertEquals((Object)folder, (Object)testFolder);
        path = IPath.fromOSString((String)"folder/folder/target");
        folder = this.project.getFolder(path);
        location = this.project.getLocation().append(path);
        testFolder = (IFolder)this.getLocalManager().containerForLocation(location);
        Assert.assertEquals((Object)folder, (Object)testFolder);
        testFolder = (IFolder)this.getLocalManager().containerForLocation(IPath.fromOSString((String)"../this/path/must/not/exist"));
        Assert.assertNull((Object)testFolder);
    }

    @Test
    public void testCreateFile() throws Exception {
        File file = (File)this.project.getFile("testCreateFile");
        String originalContent = "this string should not be equal the other";
        file.create(ResourceTestUtil.createInputStream(originalContent), false, null);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)file.isLocal(0));
        Assert.assertEquals((long)file.getStore().fetchInfo().getLastModified(), (long)file.getResourceInfo(false, false).getLocalSyncInfo());
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream readFile = this.getLocalManager().read((IFile)file, true, null);){
            Assertions.assertThat((InputStream)readFile).hasContent(originalContent);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testFileFor() {
        Assert.assertThrows(RuntimeException.class, () -> {
            IFile iFile = this.getLocalManager().fileForLocation(null);
        });
        IPath path = IPath.fromOSString((String)"file");
        IFile file = this.project.getFile(path);
        IPath location = this.project.getLocation().append(path);
        IFile testFile = this.getLocalManager().fileForLocation(location);
        Assert.assertEquals((Object)file, (Object)testFile);
        path = IPath.fromOSString((String)"folder/file");
        file = this.project.getFile(path);
        location = this.project.getLocation().append(path);
        testFile = this.getLocalManager().fileForLocation(location);
        Assert.assertEquals((Object)file, (Object)testFile);
        path = IPath.fromOSString((String)"folder/folder/file");
        file = this.project.getFile(path);
        location = this.project.getLocation().append(path);
        testFile = this.getLocalManager().fileForLocation(location);
        Assert.assertEquals((Object)file, (Object)testFile);
        testFile = this.getLocalManager().fileForLocation(IPath.fromOSString((String)"../this/path/must/not/exist"));
        Assert.assertNull((Object)testFile);
    }

    @Test
    public void testIsLocal() throws CoreException {
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)this.project, new String[]{"/Folder1/", "/Folder1/File1", "/Folder1/Folder2/", "/Folder1/Folder2/File2", "/Folder1/Folder2/Folder3/"});
        ResourceTestUtil.createInWorkspace(resources);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ResourceTestUtil.removeFromFileSystem(resource);
            ++n2;
        }
        Assert.assertTrue((boolean)this.project.isLocal(2));
        IFolder folder = this.project.getFolder("Folder1");
        IWorkspaceRunnable operation = monitor -> {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                ((Resource)member).getResourceInfo(false, true).clear(2);
                ++n2;
            }
        };
        ResourcesPlugin.getWorkspace().run(operation, null);
        Assert.assertTrue((boolean)this.project.isLocal(1));
        Assert.assertTrue((boolean)folder.isLocal(0));
        Assert.assertFalse((boolean)folder.isLocal(2));
        ResourceTestUtil.removeFromWorkspace((IResource)this.project);
    }

    @Test
    public void testLocationFor() {
        IPath location = this.project.getLocation();
        Assert.assertEquals((Object)this.getLocalManager().locationFor((IResource)this.project), (Object)location);
        Assert.assertEquals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation().append(this.project.getName()), (Object)location);
    }

    @Test
    public void testSynchronizeProject() throws Exception {
        IFile file = this.project.getFile("file");
        ResourceTestUtil.createInFileSystem((IResource)file);
        this.project.refreshLocal(0, null);
        Assert.assertFalse((boolean)file.exists());
        IFolder folder = this.project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        ResourceTestUtil.createInFileSystem((IResource)folder);
        ResourceTestUtil.createInFileSystem((IResource)subfolder);
        ResourceTestUtil.createInFileSystem((IResource)subfile);
        this.project.refreshLocal(1, null);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)folder.exists());
        Assert.assertFalse((boolean)subfolder.exists());
        Assert.assertFalse((boolean)subfile.exists());
        this.project.refreshLocal(2, null);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)folder.exists());
        Assert.assertTrue((boolean)subfolder.exists());
        Assert.assertTrue((boolean)subfile.exists());
        file = this.project.getFile("closed");
        this.project.close(null);
        ResourceTestUtil.createInFileSystem((IResource)file);
        this.project.open(null);
        Assert.assertFalse((boolean)file.exists());
        this.project.refreshLocal(2, null);
        Assert.assertTrue((boolean)file.exists());
        ResourcesPlugin.getWorkspace().getRoot().getProject("inexistingProject").refreshLocal(2, null);
    }

    @Test
    public void testWriteFile() throws Exception {
        InputStream readFile;
        InputStream original;
        IFile file = this.project.getFile("testWriteFile");
        ResourceTestUtil.createInWorkspace((IResource)file);
        String originalContent = "this string should not be equal the other";
        String anotherContent = "and this string should not... well, you know...";
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            original = ResourceTestUtil.createInputStream(originalContent);
            try {
                this.write(file, original, true, null);
            }
            finally {
                if (original != null) {
                    original.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        throwable2 = null;
        try {
            readFile = this.getLocalManager().read(file, true, null);
            try {
                Assertions.assertThat((InputStream)readFile).hasContent(originalContent);
            }
            finally {
                if (readFile != null) {
                    readFile.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        throwable = null;
        throwable2 = null;
        try (InputStream another = ResourceTestUtil.createInputStream(anotherContent);){
            this.write(file, another, false, null);
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        throwable = null;
        throwable2 = null;
        try {
            readFile = this.getLocalManager().read(file, true, null);
            try {
                Assertions.assertThat((InputStream)readFile).hasContent(anotherContent);
            }
            finally {
                if (readFile != null) {
                    readFile.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        throwable = null;
        throwable2 = null;
        try {
            original = ResourceTestUtil.createInputStream(originalContent);
            try {
                this.write(file, original, true, null);
            }
            finally {
                if (original != null) {
                    original.close();
                }
            }
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
            } else if (throwable != throwable7) {
                throwable.addSuppressed(throwable7);
            }
            throw throwable;
        }
        throwable = null;
        throwable2 = null;
        try {
            readFile = this.getLocalManager().read(file, true, null);
            try {
                Assertions.assertThat((InputStream)readFile).hasContent(originalContent);
            }
            finally {
                if (readFile != null) {
                    readFile.close();
                }
            }
        }
        catch (Throwable throwable8) {
            if (throwable == null) {
                throwable = throwable8;
            } else if (throwable != throwable8) {
                throwable.addSuppressed(throwable8);
            }
            throw throwable;
        }
        ResourceTestUtil.ensureOutOfSync(file);
        InputStream another2 = ResourceTestUtil.createInputStream(anotherContent);
        Assert.assertThrows((String)"Should fail writing out of sync file #1", CoreException.class, () -> this.write(file, another2, false, null));
        ResourceTestUtil.ensureOutOfSync(file);
        Assert.assertThrows((String)"Should fail writing out of sync file #2", CoreException.class, () -> file.setContents(another2, false, false, null));
        throwable2 = null;
        Object var6_19 = null;
        try (InputStream another = ResourceTestUtil.createInputStream(anotherContent);){
            file.setContents(another, true, false, null);
        }
        catch (Throwable throwable9) {
            if (throwable2 == null) {
                throwable2 = throwable9;
            } else if (throwable2 != throwable9) {
                throwable2.addSuppressed(throwable9);
            }
            throw throwable2;
        }
        ResourceTestUtil.removeFromFileSystem((IResource)file);
        InputStream another3 = ResourceTestUtil.createInputStream(anotherContent);
        ResourceTestUtil.waitForRefresh();
        Assert.assertThrows((String)"Should fail writing non existing file", CoreException.class, () -> this.write(file, another3, false, null));
        ResourceTestUtil.removeFromWorkspace((IResource)this.project);
    }

    @Test
    public void testWriteDeletedFile() throws CoreException {
        IFile file = this.project.getFile("testWriteFile");
        ResourceTestUtil.createInWorkspace((IResource)file);
        String content = "original";
        this.write(file, ResourceTestUtil.createInputStream(content), true, null);
        file.delete(true, null);
        Assert.assertThrows((String)"Should fail writing file that is already deleted", CoreException.class, () -> this.write(file, ResourceTestUtil.createInputStream(content), false, null));
    }

    @Test
    public void testWriteFileNotInWorkspace() throws CoreException {
        IFile file = this.project.getFile("testWriteFile2");
        String anotherContent = "and this string should not... well, you know...";
        InputStream another = ResourceTestUtil.createInputStream(anotherContent);
        Assert.assertThrows(CoreException.class, () -> this.write(file, another, false, null));
        ResourceTestUtil.removeFromWorkspace((IResource)this.project);
    }

    @Test
    public void testWriteFolder() throws Exception {
        IFolder folder = this.project.getFolder("testWriteFolder");
        ResourceTestUtil.createInWorkspace((IResource)folder);
        ResourceTestUtil.removeFromFileSystem((IResource)folder);
        IFile file = this.project.getFile("testWriteFolder");
        ResourceTestUtil.createInFileSystem((IResource)file);
        Assert.assertThrows(CoreException.class, () -> this.write(folder, true, null));
        Assert.assertThrows(CoreException.class, () -> this.write(folder, false, null));
        ResourceTestUtil.removeFromFileSystem((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)folder);
        this.write(folder, true, null);
        Assert.assertTrue((boolean)folder.getLocation().toFile().isDirectory());
        Assert.assertThrows(CoreException.class, () -> this.write(folder, false, null));
        ResourceTestUtil.removeFromFileSystem((IResource)folder);
        this.write(folder, true, null);
        Assert.assertTrue((boolean)folder.getLocation().toFile().isDirectory());
        ResourceTestUtil.removeFromFileSystem((IResource)folder);
        this.write(folder, false, null);
        Assert.assertTrue((boolean)folder.getLocation().toFile().isDirectory());
    }

    @Test
    public void testWriteProject() throws CoreException {
        IFile dotProject = this.project.getFile(".project");
        IFileStore fileStore = ((Resource)this.project).getStore();
        ResourcesPlugin.getWorkspace().run(monitor -> {
            ResourceTestUtil.removeFromFileSystem((IResource)this.project);
            Assert.assertFalse((String)"2.1", (boolean)fileStore.fetchInfo().isDirectory());
            ((Project)this.project).writeDescription(1);
        }, null);
        Assert.assertTrue((boolean)fileStore.fetchInfo().isDirectory());
        long lastModified = ((Resource)dotProject).getStore().fetchInfo().getLastModified();
        Assert.assertEquals((long)lastModified, (long)((Resource)this.project).getResourceInfo(false, false).getLocalSyncInfo());
    }

    @Test
    public void testBug547691() throws CoreException {
        String projectName = ResourceTestUtil.createUniqueString();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.project = workspace.getRoot().getProject(projectName);
        IProjectDescription projectDescription = workspace.newProjectDescription(projectName);
        this.project.create(projectDescription, null);
        this.project.open(null);
        FileSystemResourceManager manager = ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager();
        URI location = manager.locationURIFor((IResource)this.project);
        Assert.assertNotNull((String)"Expected location for accessible project to not be null", (Object)location);
        this.project.delete(true, null);
        URI locationAfterDelete = manager.locationURIFor((IResource)this.project);
        Assert.assertEquals((String)"Expected location of project to not change after delete", (Object)location, (Object)locationAfterDelete);
    }

    @Test
    public void testLightweightAutoRefreshPrefChange() {
        FileSystemResourceManager manager = ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager();
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putBoolean("refresh.lightweight.enabled", false);
        Assert.assertFalse((boolean)manager.isLightweightAutoRefreshEnabled());
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putBoolean("refresh.lightweight.enabled", true);
        Assert.assertTrue((boolean)manager.isLightweightAutoRefreshEnabled());
    }

    protected void write(IFile file, InputStream contents, boolean force, IProgressMonitor monitor) throws CoreException {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Assert.assertNotNull((String)"workspace cannot be null", (Object)workspace);
            workspace.run((IWorkspaceRunnable)new WriteFileContents(file, contents, force, this.getLocalManager()), monitor);
        }
        catch (Throwable t) {
            String errorMessage = "exception occurred during write of file: " + String.valueOf(file);
            Status errorStatus = new Status(4, "org.eclipse.core.resources", errorMessage, t);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)errorStatus);
            throw t;
        }
    }

    private void write(IFolder folder, boolean force, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable operation = pm -> this.getLocalManager().write(folder, force, monitor);
        ResourcesPlugin.getWorkspace().run(operation, monitor);
    }

    private FileSystemResourceManager getLocalManager() {
        return ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager();
    }

    static class WriteFileContents
    implements IWorkspaceRunnable {
        private final IFile file;
        private final InputStream contents;
        private final boolean force;
        private final FileSystemResourceManager localManager;

        WriteFileContents(IFile file, InputStream contents, boolean force, FileSystemResourceManager localManager) {
            this.file = file;
            Assert.assertNotNull((String)"file cannot be null", (Object)file);
            this.contents = contents;
            Assert.assertNotNull((String)"contents cannot be null", (Object)contents);
            this.force = force;
            this.localManager = localManager;
            Assert.assertNotNull((String)"file system resource manager cannot be null", (Object)localManager);
        }

        public void run(IProgressMonitor jobMonitor) throws CoreException {
            int flags = this.force ? 1 : 0;
            IFileStore store = ((Resource)this.file).getStore();
            Assert.assertNotNull((String)"file store cannot be null", (Object)store);
            IFileInfo info = store.fetchInfo();
            Assert.assertNotNull((String)("file info cannot be null for file " + String.valueOf(this.file)), (Object)info);
            this.localManager.write(this.file, this.contents, info, flags, false, jobMonitor);
        }
    }
}

