/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.HistoryBucket;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class HistoryBucketTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Test
    public void testDuplicates() throws CoreException {
        IPath baseLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(baseLocation);
        HistoryBucket index1 = new HistoryBucket();
        IPath location1 = baseLocation.append("location1");
        index1.load("foo", location1.toFile());
        IPath path = IPath.fromOSString((String)"/foo/bar");
        UniversalUniqueIdentifier uuid = new UniversalUniqueIdentifier();
        long lastModified = (long)(Math.random() * 9.223372036854776E18);
        index1.addBlob(path, uuid, lastModified);
        Assert.assertEquals((long)1L, (long)index1.getEntryCount());
        index1.addBlob(path, uuid, lastModified);
        Assert.assertEquals((long)1L, (long)index1.getEntryCount());
        HistoryBucket.HistoryEntry entry = index1.getEntry(path);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)path, (Object)entry.getPath());
        Assert.assertEquals((long)1L, (long)entry.getOccurrences());
        Assert.assertEquals((Object)uuid, (Object)entry.getUUID(0));
        Assert.assertEquals((long)lastModified, (long)entry.getTimestamp(0));
    }

    @Test
    public void testPersistence() throws CoreException {
        IPath baseLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(baseLocation);
        HistoryBucket index1 = new HistoryBucket();
        IPath location = baseLocation.append("location");
        index1.load("foo", location.toFile());
        Assert.assertEquals((long)0L, (long)index1.getEntryCount());
        IPath path = IPath.fromOSString((String)"/foo/bar");
        UniversalUniqueIdentifier uuid1 = new UniversalUniqueIdentifier();
        long lastModified1 = (long)(Math.random() * 9.223372036854776E18);
        index1.addBlob(path, uuid1, lastModified1);
        Assert.assertEquals((long)1L, (long)index1.getEntryCount());
        index1.save();
        HistoryBucket index2 = new HistoryBucket();
        index2.load("foo", location.toFile(), false);
        Assert.assertEquals((long)1L, (long)index1.getEntryCount());
        HistoryBucket.HistoryEntry entry = index1.getEntry(path);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)path, (Object)entry.getPath());
        Assert.assertEquals((long)1L, (long)entry.getOccurrences());
        Assert.assertEquals((Object)uuid1, (Object)entry.getUUID(0));
        Assert.assertEquals((long)lastModified1, (long)entry.getTimestamp(0));
        UniversalUniqueIdentifier uuid2 = new UniversalUniqueIdentifier();
        long lastModified2 = (long)Math.abs(Math.random() * 9.223372036854776E18);
        index2.addBlob(path, uuid2, lastModified2);
        index2.save();
        index1.load("foo", location.toFile(), true);
        Assert.assertEquals((long)1L, (long)index1.getEntryCount());
        entry = index1.getEntry(path);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)path, (Object)entry.getPath());
        Assert.assertEquals((long)2L, (long)entry.getOccurrences());
        index1.accept(new Bucket.Visitor(){

            public int visit(Bucket.Entry fileEntry) {
                fileEntry.delete();
                return 0;
            }
        }, path, 0);
        entry = index1.getEntry(path);
        Assert.assertNull((Object)entry);
        index2.load("foo", location.toFile(), true);
        entry = index2.getEntry(path);
        Assert.assertNull((Object)entry);
    }

    @Test
    public void testSort() {
        HistoryBucket index = new HistoryBucket();
        IPath path = IPath.fromOSString((String)"/foo");
        Assert.assertNull((Object)index.getEntry(path));
        UniversalUniqueIdentifier uuid1 = new UniversalUniqueIdentifier();
        long timestamp1 = 10L;
        index.addBlob(path, uuid1, timestamp1);
        HistoryBucket.HistoryEntry entry = index.getEntry(path);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)1L, (long)entry.getOccurrences());
        Assert.assertEquals((Object)uuid1, (Object)entry.getUUID(0));
        Assert.assertEquals((long)timestamp1, (long)entry.getTimestamp(0));
        UniversalUniqueIdentifier uuid2 = new UniversalUniqueIdentifier();
        long timestamp2 = timestamp1 + 1L;
        index.addBlob(path, uuid2, timestamp2);
        entry = index.getEntry(path);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)2L, (long)entry.getOccurrences());
        Assert.assertEquals((Object)uuid2, (Object)entry.getUUID(0));
        Assert.assertEquals((long)timestamp2, (long)entry.getTimestamp(0));
        Assert.assertEquals((Object)uuid1, (Object)entry.getUUID(1));
        Assert.assertEquals((long)timestamp1, (long)entry.getTimestamp(1));
        UniversalUniqueIdentifier uuid3 = new UniversalUniqueIdentifier();
        long timestamp3 = timestamp1;
        index.addBlob(path, uuid3, timestamp3);
        entry = index.getEntry(path);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)3L, (long)entry.getOccurrences());
        Assert.assertEquals((Object)uuid2, (Object)entry.getUUID(0));
        Assert.assertEquals((long)timestamp2, (long)entry.getTimestamp(0));
        Assert.assertEquals((Object)uuid3, (Object)entry.getUUID(1));
        Assert.assertEquals((long)timestamp3, (long)entry.getTimestamp(1));
        Assert.assertEquals((Object)uuid1, (Object)entry.getUUID(2));
        Assert.assertEquals((long)timestamp1, (long)entry.getTimestamp(2));
    }
}

