/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractInputStreamAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.FileState;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class HistoryStoreTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    public static void assertFileStateEquals(String tag, IFileState expected, IFileState actual) {
        Assert.assertEquals((String)(tag + " path differs"), (Object)expected.getFullPath(), (Object)actual.getFullPath());
        Assert.assertEquals((String)(tag + " timestamp differs"), (long)expected.getModificationTime(), (long)actual.getModificationTime());
        Assert.assertEquals((String)(tag + " uuid differs"), (Object)((FileState)expected).getUUID(), (Object)((FileState)actual).getUUID());
    }

    public static void wipeHistoryStore(IProgressMonitor monitor) {
        IHistoryStore store = ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager().getHistoryStore();
        store.remove(IPath.ROOT, monitor);
        store.removeGarbage();
    }

    private int numBytes(InputStream input) {
        int i = 0;
        int c = -1;
        try {
            c = input.read();
            while (c != -1) {
                ++i;
                c = input.read();
            }
        }
        catch (IOException e) {
            i = 0;
        }
        if (c != -1) {
            i = 0;
        }
        return i;
    }

    public IWorkspaceDescription setMaxFileStates(int maxFileStates) throws CoreException {
        IWorkspaceDescription currentDescription = ResourcesPlugin.getWorkspace().getDescription();
        IWorkspaceDescription newDescription = ResourcesPlugin.getWorkspace().getDescription();
        newDescription.setMaxFileStates(maxFileStates);
        ResourcesPlugin.getWorkspace().setDescription(newDescription);
        return currentDescription;
    }

    @After
    public void tearDown() throws Exception {
        HistoryStoreTest.wipeHistoryStore(ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testAddStateAndPolicies() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("file.txt");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(5);
        description.setMaxFileStateSize(0x100000L);
        ResourcesPlugin.getWorkspace().setDescription(description);
        int i = 0;
        while (i < 8) {
            ResourceTestUtil.ensureOutOfSync(file);
            file.refreshLocal(0, ResourceTestUtil.createTestMonitor());
            file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
            ++i;
        }
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(8);
        Object[] oldStates = states;
        ResourcesPlugin.getWorkspace().save(true, null);
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(description.getMaxFileStates());
        long lastModified = states[0].getModificationTime();
        int i2 = 1;
        while (i2 < states.length) {
            Assert.assertTrue((String)("1.3." + i2), (lastModified >= states[i2].getModificationTime() ? 1 : 0) != 0);
            lastModified = states[i2].getModificationTime();
            ++i2;
        }
        i2 = 0;
        while (i2 < states.length) {
            HistoryStoreTest.assertFileStateEquals("1.4." + i2, (IFileState)oldStates[i2], (IFileState)states[i2]);
            ++i2;
        }
        description.setMaxFileStates(15);
        description.setMaxFileStateSize(7L);
        ResourcesPlugin.getWorkspace().setDescription(description);
        file = project.getFile("file1.txt");
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, ResourceTestUtil.createTestMonitor());
        i2 = 0;
        while (i2 < 10) {
            file.appendContents(ResourceTestUtil.createInputStream("a"), true, true, ResourceTestUtil.createTestMonitor());
            ++i2;
        }
        ResourcesPlugin.getWorkspace().save(true, null);
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        i2 = 0;
        while (i2 < states.length) {
            int bytesRead = this.numBytes(states[i2].getContents());
            Assert.assertTrue((String)("2.2." + i2), ((long)bytesRead <= description.getMaxFileStateSize() ? 1 : 0) != 0);
            ++i2;
        }
        file = project.getFile("file.txt");
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(5);
        description.setMaxFileStateSize(0x100000L);
        ResourcesPlugin.getWorkspace().setDescription(description);
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(description.getMaxFileStates());
        description.setFileStateLongevity(10000L);
        description.setMaxFileStateSize(0x100000L);
        ResourcesPlugin.getWorkspace().setDescription(description);
        Thread.sleep(12000L);
        ResourcesPlugin.getWorkspace().save(true, null);
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).isEmpty();
    }

    @Test
    public void testBug28238() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("myproject28238");
        IFolder folder = project.getFolder("myfolder");
        IFolder destinationFolder = project.getFolder("myfolder2");
        IFile file = folder.getFile("myfile.txt");
        IFile destinationFile = destinationFolder.getFile(file.getName());
        IHistoryStore store = ((Resource)ResourcesPlugin.getWorkspace().getRoot()).getLocalManager().getHistoryStore();
        IFileStore fileStore = this.workspaceRule.getTempStore();
        ResourceTestUtil.createInFileSystem(fileStore);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])store.getStates(file.getFullPath(), ResourceTestUtil.createTestMonitor())).as("check file has no state", new Object[0])).isEmpty();
        FileInfo fileInfo = new FileInfo(file.getName());
        fileInfo.setLastModified(System.currentTimeMillis());
        store.addState(file.getFullPath(), fileStore, (IFileInfo)fileInfo, true);
        Object[] states = store.getStates(file.getFullPath(), ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(1);
        store.copyHistory((IResource)folder, (IResource)destinationFolder, true);
        states = store.getStates(destinationFile.getFullPath(), ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(1);
    }

    @Test
    public void testBug28603() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("myproject28603");
        IFolder folder1 = project.getFolder("myfolder1");
        IFolder folder2 = project.getFolder("myfolder2");
        IFile file1 = folder1.getFile("myfile.txt");
        IFile file2 = folder2.getFile(file1.getName());
        ResourceTestUtil.createInWorkspace(new IResource[]{project, folder1, folder2});
        file1.create(ResourceTestUtil.createRandomContentsStream(), 1, ResourceTestUtil.createTestMonitor());
        file1.setContents(ResourceTestUtil.createRandomContentsStream(), 3, ResourceTestUtil.createTestMonitor());
        file1.setContents(ResourceTestUtil.createRandomContentsStream(), 3, ResourceTestUtil.createTestMonitor());
        file1.setContents(ResourceTestUtil.createRandomContentsStream(), 3, ResourceTestUtil.createTestMonitor());
        this.setMaxFileStates(50);
        int maxStates = ResourcesPlugin.getWorkspace().getDescription().getMaxFileStates();
        Object[] states = file1.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        int currentStates = 3;
        ((ObjectArrayAssert)Assertions.assertThat((Object[])file2.getHistory(ResourceTestUtil.createTestMonitor())).as("check file2 has no history", new Object[0])).isEmpty();
        int i = 0;
        while (i < maxStates + 10) {
            states = file1.getHistory(ResourceTestUtil.createTestMonitor());
            ((ObjectArrayAssert)Assertions.assertThat((Object[])states).as(i + " file1 states", new Object[0])).hasSize(currentStates);
            file1.move(file2.getFullPath(), true, true, ResourceTestUtil.createTestMonitor());
            states = file2.getHistory(ResourceTestUtil.createTestMonitor());
            currentStates = currentStates < maxStates ? currentStates + 1 : maxStates;
            ((ObjectArrayAssert)Assertions.assertThat((Object[])states).as(i + " file2 states", new Object[0])).hasSize(currentStates);
            file2.move(file1.getFullPath(), true, true, ResourceTestUtil.createTestMonitor());
            states = file1.getHistory(ResourceTestUtil.createTestMonitor());
            currentStates = currentStates < maxStates ? currentStates + 1 : maxStates;
            ((ObjectArrayAssert)Assertions.assertThat((Object[])states).as(i + " file1 states", new Object[0])).hasSize(currentStates);
            ++i;
        }
    }

    @Test
    public void testClean() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("ProjectClean");
        IFile file = project.getFile("file.txt");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        IHistoryStore store = ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager().getHistoryStore();
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(500);
        description.setMaxFileStateSize(0x100000L);
        ResourcesPlugin.getWorkspace().setDescription(description);
        int i = 0;
        while (i < 8) {
            ResourceTestUtil.ensureOutOfSync(file);
            file.refreshLocal(0, ResourceTestUtil.createTestMonitor());
            file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
            ++i;
        }
        long[] oldLastModTimes = new long[8];
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(8);
        int i2 = 0;
        while (i2 < 8) {
            oldLastModTimes[i2] = states[i2].getModificationTime();
            ++i2;
        }
        description.setMaxFileStates(3);
        ResourcesPlugin.getWorkspace().setDescription(description);
        store.clean(ResourceTestUtil.createTestMonitor());
        description.setMaxFileStates(500);
        ResourcesPlugin.getWorkspace().setDescription(description);
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        long lastModified = states[0].getModificationTime();
        int i3 = 1;
        while (i3 < states.length) {
            Assert.assertTrue((String)("2.4." + i3), (lastModified >= states[i3].getModificationTime() ? 1 : 0) != 0);
            lastModified = states[i3].getModificationTime();
            ++i3;
        }
        i3 = 0;
        while (i3 < states.length) {
            Assert.assertTrue((String)("2.5." + i3), (oldLastModTimes[i3] == states[i3].getModificationTime() ? 1 : 0) != 0);
            ++i3;
        }
        file = project.getFile("file.txt");
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(500);
        description.setMaxFileStateSize(0x100000L);
        ResourcesPlugin.getWorkspace().setDescription(description);
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        description.setFileStateLongevity(10000L);
        description.setMaxFileStateSize(0x100000L);
        ResourcesPlugin.getWorkspace().setDescription(description);
        Thread.sleep(12000L);
        store.clean(ResourceTestUtil.createTestMonitor());
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStateSize(0x100000L);
        ResourcesPlugin.getWorkspace().setDescription(description);
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).isEmpty();
    }

    @Test
    public void testCopyFolder() throws Exception {
        String[] contents = new String[]{"content1", "content2", "content3", "content4", "content5"};
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("CopyFolderProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFile file = project.getFile("file1.txt");
        IFolder folder = project.getFolder("folder1");
        IFolder folder2 = project.getFolder("folder2");
        file = folder.getFile("file1.txt");
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createInputStream(contents[0]), true, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createInputStream(contents[1]), true, true, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createInputStream(contents[2]), true, true, ResourceTestUtil.createTestMonitor());
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[0]);
        }});
        folder.copy(folder2.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        IFile file2 = folder2.getFile("file1.txt");
        Assert.assertTrue((String)"1.3", (boolean)file2.getFullPath().toString().endsWith("folder2/file1.txt"));
        file2.setContents(ResourceTestUtil.createInputStream(contents[3]), true, true, ResourceTestUtil.createTestMonitor());
        file2.setContents(ResourceTestUtil.createInputStream(contents[4]), true, true, ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[0]);
        }});
        states = file2.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(4)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[3]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[2]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[1]);
        }, fourth -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)fourth.getContents()).hasContent(contents[0]);
        }});
        project.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testCopyHistoryFile() throws Exception {
        String[] contents = new String[]{"content0", "content1", "content2", "content3", "content4"};
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("TestCopyHistoryProject");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFolder folder = project.getFolder("folder1");
        IFile file = folder.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createInputStream(contents[0]), true, ResourceTestUtil.createTestMonitor());
        Thread.sleep(1000L);
        file.setContents(ResourceTestUtil.createInputStream(contents[1]), true, true, ResourceTestUtil.createTestMonitor());
        Thread.sleep(1000L);
        file.setContents(ResourceTestUtil.createInputStream(contents[2]), true, true, ResourceTestUtil.createTestMonitor());
        Thread.sleep(1000L);
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[0]);
        }});
        file2.create(ResourceTestUtil.createInputStream(contents[3]), true, ResourceTestUtil.createTestMonitor());
        file2.setContents(ResourceTestUtil.createInputStream(contents[4]), true, true, ResourceTestUtil.createTestMonitor());
        LogListenerVerifier verifier = new LogListenerVerifier();
        ILog log = ResourcesPlugin.getPlugin().getLog();
        log.addLogListener((ILogListener)verifier);
        IHistoryStore store = ((Resource)file).getLocalManager().getHistoryStore();
        verifier.addExpected(566);
        store.copyHistory(null, null, false);
        verifier.verify();
        verifier.reset();
        verifier.addExpected(566);
        store.copyHistory(null, (IResource)file2, false);
        verifier.verify();
        verifier.reset();
        verifier.addExpected(566);
        store.copyHistory((IResource)file, null, false);
        verifier.verify();
        verifier.reset();
        verifier.addExpected(566);
        store.copyHistory((IResource)file, (IResource)file, false);
        verifier.verify();
        verifier.reset();
        log.removeLogListener((ILogListener)verifier);
        store.copyHistory((IResource)file, (IResource)file2, false);
        states = file2.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(3)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[3]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[1]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[0]);
        }});
    }

    @Test
    public void testCopyHistoryFolder() throws Exception {
        String[] contents = new String[]{"content0", "content1", "content2", "content3", "content4"};
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("TestCopyHistoryProject");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFolder folder = project.getFolder("folder1");
        IFolder folder2 = project.getFolder("folder2");
        IFile file = folder.getFile("file1.txt");
        IFile file2 = folder2.getFile("file1.txt");
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createInputStream(contents[0]), true, ResourceTestUtil.createTestMonitor());
        Thread.sleep(1000L);
        file.setContents(ResourceTestUtil.createInputStream(contents[1]), true, true, ResourceTestUtil.createTestMonitor());
        Thread.sleep(1000L);
        file.setContents(ResourceTestUtil.createInputStream(contents[2]), true, true, ResourceTestUtil.createTestMonitor());
        Thread.sleep(1000L);
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[0]);
        }});
        folder2.create(true, true, ResourceTestUtil.createTestMonitor());
        file2.create(ResourceTestUtil.createInputStream(contents[3]), true, ResourceTestUtil.createTestMonitor());
        file2.setContents(ResourceTestUtil.createInputStream(contents[4]), true, true, ResourceTestUtil.createTestMonitor());
        IHistoryStore store = ((Resource)file).getLocalManager().getHistoryStore();
        store.copyHistory((IResource)folder, (IResource)folder2, false);
        states = file2.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(3)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[3]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[1]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[0]);
        }});
    }

    @Test
    public void testCopyHistoryProject() throws Exception {
        String[] contents = new String[]{"content0", "content1", "content2", "content3", "content4"};
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("TestCopyHistoryProject");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("TestCopyHistoryProject2");
        ResourceTestUtil.createInWorkspace(new IResource[]{project, project2});
        IFolder folder = project.getFolder("folder1");
        IFolder folder2 = project2.getFolder("folder1");
        IFile file = folder.getFile("file1.txt");
        IFile file2 = folder2.getFile("file1.txt");
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createInputStream(contents[0]), true, ResourceTestUtil.createTestMonitor());
        Thread.sleep(1000L);
        file.setContents(ResourceTestUtil.createInputStream(contents[1]), true, true, ResourceTestUtil.createTestMonitor());
        Thread.sleep(1000L);
        file.setContents(ResourceTestUtil.createInputStream(contents[2]), true, true, ResourceTestUtil.createTestMonitor());
        Thread.sleep(1000L);
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[0]);
        }});
        folder2.create(true, true, ResourceTestUtil.createTestMonitor());
        file2.create(ResourceTestUtil.createInputStream(contents[3]), true, ResourceTestUtil.createTestMonitor());
        file2.setContents(ResourceTestUtil.createInputStream(contents[4]), true, true, ResourceTestUtil.createTestMonitor());
        IHistoryStore store = ((Resource)file).getLocalManager().getHistoryStore();
        store.copyHistory((IResource)project, (IResource)project2, false);
        states = file2.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(3)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[3]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[1]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[0]);
        }});
    }

    @Test
    public void testDelete() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFile file = project.getFile("file.txt");
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(2);
        file.delete(true, true, ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        IFolder folder = project.getFolder("folder");
        file = folder.getFile("file2.txt");
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(2);
        folder.delete(true, true, ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(3);
        project.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testExists() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("removeAllStatesFile.txt");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        int ITERATIONS = 20;
        int i = 0;
        while (i < 20) {
            file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
            ++i;
        }
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(20);
        Object[] objectArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            Object state = objectArray[n2];
            Assertions.assertThat((Object)state).matches(IFileState::exists, "exists");
            ++n2;
        }
    }

    @Test
    public void testFindDeleted() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        IFile pfile = project.getFile("findDeletedFile.txt");
        pfile.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        pfile.delete(true, true, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{pfile});
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{pfile});
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{pfile});
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        pfile.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        project.delete(true, ResourceTestUtil.createTestMonitor());
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("filex.txt");
        IFile folderAsFile = project.getFile(folder.getProjectRelativePath());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file.delete(true, true, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{file});
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        folder.delete(true, true, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{file});
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        folderAsFile.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        folderAsFile.delete(true, true, ResourceTestUtil.createTestMonitor());
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])folder.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).containsExactly((Object[])new IFile[]{folderAsFile});
        Assertions.assertThat((Object[])folder.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).containsExactlyInAnyOrder((Object[])new IFile[]{file, folderAsFile});
        Assertions.assertThat((Object[])folder.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactlyInAnyOrder((Object[])new IFile[]{file, folderAsFile});
        project.delete(true, ResourceTestUtil.createTestMonitor());
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        folder = project.getFolder("folder");
        IFile file1 = folder.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        IFolder folder2 = folder.getFolder("folder2");
        IFile file3 = folder2.getFile("file3.txt");
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        folder2.create(true, true, ResourceTestUtil.createTestMonitor());
        file1.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file2.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        file3.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        folder.delete(true, true, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactlyInAnyOrder((Object[])new IFile[]{file1, file2, file3});
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).containsExactlyInAnyOrder((Object[])new IFile[]{file1, file2, file3});
        Assertions.assertThat((Object[])folder.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])folder.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).hasSize(2);
        Assertions.assertThat((Object[])folder.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).hasSize(3);
        Assertions.assertThat((Object[])folder2.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])folder2.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).hasSize(1);
        Assertions.assertThat((Object[])folder2.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).hasSize(1);
        project.delete(true, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])root.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])project.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])folder.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])folder.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])folder.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])folder2.findDeletedMembersWithHistory(0, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])folder2.findDeletedMembersWithHistory(1, ResourceTestUtil.createTestMonitor())).isEmpty();
        Assertions.assertThat((Object[])folder2.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor())).isEmpty();
    }

    @Test
    public void testGetContents() throws Throwable {
        DataInputStream inContents;
        Object var15_27;
        Throwable throwable;
        DataInputStream inFile;
        FileOutputStream output;
        Object var12_18;
        Throwable throwable2;
        FileInfo fileInfo;
        int ITERATIONS = 20;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFile file = project.getFile("getContentsFile.txt");
        String contents = "This file has some contents in testGetContents.";
        ResourceTestUtil.createInWorkspace(file, contents);
        IFile secondValidFile = project.getFile("secondGetContentsFile.txt");
        contents = "A file with some other contents in testGetContents.";
        ResourceTestUtil.createInWorkspace(secondValidFile, contents);
        IHistoryStore historyStore = ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager().getHistoryStore();
        long myLong = 0L;
        int i = 0;
        while (i < 20) {
            fileInfo = new FileInfo(file.getName());
            fileInfo.setLastModified(myLong);
            historyStore.addState(file.getFullPath(), ((Resource)file).getStore(), (IFileInfo)fileInfo, true);
            contents = "This file has some contents in testGetContents.";
            throwable2 = null;
            var12_18 = null;
            try {
                output = new FileOutputStream(file.getLocation().toFile());
                try {
                    ResourceTestUtil.createInputStream(contents).transferTo(output);
                }
                finally {
                    if (output != null) {
                        output.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            file.refreshLocal(2, null);
            ++i;
            ++myLong;
        }
        i = 0;
        while (i < 20) {
            fileInfo = new FileInfo(file.getName());
            fileInfo.setLastModified(myLong);
            historyStore.addState(secondValidFile.getFullPath(), ((Resource)secondValidFile).getStore(), (IFileInfo)fileInfo, true);
            contents = "A file with some other contents in testGetContents.";
            throwable2 = null;
            var12_18 = null;
            try {
                output = new FileOutputStream(secondValidFile.getLocation().toFile());
                try {
                    ResourceTestUtil.createInputStream(contents).transferTo(output);
                }
                finally {
                    if (output != null) {
                        output.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            secondValidFile.refreshLocal(2, null);
            ++i;
            ++myLong;
        }
        IFileState[] stateArray = historyStore.getStates(file.getFullPath(), ResourceTestUtil.createTestMonitor());
        int i2 = 0;
        while (i2 < stateArray.length) {
            throwable2 = null;
            var12_18 = null;
            try {
                inFile = new DataInputStream(file.getContents(false));
                try {
                    throwable = null;
                    var15_27 = null;
                    try {
                        inContents = new DataInputStream(historyStore.getContents(stateArray[i2]));
                        try {
                            ((AbstractInputStreamAssert)Assertions.assertThat((InputStream)inFile).as("match history state " + i2, new Object[0])).hasSameContentAs((InputStream)inContents);
                        }
                        finally {
                            if (inContents != null) {
                                inContents.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                finally {
                    if (inFile != null) {
                        inFile.close();
                    }
                }
            }
            catch (Throwable throwable6) {
                if (throwable2 == null) {
                    throwable2 = throwable6;
                } else if (throwable2 != throwable6) {
                    throwable2.addSuppressed(throwable6);
                }
                throw throwable2;
            }
            ++i2;
            ++myLong;
        }
        stateArray = historyStore.getStates(secondValidFile.getFullPath(), ResourceTestUtil.createTestMonitor());
        i2 = 0;
        while (i2 < stateArray.length) {
            throwable2 = null;
            var12_18 = null;
            try {
                inFile = new DataInputStream(secondValidFile.getContents(false));
                try {
                    throwable = null;
                    var15_27 = null;
                    try {
                        inContents = new DataInputStream(historyStore.getContents(stateArray[i2]));
                        try {
                            ((AbstractInputStreamAssert)Assertions.assertThat((InputStream)inFile).as("match history state " + i2, new Object[0])).hasSameContentAs((InputStream)inContents);
                        }
                        finally {
                            if (inContents != null) {
                                inContents.close();
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable == null) {
                            throwable = throwable7;
                        } else if (throwable != throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        throw throwable;
                    }
                }
                finally {
                    if (inFile != null) {
                        inFile.close();
                    }
                }
            }
            catch (Throwable throwable8) {
                if (throwable2 == null) {
                    throwable2 = throwable8;
                } else if (throwable2 != throwable8) {
                    throwable2.addSuppressed(throwable8);
                }
                throw throwable2;
            }
            ++i2;
            ++myLong;
        }
        i2 = 0;
        while (i2 < 20) {
            long immutableValue = myLong;
            Assert.assertThrows(CoreException.class, () -> {
                InputStream inputStream = historyStore.getContents((IFileState)new FileState(historyStore, IPath.ROOT, immutableValue, new UniversalUniqueIdentifier()));
            });
            ++i2;
        }
        i2 = 0;
        while (i2 < 20) {
            Assert.assertThrows(RuntimeException.class, () -> {
                InputStream inputStream = historyStore.getContents(null);
            });
            ++i2;
        }
    }

    @Test
    public void testModifiedStamp() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFile file = project.getFile("file");
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        Object[] history = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])history).isEmpty();
        long fileTimeStamp = file.getLocalTimeStamp();
        file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
        history = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])history).hasSize(1);
        Assertions.assertThat((long)history[0].getModificationTime()).isEqualByComparingTo((Comparable)Long.valueOf(fileTimeStamp));
    }

    @Test
    public void testMoveFolder() throws Exception {
        String[] contents = new String[]{"content1", "content2", "content3", "content4", "content5"};
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFile file = project.getFile("file1.txt");
        IFolder folder = project.getFolder("folder1");
        IFolder folder2 = project.getFolder("folder2");
        file = folder.getFile("file1.txt");
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createInputStream(contents[0]), true, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createInputStream(contents[1]), true, true, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createInputStream(contents[2]), true, true, ResourceTestUtil.createTestMonitor());
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[0]);
        }});
        folder.move(folder2.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        IFile file2 = folder2.getFile("file1.txt");
        Assert.assertTrue((String)"1.3", (boolean)file2.getFullPath().toString().endsWith("folder2/file1.txt"));
        file2.setContents(ResourceTestUtil.createInputStream(contents[3]), true, true, ResourceTestUtil.createTestMonitor());
        file2.setContents(ResourceTestUtil.createInputStream(contents[4]), true, true, ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[0]);
        }});
        states = file2.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(4)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[3]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[2]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[1]);
        }, fourth -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)fourth.getContents()).hasContent(contents[0]);
        }});
        project.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testMoveProject() throws Exception {
        String[] contents = new String[]{"content1", "content2", "content3", "content4", "content5"};
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MoveProjectProject");
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("SecondMoveProjectProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFile file = project.getFile("file1.txt");
        IFolder folder = project.getFolder("folder1");
        file = folder.getFile("file1.txt");
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createInputStream(contents[0]), true, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createInputStream(contents[1]), true, true, ResourceTestUtil.createTestMonitor());
        file.setContents(ResourceTestUtil.createInputStream(contents[2]), true, true, ResourceTestUtil.createTestMonitor());
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[0]);
        }});
        project.move(IPath.fromOSString((String)"SecondMoveProjectProject"), true, ResourceTestUtil.createTestMonitor());
        IFile file2 = project2.getFile("folder1/file1.txt");
        Assert.assertTrue((String)"1.3", (boolean)file2.getFullPath().toString().endsWith("SecondMoveProjectProject/folder1/file1.txt"));
        file2.setContents(ResourceTestUtil.createInputStream(contents[3]), true, true, ResourceTestUtil.createTestMonitor());
        file2.setContents(ResourceTestUtil.createInputStream(contents[4]), true, true, ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).isEmpty();
        states = file2.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(4)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[3]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[2]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[1]);
        }, fourth -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)fourth.getContents()).hasContent(contents[0]);
        }});
        project.delete(true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testRemoveAll() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("removeAllStatesFile.txt");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        int ITERATIONS = 20;
        int i = 0;
        while (i < 20) {
            file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
            ++i;
        }
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(20);
        file.clearHistory(ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).isEmpty();
        IFolder folder = project.getFolder("folder");
        IFile anotherOne = folder.getFile("anotherOne");
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        anotherOne.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        int i2 = 0;
        while (i2 < 20) {
            file.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
            anotherOne.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
            ++i2;
        }
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(20);
        states = anotherOne.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(20);
        project.clearHistory(ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).isEmpty();
        states = anotherOne.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).isEmpty();
        IFile aaa = project.getFile("aaa");
        IFolder bbb = project.getFolder("bbb");
        anotherOne = bbb.getFile("anotherOne");
        IFile ccc = project.getFile("ccc");
        bbb.create(true, true, ResourceTestUtil.createTestMonitor());
        anotherOne.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        aaa.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        ccc.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        int i3 = 0;
        while (i3 < 20) {
            anotherOne.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
            aaa.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
            ccc.setContents(ResourceTestUtil.createRandomContentsStream(), true, true, ResourceTestUtil.createTestMonitor());
            ++i3;
        }
        states = anotherOne.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(20);
        states = aaa.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(20);
        states = ccc.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(20);
        bbb.clearHistory(ResourceTestUtil.createTestMonitor());
        states = anotherOne.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).isEmpty();
        states = aaa.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(20);
        states = ccc.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])states).hasSize(20);
    }

    @Test
    public void testSimpleCopy() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("SimpleCopyProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        String[] contents = new String[]{"content1", "content2", "content3", "content4", "content5"};
        IFile file = project.getFile("simpleCopyFileWithHistoryCopy");
        IFile copyFile = project.getFile("copyOfSimpleCopyFileWithHistoryCopy");
        file.create(ResourceTestUtil.createInputStream(contents[0]), true, null);
        file.setContents(ResourceTestUtil.createInputStream(contents[1]), true, true, null);
        file.setContents(ResourceTestUtil.createInputStream(contents[2]), true, true, null);
        file.copy(copyFile.getFullPath(), true, null);
        Object[] states = file.getHistory(null);
        Assertions.assertThat((Object[])states).hasSize(2);
        states = copyFile.getHistory(null);
        Assertions.assertThat((Object[])states).hasSize(2);
        copyFile.setContents(ResourceTestUtil.createInputStream(contents[3]), true, true, null);
        copyFile.setContents(ResourceTestUtil.createInputStream(contents[4]), true, true, null);
        states = file.getHistory(null);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[0]);
        }});
        states = copyFile.getHistory(null);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(4)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[3]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[2]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[1]);
        }, fourth -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)fourth.getContents()).hasContent(contents[0]);
        }});
    }

    @Test
    public void testSimpleMove() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("SimpleMoveProject");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        String[] contents = new String[]{"content1", "content2", "content3", "content4", "content5"};
        IFile file = project.getFile("simpleMoveFileWithCopy");
        IFile moveFile = project.getFile("copyOfSimpleMoveFileWithCopy");
        file.create(ResourceTestUtil.createInputStream(contents[0]), true, null);
        file.setContents(ResourceTestUtil.createInputStream(contents[1]), true, true, null);
        file.setContents(ResourceTestUtil.createInputStream(contents[2]), true, true, null);
        file.move(moveFile.getFullPath(), true, null);
        Object[] states = file.getHistory(null);
        Assertions.assertThat((Object[])states).hasSize(2);
        states = moveFile.getHistory(null);
        Assertions.assertThat((Object[])states).hasSize(2);
        moveFile.setContents(ResourceTestUtil.createInputStream(contents[3]), true, true, null);
        moveFile.setContents(ResourceTestUtil.createInputStream(contents[4]), true, true, null);
        states = file.getHistory(null);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[0]);
        }});
        states = moveFile.getHistory(null);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(4)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[3]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[2]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[1]);
        }, fourth -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)fourth.getContents()).hasContent(contents[0]);
        }});
    }

    @Test
    public void testSimpleUse() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        String[] contents = new String[]{"content1", "content2", "content3"};
        IFile file = project.getFile("file");
        file.create(ResourceTestUtil.createInputStream(contents[0]), true, ResourceTestUtil.createTestMonitor());
        int i = 0;
        while (i < 2) {
            file.setContents(ResourceTestUtil.createInputStream(contents[i + 1]), true, true, ResourceTestUtil.createTestMonitor());
            ++i;
        }
        Object[] states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[0]);
        }});
        file.delete(true, true, ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(3)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[2]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[1]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[0]);
        }});
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        file.create(states[0].getContents(), false, ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(3)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[2]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[1]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[0]);
        }});
        Assertions.assertThat((InputStream)file.getContents(false)).hasContent(contents[2]);
        file.setContents(ResourceTestUtil.createInputStream(contents[1]), true, true, null);
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(4)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[2]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[2]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[1]);
        }, fourth -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)fourth.getContents()).hasContent(contents[0]);
        }});
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        file.setContents((IFileState)states[2], true, true, ResourceTestUtil.createTestMonitor());
        states = file.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])states).hasSize(5)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)first.getContents()).hasContent(contents[1]);
        }, second -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)second.getContents()).hasContent(contents[2]);
        }, third -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)third.getContents()).hasContent(contents[2]);
        }, fourth -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)fourth.getContents()).hasContent(contents[1]);
        }, fifth -> {
            AbstractInputStreamAssert abstractInputStreamAssert = Assertions.assertThat((InputStream)fifth.getContents()).hasContent(contents[0]);
        }});
        Assertions.assertThat((InputStream)file.getContents(false)).hasContent(contents[1]);
    }

    static class LogListenerVerifier
    implements ILogListener {
        List<Integer> actual = new ArrayList<Integer>();
        List<Integer> expected = new ArrayList<Integer>();

        LogListenerVerifier() {
        }

        void addExpected(int statusCode) {
            this.expected.add(statusCode);
        }

        String dump() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Expected:\n");
            for (Integer integer : this.expected) {
                buffer.append("\t" + String.valueOf(integer) + "\n");
            }
            buffer.append("Actual:\n");
            for (Integer integer : this.actual) {
                buffer.append("\t" + String.valueOf(integer) + "\n");
            }
            return buffer.toString();
        }

        public void logging(IStatus status, String plugin) {
            this.actual.add(status.getCode());
        }

        void reset() {
            this.expected = new ArrayList<Integer>();
            this.actual = new ArrayList<Integer>();
        }

        void verify() throws VerificationFailedException {
            if (this.expected.size() != this.actual.size()) {
                String message = "Expected size: " + this.expected.size() + " does not equal actual size: " + this.actual.size() + "\n";
                message = message + this.dump();
                throw new VerificationFailedException(message);
            }
            for (Integer status : this.expected) {
                if (this.actual.contains(status)) continue;
                Object message = "Expected and actual results differ.\n";
                message = (String)message + this.dump();
                throw new VerificationFailedException((String)message);
            }
        }
    }

    static class VerificationFailedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        VerificationFailedException(String message) {
            super(message);
        }
    }
}

