/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;

public final class LocalStoreTestUtil {
    public static void createTree(IFileStore[] tree) throws CoreException, IOException {
        LocalStoreTestUtil.createTree(tree, 20);
    }

    public static void createTree(IFileStore[] tree, int fileSize) throws CoreException, IOException {
        IFileStore[] iFileStoreArray = tree;
        int n = tree.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore element = iFileStoreArray[n2];
            LocalStoreTestUtil.createNode(element, fileSize);
            ++n2;
        }
    }

    private static void createNode(IFileStore node, int fileSize) throws CoreException, IOException {
        char type = node.getName().charAt(0);
        if (type == 'd') {
            node.mkdir(0, null);
        } else {
            ResourceTestUtil.createInFileSystem(node, fileSize);
        }
    }

    public static IFileStore[] getTree(IFileStore root) {
        return LocalStoreTestUtil.getTree(root, LocalStoreTestUtil.getTreeElements());
    }

    private static IFileStore[] getTree(IFileStore root, String[] elements) {
        IFileStore[] tree = new IFileStore[elements.length];
        int i = 0;
        while (i < elements.length) {
            tree[i] = root.getChild(elements[i]);
            ++i;
        }
        return tree;
    }

    private static String[] getTreeElements() {
        String[] tree;
        tree = new String[]{"d-folder", tree[0] + File.separator + "d-subfolder", tree[0] + File.separator + "f-file", tree[1] + File.separator + "f-anotherFile", tree[1] + File.separator + "d-subfolder", "d-1", "d-2", "f-3", "f-4", "f-5"};
        return tree;
    }
}

