/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.TestingSupport;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class LocalSyncTest
implements ICoreConstants {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private IProject project;

    @Before
    public void createTestProject() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)this.project);
    }

    public void assertExistsInFileSystemWithNoContent(IFile target) {
        Assert.assertTrue((boolean)this.existsInFileSystemWithNoContent((IResource)target));
    }

    private boolean existsInFileSystemWithNoContent(IResource resource) {
        IPath path = resource.getLocation();
        return path.toFile().exists() && path.toFile().length() == 0L;
    }

    @Test
    public void testProjectDeletion() throws CoreException {
        TestingSupport.waitForSnapshot();
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)this.project, new String[]{"/File1", "/Folder1/", "/Folder1/File1", "/Folder1/Folder2/"});
        ResourceTestUtil.createInWorkspace(resources);
        Workspace.clear((File)this.project.getLocation().toFile());
        Assert.assertThrows(CoreException.class, () -> this.project.refreshLocal(2, null));
        Assert.assertTrue((boolean)this.project.exists());
        int i = 1;
        while (i < resources.length) {
            Assert.assertFalse((String)("Resource does unexpectedly exist: " + String.valueOf(resources[i])), (boolean)resources[i].exists());
            ++i;
        }
    }

    @Test
    public void testProjectWithNoResources() throws CoreException {
        this.project.refreshLocal(2, null);
        Assert.assertTrue((boolean)this.project.exists());
    }

    @Test
    public void testSimpleSync() throws Exception {
        IFile index = this.project.getFile(IPath.fromOSString((String)"index.html"));
        IFile toc = this.project.getFile(IPath.fromOSString((String)"toc.html"));
        IFile file = this.project.getFile(IPath.fromOSString((String)"file"));
        IFolder folder = this.project.getFolder(IPath.fromOSString((String)"folder"));
        ResourceTestUtil.createInWorkspace(index, "");
        ResourceTestUtil.createInWorkspace((IResource)toc);
        ResourceTestUtil.createInWorkspace(file, "");
        ResourceTestUtil.createInWorkspace((IResource)folder);
        this.project.refreshLocal(2, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)index);
        this.assertExistsInFileSystemWithNoContent(index);
        ResourceTestUtil.assertExistsInWorkspace((IResource)toc);
        ResourceTestUtil.assertExistsInFileSystem((IResource)toc);
        Assert.assertTrue((boolean)toc.exists());
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        this.assertExistsInFileSystemWithNoContent(file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((file.getType() == 1 ? 1 : 0) != 0);
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        Assert.assertTrue((folder.getType() == 2 ? 1 : 0) != 0);
        ResourceTestUtil.removeFromFileSystem((IResource)toc);
        ResourceTestUtil.removeFromFileSystem((IResource)file);
        ResourceTestUtil.removeFromFileSystem((IResource)folder);
        Thread.sleep(5000L);
        file = this.project.getFolder(IPath.fromOSString((String)"file"));
        folder = this.project.getFile(IPath.fromOSString((String)"folder"));
        ResourceTestUtil.createInFileSystem((IResource)file);
        ResourceTestUtil.createInFileSystem((IResource)folder);
        this.project.refreshLocal(2, null);
        ResourceTestUtil.assertExistsInWorkspace((IResource)index);
        this.assertExistsInFileSystemWithNoContent(index);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)toc);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)toc);
        ResourceTestUtil.assertExistsInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((file.getType() == 2 ? 1 : 0) != 0);
        ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
        ResourceTestUtil.assertExistsInFileSystem((IResource)folder);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((folder.getType() == 1 ? 1 : 0) != 0);
    }
}

