/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;

public class MoveTest {
    private static final int NUMBER_OF_PROPERTIES = 5;
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Test
    public void testMoveFileAcrossVolumes() throws CoreException {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        String[] devices = ResourceTestUtil.findAvailableDevices();
        Assume.assumeFalse((String)"only executable if at least two volumes are present", (devices[0] == null || devices[1] == null ? 1 : 0) != 0);
        String location = ResourceTestUtil.createUniqueString();
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject(location + "1");
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject(location + "2");
        source.create(ResourceTestUtil.createTestMonitor());
        source.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(destination.getName());
        description.setLocation(IPath.fromOSString((String)(devices[1] + location)));
        destination.create(description, ResourceTestUtil.createTestMonitor());
        destination.open(ResourceTestUtil.createTestMonitor());
        String fileName = "fileToBeMoved.txt";
        IFile file = source.getFile(fileName);
        file.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        QualifiedName[] propNames = new QualifiedName[5];
        String[] propValues = new String[5];
        int j = 0;
        while (j < 5) {
            propNames[j] = new QualifiedName("test", "prop" + j);
            propValues[j] = "value" + j;
            file.setPersistentProperty(propNames[j], propValues[j]);
            file.setSessionProperty(propNames[j], (Object)propValues[j]);
            ++j;
        }
        IPath dest = destination.getFile(fileName).getFullPath();
        file.move(dest, true, ResourceTestUtil.createTestMonitor());
        IFile newFile = destination.getFile(fileName);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)file);
        ResourceTestUtil.assertExistsInWorkspace((IResource)newFile);
        ResourceTestUtil.assertExistsInFileSystem((IResource)newFile);
        int j2 = 0;
        while (j2 < 5) {
            String persistentValue = newFile.getPersistentProperty(propNames[j2]);
            Object sessionValue = newFile.getSessionProperty(propNames[j2]);
            Assert.assertEquals((String)"5.1", (Object)persistentValue, (Object)propValues[j2]);
            Assert.assertEquals((String)"5.2", (Object)sessionValue, (Object)propValues[j2]);
            ++j2;
        }
    }

    @Test
    public void testMoveFileBetweenProjects() throws Exception {
        IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Source");
        ResourceTestUtil.createInWorkspace((IResource)sourceProject);
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Target");
        ResourceTestUtil.createInWorkspace((IResource)destinationProject);
        String fileName = "newFile.txt";
        IFile file = sourceProject.getFile(fileName);
        ResourceTestUtil.createInWorkspace((IResource)file);
        QualifiedName[] propNames = new QualifiedName[5];
        String[] propValues = new String[5];
        int j = 0;
        while (j < 5) {
            propNames[j] = new QualifiedName("test", "prop" + j);
            propValues[j] = "value" + j;
            file.setPersistentProperty(propNames[j], propValues[j]);
            file.setSessionProperty(propNames[j], (Object)propValues[j]);
            ++j;
        }
        IPath destination = destinationProject.getFile(fileName).getFullPath();
        file.move(destination, true, null);
        IFile newFile = destinationProject.getFile(fileName);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)file);
        ResourceTestUtil.assertExistsInWorkspace((IResource)newFile);
        ResourceTestUtil.assertExistsInFileSystem((IResource)newFile);
        int j2 = 0;
        while (j2 < 5) {
            String persistentValue = newFile.getPersistentProperty(propNames[j2]);
            Object sessionValue = newFile.getSessionProperty(propNames[j2]);
            Assert.assertEquals((String)"persistent property value is not the same", (Object)propValues[j2], (Object)persistentValue);
            Assert.assertEquals((String)"session property value is not the same", (Object)propValues[j2], (Object)sessionValue);
            ++j2;
        }
    }

    @Test
    public void testMoveFolderAcrossVolumes() throws CoreException {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        String[] devices = ResourceTestUtil.findAvailableDevices();
        Assume.assumeFalse((String)"only executable if at least two volumes are present", (devices[0] == null || devices[1] == null ? 1 : 0) != 0);
        String location = ResourceTestUtil.createUniqueString();
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject(location + "1");
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject(location + "2");
        source.create(ResourceTestUtil.createTestMonitor());
        source.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(destination.getName());
        description.setLocation(IPath.fromOSString((String)(devices[1] + location)));
        destination.create(description, ResourceTestUtil.createTestMonitor());
        destination.open(ResourceTestUtil.createTestMonitor());
        String folderName = "folderToBeMoved";
        IFolder folder = source.getFolder(folderName);
        folder.create(true, true, ResourceTestUtil.createTestMonitor());
        QualifiedName[] propNames = new QualifiedName[5];
        String[] propValues = new String[5];
        int j = 0;
        while (j < 5) {
            propNames[j] = new QualifiedName("test", "prop" + j);
            propValues[j] = "value" + j;
            folder.setPersistentProperty(propNames[j], propValues[j]);
            folder.setSessionProperty(propNames[j], (Object)propValues[j]);
            ++j;
        }
        IPath dest = destination.getFile(folderName).getFullPath();
        folder.move(dest, true, ResourceTestUtil.createTestMonitor());
        IFolder newFolder = destination.getFolder(folderName);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)folder);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)folder);
        ResourceTestUtil.assertExistsInWorkspace((IResource)newFolder);
        ResourceTestUtil.assertExistsInFileSystem((IResource)newFolder);
        int j2 = 0;
        while (j2 < 5) {
            String persistentValue = newFolder.getPersistentProperty(propNames[j2]);
            Object sessionValue = newFolder.getSessionProperty(propNames[j2]);
            Assert.assertEquals((Object)persistentValue, (Object)propValues[j2]);
            Assert.assertEquals((Object)sessionValue, (Object)propValues[j2]);
            ++j2;
        }
    }

    @Test
    public void testMoveFolderBetweenProjects() throws Exception {
        IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Source");
        ResourceTestUtil.createInWorkspace((IResource)sourceProject);
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Target");
        ResourceTestUtil.createInWorkspace((IResource)destinationProject);
        String folderName = "newFolder";
        IFolder folder = sourceProject.getFolder(folderName);
        ResourceTestUtil.createInWorkspace((IResource)folder);
        QualifiedName[] propNames = new QualifiedName[5];
        String[] propValues = new String[5];
        int j = 0;
        while (j < 5) {
            propNames[j] = new QualifiedName("test", "prop" + j);
            propValues[j] = "value" + j;
            folder.setPersistentProperty(propNames[j], propValues[j]);
            folder.setSessionProperty(propNames[j], (Object)propValues[j]);
            ++j;
        }
        IPath destination = destinationProject.getFolder(folderName).getFullPath();
        folder.move(destination, true, null);
        IFolder newFolder = destinationProject.getFolder(folderName);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)folder);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)folder);
        ResourceTestUtil.assertExistsInWorkspace((IResource)newFolder);
        ResourceTestUtil.assertExistsInFileSystem((IResource)newFolder);
        int j2 = 0;
        while (j2 < 5) {
            String persistentValue = newFolder.getPersistentProperty(propNames[j2]);
            Object sessionValue = newFolder.getSessionProperty(propNames[j2]);
            Assert.assertEquals((String)"persistent property value is not the same", (Object)propValues[j2], (Object)persistentValue);
            Assert.assertEquals((String)"session property value is not the same", (Object)propValues[j2], (Object)sessionValue);
            ++j2;
        }
    }

    @Test
    public void testMoveHierarchy() throws Exception {
        IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Source");
        ResourceTestUtil.createInWorkspace((IResource)sourceProject);
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Target");
        ResourceTestUtil.createInWorkspace((IResource)destinationProject);
        String folderSourceName = "folder source";
        IFolder folderSource = sourceProject.getFolder(folderSourceName);
        ResourceTestUtil.createInWorkspace((IResource)folderSource);
        String[] hierarchy = new String[]{"/", "/file1", "/file2", "/folder1/", "/folder1/file3", "/folder1/file4", "/folder2/", "/folder2/file5", "/folder2/file6", "/folder1/folder3/", "/folder1/folder3/file7", "/folder1/folder3/file8"};
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)folderSource, hierarchy);
        ResourceTestUtil.createInWorkspace(resources);
        String[] propNames = new String[5];
        String[] propValues = new String[5];
        int j = 0;
        while (j < 5) {
            propNames[j] = "prop" + j;
            propValues[j] = "value" + j;
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                QualifiedName propName = new QualifiedName("test", resource.getName() + propNames[j]);
                String propValue = resource.getName() + propValues[j];
                resource.setPersistentProperty(propName, propValue);
                resource.setSessionProperty(propName, (Object)propValue);
                ++n2;
            }
            ++j;
        }
        String folderDestinationName = "folder destination";
        IFolder folderDestination = destinationProject.getFolder(folderDestinationName);
        IProgressMonitor monitor = ResourceTestUtil.createTestMonitor();
        folderSource.move(folderDestination.getFullPath(), true, monitor);
        IResource[] newResources = ResourceTestUtil.buildResources((IContainer)folderDestination, hierarchy);
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.assertDoesNotExistInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(newResources);
        ResourceTestUtil.assertExistsInFileSystem(newResources);
        int j2 = 0;
        while (j2 < 5) {
            int i = 0;
            while (i < newResources.length) {
                IResource destResource = newResources[i];
                IResource sourceResource = resources[i];
                QualifiedName propName = new QualifiedName("test", sourceResource.getName() + propNames[j2]);
                String propValue = sourceResource.getName() + propValues[j2];
                String persistentValue = destResource.getPersistentProperty(propName);
                Object sessionValue = destResource.getSessionProperty(propName);
                Assert.assertEquals((String)"persistent property value is not the same", (Object)propValue, (Object)persistentValue);
                Assert.assertEquals((String)"session property value is not the same", (Object)propValue, (Object)sessionValue);
                ++i;
            }
            ++j2;
        }
    }

    @Test
    public void testMoveHierarchyBetweenProjects() throws Exception {
        IProject sourceProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Source");
        ResourceTestUtil.createInWorkspace((IResource)sourceProject);
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Target");
        ResourceTestUtil.createInWorkspace((IResource)destinationProject);
        String folderSourceName = "source";
        IFolder folderSource = sourceProject.getFolder(folderSourceName);
        ResourceTestUtil.createInWorkspace((IResource)folderSource);
        String[] hierarchy = new String[]{"/", "/file1", "/file2", "/folder1/", "/folder1/file3", "/folder1/file4", "/folder2/", "/folder2/file5", "/folder2/file6", "/folder1/folder3/", "/folder1/folder3/file7", "/folder1/folder3/file8"};
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)folderSource, hierarchy);
        ResourceTestUtil.createInWorkspace(resources);
        String[] propNames = new String[5];
        String[] propValues = new String[5];
        int j = 0;
        while (j < 5) {
            propNames[j] = "prop" + j;
            propValues[j] = "value" + j;
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                QualifiedName propName = new QualifiedName("test", resource.getName() + propNames[j]);
                String propValue = resource.getName() + propValues[j];
                resource.setPersistentProperty(propName, propValue);
                resource.setSessionProperty(propName, (Object)propValue);
                ++n2;
            }
            ++j;
        }
        String folderDestinationName = "destination";
        IFolder folderDestination = destinationProject.getFolder(folderDestinationName);
        folderSource.move(folderDestination.getFullPath(), true, null);
        IResource[] newResources = ResourceTestUtil.buildResources((IContainer)folderDestination, hierarchy);
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.assertDoesNotExistInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(newResources);
        ResourceTestUtil.assertExistsInFileSystem(newResources);
        int j2 = 0;
        while (j2 < 5) {
            int i = 0;
            while (i < newResources.length) {
                IResource destResource = newResources[i];
                IResource sourceResource = resources[i];
                QualifiedName propName = new QualifiedName("test", sourceResource.getName() + propNames[j2]);
                String propValue = sourceResource.getName() + propValues[j2];
                String persistentValue = destResource.getPersistentProperty(propName);
                Object sessionValue = destResource.getSessionProperty(propName);
                Assert.assertEquals((String)"persistent property value is not the same", (Object)propValue, (Object)persistentValue);
                Assert.assertEquals((String)"session property value is not the same", (Object)propValue, (Object)sessionValue);
                ++i;
            }
            ++j2;
        }
    }

    @Test
    public void testMoveResource() throws Exception {
        IFile ghostFile;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("file.txt");
        ResourceTestUtil.createInWorkspace((IResource)folder);
        ResourceTestUtil.createInWorkspace((IResource)file);
        IFile destination = project.getFile("file.txt");
        file.move(destination.getFullPath(), true, null);
        Assert.assertFalse((boolean)file.exists());
        Assert.assertTrue((boolean)destination.exists());
        destination.move(file.getFullPath(), true, null);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)destination.exists());
        IPath path = IPath.fromOSString((String)"destination");
        destination = folder.getFile(path);
        file.move(path, true, null);
        Assert.assertFalse((boolean)file.exists());
        Assert.assertTrue((boolean)destination.exists());
        destination.move(file.getFullPath(), true, null);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)destination.exists());
        IFolder subFolderDestination = folder.getFolder("subfolder");
        Assert.assertThrows(RuntimeException.class, () -> folder.move(subFolderDestination.getFullPath(), true, null));
        project.refreshLocal(2, null);
        IFolder subfolder = folder.getFolder("aaa");
        ResourceTestUtil.createInFileSystem((IResource)subfolder);
        IFile anotherFile = folder.getFile("bbb");
        ResourceTestUtil.createInFileSystem((IResource)anotherFile);
        IFolder folderDestination = project.getFolder("destination");
        Assert.assertThrows(CoreException.class, () -> folder.move(folderDestination.getFullPath(), false, null));
        Assert.assertThrows(CoreException.class, () -> folder.move(folderDestination.getFullPath(), false, null));
        Assert.assertTrue((boolean)folder.exists());
        IFile destChild = folderDestination.getFile(IPath.fromOSString((String)anotherFile.getName()));
        Assert.assertFalse((boolean)folderDestination.exists());
        Assert.assertFalse((boolean)destChild.exists());
        folderDestination.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        folderDestination.delete(true, ResourceTestUtil.createTestMonitor());
        folder.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        folder.move(folderDestination.getFullPath(), false, ResourceTestUtil.createTestMonitor());
        folderDestination.move(folder.getFullPath(), true, null);
        Assert.assertTrue((boolean)folder.exists());
        Assert.assertFalse((boolean)destination.exists());
        IFile hackFile = ghostFile = project.getFile("ghost");
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable operation = monitor -> {
            ResourceInfo resourceInfo = workspace.createResource((IResource)hackFile, false);
        };
        workspace.run(operation, null);
        IFile fileDestination = project.getFile("destination");
        Assert.assertThrows(CoreException.class, () -> ghostFile.move(fileDestination.getFullPath(), true, null));
        Assert.assertTrue((boolean)ghostFile.exists());
        operation = monitor -> ((Resource)hackFile).convertToPhantom();
        workspace.run(operation, null);
        Assert.assertFalse((boolean)ghostFile.exists());
        ResourceInfo info = ((File)ghostFile).getResourceInfo(true, false);
        int flags = ((File)ghostFile).getFlags(info);
        Assert.assertTrue((boolean)((Resource)ghostFile).exists(flags, true));
        anotherFile = folder.getFile("anotherFile");
        ResourceTestUtil.createInWorkspace((IResource)anotherFile);
        anotherFile.move(ghostFile.getFullPath(), true, null);
        Assert.assertTrue((boolean)ghostFile.exists());
    }

    @Test
    public void testRenameFile() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String fileName = "file.txt";
        IFile file = project.getFile(fileName);
        ResourceTestUtil.createInWorkspace((IResource)file);
        QualifiedName[] propNames = new QualifiedName[5];
        String[] propValues = new String[5];
        int j = 0;
        while (j < 5) {
            propNames[j] = new QualifiedName("test", "prop" + j);
            propValues[j] = "value" + j;
            file.setPersistentProperty(propNames[j], propValues[j]);
            file.setSessionProperty(propNames[j], (Object)propValues[j]);
            ++j;
        }
        String newFileName = "newFile.txt";
        IPath destination = project.getFile(newFileName).getFullPath();
        file.move(destination, true, null);
        IFile newFile = project.getFile(newFileName);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)file);
        ResourceTestUtil.assertExistsInWorkspace((IResource)newFile);
        ResourceTestUtil.assertExistsInFileSystem((IResource)newFile);
        int j2 = 0;
        while (j2 < 5) {
            String persistentValue = newFile.getPersistentProperty(propNames[j2]);
            Object sessionValue = newFile.getSessionProperty(propNames[j2]);
            Assert.assertEquals((String)"persistent property value is not the same", (Object)propValues[j2], (Object)persistentValue);
            Assert.assertEquals((String)"session property value is not the same", (Object)propValues[j2], (Object)sessionValue);
            ++j2;
        }
    }

    @Test
    public void testRenameFolder() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        String folderName = "folder";
        IFolder folder = project.getFolder(folderName);
        ResourceTestUtil.createInWorkspace((IResource)folder);
        QualifiedName[] propNames = new QualifiedName[5];
        String[] propValues = new String[5];
        int j = 0;
        while (j < 5) {
            propNames[j] = new QualifiedName("test", "prop" + j);
            propValues[j] = "value" + j;
            folder.setPersistentProperty(propNames[j], propValues[j]);
            folder.setSessionProperty(propNames[j], (Object)propValues[j]);
            ++j;
        }
        String newFolderName = "newFolder";
        IPath destination = project.getFolder(newFolderName).getFullPath();
        folder.move(destination, true, null);
        IFolder newFolder = project.getFolder(newFolderName);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)folder);
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)folder);
        ResourceTestUtil.assertExistsInWorkspace((IResource)newFolder);
        ResourceTestUtil.assertExistsInFileSystem((IResource)newFolder);
        int j2 = 0;
        while (j2 < 5) {
            String persistentValue = newFolder.getPersistentProperty(propNames[j2]);
            Object sessionValue = newFolder.getSessionProperty(propNames[j2]);
            Assert.assertEquals((String)"persistent property value is not the same", (Object)propValues[j2], (Object)persistentValue);
            Assert.assertEquals((String)"session property value is not the same", (Object)propValues[j2], (Object)sessionValue);
            ++j2;
        }
    }

    @Test
    public void testRenameProjects() throws Exception {
        IProject[] projects = new IProject[5];
        int i = 0;
        while (i < 5) {
            projects[i] = ResourcesPlugin.getWorkspace().getRoot().getProject("Project" + i);
            ResourceTestUtil.createInWorkspace((IResource)projects[i]);
            ++i;
        }
        QualifiedName[] propNames = new QualifiedName[5];
        String[] propValues = new String[5];
        int i2 = 0;
        while (i2 < 5) {
            propNames[i2] = new QualifiedName("test", "prop" + i2);
            propValues[i2] = "value" + i2;
            projects[i2].setPersistentProperty(propNames[i2], propValues[i2]);
            projects[i2].setSessionProperty(propNames[i2], (Object)propValues[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < 5) {
            String persistentValue = projects[i2].getPersistentProperty(propNames[i2]);
            Object sessionValue = projects[i2].getSessionProperty(propNames[i2]);
            Assert.assertEquals((String)"persistent property value is not the same", (Object)propValues[i2], (Object)persistentValue);
            Assert.assertEquals((String)"session property value is not the same", (Object)propValues[i2], (Object)sessionValue);
            ++i2;
        }
        String prefix = "Renamed_PrOjEcT";
        int i3 = 0;
        while (i3 < 5) {
            String projectName = prefix + i3;
            IPath destination = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFullPath();
            projects[i3].move(destination, true, null);
            ++i3;
        }
        i3 = 0;
        while (i3 < 5) {
            projects[i3] = ResourcesPlugin.getWorkspace().getRoot().getProject(prefix + i3);
            ++i3;
        }
        i3 = 0;
        while (i3 < 5) {
            String persistentValue = projects[i3].getPersistentProperty(propNames[i3]);
            Object sessionValue = projects[i3].getSessionProperty(propNames[i3]);
            Assert.assertEquals((String)"persistent property value is not the same", (Object)propValues[i3], (Object)persistentValue);
            Assert.assertEquals((String)"session property value is not the same", (Object)propValues[i3], (Object)sessionValue);
            ++i3;
        }
    }
}

