/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import org.eclipse.core.internal.localstore.PrefixPool;
import org.junit.Assert;
import org.junit.Test;

public class PrefixPoolTest {
    @Test
    public void testIllegalCapacity() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            PrefixPool prefixPool = new PrefixPool(0);
        });
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            PrefixPool prefixPool = new PrefixPool(-1);
        });
    }

    @Test
    public void testPrefixPool() {
        PrefixPool p = new PrefixPool(1);
        Assert.assertFalse((boolean)p.containsAsPrefix(""));
        Assert.assertFalse((boolean)p.containsAsPrefix("/a"));
        Assert.assertFalse((boolean)p.hasPrefixOf("/a"));
        boolean rv = p.insertShorter("/a/");
        Assert.assertFalse((boolean)rv);
        p.insertLonger("/a/b/");
        Assert.assertEquals((long)1L, (long)p.size());
        p.insertLonger("/A/");
        Assert.assertEquals((long)2L, (long)p.size());
        p.insertLonger("/");
        Assert.assertEquals((long)2L, (long)p.size());
        Assert.assertFalse((boolean)p.hasPrefixOf("/c"));
        rv = p.insertShorter("/a/b/c/");
        Assert.assertFalse((boolean)rv);
        Assert.assertEquals((long)2L, (long)p.size());
        p.insertLonger("/a/B/c/");
        Assert.assertEquals((long)3L, (long)p.size());
        p.insertShorter("/a/B/");
        Assert.assertEquals((long)3L, (long)p.size());
        Assert.assertTrue((boolean)p.hasPrefixOf("/a/B/"));
        Assert.assertTrue((boolean)p.hasPrefixOf("/a/b/c/d/"));
        Assert.assertFalse((boolean)p.hasPrefixOf("/"));
        Assert.assertTrue((boolean)p.containsAsPrefix("/a/B"));
        Assert.assertTrue((boolean)p.containsAsPrefix("/a/b/"));
        Assert.assertTrue((boolean)p.containsAsPrefix(""));
        Assert.assertFalse((boolean)p.containsAsPrefix("/a/b//"));
        Assert.assertFalse((boolean)p.containsAsPrefix("/A/B/"));
        Assert.assertEquals((long)3L, (long)p.size());
        p.clear();
        Assert.assertEquals((long)0L, (long)p.size());
        Assert.assertFalse((boolean)p.hasPrefixOf(""));
        Assert.assertFalse((boolean)p.containsAsPrefix(""));
    }
}

