/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.localstore.LocalStoreTestUtil;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class RefreshLocalTest
implements ICoreConstants {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private IProject project;

    @Before
    public void createTestProject() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)this.project);
    }

    @Test
    public void testDiscoverCaseChange() throws CoreException {
        IFolder folder = this.project.getFolder("A");
        IFolder folderVariant = this.project.getFolder("a");
        IFile file = folder.getFile("file");
        IFile fileVariant = folderVariant.getFile(file.getName());
        ResourceTestUtil.createInWorkspace((IResource)file);
        this.project.getLocation().append("A").toFile().renameTo(this.project.getLocation().append("a").toFile());
        this.project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)folderVariant.exists());
        Assert.assertTrue((boolean)fileVariant.exists());
        Assert.assertFalse((boolean)folder.exists());
        Assert.assertFalse((boolean)file.exists());
        Assert.assertTrue((boolean)this.project.isSynchronized(2));
    }

    @Test
    public void testDiscoverLinkedResource() {
    }

    @Test
    public void testFileDiscovery() throws Throwable {
        this.workspaceRule.deleteOnTearDown(this.project.getLocation());
        IFolder folder = this.project.getFolder("Folder");
        IFile file = folder.getFile("File");
        ResourceTestUtil.createInFileSystem((IResource)folder);
        ResourceTestUtil.removeFromWorkspace((IResource)folder);
        ResourceTestUtil.createInFileSystem((IResource)file);
        ResourceTestUtil.removeFromWorkspace((IResource)file);
        Assert.assertFalse((boolean)file.exists());
        Assert.assertFalse((boolean)folder.exists());
        Assert.assertFalse((boolean)file.isSynchronized(0));
        Assert.assertFalse((boolean)folder.isSynchronized(2));
        file.refreshLocal(0, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)folder.exists());
        this.project.delete(1, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.createInFileSystem((IResource)folder);
        ResourceTestUtil.removeFromWorkspace((IResource)folder);
        ResourceTestUtil.createInFileSystem((IResource)file);
        ResourceTestUtil.removeFromWorkspace((IResource)file);
        Assert.assertFalse((boolean)file.exists());
        Assert.assertFalse((boolean)folder.exists());
        file.refreshLocal(0, ResourceTestUtil.createTestMonitor());
        Assert.assertFalse((boolean)file.exists());
        Assert.assertFalse((boolean)folder.exists());
    }

    @Test
    public void testFileToFolder() throws Throwable {
        IFile file = this.project.getFile("file");
        file.create(null, true, null);
        ResourceTestUtil.removeFromFileSystem((IResource)file);
        File target = file.getLocation().toFile();
        target.mkdirs();
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)target.isDirectory());
        file.refreshLocal(0, null);
        Assert.assertFalse((boolean)file.exists());
        IFolder folder = this.project.getFolder("file");
        Assert.assertTrue((boolean)folder.exists());
    }

    @Test
    public void testFolderToFile() throws Throwable {
        IFolder folder = this.project.getFolder("folder");
        folder.create(true, true, null);
        ResourceTestUtil.removeFromFileSystem((IResource)folder);
        IFile file = this.project.getFile("folder");
        ResourceTestUtil.createInFileSystem((IResource)file);
        Assert.assertTrue((boolean)folder.exists());
        folder.refreshLocal(0, null);
        Assert.assertFalse((boolean)folder.exists());
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void testRefreshClosedProject() throws CoreException {
        this.project.close(ResourceTestUtil.createTestMonitor());
        this.project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        this.project.refreshLocal(0, ResourceTestUtil.createTestMonitor());
        this.project.refreshLocal(1, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testRefreshFolder() throws Throwable {
        IFile file;
        IFile hackFile = file = this.project.getFile("file");
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable operation = monitor -> {
            workspace.createResource((IResource)hackFile, false);
            ((Resource)hackFile).getResourceInfo(false, true).set(2);
        };
        workspace.run(operation, null);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)file.isLocal(0));
        this.project.refreshLocal(2, null);
        Assert.assertFalse((boolean)file.exists());
        ResourceTestUtil.removeFromWorkspace((IResource)file);
        ResourceTestUtil.removeFromFileSystem((IResource)file);
        file = this.project.getFile("file");
        ResourceTestUtil.createInFileSystem((IResource)file);
        Assert.assertFalse((boolean)file.exists());
        this.project.refreshLocal(2, null);
        Assert.assertTrue((boolean)file.exists());
        ResourceTestUtil.removeFromWorkspace((IResource)file);
        ResourceTestUtil.removeFromFileSystem((IResource)file);
        IFolder folder = this.project.getFolder("folder");
        folder.create(true, true, null);
        file = folder.getFile("file");
        ResourceTestUtil.createInFileSystem((IResource)file);
        Assert.assertTrue((boolean)folder.exists());
        Assert.assertTrue((boolean)folder.isLocal(0));
        Assert.assertFalse((boolean)file.exists());
        folder.refreshLocal(0, null);
        Assert.assertTrue((boolean)folder.exists());
        Assert.assertTrue((boolean)folder.isLocal(0));
        Assert.assertFalse((boolean)file.exists());
        folder.refreshLocal(1, null);
        Assert.assertTrue((boolean)folder.exists());
        Assert.assertTrue((boolean)folder.isLocal(0));
        Assert.assertTrue((boolean)file.exists());
        ResourceTestUtil.removeFromWorkspace((IResource)folder);
        ResourceTestUtil.removeFromFileSystem((IResource)folder);
        file = this.project.getFile("file");
        IFileStore fileStore = ((Resource)file).getStore();
        ResourceTestUtil.createInWorkspace((IResource)file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)file.isLocal(0));
        Assert.assertEquals((long)fileStore.fetchInfo().getLastModified(), (long)((Resource)file).getResourceInfo(false, false).getLocalSyncInfo());
        ResourceTestUtil.ensureOutOfSync(file);
        Assert.assertNotSame((Object)((Resource)file).getResourceInfo(false, false).getLocalSyncInfo(), (Object)fileStore.fetchInfo().getLastModified());
        this.project.refreshLocal(2, null);
        Assert.assertEquals((long)fileStore.fetchInfo().getLastModified(), (long)((Resource)file).getResourceInfo(false, false).getLocalSyncInfo());
        ResourceTestUtil.removeFromWorkspace((IResource)file);
        ResourceTestUtil.removeFromFileSystem((IResource)file);
    }

    @Test
    public void testSimpleRefresh() throws Throwable {
        IFile file = this.project.getFile("file");
        ResourceTestUtil.createInWorkspace((IResource)file);
        ResourceTestUtil.removeFromFileSystem((IResource)file);
        Assert.assertTrue((boolean)file.exists());
        file.refreshLocal(2, null);
        Assert.assertFalse((boolean)file.exists());
        IFolder folder = this.project.getFolder("folder");
        IFileStore target = ((Resource)folder).getStore();
        LocalStoreTestUtil.createTree(LocalStoreTestUtil.getTree(target));
        Assert.assertFalse((boolean)folder.exists());
        folder.refreshLocal(2, null);
        Assert.assertTrue((boolean)folder.exists());
        Assertions.assertThat((Object[])LocalStoreTestUtil.getTree(target)).hasSize(((Resource)folder).countResources(2, false) - 1);
    }
}

