/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeChunkyOutputStream;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SafeChunkyInputOutputStreamTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private File temp;
    private List<SafeChunkyOutputStream> streams;
    private File target;

    private byte[] merge(byte[] b1, byte[] b2) {
        byte[] result = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, result, 0, b1.length);
        System.arraycopy(b2, 0, result, b1.length, b2.length);
        return result;
    }

    @Before
    public void setUp() throws Exception {
        this.streams = new ArrayList<SafeChunkyOutputStream>();
        this.temp = FileSystemHelper.getRandomLocation().append("temp").toFile();
        this.temp.mkdirs();
        Assert.assertTrue((String)"could not create temp directory", (boolean)this.temp.isDirectory());
        this.target = new File(this.temp, "target");
    }

    @After
    public void tearDown() throws Exception {
        for (SafeChunkyOutputStream stream : this.streams) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ResourceTestUtil.removeFromFileSystem(this.temp.getParentFile());
    }

    @Test
    public void testBufferLimit() throws Exception {
        Workspace.clear((File)this.target);
        Assert.assertTrue((!this.target.exists() ? 1 : 0) != 0);
        int bufferSize = 10024;
        byte[] chunk = this.getBigContents(bufferSize);
        Throwable throwable = null;
        Object var4_6 = null;
        try (SafeChunkyOutputStream output = new SafeChunkyOutputStream(this.target);){
            output.write(chunk);
            output.succeed();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try (SafeChunkyInputStream input = new SafeChunkyInputStream(this.target);){
            byte[] read = new byte[chunk.length];
            Assertions.assertThat((byte[])chunk).hasSize(input.read(read));
            Assertions.assertThat((byte[])read).isEqualTo((Object)chunk);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        Workspace.clear((File)this.target);
    }

    private byte[] getBigContents(int size) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < size) {
            sb.append(ResourceTestUtil.createRandomString());
        }
        return sb.toString().getBytes();
    }

    @Test
    public void testFailure() throws Exception {
        Workspace.clear((File)this.target);
        Assert.assertFalse((boolean)this.target.exists());
        byte[] fakeEnd = new byte[ILocalStoreConstants.END_CHUNK.length];
        System.arraycopy(ILocalStoreConstants.END_CHUNK, 0, fakeEnd, 0, ILocalStoreConstants.END_CHUNK.length);
        fakeEnd[fakeEnd.length - 1] = 86;
        byte[] chunk1 = ResourceTestUtil.createRandomString().getBytes();
        byte[] chunk2 = ResourceTestUtil.createRandomString().getBytes();
        byte[] chunk3 = ResourceTestUtil.createRandomString().getBytes();
        byte[] chunk4 = ResourceTestUtil.createRandomString().getBytes();
        byte[] chunk5 = ResourceTestUtil.createRandomString().getBytes();
        byte[] chunk6 = ResourceTestUtil.createRandomString().getBytes();
        try (SafeChunkyOutputStream output = new SafeChunkyOutputStream(this.target);){
            output.write(chunk1);
            output.succeed();
            this.doNothing(output);
            output = new SafeChunkyOutputStream(this.target);
            output.write(chunk2);
            output.write(ILocalStoreConstants.BEGIN_CHUNK);
            output.succeed();
            this.doNothing(output);
            output = new SafeChunkyOutputStream(this.target);
            output.write(chunk3);
            output.succeed();
            this.doNothing(output);
            output = new SafeChunkyOutputStream(this.target);
            output.write(chunk4);
            output.write(ILocalStoreConstants.END_CHUNK);
            output.succeed();
            this.doNothing(output);
            output = new SafeChunkyOutputStream(this.target);
            output.write(chunk5);
            output.succeed();
            output.write(fakeEnd);
            output.write(chunk6);
            output.succeed();
        }
        Throwable throwable = null;
        Object var10_12 = null;
        try (SafeChunkyInputStream input = new SafeChunkyInputStream(this.target);){
            byte[] read1 = new byte[chunk1.length];
            byte[] read3 = new byte[chunk3.length];
            byte[] read4 = new byte[chunk4.length];
            byte[] read5 = new byte[chunk5.length];
            byte[] read6 = new byte[fakeEnd.length + chunk6.length];
            Assertions.assertThat((byte[])chunk1).hasSize(input.read(read1));
            Assertions.assertThat((byte[])chunk3).hasSize(input.read(read3));
            Assertions.assertThat((byte[])chunk4).hasSize(input.read(read4));
            Assertions.assertThat((byte[])chunk5).hasSize(input.read(read5));
            Assertions.assertThat((byte[])chunk6).hasSize(input.read(read6) - fakeEnd.length);
            Assertions.assertThat((byte[])read1).isEqualTo((Object)chunk1);
            Assertions.assertThat((byte[])read3).isEqualTo((Object)chunk3);
            Assertions.assertThat((byte[])read4).isEqualTo((Object)chunk4);
            Assertions.assertThat((byte[])read5).isEqualTo((Object)chunk5);
            byte[] expected = this.merge(fakeEnd, chunk6);
            Assertions.assertThat((byte[])read6).isEqualTo((Object)expected);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void doNothing(SafeChunkyOutputStream output) {
        this.streams.add(output);
    }

    @Test
    public void testAlmostEmpty() throws Exception {
        Workspace.clear((File)this.target);
        Assert.assertTrue((!this.target.exists() ? 1 : 0) != 0);
        Throwable throwable = null;
        Object var2_4 = null;
        try (SafeChunkyOutputStream output = new SafeChunkyOutputStream(this.target);){
            output.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_4 = null;
        try (DataInputStream input = new DataInputStream((InputStream)new SafeChunkyInputStream(this.target));){
            Assert.assertThrows(EOFException.class, () -> {
                String string = input.readUTF();
            });
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void testSimple() throws Exception {
        Workspace.clear((File)this.target);
        Assert.assertFalse((boolean)this.target.exists());
        byte[] chunk1 = ResourceTestUtil.createRandomString().getBytes();
        byte[] chunk2 = ResourceTestUtil.createRandomString().getBytes();
        byte[] chunk3 = ResourceTestUtil.createRandomString().getBytes();
        byte[] chunk4 = ResourceTestUtil.createRandomString().getBytes();
        byte[] chunk5 = ResourceTestUtil.createRandomString().getBytes();
        Throwable throwable = null;
        Object var7_9 = null;
        try (SafeChunkyOutputStream output = new SafeChunkyOutputStream(this.target);){
            output.write(chunk1);
            output.succeed();
            output.write(chunk2);
            output.succeed();
            output.write(chunk3);
            output.succeed();
            output.write(chunk4);
            output.succeed();
            output.write(chunk5);
            output.succeed();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        try {
            throwable = null;
            var7_9 = null;
            try (SafeChunkyInputStream input = new SafeChunkyInputStream(this.target);){
                byte[] read1 = new byte[chunk1.length];
                byte[] read2 = new byte[chunk2.length];
                byte[] read3 = new byte[chunk3.length];
                byte[] read4 = new byte[chunk4.length];
                byte[] read5 = new byte[chunk5.length];
                Assertions.assertThat((byte[])chunk1).hasSize(input.read(read1));
                Assertions.assertThat((byte[])chunk2).hasSize(input.read(read2));
                Assertions.assertThat((byte[])chunk3).hasSize(input.read(read3));
                Assertions.assertThat((byte[])chunk4).hasSize(input.read(read4));
                Assertions.assertThat((byte[])chunk5).hasSize(input.read(read5));
                Assertions.assertThat((byte[])read1).isEqualTo((Object)chunk1);
                Assertions.assertThat((byte[])read2).isEqualTo((Object)chunk2);
                Assertions.assertThat((byte[])read3).isEqualTo((Object)chunk3);
                Assertions.assertThat((byte[])read4).isEqualTo((Object)chunk4);
                Assertions.assertThat((byte[])read5).isEqualTo((Object)chunk5);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            Workspace.clear((File)this.target);
        }
    }
}

