/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.eclipse.core.internal.localstore.SafeFileOutputStream;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SafeFileInputOutputStreamTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private IPath temp;

    private SafeFileOutputStream createSafeStream(File target) throws IOException {
        return this.createSafeStream(target.getAbsolutePath(), null);
    }

    private SafeFileOutputStream createSafeStream(String targetPath, String tempFilePath) throws IOException {
        return new SafeFileOutputStream(targetPath, tempFilePath);
    }

    private InputStream getContents(File target) throws IOException {
        return new SafeFileInputStream(target);
    }

    @Before
    public void setUp() throws Exception {
        this.temp = FileSystemHelper.getRandomLocation().append("temp");
        this.temp.toFile().mkdirs();
        this.workspaceRule.deleteOnTearDown(this.temp);
        Assert.assertTrue((String)"could not create temp directory", (boolean)this.temp.toFile().isDirectory());
    }

    @Test
    public void testSafeFileInputStream() throws IOException {
        SafeFileOutputStream safeStream;
        File target = new File(this.temp.toFile(), "target");
        Workspace.clear((File)target);
        Assert.assertFalse((boolean)target.exists());
        IPath parentLocation = IPath.fromOSString((String)target.getParentFile().getAbsolutePath());
        IPath tempLocation = parentLocation.append(target.getName() + ".backup");
        String contents = ResourceTestUtil.createRandomString();
        File tempFile = tempLocation.toFile();
        Throwable throwable = null;
        Object var7_10 = null;
        try {
            safeStream = this.createSafeStream(target.getAbsolutePath(), tempLocation.toOSString());
            try {
                ResourceTestUtil.createInputStream(contents).transferTo((OutputStream)safeStream);
            }
            finally {
                if (safeStream != null) {
                    safeStream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var7_10 = null;
        try {
            safeStream = this.createSafeStream(target.getAbsolutePath(), tempLocation.toOSString());
            try {
                ResourceTestUtil.createInputStream(contents).transferTo((OutputStream)safeStream);
            }
            finally {
                if (safeStream != null) {
                    safeStream.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)target.exists());
        Assert.assertFalse((boolean)tempFile.exists());
        throwable = null;
        var7_10 = null;
        try (SafeFileInputStream diskContents = new SafeFileInputStream(tempLocation.toOSString(), target.getAbsolutePath());){
            Assertions.assertThat((InputStream)diskContents).hasContent(contents);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        Workspace.clear((File)target);
    }

    @Test
    public void testSimple() throws IOException {
        File tempFile;
        File target = new File(this.temp.toFile(), "target");
        Workspace.clear((File)target);
        Assert.assertTrue((!target.exists() ? 1 : 0) != 0);
        String contents = ResourceTestUtil.createRandomString();
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (SafeFileOutputStream safeStream = this.createSafeStream(target);){
            ResourceTestUtil.createInputStream(contents).transferTo((OutputStream)safeStream);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        throwable2 = null;
        try (InputStream diskContents = this.getContents(target);){
            Assertions.assertThat((InputStream)diskContents).hasContent(contents);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        contents = ResourceTestUtil.createRandomString();
        throwable2 = null;
        Object var5_11 = null;
        try (SafeFileOutputStream safeStream = this.createSafeStream(target);){
            tempFile = new File(safeStream.getTempFilePath());
            Assert.assertTrue((boolean)tempFile.exists());
            ResourceTestUtil.createInputStream(contents).transferTo((OutputStream)safeStream);
        }
        catch (Throwable throwable5) {
            if (throwable2 == null) {
                throwable2 = throwable5;
            } else if (throwable2 != throwable5) {
                throwable2.addSuppressed(throwable5);
            }
            throw throwable2;
        }
        Assert.assertFalse((boolean)tempFile.exists());
        throwable2 = null;
        var5_11 = null;
        try (InputStream diskContents = this.getContents(target);){
            Assertions.assertThat((InputStream)diskContents).hasContent(contents);
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
        Workspace.clear((File)target);
    }

    @Test
    public void testSpecifiedTempFile() throws IOException {
        InputStream diskContents;
        SafeFileOutputStream safeStream;
        File target = new File(this.temp.toFile(), "target");
        Workspace.clear((File)target);
        Assert.assertTrue((!target.exists() ? 1 : 0) != 0);
        IPath parentLocation = IPath.fromOSString((String)target.getParentFile().getAbsolutePath());
        IPath tempLocation = parentLocation.append(target.getName() + ".backup");
        String contents = ResourceTestUtil.createRandomString();
        File tempFile = tempLocation.toFile();
        Throwable throwable = null;
        Object var7_11 = null;
        try {
            safeStream = this.createSafeStream(target.getAbsolutePath(), tempLocation.toOSString());
            try {
                Assert.assertFalse((boolean)tempFile.exists());
                ResourceTestUtil.createInputStream(contents).transferTo((OutputStream)safeStream);
            }
            finally {
                if (safeStream != null) {
                    safeStream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertFalse((boolean)tempFile.exists());
        throwable = null;
        var7_11 = null;
        try {
            diskContents = this.getContents(target);
            try {
                Assertions.assertThat((InputStream)diskContents).hasContent(contents);
            }
            finally {
                if (diskContents != null) {
                    diskContents.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        contents = ResourceTestUtil.createRandomString();
        throwable = null;
        var7_11 = null;
        try {
            safeStream = this.createSafeStream(target.getAbsolutePath(), tempLocation.toOSString());
            try {
                Assert.assertTrue((boolean)tempFile.exists());
                ResourceTestUtil.createInputStream(contents).transferTo((OutputStream)safeStream);
            }
            finally {
                if (safeStream != null) {
                    safeStream.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        Assert.assertFalse((boolean)tempFile.exists());
        throwable = null;
        var7_11 = null;
        try {
            diskContents = this.getContents(target);
            try {
                Assertions.assertThat((InputStream)diskContents).hasContent(contents);
            }
            finally {
                if (diskContents != null) {
                    diskContents.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        Workspace.clear((File)target);
    }
}

