/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;

public class SymlinkResourceTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    private void mkLink(IFileStore dir, String src, String tgt, boolean isDir) throws CoreException, IOException {
        FileSystemHelper.createSymLink((File)dir.toLocalFile(0, ResourceTestUtil.createTestMonitor()), (String)src, (String)tgt, (boolean)isDir);
    }

    protected void createBug232426Structure(IFileStore rootDir) throws CoreException, IOException {
        IFileStore folderA = rootDir.getChild("a");
        IFileStore folderB = rootDir.getChild("b");
        IFileStore folderC = rootDir.getChild("c");
        folderA.mkdir(0, ResourceTestUtil.createTestMonitor());
        folderB.mkdir(0, ResourceTestUtil.createTestMonitor());
        folderC.mkdir(0, ResourceTestUtil.createTestMonitor());
        this.mkLink(folderA, "link", IPath.fromOSString((String)"../b").toOSString(), true);
        this.mkLink(folderB, "linkA", IPath.fromOSString((String)"../a").toOSString(), true);
        this.mkLink(folderB, "linkC", IPath.fromOSString((String)"../c").toOSString(), true);
        this.mkLink(folderC, "link", IPath.fromOSString((String)"../b").toOSString(), true);
    }

    protected void createBug358830Structure(IFileStore rootDir) throws CoreException, IOException {
        IFileStore folderA = rootDir.getChild("a");
        folderA.mkdir(0, ResourceTestUtil.createTestMonitor());
        this.mkLink(folderA, "link", IPath.fromOSString((String)"../").toOSString(), true);
    }

    @Test
    public void testBug232426() throws Exception {
        Assume.assumeTrue((String)"only relevant for platforms supporting symbolic links", (boolean)FileSystemHelper.canCreateSymLinks());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourcesPlugin.getWorkspace().run(monitor -> {
            project.delete(8, ResourceTestUtil.createTestMonitor());
            project.create(null);
            try {
                this.createBug232426Structure(EFS.getStore((URI)project.getLocationURI()));
            }
            catch (IOException e) {
                throw new IllegalStateException("unexpected IOException occurred", e);
            }
            project.open(128, ResourceTestUtil.createTestMonitor());
        }, null);
        ResourceTestUtil.waitForRefresh();
        project.accept(new IResourceVisitor(){
            int resourceCount = 0;

            public boolean visit(IResource resource) {
                ++this.resourceCount;
                Assert.assertTrue((this.resourceCount <= 10 ? 1 : 0) != 0);
                return true;
            }
        });
    }

    @Test
    public void testBug358830() throws Exception {
        Assume.assumeTrue((String)"only relevant for platforms supporting symbolic links", (boolean)FileSystemHelper.canCreateSymLinks());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        ResourcesPlugin.getWorkspace().run(monitor -> {
            project.delete(8, ResourceTestUtil.createTestMonitor());
            project.create(null);
            try {
                this.createBug358830Structure(EFS.getStore((URI)project.getLocationURI()));
            }
            catch (IOException e) {
                throw new IllegalStateException("unexpected IOException occurred", e);
            }
            project.open(128, ResourceTestUtil.createTestMonitor());
        }, null);
        ResourceTestUtil.waitForRefresh();
        int[] resourceCount = new int[1];
        project.accept(resource -> {
            nArray[0] = resourceCount[0] + 1;
            return true;
        });
        Assert.assertEquals((long)5L, (long)resourceCount[0]);
    }
}

