/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Hashtable;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.UnifiedTree;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.localstore.Test342968FileSystem;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class UnifiedTreeTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final int LIMIT = 10;

    protected void createFiles(IFileStore folder, Hashtable<String, String> set) throws Exception {
        int i = 0;
        while (i < 10) {
            IFileStore child = folder.getChild("fsFile" + i);
            Throwable throwable = null;
            Object var6_7 = null;
            try (OutputStream out = child.openOutputStream(0, null);){
                out.write("contents".getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            set.put(child.toString(), "");
            ++i;
        }
    }

    protected void createFiles(IContainer target, Hashtable<String, String> set) throws CoreException {
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable operation = monitor -> {
            int i = 0;
            while (i < 10) {
                IFile child = target.getFile(IPath.fromOSString((String)("wbFile" + i)));
                workspace.createResource((IResource)child, false);
                String location = child.getLocation().toOSString();
                set.put(location, "");
                ++i;
            }
        };
        workspace.run(operation, null);
    }

    protected void createResourcesInFileSystem(IFileStore folder, Hashtable<String, String> set) throws Exception {
        this.createFiles(folder, set);
        int i = 0;
        while (i < 10) {
            IFileStore child = folder.getChild("fsFolder" + i);
            child.mkdir(0, null);
            set.put(child.toString(), "");
            if (i < 5) {
                this.createFiles(child, set);
            }
            ++i;
        }
    }

    protected void createResourcesInWorkspace(IContainer target, Hashtable<String, String> set) throws CoreException {
        this.createFiles(target, set);
        int i = 0;
        while (i < 10) {
            IFolder child = target.getFolder(IPath.fromOSString((String)("wbFolder" + i)));
            child.create(true, true, null);
            String location = child.getLocation().toOSString();
            set.put(location, "");
            if (i < 5) {
                this.createFiles((IContainer)child, set);
            }
            ++i;
        }
    }

    @Test
    public void testTraverseMechanismInFolder() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFolder folder = project.getFolder("root");
        folder.create(true, true, null);
        Hashtable<String, String> set = new Hashtable<String, String>();
        this.createResourcesInWorkspace((IContainer)folder, set);
        this.createResourcesInFileSystem(((Resource)folder).getStore(), set);
        IUnifiedTreeVisitor visitor = node -> {
            IResource resource = node.getResource();
            IFileStore store = ((Resource)resource).getStore();
            if (node.existsInFileSystem()) {
                Assert.assertEquals((String)"1.0", (Object)store.fetchInfo().getName(), (Object)node.getLocalName());
            }
            Assert.assertEquals((String)"1.1", (Object)store, (Object)node.getStore());
            set.remove(resource.getLocation().toOSString());
            return true;
        };
        UnifiedTree tree = new UnifiedTree((IResource)folder);
        tree.accept(visitor);
        Assert.assertTrue((String)"2.0", (boolean)set.isEmpty());
    }

    @Test
    public void testTraverseMechanismInFolderSkippingSomeChildren() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        IFolder folder = project.getFolder("root");
        folder.create(true, true, null);
        Hashtable<String, String> set = new Hashtable<String, String>();
        this.createResourcesInWorkspace((IContainer)folder, set);
        this.createResourcesInFileSystem(((Resource)folder).getStore(), set);
        IUnifiedTreeVisitor visitor = node -> {
            IResource resource = node.getResource();
            IFileStore store = ((Resource)resource).getStore();
            String key = store.fetchInfo().getName();
            if (node.existsInFileSystem()) {
                Assert.assertEquals((Object)key, (Object)node.getLocalName());
            }
            Assert.assertEquals((Object)store, (Object)node.getStore());
            node.getChildren();
            if (resource.getName().startsWith("fsFolder")) {
                return false;
            }
            set.remove(resource.getLocation().toOSString());
            return true;
        };
        int initialSize = set.size();
        UnifiedTree tree = new UnifiedTree((IResource)folder);
        tree.accept(visitor);
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertTrue((set.size() != initialSize ? 1 : 0) != 0);
    }

    @Test
    public void testTraverseMechanismInProject() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        ResourceTestUtil.createInWorkspace((IResource)project);
        Hashtable<String, String> set = new Hashtable<String, String>();
        this.createResourcesInWorkspace((IContainer)project, set);
        this.createResourcesInFileSystem(((Resource)project).getStore(), set);
        IUnifiedTreeVisitor visitor = node -> {
            IResource resource = node.getResource();
            IFileStore store = ((Resource)resource).getStore();
            if (node.existsInFileSystem()) {
                Assert.assertEquals((Object)store.fetchInfo().getName(), (Object)node.getLocalName());
            }
            Assert.assertEquals((Object)store, (Object)node.getStore());
            set.remove(resource.getLocation().toOSString());
            return true;
        };
        UnifiedTree tree = new UnifiedTree((IResource)project);
        tree.accept(visitor);
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void test342968() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
        ResourceTestUtil.createInWorkspace((IResource)project);
        project.open(ResourceTestUtil.createTestMonitor());
        IProjectDescription description = project.getDescription();
        URI projectLocation = Test342968FileSystem.getTestUriFor(EFS.getLocalFileSystem().fromLocalFile(new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), "test")).toURI());
        description.setLocationURI(projectLocation);
        project.delete(false, false, null);
        project.create(description, 0, null);
        project.open(ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)project.getLocationURI().equals(projectLocation));
        IFolder link = project.getFolder("link");
        File file = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), "link");
        file.mkdir();
        IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
        link.createLink(fileStore.toURI(), 0, null);
        this.workspaceRule.deleteOnTearDown(fileStore);
        IFile rf = link.getFile("fileTest342968.txt");
        rf.create((InputStream)new ByteArrayInputStream("test342968".getBytes()), false, null);
        Assert.assertTrue((String)"1.0", (boolean)rf.exists());
        project.refreshLocal(2, null);
        Assert.assertTrue((String)"2.0", (boolean)rf.exists());
    }

    @Test
    public void test368376() throws CoreException, IOException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        String filePath = "a/b/c/file.txt";
        File javaFile = new File(project.getLocation().toFile(), filePath);
        Assert.assertTrue((boolean)javaFile.getParentFile().mkdirs());
        Assert.assertTrue((boolean)javaFile.createNewFile());
        IFolder folder = project.getFolder("a");
        IFile file = project.getFile(filePath);
        Assert.assertFalse((boolean)folder.exists());
        Assert.assertFalse((boolean)file.exists());
        file.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((boolean)folder.exists());
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)folder.isSynchronized(2));
        project.delete(true, ResourceTestUtil.createTestMonitor());
    }
}

