/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.mapping;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ModelStatus;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.tests.internal.mapping.ChangeDescription;
import org.eclipse.core.tests.internal.mapping.TestModelProvider;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ChangeValidationTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private IResourceChangeDescriptionFactory factory;
    private IProject project;

    private void assertStatusEqual(IStatus status, String[] expectedMessages) {
        int n;
        ArrayList<String> actualMessages = new ArrayList<String>();
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n2 = children.length;
            n = 0;
            while (n < n2) {
                IStatus element = iStatusArray[n];
                String message = this.getModelMessage(element);
                if (message != null) {
                    actualMessages.add(message);
                }
                ++n;
            }
        } else {
            String message = this.getModelMessage(status);
            if (message != null) {
                actualMessages.add(message);
            }
        }
        if (expectedMessages.length < actualMessages.size()) {
            for (String actual : actualMessages) {
                boolean found = false;
                String[] stringArray = expectedMessages;
                int n3 = expectedMessages.length;
                int n4 = 0;
                while (n4 < n3) {
                    String expected = stringArray[n4];
                    if (actual.equals(expected)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (found) continue;
                Assert.fail((String)("Unexpected message returned: " + actual));
            }
        } else {
            String[] stringArray = expectedMessages;
            n = expectedMessages.length;
            int n5 = 0;
            while (n5 < n) {
                String expectedMessage = stringArray[n5];
                if (!actualMessages.contains(expectedMessage)) {
                    Assert.fail((String)("Expect message missing: " + expectedMessage));
                }
                ++n5;
            }
        }
    }

    private IResourceChangeDescriptionFactory createEmptyChangeDescription() {
        return ResourceChangeValidator.getValidator().createDeltaFactory();
    }

    private String getModelMessage(IStatus status) {
        ModelStatus ms;
        String id;
        if (status instanceof ModelStatus && (id = (ms = (ModelStatus)status).getModelProviderId()).equals("org.eclipse.core.tests.resources.modelProvider")) {
            return status.getMessage();
        }
        return null;
    }

    @Before
    public void setUp() throws Exception {
        TestModelProvider.enabled = true;
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IResource[] before = ResourceTestUtil.buildResources((IContainer)this.project, new String[]{"c/", "c/b/", "c/a/", "c/x", "c/b/y", "c/b/z"});
        ResourceTestUtil.createInWorkspace(before);
        ResourceTestUtil.assertExistsInWorkspace(before);
        this.factory = this.createEmptyChangeDescription();
    }

    @After
    public void tearDown() throws Exception {
        TestModelProvider.enabled = false;
    }

    @Test
    public void testCopyReplaceDeletedFolder() {
        IResource folder = this.project.findMember("c/b/");
        IFolder destination = this.project.getFolder("/c/a/");
        this.factory.delete((IResource)destination);
        this.factory.copy(folder, destination.getFullPath());
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Copied {0}", folder)});
    }

    @Test
    public void testFileChanges() {
        this.factory.change((IFile)this.project.findMember("c/x"));
        this.factory.change((IFile)this.project.findMember("c/b/y"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Changed {0}", this.project.findMember("c/x")), ChangeDescription.getMessageFor("Changed {0}", this.project.findMember("c/b/y"))});
    }

    @Test
    public void testFileCopy() {
        this.factory.copy(this.project.findMember("c/x"), IPath.fromOSString((String)"c/x2"));
        this.factory.copy(this.project.findMember("c/b/y"), IPath.fromOSString((String)"c/y"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Copied {0}", this.project.findMember("c/x")), ChangeDescription.getMessageFor("Copied {0}", this.project.findMember("c/b/y"))});
    }

    @Test
    public void testFileCreate() {
        IFile file = this.project.getFile("file");
        this.factory.create((IResource)file);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Added {0}", (IResource)file)});
    }

    @Test
    public void testFileInFolderCreate() {
        IFolder folder = this.project.getFolder("folder");
        IFile file = folder.getFile("file");
        this.factory.create((IResource)folder);
        this.factory.create((IResource)file);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Added {0}", (IResource)folder)});
    }

    @Test
    public void testFileDeletion() {
        this.factory.delete(this.project.findMember("c/x"));
        this.factory.delete(this.project.findMember("c/b/y"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Removed {0}", this.project.findMember("c/x")), ChangeDescription.getMessageFor("Removed {0}", this.project.findMember("c/b/y"))});
        this.assertContentDeletionFlag("Validation should return error status on contents deletion.", true);
    }

    @Test
    public void testFileMoves() {
        this.factory.move(this.project.findMember("c/x"), IPath.fromOSString((String)"c/x2"));
        this.factory.move(this.project.findMember("c/b/y"), IPath.fromOSString((String)"c/y"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Moved {0}", this.project.findMember("c/x")), ChangeDescription.getMessageFor("Moved {0}", this.project.findMember("c/b/y"))});
    }

    @Test
    public void testFolderCopy() {
        IResource folder = this.project.findMember("c/b/");
        this.factory.copy(folder, IPath.fromOSString((String)"c/d"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Copied {0}", folder)});
    }

    @Test
    public void testFolderDeletion() {
        IResource folder = this.project.findMember("c/b/");
        this.factory.delete(folder);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Removed {0}", this.project.findMember("c/b"))});
        this.assertContentDeletionFlag("Validation should return error status on contents deletion.", true);
    }

    @Test
    public void testFolderMove() {
        IResource folder = this.project.findMember("c/b/");
        this.factory.move(folder, IPath.fromOSString((String)"c/d"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Moved {0}", folder)});
    }

    @Test
    public void testMoveReplaceDeletedFolder() {
        IResource folder = this.project.findMember("c/b/");
        IFolder destination = this.project.getFolder("/c/a/");
        this.factory.delete((IResource)destination);
        this.factory.move(folder, destination.getFullPath());
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Moved {0}", folder)});
    }

    @Test
    public void testProjectClose() {
        this.factory.close(this.project);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Closed {0}", (IResource)this.project)});
        this.assertContentDeletionFlag("Validation should return warning status on project close.", false);
    }

    @Test
    public void testProjectCopy() {
        this.factory.copy((IResource)this.project, IPath.fromOSString((String)"MovedProject"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Copied {0}", (IResource)this.project)});
    }

    @Test
    public void testProjectDeletion() {
        this.factory.delete((IResource)this.project);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Removed {0}", (IResource)this.project)});
        this.assertContentDeletionFlag("Validation should return warning status on simple deletion.", false);
    }

    @Test
    public void testProjectDeletionWithContents() {
        this.factory.delete(this.project, true);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Removed {0}", (IResource)this.project)});
        this.assertContentDeletionFlag("Validation should return error status on contents deletion.", true);
    }

    @Test
    public void testProjectDeletionWithoutContents() {
        this.factory.delete(this.project, false);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Removed {0}", (IResource)this.project)});
        this.assertContentDeletionFlag("Validation should return warning status on project removal from workspace.", false);
    }

    @Test
    public void testProjectMove() {
        this.factory.move((IResource)this.project, IPath.fromOSString((String)"MovedProject"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Moved {0}", (IResource)this.project)});
    }

    private void assertContentDeletionFlag(String assertMessage, boolean expectFlag) {
        int expectedStatus = expectFlag ? 4 : 2;
        try {
            TestModelProvider.checkContentsDeletion = true;
            IStatus status = this.validateChange(this.factory);
            Assert.assertEquals((String)assertMessage, (long)expectedStatus, (long)status.getSeverity());
        }
        finally {
            TestModelProvider.checkContentsDeletion = false;
        }
    }

    private IStatus validateChange(IResourceChangeDescriptionFactory f) {
        return ResourceChangeValidator.getValidator().validateChange(f.getDelta(), ResourceTestUtil.createTestMonitor());
    }
}

