/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.mapping;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestProjectDeletion {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private IResourceChangeDescriptionFactory factory;
    private IProject project;
    private static int MASK = 0xFFFFFF;
    private static int KIND_MASK = 255;
    private static int FLAGS_MASK = MASK ^= KIND_MASK;

    @Before
    public void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)this.project, new String[]{"a/", "a/b/", "a/c/", "a/d", "a/b/e", "a/b/f"});
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        this.factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        int kind = this.factory.getDelta().getKind();
        int flags = this.factory.getDelta().getFlags();
        Assert.assertEquals((String)"Projects delta kind should not contain any bits before refactoring.", (long)0L, (long)(kind &= ~KIND_MASK));
        Assert.assertEquals((String)"Projects delta flags should not be set before refactoring.", (long)0L, (long)(flags &= ~FLAGS_MASK));
    }

    @Test
    public void testDeletionWithContents() {
        this.testDeletion(true);
    }

    @Test
    public void testDeletionWithoutContents() {
        this.testDeletion(false);
    }

    private void testDeletion(boolean deleteContents) {
        this.factory.delete(this.project, deleteContents);
        this.checkAffectedChildrenStatus(this.factory.getDelta().getAffectedChildren(), deleteContents);
    }

    private void checkAffectedChildrenStatus(IResourceDelta[] affectedChildren, boolean deleteContents) {
        IResourceDelta[] iResourceDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta iResourceDelta = iResourceDeltaArray[n2];
            Assert.assertEquals((String)"IResourceDelta.REMOVED kind is expected on project deletion.", (long)2L, (long)iResourceDelta.getKind());
            if (deleteContents) {
                Assert.assertEquals((String)"IResourceDelta.DELETE_CONTENT_PROPOSED flag should be set on project contents deletion.", (long)0x800000L, (long)iResourceDelta.getFlags());
            } else {
                Assert.assertEquals((String)"No flags should be set on project deletion from workspace.", (long)0L, (long)iResourceDelta.getFlags());
            }
            this.checkAffectedChildrenStatus(iResourceDelta.getAffectedChildren(), deleteContents);
            ++n2;
        }
    }
}

