/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.properties;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.internal.properties.PropertyManager2;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PropertyManagerTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private IProject project;

    @Before
    public void createTestProject() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
        ResourceTestUtil.createInWorkspace((IResource)this.project);
    }

    private void createProperties(IFile target, QualifiedName[] names, String[] values) throws CoreException {
        int i = 0;
        while (i < names.length) {
            names[i] = new QualifiedName("org.eclipse.core.tests", "prop" + i);
            values[i] = "property value" + i;
            ++i;
        }
        i = 0;
        while (i < names.length) {
            target.setPersistentProperty(names[i], values[i]);
            ++i;
        }
    }

    private Thread[] createThreads(IFile target, QualifiedName[] names, String[] values, CoreException[] errorPointer) {
        int THREAD_COUNT = 3;
        Thread[] threads = new Thread[3];
        int j = 0;
        while (j < 3) {
            String id = "GetSetProperty" + j;
            threads[j] = new Thread(() -> {
                block2: {
                    try {
                        this.doGetSetProperties(target, id, names, values);
                    }
                    catch (CoreException e) {
                        if (!target.exists()) break block2;
                        e.printStackTrace();
                        coreExceptionArray[0] = e;
                        return;
                    }
                }
            }, id);
            threads[j].start();
            ++j;
        }
        return threads;
    }

    protected void doGetSetProperties(IFile target, String threadID, QualifiedName[] names, String[] values) throws CoreException {
        int N = names.length;
        int j = 0;
        while (j < 10) {
            int i = 0;
            while (i < N) {
                target.getPersistentProperty(names[i]);
                ++i;
            }
            i = 0;
            while (i < N) {
                target.setPersistentProperty(names[i], values[i]);
                ++i;
            }
            i = 0;
            while (i < N) {
                target.getPersistentProperty(names[i]);
                ++i;
            }
            ++j;
        }
    }

    @Test
    public void testConcurrentAccess() throws Exception {
        Thread[] threads;
        IFile target = this.project.getFile("target");
        target.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        int N = 50;
        QualifiedName[] names = new QualifiedName[50];
        String[] values = new String[50];
        this.createProperties(target, names, values);
        CoreException[] errorPointer = new CoreException[1];
        Thread[] threadArray = threads = this.createThreads(target, names, values, errorPointer);
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            thread.join();
            ++n2;
        }
        if (errorPointer[0] != null) {
            throw errorPointer[0];
        }
    }

    @Test
    public void testConcurrentDelete() throws Exception {
        IFile target = this.project.getFile("target");
        int REPEAT = 8;
        int i = 0;
        while (i < 8) {
            ResourceTestUtil.createInWorkspace((IResource)this.project);
            ResourceTestUtil.createInWorkspace((IResource)target);
            int N = 50;
            QualifiedName[] names = new QualifiedName[50];
            String[] values = new String[50];
            this.createProperties(target, names, values);
            CoreException[] errorPointer = new CoreException[1];
            Thread[] threads = this.createThreads(target, names, values, errorPointer);
            Thread.sleep(10L);
            target.getProject().delete(0, ResourceTestUtil.createTestMonitor());
            Thread[] threadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                Thread thread = threadArray[n2];
                thread.join();
                ++n2;
            }
            if (errorPointer[0] != null) {
                throw errorPointer[0];
            }
            ++i;
        }
    }

    @Test
    public void testCache() throws Throwable {
        PropertyManager2 manager = new PropertyManager2((Workspace)ResourcesPlugin.getWorkspace());
        IProject source = this.project;
        IFolder sourceFolder = source.getFolder("myfolder");
        IFile sourceFile = sourceFolder.getFile("myfile.txt");
        QualifiedName propName = new QualifiedName("test", "prop");
        String propValue = "this is the property value";
        ResourceTestUtil.createInWorkspace(new IResource[]{source, sourceFolder, sourceFile});
        System.gc();
        System.runFinalization();
        manager.setProperty((IResource)source, propName, propValue);
        manager.setProperty((IResource)sourceFolder, propName, propValue);
        manager.setProperty((IResource)sourceFile, propName, propValue);
        Assert.assertNotNull((String)"1.1", (Object)manager.getProperty((IResource)source, propName));
        String hint = "Property cache returned another instance. Same instance is not required but expected. Eiter the Garbage Collector deleted the cache or the cache is not working.";
        Assert.assertSame((String)(hint + "1.2"), (Object)propValue, (Object)manager.getProperty((IResource)source, propName));
        Assert.assertNotNull((String)"1.3", (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertSame((String)(hint + "1.4"), (Object)propValue, (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertNotNull((String)"1.5", (Object)manager.getProperty((IResource)sourceFile, propName));
        Assert.assertSame((String)(hint + "1.6"), (Object)propValue, (Object)manager.getProperty((IResource)sourceFile, propName));
    }

    @Test
    public void testOOME() throws Throwable {
        PropertyManager2 manager = new PropertyManager2((Workspace)ResourcesPlugin.getWorkspace());
        IProject source = this.project;
        IFolder sourceFolder = source.getFolder("myfolder");
        IFile sourceFile = sourceFolder.getFile("myfile.txt");
        QualifiedName propName = new QualifiedName("test", "prop");
        int MAX_VALUE_SIZE = 2048;
        String propValue = new String(new byte[MAX_VALUE_SIZE], StandardCharsets.ISO_8859_1);
        ResourceTestUtil.createInWorkspace(new IResource[]{source, sourceFolder, sourceFile});
        manager.setProperty((IResource)source, propName, propValue);
        manager.setProperty((IResource)sourceFolder, propName, propValue);
        manager.setProperty((IResource)sourceFile, propName, propValue);
        String hint = "Property cache returned another instance. Same instance is not required but expected. Eiter the Garbage Collector deleted the cache or the cache is not working.";
        Assert.assertSame((String)(hint + "1.2"), (Object)propValue, (Object)manager.getProperty((IResource)source, propName));
        Assert.assertNotNull((String)"1.3", (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertSame((String)(hint + "1.4"), (Object)propValue, (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertNotNull((String)"1.5", (Object)manager.getProperty((IResource)sourceFile, propName));
        Assert.assertSame((String)(hint + "1.6"), (Object)propValue, (Object)manager.getProperty((IResource)sourceFile, propName));
        LinkedList<byte[]> wastedMemory = new LinkedList<byte[]>();
        try {
            long maxMemory = Runtime.getRuntime().maxMemory();
            int quickAllocationSize = Math.max(200000000, (int)Math.min(0x7FFFFFF7L, maxMemory / 2L));
            System.out.println("Waste memory to force OOME: " + quickAllocationSize + "/" + maxMemory);
            while (wastedMemory.add(new byte[quickAllocationSize])) {
                System.out.println("Waste memory to force OOME: " + quickAllocationSize);
            }
        }
        catch (OutOfMemoryError e1) {
            wastedMemory.clear();
            wastedMemory = null;
            System.gc();
            Assert.assertNotEquals((Object)"Requested array size exceeds VM limit", (Object)e1.getMessage());
        }
        Assert.assertNotNull((String)"2.1", (Object)manager.getProperty((IResource)source, propName));
        Assert.assertEquals((String)"2.2", (Object)propValue, (Object)manager.getProperty((IResource)source, propName));
        Assert.assertNotSame((String)"2.3", (Object)propValue, (Object)manager.getProperty((IResource)source, propName));
        Assert.assertNotNull((String)"3.1", (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertEquals((String)"3.2", (Object)propValue, (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertNotSame((String)"3.3", (Object)propValue, (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertNotNull((String)"4.1", (Object)manager.getProperty((IResource)sourceFile, propName));
        Assert.assertEquals((String)"4.2", (Object)propValue, (Object)manager.getProperty((IResource)sourceFile, propName));
        Assert.assertSame((String)"4.3", (Object)propValue, (Object)manager.getProperty((IResource)sourceFile, propName));
    }

    @Test
    public void testCopy() throws Throwable {
        PropertyManager2 manager = new PropertyManager2((Workspace)ResourcesPlugin.getWorkspace());
        IProject source = this.project;
        IFolder sourceFolder = source.getFolder("myfolder");
        IFile sourceFile = sourceFolder.getFile("myfile.txt");
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("destination");
        ResourceTestUtil.createInWorkspace((IResource)destination);
        IFolder destFolder = destination.getFolder(sourceFolder.getName());
        IFile destFile = destFolder.getFile(sourceFile.getName());
        QualifiedName propName = new QualifiedName("test", "prop");
        String propValue = "this is the property value";
        ResourceTestUtil.createInWorkspace(new IResource[]{source, sourceFolder, sourceFile});
        manager.setProperty((IResource)source, propName, propValue);
        manager.setProperty((IResource)sourceFolder, propName, propValue);
        manager.setProperty((IResource)sourceFile, propName, propValue);
        Assert.assertNotNull((String)"1.1", (Object)manager.getProperty((IResource)source, propName));
        Assert.assertTrue((String)"1.2", (boolean)manager.getProperty((IResource)source, propName).equals(propValue));
        Assert.assertNotNull((String)"1.3", (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertTrue((String)"1.4", (boolean)manager.getProperty((IResource)sourceFolder, propName).equals(propValue));
        Assert.assertNotNull((String)"1.5", (Object)manager.getProperty((IResource)sourceFile, propName));
        Assert.assertTrue((String)"1.6", (boolean)manager.getProperty((IResource)sourceFile, propName).equals(propValue));
        manager.copy((IResource)source, (IResource)destination, 2);
        Assert.assertNotNull((String)"1.7", (Object)manager.getProperty((IResource)destination, propName));
        Assert.assertTrue((String)"1.8", (boolean)manager.getProperty((IResource)destination, propName).equals(propValue));
        Assert.assertNotNull((String)"1.9", (Object)manager.getProperty((IResource)destFolder, propName));
        Assert.assertTrue((String)"1.10", (boolean)manager.getProperty((IResource)destFolder, propName).equals(propValue));
        Assert.assertNotNull((String)"1.11", (Object)manager.getProperty((IResource)destFile, propName));
        Assert.assertTrue((String)"1.12", (boolean)manager.getProperty((IResource)destFile, propName).equals(propValue));
        manager.deleteProperties((IResource)source, 2);
        manager.deleteProperties((IResource)destination, 2);
        Assert.assertNull((String)"2.0", (Object)manager.getProperty((IResource)source, propName));
        Assert.assertNull((String)"2.1", (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertNull((String)"2.2", (Object)manager.getProperty((IResource)sourceFile, propName));
        Assert.assertNull((String)"2.3", (Object)manager.getProperty((IResource)destination, propName));
        Assert.assertNull((String)"2.4", (Object)manager.getProperty((IResource)destFolder, propName));
        Assert.assertNull((String)"2.5", (Object)manager.getProperty((IResource)destFile, propName));
        manager.setProperty((IResource)sourceFolder, propName, propValue);
        manager.setProperty((IResource)sourceFile, propName, propValue);
        Assert.assertNotNull((String)"2.6", (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertTrue((String)"2.7", (boolean)manager.getProperty((IResource)sourceFolder, propName).equals(propValue));
        Assert.assertNotNull((String)"2.8", (Object)manager.getProperty((IResource)sourceFile, propName));
        Assert.assertTrue((String)"2.9", (boolean)manager.getProperty((IResource)sourceFile, propName).equals(propValue));
        manager.copy((IResource)sourceFolder, (IResource)destFolder, 2);
        Assert.assertNotNull((String)"2.10", (Object)manager.getProperty((IResource)destFolder, propName));
        Assert.assertTrue((String)"2.11", (boolean)manager.getProperty((IResource)destFolder, propName).equals(propValue));
        Assert.assertNotNull((String)"2.12", (Object)manager.getProperty((IResource)destFile, propName));
        Assert.assertTrue((String)"2.13", (boolean)manager.getProperty((IResource)destFile, propName).equals(propValue));
        String newPropValue = "change property value";
        manager.setProperty((IResource)source, propName, newPropValue);
        Assert.assertTrue((String)"2.0", (boolean)manager.getProperty((IResource)source, propName).equals(newPropValue));
        manager.copy((IResource)source, (IResource)destination, 2);
        Assert.assertTrue((String)"2.1", (boolean)manager.getProperty((IResource)destination, propName).equals(newPropValue));
    }

    @Test
    public void testDeleteProperties() throws Throwable {
        PropertyManager2 manager = new PropertyManager2((Workspace)ResourcesPlugin.getWorkspace());
        IFile target = this.project.getFile("target");
        ResourceTestUtil.createInWorkspace((IResource)target);
        QualifiedName propName = new QualifiedName("eclipse", "prop");
        String propValue = "this is the property value";
        manager.setProperty((IResource)target, propName, propValue);
        Assert.assertTrue((String)"1.1", (boolean)manager.getProperty((IResource)target, propName).equals(propValue));
        manager.deleteProperties((IResource)target, 2);
        Assert.assertTrue((String)"1.3", (manager.getProperty((IResource)target, propName) == null ? 1 : 0) != 0);
        IProject source = this.project;
        IFolder sourceFolder = source.getFolder("myfolder");
        IFile sourceFile = sourceFolder.getFile("myfile.txt");
        propName = new QualifiedName("test", "prop");
        propValue = "this is the property value";
        ResourceTestUtil.createInWorkspace(new IResource[]{source, sourceFolder, sourceFile});
        manager.setProperty((IResource)source, propName, propValue);
        manager.setProperty((IResource)sourceFolder, propName, propValue);
        manager.setProperty((IResource)sourceFile, propName, propValue);
        Assert.assertNotNull((String)"2.1", (Object)manager.getProperty((IResource)source, propName));
        Assert.assertTrue((String)"2.2", (boolean)manager.getProperty((IResource)source, propName).equals(propValue));
        Assert.assertNotNull((String)"2.3", (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertTrue((String)"2.4", (boolean)manager.getProperty((IResource)sourceFolder, propName).equals(propValue));
        Assert.assertNotNull((String)"2.5", (Object)manager.getProperty((IResource)sourceFile, propName));
        Assert.assertTrue((String)"2.6", (boolean)manager.getProperty((IResource)sourceFile, propName).equals(propValue));
        manager.deleteProperties((IResource)source, 2);
        Assert.assertNull((String)"3.1", (Object)manager.getProperty((IResource)source, propName));
        Assert.assertNull((String)"3.2", (Object)manager.getProperty((IResource)sourceFolder, propName));
        Assert.assertNull((String)"3.3", (Object)manager.getProperty((IResource)sourceFile, propName));
    }

    @Test
    public void testFileRename() throws CoreException {
        IFolder folder = this.project.getFolder("folder");
        IFile file1a = folder.getFile("file1");
        ResourceTestUtil.createInWorkspace((IResource)file1a);
        QualifiedName key = new QualifiedName("org.eclipse.core.tests.resources", "key");
        file1a.setPersistentProperty(key, "value");
        file1a.move(IPath.fromOSString((String)"file2"), true, ResourceTestUtil.createTestMonitor());
        IFile file1b = folder.getFile("file1");
        ResourceTestUtil.createInWorkspace((IResource)file1b);
        String value = null;
        value = file1b.getPersistentProperty(key);
        Assert.assertNull((String)"1.0", (Object)value);
        file1a = folder.getFile("file2");
        value = file1a.getPersistentProperty(key);
        Assert.assertEquals((String)"2.0", (Object)"value", (Object)value);
    }

    @Test
    public void testFolderRename() throws CoreException {
        IFolder folder1a = this.project.getFolder("folder1");
        ResourceTestUtil.createInWorkspace((IResource)folder1a);
        QualifiedName key = new QualifiedName("org.eclipse.core.tests.resources", "key");
        folder1a.setPersistentProperty(key, "value");
        folder1a.move(IPath.fromOSString((String)"folder2"), true, ResourceTestUtil.createTestMonitor());
        IFolder folder1b = this.project.getFolder("folder1");
        ResourceTestUtil.createInWorkspace((IResource)folder1b);
        String value = null;
        value = folder1b.getPersistentProperty(key);
        Assert.assertNull((String)"1.0", (Object)value);
        folder1a = this.project.getFolder("folder2");
        value = folder1a.getPersistentProperty(key);
        Assert.assertEquals((String)"2.0", (Object)"value", (Object)value);
    }

    @Test
    public void testLargeProperty() throws CoreException {
        IFile target = this.project.getFile("target");
        target.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        QualifiedName name = new QualifiedName("stressTest", "prop");
        int SIZE = 10000;
        StringBuilder valueBuf = new StringBuilder(10000);
        int i = 0;
        while (i < 10000) {
            valueBuf.append("a");
            ++i;
        }
        String value = valueBuf.toString();
        Assert.assertThrows(CoreException.class, () -> target.setPersistentProperty(name, value));
    }

    @Test
    public void testProjectRename() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project1a = root.getProject("proj1");
        ResourceTestUtil.createInWorkspace((IResource)project1a);
        QualifiedName key = new QualifiedName("org.eclipse.core.tests.resources", "key");
        project1a.setPersistentProperty(key, "value");
        project1a.move(IPath.fromOSString((String)"proj2"), true, ResourceTestUtil.createTestMonitor());
        IProject project1b = root.getProject("proj1");
        ResourceTestUtil.createInWorkspace((IResource)project1b);
        String value = project1b.getPersistentProperty(key);
        Assert.assertNull((String)"1.0", (Object)value);
        project1a = root.getProject("proj2");
        value = project1a.getPersistentProperty(key);
        Assert.assertEquals((String)"2.0", (Object)"value", (Object)value);
    }

    @Test
    public void testProperties() throws Throwable {
        PropertyManager2 manager = new PropertyManager2((Workspace)ResourcesPlugin.getWorkspace());
        IFile target = this.project.getFile("target");
        target.create(null, false, ResourceTestUtil.createTestMonitor());
        QualifiedName propName1 = new QualifiedName("org.eclipse.core.tests", "prop1");
        QualifiedName propName2 = new QualifiedName("org.eclipse.core.tests", "prop2");
        QualifiedName propName3 = new QualifiedName("org.eclipse.core.tests", "prop3");
        String propValue1 = "this is the property value1";
        String propValue2 = "this is the property value2";
        String propValue3 = "this is the property value3";
        ArrayList<StoredProperty> props = new ArrayList<StoredProperty>(3);
        props.add(new StoredProperty(propName1, propValue1));
        props.add(new StoredProperty(propName2, propValue2));
        props.add(new StoredProperty(propName3, propValue3));
        for (StoredProperty prop : props) {
            manager.setProperty((IResource)target, prop.getName(), prop.getStringValue());
            Assert.assertEquals((String)("1.0." + String.valueOf(prop.getName())), (Object)prop.getStringValue(), (Object)manager.getProperty((IResource)target, prop.getName()));
        }
        for (StoredProperty prop : props) {
            manager.setProperty((IResource)target, prop.getName(), null);
            Assert.assertEquals((String)("2.0." + String.valueOf(prop.getName())), null, (Object)manager.getProperty((IResource)target, prop.getName()));
        }
        Assert.assertEquals((String)"3.0", (long)0L, (long)manager.getProperties((IResource)target).size());
        manager.deleteProperties((IResource)target, 2);
    }

    @Test
    public void testSimpleUpdate() throws CoreException {
        IFile target = this.project.getFile("target");
        target.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        int N = 3;
        QualifiedName[] names = new QualifiedName[3];
        String[] values = new String[N];
        int i = 0;
        while (i < N) {
            names[i] = new QualifiedName("org.eclipse.core.tests", "prop" + i);
            values[i] = "property value" + i;
            ++i;
        }
        i = 0;
        while (i < N) {
            target.setPersistentProperty(names[i], values[i]);
            ++i;
        }
        i = 0;
        while (i < N) {
            Assert.assertTrue((String)"2.0", (boolean)target.getPersistentProperty(names[i]).equals(values[i]));
            ++i;
        }
        int j = 0;
        while (j < 20) {
            int i2 = 0;
            while (i2 < N) {
                values[i2] = values[i2] + " - changed";
                target.setPersistentProperty(names[i2], values[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < N) {
                Assert.assertTrue((String)"5.0", (boolean)target.getPersistentProperty(names[i2]).equals(values[i2]));
                ++i2;
            }
            ++j;
        }
    }

    @Test
    public void testFileDeleteTraversalDepth() throws CoreException {
        ArgumentCaptor resourceArgCaptor = ArgumentCaptor.forClass(IResource.class);
        ArgumentCaptor depthArgCapture = ArgumentCaptor.forClass(Integer.class);
        IFolder tempFolder = this.project.getFolder("temp");
        tempFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IFile fileToBeDeleted = tempFolder.getFile("testfile0");
        fileToBeDeleted.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        fileToBeDeleted.setPersistentProperty(new QualifiedName(this.getClass().getName(), fileToBeDeleted.getName()), fileToBeDeleted.getName());
        MockitoAnnotations.openMocks((Object)this);
        Workspace ws = (Workspace)Mockito.spy((Object)new Workspace());
        PropertyManager2 manager = (PropertyManager2)Mockito.spy((Object)new PropertyManager2(ws));
        manager.deleteResource((IResource)fileToBeDeleted);
        ((PropertyManager2)Mockito.verify((Object)manager)).deleteProperties((IResource)resourceArgCaptor.capture(), ((Integer)depthArgCapture.capture()).intValue());
        Integer expectedDepth = 0;
        Assert.assertEquals((Object)expectedDepth, (Object)depthArgCapture.getValue());
    }

    public static class StoredProperty {
        protected QualifiedName name = null;
        protected String value = null;

        public StoredProperty(QualifiedName name, String value) {
            this.name = name;
            this.value = value;
        }

        public QualifiedName getName() {
            return this.name;
        }

        public String getStringValue() {
            return this.value;
        }
    }
}

