/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.propertytester;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.internal.propertytester.FilePropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@ExtendWith(value={WorkspaceResetExtension.class})
public class FilePropertyTesterTest {
    private static final String CONTENT_TYPE_ID = "contentTypeId";
    private static final String IS_KIND_OF = "kindOf";
    private static final String USE_FILENAME_ONLY = "useFilenameOnly";
    private FilePropertyTester tester = null;
    private IProject project = null;

    @BeforeEach
    public void setUp() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("project1");
        this.project.create(ResourceTestUtil.createTestMonitor());
        this.project.open(ResourceTestUtil.createTestMonitor());
        this.tester = new FilePropertyTester();
    }

    private static Stream<List<String>> arguments() {
        return Stream.of(List.of(), List.of(IS_KIND_OF), List.of(USE_FILENAME_ONLY), List.of(IS_KIND_OF, USE_FILENAME_ONLY));
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    public void testNonExistingTextFile(List<String> arguments) throws Throwable {
        String expected = "org.eclipse.core.runtime.text";
        IFile target = this.project.getFile("tmp.txt");
        boolean testResult = this.tester.test((Object)target, CONTENT_TYPE_ID, arguments.toArray(), (Object)expected);
        Assertions.assertEquals((Object)arguments.contains(USE_FILENAME_ONLY), (Object)testResult);
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    public void testExistingTextFile(List<String> arguments) throws Throwable {
        String expected = "org.eclipse.core.runtime.text";
        IFile target = this.project.getFile("tmp.txt");
        target.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        Assertions.assertTrue((boolean)this.tester.test((Object)target, CONTENT_TYPE_ID, arguments.toArray(), (Object)expected));
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    public void testNonExistingNsRootElementFile(List<String> arguments) throws Throwable {
        String expectedBase = "org.eclipse.core.runtime.xml";
        String expectedExact = "org.eclipse.core.tests.resources.ns-root-element";
        String expected = arguments.isEmpty() ? expectedExact : expectedBase;
        IFile target = this.project.getFile("tmp.xml");
        boolean testResult = this.tester.test((Object)target, CONTENT_TYPE_ID, arguments.toArray(), (Object)expected);
        Assertions.assertEquals((Object)arguments.contains(USE_FILENAME_ONLY), (Object)testResult);
    }

    @ParameterizedTest
    @MethodSource(value={"arguments"})
    public void testExistingNsRootElementFile(List<String> arguments) throws Throwable {
        String expectedBase = "org.eclipse.core.runtime.xml";
        String expectedExact = "org.eclipse.core.tests.resources.ns-root-element";
        String expected = arguments.isEmpty() ? expectedExact : expectedBase;
        IFile target = this.project.getFile("tmp.xml");
        byte[] bytes = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><prefix:rootElement1 xmlns:prefix='urn:eclipse.core.runtime.ns1'/>".getBytes(StandardCharsets.UTF_8);
        target.create((InputStream)new ByteArrayInputStream(bytes), true, ResourceTestUtil.createTestMonitor());
        Assertions.assertTrue((boolean)this.tester.test((Object)target, CONTENT_TYPE_ID, arguments.toArray(), (Object)expected));
    }
}

