/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Bug544975Test {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Test
    public void testBug544975ProjectOpenBackgroundRefresh() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("Bug544975");
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        boolean originalRefreshSetting = prefs.getBoolean("refresh.enabled", false);
        try {
            prefs.putBoolean("refresh.enabled", true);
            ResourceTestUtil.createInWorkspace((IResource)project);
            this.createFile(project, "someFile.txt", "some text");
            IFile file1 = project.getFile("someFile.txt");
            Assert.assertTrue((boolean)file1.exists());
            IFile file2 = project.getFile("someOtherFile.txt");
            Assert.assertFalse((boolean)file2.exists());
            project.close((IProgressMonitor)new NullProgressMonitor());
            Path projectPath = Paths.get(project.getLocationURI());
            Assert.assertTrue((String)"Test project must exist on file system", (boolean)Files.exists(projectPath, new LinkOption[0]));
            Path filePath = projectPath.resolve("someFile.txt");
            Files.delete(filePath);
            filePath = projectPath.resolve("someOtherFile.txt");
            Files.createFile(filePath, new FileAttribute[0]);
            project.open(128, (IProgressMonitor)new NullProgressMonitor());
            Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, (IProgressMonitor)new NullProgressMonitor());
            file1 = project.getFile("someFile.txt");
            Assert.assertFalse((String)"Expected deleted project resource not exist after opening with BACKGROUND_REFRESH", (boolean)file1.exists());
            file2 = project.getFile("someOtherFile.txt");
            Assert.assertTrue((String)"Expected new project resource to be found after opening with BACKGROUND_REFRESH", (boolean)file2.exists());
        }
        finally {
            prefs.putBoolean("refresh.enabled", originalRefreshSetting);
        }
    }

    @Test
    public void testBug544975ProjectOpenWithoutBackgroundRefresh() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("Bug544975");
        ResourceTestUtil.createInWorkspace((IResource)project);
        this.createFile(project, "someFile.txt", "some text");
        IFile file1 = project.getFile("someFile.txt");
        Assert.assertTrue((boolean)file1.exists());
        IFile file2 = project.getFile("someOtherFile.txt");
        Assert.assertFalse((boolean)file2.exists());
        project.close((IProgressMonitor)new NullProgressMonitor());
        Path projectPath = Paths.get(project.getLocationURI());
        Assert.assertTrue((String)"Test project must exist on file system", (boolean)Files.exists(projectPath, new LinkOption[0]));
        Path filePath = projectPath.resolve("someFile.txt");
        Files.delete(filePath);
        filePath = projectPath.resolve("someOtherFile.txt");
        Files.createFile(filePath, new FileAttribute[0]);
        project.open(0, (IProgressMonitor)new NullProgressMonitor());
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, (IProgressMonitor)new NullProgressMonitor());
        file1 = project.getFile("someFile.txt");
        Assert.assertTrue((String)"Expected deleted project resource still exist after opening without BACKGROUND_REFRESH", (boolean)file1.exists());
        file2 = project.getFile("someOtherFile.txt");
        Assert.assertFalse((String)"Expected new project resource not to be found after opening without BACKGROUND_REFRESH", (boolean)file2.exists());
    }

    private IFile createFile(IProject project, String fileName, String initialContents) throws CoreException {
        IFile file = project.getFile(fileName);
        file.create(null, true, ResourceTestUtil.createTestMonitor());
        file.setContents(initialContents.getBytes(), 1, (IProgressMonitor)new NullProgressMonitor());
        return file;
    }
}

