/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class Bug552185PerformanceTest {
    public void testBug552185Performance() throws Exception {
        WorkspaceJob testJob = new WorkspaceJob(Bug552185PerformanceTest.class.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    Bug552185PerformanceTest.runBenchmark(monitor);
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.core.resources", "Benchmark failed.", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        testJob.schedule();
        testJob.join();
    }

    static void runBenchmark(IProgressMonitor monitor) throws CoreException {
        Bug552185PerformanceTest.runBenchmark(1, 10000, monitor);
        Bug552185PerformanceTest.runBenchmark(10000, 1, monitor);
        Bug552185PerformanceTest.runBenchmark(10, 1000, monitor);
        Bug552185PerformanceTest.runBenchmark(1, 100000, monitor);
        Bug552185PerformanceTest.runBenchmark(100000, 1, monitor);
    }

    static void runBenchmark(int directoriesCount, int fileCountPerDirectory, IProgressMonitor monitor) throws CoreException {
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        boolean local = false;
        IProject project = root.getProject("TestBug552185ResourcesIO");
        try {
            project.create(monitor);
            project.open(monitor);
            System.out.println("Creating " + directoriesCount + " directories with " + fileCountPerDirectory + " files each");
            long start = System.currentTimeMillis();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)directoriesCount);
            int i = 0;
            while (i < directoriesCount) {
                IFolder folder = project.getFolder("folder" + i);
                SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)subMonitor, (String)("Creating directory " + folder.getName()), (int)fileCountPerDirectory);
                folder.create(1, local, (IProgressMonitor)subMonitor);
                int j = 0;
                while (j < fileCountPerDirectory) {
                    subMonitor2.checkCanceled();
                    IFile file = folder.getFile("file" + j);
                    String content = "file content " + j;
                    file.create(content.getBytes(), 1, (IProgressMonitor)subMonitor2);
                    subMonitor2.worked(1);
                    ++j;
                }
                subMonitor.worked(1);
                ++i;
            }
            subMonitor.done();
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            System.out.println("Elapsed: " + elapsed + " ms");
        }
        finally {
            if (project.exists()) {
                project.delete(1, monitor);
            }
        }
    }
}

