/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractUriAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.LocalMetaArea;
import org.eclipse.core.internal.resources.ModelObjectWriter;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.xml.sax.InputSource;

public class ModelObjectReaderWriterTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    static final IPath LONG_LOCATION = IPath.fromOSString((String)"/eclipse/dev/i0218/eclipse/pffds/fds//fds///fdsfsdfsd///fdsfdsf/fsdfsdfsd/lugi/dsds/fsd//f/ffdsfdsf/fsdfdsfsd/fds//fdsfdsfdsf/fdsfdsfds/fdsfdsfdsf/fdsfdsfdsds/ns/org.eclipse.help.ui_2.1.0/contexts.xml").setDevice(Platform.OS.isWindows() ? "D:" : null);
    static final URI LONG_LOCATION_URI = LONG_LOCATION.toFile().toURI();
    private static final String PATH_STRING = IPath.fromOSString((String)"/abc/def").setDevice(Platform.OS.isWindows() ? "D:" : null).toString();

    private HashMap<String, ProjectDescription> buildBaselineDescriptors() {
        HashMap<String, ProjectDescription> result = new HashMap<String, ProjectDescription>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ProjectDescription desc = new ProjectDescription();
        desc.setName("abc.project");
        ICommand[] commands = new ICommand[]{desc.newCommand()};
        commands[0].setBuilderName("org.eclipse.jdt.core.javabuilder");
        desc.setBuildSpec(commands);
        String[] natures = new String[]{"org.eclipse.jdt.core.javanature"};
        desc.setNatureIds(natures);
        HashMap<IPath, LinkDescription> linkMap = new HashMap<IPath, LinkDescription>();
        LinkDescription link = this.createLinkDescription("newLink", 2, "d:/abc/def");
        linkMap.put(link.getProjectRelativePath(), link);
        desc.setLinkDescriptions(linkMap);
        result.put(desc.getName(), desc);
        commands = null;
        natures = null;
        link = null;
        linkMap = null;
        desc = null;
        desc = new ProjectDescription();
        desc.setName("def.project");
        commands = new ICommand[]{desc.newCommand()};
        commands[0].setBuilderName("org.eclipse.jdt.core.javabuilder");
        desc.setBuildSpec(commands);
        natures = new String[]{"org.eclipse.jdt.core.javanature"};
        desc.setNatureIds(natures);
        linkMap = new HashMap();
        link = this.createLinkDescription("newLink", 2, "d:/abc/def");
        linkMap.put(link.getProjectRelativePath(), link);
        link = this.createLinkDescription("link2", 2, "d:/abc");
        linkMap.put(link.getProjectRelativePath(), link);
        link = this.createLinkDescription("link3", 2, "d:/abc/def/ghi");
        linkMap.put(link.getProjectRelativePath(), link);
        link = this.createLinkDescription("link4", 1, "d:/abc/def/afile.txt");
        linkMap.put(link.getProjectRelativePath(), link);
        desc.setLinkDescriptions(linkMap);
        result.put(desc.getName(), desc);
        commands = null;
        natures = null;
        link = null;
        linkMap = null;
        desc = null;
        desc = new ProjectDescription();
        desc.setName("org.apache.lucene.project");
        Project[] refProjects = new Project[]{root.getProject("org.eclipse.core.boot"), root.getProject("org.eclipse.core.runtime")};
        desc.setReferencedProjects((IProject[])refProjects);
        commands = new ICommand[3];
        commands[0] = desc.newCommand();
        commands[0].setBuilderName("org.eclipse.jdt.core.javabuilder");
        commands[1] = desc.newCommand();
        commands[1].setBuilderName("org.eclipse.pde.ManifestBuilder");
        commands[2] = desc.newCommand();
        commands[2].setBuilderName("org.eclipse.pde.SchemaBuilder");
        desc.setBuildSpec(commands);
        natures = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"};
        desc.setNatureIds(natures);
        result.put(desc.getName(), desc);
        refProjects = null;
        commands = null;
        natures = null;
        desc = null;
        desc = new ProjectDescription();
        desc.setName("org.eclipse.ant.core.project");
        refProjects = new Project[]{root.getProject("org.apache.ant"), root.getProject("org.apache.xerces"), root.getProject("org.eclipse.core.boot"), root.getProject("org.eclipse.core.runtime")};
        desc.setReferencedProjects((IProject[])refProjects);
        commands = new ICommand[2];
        commands[0] = desc.newCommand();
        commands[0].setBuilderName("org.eclipse.jdt.core.javabuilder");
        commands[1] = desc.newCommand();
        commands[1].setBuilderName("org.eclipse.ui.externaltools.ExternalToolBuilder");
        HashMap<String, String> argMap = new HashMap<String, String>();
        argMap.put("!{tool_show_log}", "true");
        argMap.put("!{tool_refresh}", "${none}");
        argMap.put("!{tool_name}", "org.eclipse.ant.core extra builder");
        argMap.put("!{tool_dir}", "");
        argMap.put("!{tool_args}", "-DbuildType=${build_type}");
        argMap.put("!{tool_loc}", "${workspace_loc:/org.eclipse.ant.core/scripts/buildExtraJAR.xml}");
        argMap.put("!{tool_type}", "org.eclipse.ui.externaltools.type.ant");
        commands[1].setArguments(argMap);
        desc.setBuildSpec(commands);
        natures = new String[]{"org.eclipse.jdt.core.javanature"};
        desc.setNatureIds(natures);
        result.put(desc.getName(), desc);
        refProjects = null;
        commands = null;
        natures = null;
        desc = null;
        return result;
    }

    private void compareBuildSpecs(ICommand[] commands, ICommand[] commands2) {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])commands).as("compare number of commands", new Object[0])).hasSameSizeAs((Object)commands2);
        int i = 0;
        while (i < commands.length) {
            ((AbstractStringAssert)Assertions.assertThat((String)commands[i].getBuilderName()).as("compare names of builders at index %s", new Object[]{i})).isEqualTo(commands2[i].getBuilderName());
            Map args = commands[i].getArguments();
            Map args2 = commands2[i].getArguments();
            ((AbstractCollectionAssert)Assertions.assertThat(args.entrySet()).as("compare number of arguments for builder at index %s", new Object[]{i})).hasSize(args2.size());
            for (Map.Entry entry : args.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                String value2 = (String)args2.get(key);
                if (value == null) {
                    ((AbstractStringAssert)Assertions.assertThat((String)value2).as("value for key '%s'", new Object[]{key})).isNull();
                    continue;
                }
                ((AbstractStringAssert)Assertions.assertThat((String)((String)args.get(key))).as("compare values for key: %s", new Object[]{key})).isEqualTo((String)args2.get(key));
            }
            ++i;
        }
    }

    private void compareProjectDescriptions(int errorTag, ProjectDescription description, ProjectDescription description2) {
        Assertions.assertThat((String)description.getName()).isEqualTo(description2.getName());
        String comment = description.getComment();
        if (comment == null) {
            Assertions.assertThat((String)description2.getComment()).isEmpty();
        } else {
            Assertions.assertThat((String)description.getComment()).isEqualTo(description2.getComment());
        }
        IProject[] projects = description.getReferencedProjects();
        IProject[] projects2 = description2.getReferencedProjects();
        this.compareProjects(projects, projects2);
        ICommand[] commands = description.getBuildSpec();
        ICommand[] commands2 = description2.getBuildSpec();
        this.compareBuildSpecs(commands, commands2);
        Object[] natures = description.getNatureIds();
        String[] natures2 = description2.getNatureIds();
        Assertions.assertThat((Object[])natures).isEqualTo((Object)natures2);
        HashMap links = description.getLinks();
        HashMap links2 = description2.getLinks();
        Assertions.assertThat((Map)links).isEqualTo((Object)links2);
    }

    private void compareProjects(IProject[] projects, IProject[] projects2) {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])projects).as("compare number of projects", new Object[0])).hasSameSizeAs((Object)projects2);
        int i = 0;
        while (i < projects.length) {
            ((AbstractStringAssert)Assertions.assertThat((String)projects[i].getName()).as("compare names of projects at index %s", new Object[]{i})).isEqualTo(projects2[i].getName());
            ++i;
        }
    }

    protected boolean contains(Object key, Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (key.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private LinkDescription createLinkDescription(IPath path, int type, URI location) {
        LinkDescription result = new LinkDescription();
        result.setPath(path);
        result.setType(type);
        result.setLocationURI(location);
        return result;
    }

    private LinkDescription createLinkDescription(String path, int type, String location) {
        return this.createLinkDescription(IPath.fromOSString((String)path), type, this.uriFromPortableString(location));
    }

    private String getLongDescription() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name>org.eclipse.help.ui</name><comment></comment><charset>UTF-8</charset>\t<projects>\t<project>org.eclipse.core.boot</project>\t<project>org.eclipse.core.resources</project>\t<project>org.eclipse.core.runtime</project>\t<project>org.eclipse.help</project>\t<project>org.eclipse.help.appserver</project>\t<project>org.eclipse.search</project>\t<project>org.eclipse.ui</project>\t</projects>\t<buildSpec>\t<buildCommand>\t<name>org.eclipse.jdt.core.javabuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t<buildCommand>\t<name>org.eclipse.pde.ManifestBuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t<buildCommand>\t<name>org.eclipse.pde.SchemaBuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t</buildSpec>\t<natures>\t<nature>org.eclipse.jdt.core.javanature</nature>\t<nature>org.eclipse.pde.PluginNature</nature>\t</natures>\t<linkedResources>\t<link>\t<name>contexts.xml</name>\t<type>1</type>\t<location>" + String.valueOf(LONG_LOCATION) + "</location>\t</link>\t<link>\t<name>doc</name>\t<type>2</type>\t<location>" + String.valueOf(LONG_LOCATION) + "</location>\t</link>\t<link>\t<name>icons</name>\t<type>2</type>\t<location>" + String.valueOf(LONG_LOCATION) + "</location>\t</link>\t<link>\t<name>preferences.ini</name>\t<type>1</type>\t<location>" + String.valueOf(LONG_LOCATION) + "</location>\t</link>\t<link>\t<name>.options</name>\t<type>1</type>\t<location>" + String.valueOf(LONG_LOCATION) + "</location>\t</link>\t<link>\t<name>plugin.properties</name>\t<type>1</type>\t<location>" + String.valueOf(LONG_LOCATION) + "</location>\t</link>\t<link>\t<name>plugin.xml</name>\t<type>1</type>\t<location>" + String.valueOf(LONG_LOCATION) + "</location>\t</link>\t<link>\t<name>about.html</name>\t<type>1</type>\t<location>" + String.valueOf(LONG_LOCATION) + "</location>\t</link>\t<link>\t<name>helpworkbench.jar</name>\t<type>1</type>\t<location>" + String.valueOf(LONG_LOCATION) + "</location>\t</link></linkedResources></projectDescription>";
    }

    private String getLongDescriptionURI() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name>org.eclipse.help.ui</name><comment></comment><charset>UTF-8</charset>\t<projects>\t<project>org.eclipse.core.boot</project>\t<project>org.eclipse.core.resources</project>\t<project>org.eclipse.core.runtime</project>\t<project>org.eclipse.help</project>\t<project>org.eclipse.help.appserver</project>\t<project>org.eclipse.search</project>\t<project>org.eclipse.ui</project>\t</projects>\t<buildSpec>\t<buildCommand>\t<name>org.eclipse.jdt.core.javabuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t<buildCommand>\t<name>org.eclipse.pde.ManifestBuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t<buildCommand>\t<name>org.eclipse.pde.SchemaBuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t</buildSpec>\t<natures>\t<nature>org.eclipse.jdt.core.javanature</nature>\t<nature>org.eclipse.pde.PluginNature</nature>\t</natures>\t<linkedResources>\t<link>\t<name>contexts.xml</name>\t<type>1</type>\t<locationURI>" + String.valueOf(LONG_LOCATION_URI) + "</locationURI>\t</link>\t<link>\t<name>doc</name>\t<type>2</type>\t<locationURI>" + String.valueOf(LONG_LOCATION_URI) + "</locationURI>\t</link>\t<link>\t<name>icons</name>\t<type>2</type>\t<locationURI>" + String.valueOf(LONG_LOCATION_URI) + "</locationURI>\t</link>\t<link>\t<name>preferences.ini</name>\t<type>1</type>\t<locationURI>" + String.valueOf(LONG_LOCATION_URI) + "</locationURI>\t</link>\t<link>\t<name>.options</name>\t<type>1</type>\t<locationURI>" + String.valueOf(LONG_LOCATION_URI) + "</locationURI>\t</link>\t<link>\t<name>plugin.properties</name>\t<type>1</type>\t<locationURI>" + String.valueOf(LONG_LOCATION_URI) + "</locationURI>\t</link>\t<link>\t<name>plugin.xml</name>\t<type>1</type>\t<locationURI>" + String.valueOf(LONG_LOCATION_URI) + "</locationURI>\t</link>\t<link>\t<name>about.html</name>\t<type>1</type>\t<locationURI>" + String.valueOf(LONG_LOCATION_URI) + "</locationURI>\t</link>\t<link>\t<name>helpworkbench.jar</name>\t<type>1</type>\t<locationURI>" + String.valueOf(LONG_LOCATION_URI) + "</locationURI>\t</link></linkedResources></projectDescription>";
    }

    private ProjectDescription readDescription(IFileStore store) throws CoreException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream input = store.openInputStream(0, ResourceTestUtil.createTestMonitor());){
            InputSource in = new InputSource(input);
            return new ProjectDescriptionReader(ResourcesPlugin.getWorkspace()).read(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testConsistentWrite() throws Throwable {
        String locationA = FileSystemHelper.getTempDir().append("testPath1").toPortableString();
        String locationB = FileSystemHelper.getTempDir().append("testPath1").toPortableString();
        String newline = System.lineSeparator();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<projectDescription>" + newline + "\t<name>MyProjectDescription</name>" + newline + "\t<comment></comment>" + newline + "\t<projects>" + newline + "\t</projects>" + newline + "\t<buildSpec>" + newline + "\t\t<buildCommand>" + newline + "\t\t\t<name>MyCommand</name>" + newline + "\t\t\t<arguments>" + newline + "\t\t\t\t<dictionary>" + newline + "\t\t\t\t\t<key>aA</key>" + newline + "\t\t\t\t\t<value>2 x ARGH!</value>" + newline + "\t\t\t\t</dictionary>" + newline + "\t\t\t\t<dictionary>" + newline + "\t\t\t\t\t<key>b</key>" + newline + "\t\t\t\t\t<value>ARGH!</value>" + newline + "\t\t\t\t</dictionary>" + newline + "\t\t\t</arguments>" + newline + "\t\t</buildCommand>" + newline + "\t</buildSpec>" + newline + "\t<natures>" + newline + "\t</natures>" + newline + "\t<linkedResources>" + newline + "\t\t<link>" + newline + "\t\t\t<name>pathA</name>" + newline + "\t\t\t<type>2</type>" + newline + "\t\t\t<location>" + locationA + "</location>" + newline + "\t\t</link>" + newline + "\t\t<link>" + newline + "\t\t\t<name>pathB</name>" + newline + "\t\t\t<type>2</type>" + newline + "\t\t\t<location>" + locationB + "</location>" + newline + "\t\t</link>" + newline + "\t</linkedResources>" + newline + "</projectDescription>" + newline;
        IFileStore tempStore = this.workspaceRule.getTempStore();
        URI location = tempStore.toURI();
        ProjectDescription description = new ProjectDescription();
        description.setLocationURI(location);
        description.setName("MyProjectDescription");
        HashMap<String, String> args = new HashMap<String, String>(2);
        args.put("b", "ARGH!");
        args.put("aA", "2 x ARGH!");
        ICommand[] commands = new ICommand[]{description.newCommand()};
        commands[0].setBuilderName("MyCommand");
        commands[0].setArguments(args);
        description.setBuildSpec(commands);
        HashMap<IPath, LinkDescription> linkDescriptions = new HashMap<IPath, LinkDescription>(2);
        LinkDescription link = this.createLinkDescription("pathB", 2, locationB);
        linkDescriptions.put(link.getProjectRelativePath(), link);
        link = this.createLinkDescription("pathA", 2, locationA);
        linkDescriptions.put(link.getProjectRelativePath(), link);
        description.setLinkDescriptions(linkDescriptions);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new ModelObjectWriter().write((Object)description, (OutputStream)buffer, System.lineSeparator());
        String result = buffer.toString();
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void testLocalMetaAreaReadWriteNatures() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        LocalMetaArea area = new LocalMetaArea((Workspace)workspace);
        ProjectDescription description = new ProjectDescription();
        description.setName("Testme");
        Object[] value = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"};
        description.setNatureIds((String[])value);
        File file = this.folder.newFile();
        area.writeToFile(description, file);
        IProject proj = workspace.getRoot().getProject("tmpproject");
        ProjectDescription readme = new ProjectDescription();
        area.readFromFile(proj, readme, file);
        Assert.assertArrayEquals((Object[])value, (Object[])readme.getNatureIds());
    }

    @Test
    public void testLocalMetaAreaReadWriteBuildSpec() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        LocalMetaArea area = new LocalMetaArea((Workspace)workspace);
        ProjectDescription description = new ProjectDescription();
        description.setName("Testme");
        BuildCommand buildCommand = new BuildCommand();
        buildCommand.setBuilderName("testBuilder");
        Map<String, String> args = Map.of("1", "2");
        buildCommand.setArguments(args);
        description.setBuildSpec(new ICommand[]{buildCommand});
        File file = this.folder.newFile();
        area.writeToFile(description, file);
        IProject proj = workspace.getRoot().getProject("tmpproject");
        ProjectDescription readme = new ProjectDescription();
        area.readFromFile(proj, readme, file);
        ICommand[] buildSpec = readme.getBuildSpec();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buildSpec.length);
        ICommand read = buildSpec[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testBuilder", (Object)read.getBuilderName());
        org.junit.jupiter.api.Assertions.assertEquals(args, (Object)read.getArguments());
    }

    @Test
    public void testInvalidProjectDescription1() throws Throwable {
        String invalidProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<homeDescription>\n\t<name>abc</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\n\t\t\t<arguments>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t<nature>org.eclipse.jdt.core.javanature</nature>\n\t</natures>\n\t<linkedResources>\n\t\t<link>\n\t\t\t<name>newLink</name>\n\t\t\t<type>2</type>\n\t\t\t<location>" + PATH_STRING + "</location>\n\t\t</link>\n\t</linkedResources>\n</homeDescription>";
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath root = workspace.getRoot().getLocation();
        IPath location = root.append("ModelObjectReaderWriterTest.txt");
        this.workspaceRule.deleteOnTearDown(location);
        ProjectDescriptionReader reader = new ProjectDescriptionReader(workspace);
        ResourceTestUtil.removeFromFileSystem(location.toFile());
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileOutputStream output = new FileOutputStream(location.toFile());){
            ResourceTestUtil.createInputStream(invalidProjectDescription).transferTo(output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProjectDescription projDesc = reader.read(location);
        Assertions.assertThat((Object)projDesc).isNull();
    }

    @Test
    public void testInvalidProjectDescription2() throws Throwable {
        String invalidProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<bogusname>abc</bogusname>\n</projectDescription>";
        IFileStore store = this.workspaceRule.getTempStore();
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream output = store.openOutputStream(0, null);){
            ResourceTestUtil.createInputStream(invalidProjectDescription).transferTo(output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProjectDescription projDesc = this.readDescription(store);
        Assertions.assertThat((Object)projDesc).isNotNull();
        Assertions.assertThat((String)projDesc.getName()).isNull();
        Assertions.assertThat((String)projDesc.getComment()).isEmpty();
        Assertions.assertThat((URI)projDesc.getLocationURI()).isNull();
        Assertions.assertThat((Object[])projDesc.getReferencedProjects()).isEmpty();
        Assertions.assertThat((Object[])projDesc.getNatureIds()).isEmpty();
        Assertions.assertThat((Object[])projDesc.getBuildSpec()).isEmpty();
        Assertions.assertThat((Map)projDesc.getLinks()).isNull();
    }

    @Test
    public void testInvalidProjectDescription3() throws Throwable {
        String invalidProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>abc</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<badBuildCommand>\n\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\n\t\t\t<arguments>\n\t\t\t</arguments>\n\t\t</badBuildCommand>\n\t</buildSpec>\n</projectDescription>";
        IFileStore store = this.workspaceRule.getTempStore();
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream output = store.openOutputStream(0, null);){
            ResourceTestUtil.createInputStream(invalidProjectDescription).transferTo(output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProjectDescription projDesc = this.readDescription(store);
        Assertions.assertThat((Object)projDesc).isNotNull();
        Assertions.assertThat((String)projDesc.getName()).isEqualTo("abc");
        Assertions.assertThat((String)projDesc.getComment()).isEmpty();
        Assertions.assertThat((URI)projDesc.getLocationURI()).isNull();
        Assertions.assertThat((Object[])projDesc.getReferencedProjects()).isEmpty();
        Assertions.assertThat((Object[])projDesc.getNatureIds()).isEmpty();
        Assertions.assertThat((Object[])projDesc.getBuildSpec()).isEmpty();
        Assertions.assertThat((Map)projDesc.getLinks()).isNull();
    }

    @Test
    public void testInvalidProjectDescription4() throws Throwable {
        String invalidProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>abc</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t</buildSpec>\n\t<natures>\n\t</natures>\n\t<linkedResources>\n\t\t<link>\n\t\t\t<name>newLink</name>\n\t\t\t<type>foobar</type>\n\t\t\t<location>" + PATH_STRING + "</location>\n\t\t</link>\n\t</linkedResources>\n</projectDescription>";
        IFileStore store = this.workspaceRule.getTempStore();
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream output = store.openOutputStream(0, null);){
            ResourceTestUtil.createInputStream(invalidProjectDescription).transferTo(output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProjectDescription projDesc = this.readDescription(store);
        Assertions.assertThat((Object)projDesc).isNotNull();
        Assertions.assertThat((String)projDesc.getName()).isEqualTo("abc");
        Assertions.assertThat((String)projDesc.getComment()).isEmpty();
        Assertions.assertThat((URI)projDesc.getLocationURI()).isNull();
        Assertions.assertThat((Object[])projDesc.getReferencedProjects()).isEmpty();
        Assertions.assertThat((Object[])projDesc.getNatureIds()).isEmpty();
        Assertions.assertThat((Object[])projDesc.getBuildSpec()).isEmpty();
        LinkDescription link = (LinkDescription)projDesc.getLinks().values().iterator().next();
        Assertions.assertThat((Object)link.getProjectRelativePath()).isEqualTo((Object)IPath.fromOSString((String)"newLink"));
        Assertions.assertThat((String)URIUtil.toPath((URI)link.getLocationURI()).toString()).isEqualTo(PATH_STRING);
    }

    @Test
    public void testLongProjectDescription() throws Throwable {
        String longProjectDescription = this.getLongDescription();
        IPath location = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(location);
        ProjectDescriptionReader reader = new ProjectDescriptionReader(ResourcesPlugin.getWorkspace());
        ResourceTestUtil.removeFromFileSystem(location.toFile());
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream output = new FileOutputStream(location.toFile());){
            ResourceTestUtil.createInputStream(longProjectDescription).transferTo(output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProjectDescription projDesc = reader.read(location);
        ResourceTestUtil.removeFromFileSystem(location.toFile());
        for (LinkDescription link : projDesc.getLinks().values()) {
            ((AbstractUriAssert)Assertions.assertThat((URI)link.getLocationURI()).as("location URI for link with relative path: %s", new Object[]{link.getProjectRelativePath()})).isEqualTo((Object)LONG_LOCATION_URI);
        }
    }

    @Test
    public void testLongProjectDescriptionURI() throws Throwable {
        String longProjectDescription = this.getLongDescriptionURI();
        IPath location = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(location);
        ProjectDescriptionReader reader = new ProjectDescriptionReader(ResourcesPlugin.getWorkspace());
        ResourceTestUtil.removeFromFileSystem(location.toFile());
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream output = new FileOutputStream(location.toFile());){
            ResourceTestUtil.createInputStream(longProjectDescription).transferTo(output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProjectDescription projDesc = reader.read(location);
        ResourceTestUtil.removeFromFileSystem(location.toFile());
        for (LinkDescription link : projDesc.getLinks().values()) {
            ((AbstractUriAssert)Assertions.assertThat((URI)link.getLocationURI()).as("location URI for link with relative path: %s", new Object[]{link.getProjectRelativePath()})).isEqualTo((Object)LONG_LOCATION_URI);
        }
    }

    @Test
    public void testMultiLineCharFields() throws Throwable {
        FileOutputStream output;
        String multiLineProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>\n      abc\n   </name>\n\t<charset>\n\t\tISO-8859-1\n\t</charset>\n\t<comment>This is the comment.</comment>\n\t<projects>\n\t   <project>\n         org.eclipse.core.boot\n      </project>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>\n              org.eclipse.jdt.core.javabuilder\n           </name>\n\t\t\t<arguments>\n              <key>thisIsTheKey</key>\n              <value>thisIsTheValue</value>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t   <nature>\n         org.eclipse.jdt.core.javanature\n      </nature>\n\t</natures>\n\t<linkedResources>\n\t\t<link>\n\t\t\t<name>newLink</name>\n\t\t\t<type>\n              2\n           </type>\n\t\t\t<location>" + PATH_STRING + "</location>\n\t\t</link>\n\t</linkedResources>\n</projectDescription>";
        String singleLineProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>abc</name>\n\t<charset>ISO-8859-1</charset>\n\t<comment>This is the comment.</comment>\n\t<projects>\n\t   <project>org.eclipse.core.boot</project>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\n\t\t\t<arguments>\n              <key>thisIsTheKey</key>\n              <value>thisIsTheValue</value>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t   <nature>org.eclipse.jdt.core.javanature</nature>\n\t</natures>\n\t<linkedResources>\n\t\t<link>\n\t\t\t<name>newLink</name>\n\t\t\t<type>2</type>\n\t\t\t<location>" + PATH_STRING + "</location>\n\t\t</link>\n\t</linkedResources>\n</projectDescription>";
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath root = workspace.getRoot().getLocation();
        IPath multiLocation = root.append("multiLineTest.txt");
        this.workspaceRule.deleteOnTearDown(multiLocation);
        IPath singleLocation = root.append("singleLineTest.txt");
        this.workspaceRule.deleteOnTearDown(singleLocation);
        ProjectDescriptionReader reader = new ProjectDescriptionReader(workspace);
        ResourceTestUtil.removeFromFileSystem(multiLocation.toFile());
        ResourceTestUtil.removeFromFileSystem(singleLocation.toFile());
        Throwable throwable = null;
        Object var9_11 = null;
        try {
            output = new FileOutputStream(multiLocation.toFile());
            try {
                ResourceTestUtil.createInputStream(multiLineProjectDescription).transferTo(output);
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var9_11 = null;
        try {
            output = new FileOutputStream(singleLocation.toFile());
            try {
                ResourceTestUtil.createInputStream(singleLineProjectDescription).transferTo(output);
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        ProjectDescription multiDesc = reader.read(multiLocation);
        ProjectDescription singleDesc = reader.read(singleLocation);
        this.compareProjectDescriptions(1, multiDesc, singleDesc);
    }

    @Test
    public void testMultipleProjectDescriptions() throws Throwable {
        URL whereToLook = Platform.getBundle((String)"org.eclipse.core.tests.resources").getEntry("MultipleProjectTestFiles/");
        String[] members = new String[]{"abc.project", "def.project", "org.apache.lucene.project", "org.eclipse.ant.core.project"};
        HashMap<String, ProjectDescription> baselines = this.buildBaselineDescriptors();
        ProjectDescriptionReader reader = new ProjectDescriptionReader(ResourcesPlugin.getWorkspace());
        int i = 0;
        while (i < members.length) {
            URL currentURL = null;
            currentURL = new URL(whereToLook, members[i]);
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream is = currentURL.openStream();){
                InputSource in = new InputSource(is);
                ProjectDescription description = reader.read(in);
                this.compareProjectDescriptions(i + 1, description, baselines.get(members[i]));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++i;
        }
    }

    @Test
    public void testProjectDescription() throws Throwable {
        IFileStore tempStore = this.workspaceRule.getTempStore();
        URI location = tempStore.toURI();
        ProjectDescription description = new ProjectDescription();
        description.setLocationURI(location);
        description.setName("MyProjectDescription");
        HashMap<String, String> args = new HashMap<String, String>(3);
        args.put("ArgOne", "ARGH!");
        args.put("ArgTwo", "2 x ARGH!");
        args.put("NullArg", null);
        args.put("EmptyArg", "");
        ICommand[] commands = new ICommand[2];
        commands[0] = description.newCommand();
        commands[0].setBuilderName("MyCommand");
        commands[0].setArguments(args);
        commands[1] = description.newCommand();
        commands[1].setBuilderName("MyOtherCommand");
        commands[1].setArguments(args);
        description.setBuildSpec(commands);
        this.writeDescription(tempStore, description);
        ProjectDescription description2 = this.readDescription(tempStore);
        Assertions.assertThat((String)description.getName()).isEqualTo(description2.getName());
        Assertions.assertThat((URI)location).isEqualTo((Object)description.getLocationURI());
        Object[] commands2 = description2.getBuildSpec();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])commands2).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            ((AbstractStringAssert)Assertions.assertThat((String)first.getBuilderName()).as("name", new Object[0])).isEqualTo("MyCommand");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)first.getArguments().get("ArgOne"))).as("ArgOne", new Object[0])).isEqualTo("ARGH!");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)first.getArguments().get("ArgTwo"))).as("ArgTwO", new Object[0])).isEqualTo("2 x ARGH!");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)first.getArguments().get("NullArg"))).as("NullArg", new Object[0])).isEmpty();
            ((AbstractStringAssert)Assertions.assertThat((String)((String)first.getArguments().get("EmptyArg"))).as("EmptyArg", new Object[0])).isEmpty();
            ((AbstractStringAssert)Assertions.assertThat((String)((String)first.getArguments().get("NullArg"))).as("NullArg", new Object[0])).isEmpty();
            ((AbstractStringAssert)Assertions.assertThat((String)((String)first.getArguments().get("EmptyArg"))).as("EmptyArg", new Object[0])).isEmpty();
        }, second -> {
            ((AbstractStringAssert)Assertions.assertThat((String)second.getBuilderName()).as("name", new Object[0])).isEqualTo("MyOtherCommand");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)second.getArguments().get("ArgOne"))).as("ArgOne", new Object[0])).isEqualTo("ARGH!");
        }});
    }

    @Test
    public void testProjectDescription2() throws Throwable {
        ProjectDescription description2;
        OutputStream output22;
        ModelObjectWriter writer = new ModelObjectWriter();
        ProjectDescriptionReader reader = new ProjectDescriptionReader(ResourcesPlugin.getWorkspace());
        IFileStore tempStore = this.workspaceRule.getTempStore();
        URI location = tempStore.toURI();
        ProjectDescription description = new ProjectDescription();
        description.setLocationURI(location);
        description.setName("MyProjectDescription");
        HashMap<String, String> args = new HashMap<String, String>(3);
        args.put("ArgOne", "ARGH!");
        ICommand[] commands = new ICommand[]{description.newCommand()};
        commands[0].setBuilderName("MyCommand");
        commands[0].setArguments(args);
        description.setBuildSpec(commands);
        String comment = "Now is the time for all good men to come to the aid of the party.  Now is the time for all good men to come to the aid of the party.  Now is the time for all good men to come to the aid of the party.";
        description.setComment(comment);
        IProject[] refProjects = new IProject[]{ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.core.runtime"), ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.core.boot"), ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.core.resources")};
        description.setReferencedProjects(refProjects);
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            output22 = tempStore.openOutputStream(0, ResourceTestUtil.createTestMonitor());
            try {
                writer.write((Object)description, output22, System.lineSeparator());
            }
            finally {
                if (output22 != null) {
                    output22.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable2 = null;
        output22 = null;
        try (InputStream input = tempStore.openInputStream(0, ResourceTestUtil.createTestMonitor());){
            InputSource in = new InputSource(input);
            description2 = reader.read(in);
        }
        catch (Throwable output22) {
            if (throwable2 == null) {
                throwable2 = output22;
            } else if (throwable2 != output22) {
                throwable2.addSuppressed(output22);
            }
            throw throwable2;
        }
        Assertions.assertThat((String)description.getName()).isEqualTo(description2.getName());
        Assertions.assertThat((URI)location).isEqualTo((Object)description.getLocationURI());
        Object[] commands2 = description2.getBuildSpec();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])commands2).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{command -> {
            ((AbstractStringAssert)Assertions.assertThat((String)command.getBuilderName()).as("name", new Object[0])).isEqualTo("MyCommand");
            ((AbstractStringAssert)Assertions.assertThat((String)((String)command.getArguments().get("ArgOne"))).as("ArgOne", new Object[0])).isEqualTo("ARGH!");
        }});
        Assertions.assertThat((String)description.getComment()).isEqualTo(description2.getComment());
        IProject[] ref = description.getReferencedProjects();
        Object[] ref2 = description2.getReferencedProjects();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])ref2).hasSize(3)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)first.getName()).isEqualTo(ref[0].getName());
        }, second -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)second.getName()).isEqualTo(ref[1].getName());
        }, third -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)third.getName()).isEqualTo(ref[2].getName());
        }});
    }

    @Test
    public void testProjectDescription3() throws Throwable {
        IFileStore tempStore = this.workspaceRule.getTempStore();
        URI location = tempStore.toURI();
        ProjectDescription description = new ProjectDescription();
        description.setLocationURI(location);
        description.setName("MyProjectDescription");
        ICommand[] commands = new ICommand[]{description.newCommand()};
        commands[0].setBuilderName("MyCommand");
        commands[0].setArguments(null);
        description.setBuildSpec(commands);
        this.writeDescription(tempStore, description);
        ProjectDescription description2 = this.readDescription(tempStore);
        Assertions.assertThat((String)description.getName()).isEqualTo(description2.getName());
        Assertions.assertThat((URI)description.getLocationURI()).isEqualTo((Object)location);
        Object[] commands2 = description2.getBuildSpec();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])commands2).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{command -> {
            ((AbstractStringAssert)Assertions.assertThat((String)command.getBuilderName()).as("name", new Object[0])).isEqualTo("MyCommand");
            ((MapAssert)Assertions.assertThat((Map)command.getArguments()).as("arguments", new Object[0])).isEmpty();
        }});
    }

    @Test
    public void testProjectDescriptionWithSpaces() throws Throwable {
        IFileStore store = this.workspaceRule.getTempStore();
        IPath path = IPath.fromOSString((String)"link");
        URI location = store.toURI();
        URI locationWithSpaces = store.getChild("With some spaces").toURI();
        ProjectDescription description = new ProjectDescription();
        description.setLocationURI(location);
        description.setName("MyProjectDescription");
        description.setLinkLocation(path, this.createLinkDescription(path, 2, locationWithSpaces));
        this.writeDescription(store, description);
        ProjectDescription description2 = this.readDescription(store);
        Assertions.assertThat((String)description.getName()).isEqualTo(description2.getName());
        Assertions.assertThat((URI)description.getLocationURI()).isEqualTo((Object)location);
        Assertions.assertThat((URI)description2.getLinkLocationURI(path)).isEqualTo((Object)locationWithSpaces);
    }

    protected URI uriFromPortableString(String pathString) {
        return IPath.fromPortableString((String)pathString).toFile().toURI();
    }

    private void writeDescription(IFileStore store, ProjectDescription description) throws IOException, CoreException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream output = store.openOutputStream(0, ResourceTestUtil.createTestMonitor());){
            new ModelObjectWriter().write((Object)description, output, System.lineSeparator());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testProjectDescriptionWithFiltersAndNullProject() throws Exception {
        String projectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>rome_dfw</name>\n\t\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<linkedResources>\n\t\t<link>\n\t\t\t<name>OcdTargetPlugin</name>\n\t\t\t<type>2</type>\n\t\t\t<location>M:/lcruaud.dfw-main-validation/HSI_api/OcdTargetPlugin</location>\n\t\t</link>\n\t</linkedResources>\n\t<filteredResources>\n\t\t<filter>\n\t\t\t<id>1264174785480</id>\n\t\t\t<name></name>\n\t\t\t<type>22</type>\n\t\t\t<matcher>\n\t\t\t\t<id>org.eclipse.ui.ide.patternFilterMatcher</id>\n\t\t\t\t<arguments>*:*</arguments>\n\t\t\t</matcher>\n\t\t</filter>\n\t</filteredResources>\n</projectDescription>\n";
        IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IPath location = root.append("ModelObjectReaderWriterTest.txt");
        this.workspaceRule.deleteOnTearDown(location);
        ProjectDescriptionReader reader = new ProjectDescriptionReader(ResourcesPlugin.getWorkspace());
        ResourceTestUtil.removeFromFileSystem(location.toFile());
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileOutputStream output = new FileOutputStream(location.toFile());){
            ResourceTestUtil.createInputStream(projectDescription).transferTo(output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProjectDescription projDesc = reader.read(location);
        Assertions.assertThat((Object)projDesc).isNotNull();
    }
}

