/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.core.internal.resources.BuildConfiguration;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProjectBuildConfigsTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private IProject project;
    private static final String variantId0 = "Variant0";
    private static final String variantId1 = "Variant1";
    private static final String variantId2 = "Variant2";
    private IBuildConfiguration variant0;
    private IBuildConfiguration variant1;
    private IBuildConfiguration variant2;
    private IBuildConfiguration defaultVariant;

    @Before
    public void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("ProjectBuildConfigsTest_Project");
        ResourceTestUtil.createInWorkspace((IResource[])new IProject[]{this.project});
        this.variant0 = new BuildConfiguration(this.project, variantId0);
        this.variant1 = new BuildConfiguration(this.project, variantId1);
        this.variant2 = new BuildConfiguration(this.project, variantId2);
        this.defaultVariant = new BuildConfiguration(this.project, "");
    }

    @Test
    public void testBasics() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        String[] configs = new String[]{variantId0, variantId1};
        desc.setBuildConfigs(configs);
        this.project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])this.project.getBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.variant0, this.variant1});
        Assertions.assertThat((Object)this.project.getBuildConfig(variantId0)).isEqualTo((Object)this.variant0);
        Assertions.assertThat((Object)this.project.getBuildConfig(variantId1)).isEqualTo((Object)this.variant1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.project.hasBuildConfig(this.variant0.getName())).withFailMessage("project '%s' is missing build config: %s", new Object[]{this.project, this.variant0})).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.project.hasBuildConfig(this.variant1.getName())).withFailMessage("project '%s' is missing build config: %s", new Object[]{this.project, this.variant1})).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.project.hasBuildConfig(this.variant2.getName())).withFailMessage("project '%s' unexpectedly has build config: %s", new Object[]{this.project, this.variant2})).isFalse();
        Assertions.assertThat((Object)this.project.getActiveBuildConfig()).isEqualTo((Object)this.variant0);
        desc = this.project.getDescription();
        desc.setActiveBuildConfig(variantId1);
        this.project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)this.project.getActiveBuildConfig()).isEqualTo((Object)this.variant1);
        desc.setActiveBuildConfig(variantId2);
        Assertions.assertThat((Object)this.project.getActiveBuildConfig()).isEqualTo((Object)this.variant1);
        IBuildConfiguration variant = this.project.getBuildConfigs()[0];
        Assertions.assertThat((Object)variant.getProject()).isEqualTo((Object)this.project);
        Assertions.assertThat((String)variant.getName()).isEqualTo(variantId0);
    }

    @Test
    public void testDuplicates() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        desc.setBuildConfigs(new String[]{variantId0, variantId1, variantId0});
        this.project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])this.project.getBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.variant0, this.variant1});
    }

    @Test
    public void testDefaultVariant() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        desc.setBuildConfigs(new String[0]);
        this.project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])this.project.getBuildConfigs()).containsExactly((Object[])new IBuildConfiguration[]{this.defaultVariant});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.project.hasBuildConfig(this.defaultVariant.getName())).withFailMessage("project '%s' is missing build config: %s", new Object[]{this.project, this.defaultVariant})).isTrue();
        Assertions.assertThat((Object)this.project.getActiveBuildConfig()).isEqualTo((Object)this.defaultVariant);
        desc = this.project.getDescription();
        desc.setActiveBuildConfig("");
        this.project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)this.project.getActiveBuildConfig()).isEqualTo((Object)this.defaultVariant);
    }

    @Test
    public void testRemoveActiveVariant() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        desc.setBuildConfigs(new String[0]);
        desc.setBuildConfigs(new String[]{this.variant0.getName(), this.variant1.getName()});
        this.project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)this.project.getActiveBuildConfig()).isEqualTo((Object)this.variant0);
        desc.setBuildConfigs(new String[]{this.variant0.getName(), this.variant2.getName()});
        this.project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)this.project.getActiveBuildConfig()).isEqualTo((Object)this.variant0);
        desc = this.project.getDescription();
        desc.setActiveBuildConfig(variantId2);
        this.project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        desc.setBuildConfigs(new String[]{this.variant0.getName(), this.variant1.getName()});
        this.project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)this.project.getActiveBuildConfig()).isEqualTo((Object)this.variant0);
    }

    @Test
    public void testProjectMove() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        IBuildConfiguration[] configs = new IBuildConfiguration[]{this.variant0, this.variant1};
        desc.setBuildConfigs(new String[]{configs[0].getName(), configs[1].getName()});
        this.project.setDescription(desc, ResourceTestUtil.createTestMonitor());
        String newProjectName = "projectMoved";
        desc = this.project.getDescription();
        desc.setName(newProjectName);
        this.project.move(desc, false, ResourceTestUtil.createTestMonitor());
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newProjectName);
        Assertions.assertThat((Object)newProject).matches(IResource::exists, "exists");
        IBuildConfiguration[] newConfigs = newProject.getBuildConfigs();
        int i = 0;
        while (i < configs.length) {
            ((ObjectAssert)Assertions.assertThat((Object)newConfigs[i].getProject()).as("project at index %s", new Object[]{i})).isEqualTo((Object)newProject);
            ((AbstractStringAssert)Assertions.assertThat((String)newConfigs[i].getName()).as("project name at index %s", new Object[]{i})).isEqualTo(configs[i].getName());
            ++i;
        }
    }
}

